/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.google.common.net.InetAddresses;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u00a8\u0006\u0007"}, d2={"areEqualOrSubdomain", "", "domain", "", "subDomain", "isIpAwareLocalhost", "host", "intellij.httpClient.executor"})
public final class UrlUtilsKt {
    public static final boolean areEqualOrSubdomain(@NotNull String domain, @NotNull String subDomain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)subDomain, (String)"subDomain");
        if (Intrinsics.areEqual((Object)domain, (Object)subDomain)) {
            return true;
        }
        if (UrlUtilsKt.isIpAwareLocalhost(domain) && UrlUtilsKt.isIpAwareLocalhost(subDomain)) {
            return true;
        }
        if (InetAddresses.isInetAddress((String)domain) || InetAddresses.isInetAddress((String)subDomain)) {
            return false;
        }
        if (StringsKt.endsWith$default((String)subDomain, (String)domain, (boolean)false, (int)2, null)) {
            int prefix = subDomain.length() - domain.length();
            if (prefix == 0) {
                return true;
            }
            if (prefix > 1 && subDomain.charAt(prefix - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    private static final boolean isIpAwareLocalhost(String host) {
        return Intrinsics.areEqual((Object)host, (Object)"127.0.0.1") || Intrinsics.areEqual((Object)host, (Object)"localhost");
    }
}

