/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.cookies.validate;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.cookies.MalformedCookieException;
import com.intellij.httpClient.http.request.cookies.validate.BasicDomainHandler;
import com.intellij.httpClient.http.request.cookies.validate.BasicPathHandler;
import com.intellij.httpClient.http.request.cookies.validate.CookieAttributeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CookieValidator {
    private final List<CookieAttributeHandler> myHandlers = new ArrayList<CookieAttributeHandler>();

    private CookieValidator(CookieAttributeHandler ... handlers) {
        Collections.addAll(this.myHandlers, handlers);
    }

    public CookieValidator() {
        this(new BasicDomainHandler(), new BasicPathHandler());
    }

    public void validate(@NotNull RestClientRequest.Biscuit cookie) throws MalformedCookieException {
        if (cookie == null) {
            CookieValidator.$$$reportNull$$$0(0);
        }
        for (CookieAttributeHandler handler : this.myHandlers) {
            handler.validate(cookie);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cookie", "com/intellij/httpClient/http/request/cookies/validate/CookieValidator", "validate"));
    }
}

