/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.auth;

import com.intellij.httpClient.postman.HttpUrl;
import com.intellij.httpClient.postman.converter.PostmanCollectionConverterKt;
import com.intellij.httpClient.postman.converter.auth.HttpClientAuth;
import com.intellij.httpClient.postman.converter.auth.PostmanAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.digest.DigestAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.oauth2.Oauth2AuthProvider;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpAuthEnv;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuth;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuthAttribute;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuthType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ \u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/postman/converter/auth/PostmanAuthProvider;", "", "<init>", "()V", "oauth2AuthProvider", "Lcom/intellij/httpClient/postman/converter/auth/oauth2/Oauth2AuthProvider;", "getOauth2AuthProvider", "()Lcom/intellij/httpClient/postman/converter/auth/oauth2/Oauth2AuthProvider;", "oauth2AuthProvider$delegate", "Lkotlin/Lazy;", "httpAuthByPostmanAuth", "", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanAuth;", "Lcom/intellij/httpClient/postman/converter/auth/HttpClientAuth;", "getAuthEnv", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpAuthEnv;", "getAuth", "auth", "method", "", "url", "Lcom/intellij/httpClient/postman/HttpUrl;", "calculateAuth", "postmanAuth", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanAuthProvider.kt\ncom/intellij/httpClient/postman/converter/auth/PostmanAuthProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n136#2,9:109\n216#2:118\n217#2:120\n145#2:121\n1#3:119\n1#3:122\n*S KotlinDebug\n*F\n+ 1 PostmanAuthProvider.kt\ncom/intellij/httpClient/postman/converter/auth/PostmanAuthProvider\n*L\n53#1:109,9\n53#1:118\n53#1:120\n53#1:121\n53#1:119\n*E\n"})
public final class PostmanAuthProvider {
    @NotNull
    private final Lazy oauth2AuthProvider$delegate = LazyKt.lazy(PostmanAuthProvider::oauth2AuthProvider_delegate$lambda$0);
    @NotNull
    private final Map<PostmanAuth, HttpClientAuth> httpAuthByPostmanAuth = new LinkedHashMap();

    private final Oauth2AuthProvider getOauth2AuthProvider() {
        Lazy lazy = this.oauth2AuthProvider$delegate;
        return (Oauth2AuthProvider)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HttpAuthEnv> getAuthEnv() {
        void $this$mapNotNullTo$iv$iv;
        Map<PostmanAuth, HttpClientAuth> $this$mapNotNull$iv = this.httpAuthByPostmanAuth;
        boolean $i$f$mapNotNull = false;
        Map<PostmanAuth, HttpClientAuth> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            HttpAuthEnv it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (((HttpClientAuth)it.getValue()).getSecurityEnvironment() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final HttpClientAuth getAuth(@NotNull PostmanAuth auth, @NotNull String method, @NotNull HttpUrl url) {
        HttpClientAuth httpClientAuth;
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpClientAuth httpClientAuth2 = this.httpAuthByPostmanAuth.get(auth);
        if (httpClientAuth2 != null) {
            HttpClientAuth it = httpClientAuth2;
            boolean bl = false;
            return it;
        }
        HttpClientAuth httpClientAuth3 = this.calculateAuth(auth, method, url);
        if (httpClientAuth3 != null) {
            HttpClientAuth httpClientAuth4;
            HttpClientAuth it = httpClientAuth4 = httpClientAuth3;
            boolean bl = false;
            this.httpAuthByPostmanAuth.put(auth, it);
            httpClientAuth = httpClientAuth4;
        } else {
            httpClientAuth = null;
        }
        return httpClientAuth;
    }

    private final HttpClientAuth calculateAuth(PostmanAuth postmanAuth, String method, HttpUrl url) {
        HttpClientAuth header;
        PostmanAuthType type = postmanAuth.getType();
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                HttpClientAuth httpClientAuth;
                List<PostmanAuthAttribute> it;
                List<PostmanAuthAttribute> list2 = postmanAuth.getApikey();
                if (list2 != null) {
                    it = list2;
                    boolean bl = false;
                    httpClientAuth = PostmanAuthProviderKt.access$getApiKeyHeader(it);
                    break;
                }
                httpClientAuth = null;
                break;
            }
            case 2: {
                HttpClientAuth httpClientAuth;
                List<PostmanAuthAttribute> it;
                List<PostmanAuthAttribute> list3 = postmanAuth.getBasic();
                if (list3 != null) {
                    it = list3;
                    boolean bl = false;
                    httpClientAuth = PostmanAuthProviderKt.access$getBasicHeader(it);
                    break;
                }
                httpClientAuth = null;
                break;
            }
            case 3: {
                HttpClientAuth httpClientAuth;
                List<PostmanAuthAttribute> it;
                List<PostmanAuthAttribute> list4 = postmanAuth.getBearer();
                if (list4 != null) {
                    it = list4;
                    boolean bl = false;
                    httpClientAuth = PostmanAuthProviderKt.access$getBearerHeader(it);
                    break;
                }
                httpClientAuth = null;
                break;
            }
            case 4: {
                HttpClientAuth httpClientAuth;
                List<PostmanAuthAttribute> it;
                List<PostmanAuthAttribute> list5 = postmanAuth.getDigest();
                if (list5 != null) {
                    it = list5;
                    boolean bl = false;
                    httpClientAuth = DigestAuthProviderKt.getDigestAuth(it, method, url);
                    break;
                }
                httpClientAuth = null;
                break;
            }
            case 5: {
                HttpClientAuth httpClientAuth;
                List<PostmanAuthAttribute> it;
                List<PostmanAuthAttribute> list6 = postmanAuth.getOauth2();
                if (list6 != null) {
                    it = list6;
                    boolean bl = false;
                    httpClientAuth = this.getOauth2AuthProvider().getOauth2(it);
                    break;
                }
                httpClientAuth = null;
                break;
            }
            default: {
                HttpClientAuth httpClientAuth = header = null;
            }
        }
        if (header == null && type != PostmanAuthType.noauth) {
            PostmanCollectionConverterKt.getPostmanConverterLogger().warning("Could not retrieve header from auth with type " + type);
        }
        return header;
    }

    private static final Oauth2AuthProvider oauth2AuthProvider_delegate$lambda$0() {
        return new Oauth2AuthProvider();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PostmanAuthType.values().length];
            try {
                nArray[PostmanAuthType.apikey.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostmanAuthType.basic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostmanAuthType.bearer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostmanAuthType.digest.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostmanAuthType.oauth2.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

