/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SetIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSSetIterator;
import com.oracle.truffle.js.runtime.builtins.JSSetIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSSetObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class SetIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SetIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SetIteratorPrototypeBuiltins();

    protected SetIteratorPrototypeBuiltins() {
        super(JSSetIterator.PROTOTYPE_NAME, SetIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, SetIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return SetIteratorPrototypeBuiltinsFactory.SetIteratorNextNodeGen.create(context2, builtin, SetIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum SetIteratorPrototype implements BuiltinEnum<SetIteratorPrototype>
    {
        next(0);

        private final int length;

        private SetIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class SetIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;

        public SetIteratorNextNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context2);
        }

        @Specialization
        protected final JSObject doSetIterator(VirtualFrame frame, JSSetIteratorObject iterator, @Cached InlinedConditionProfile detachedProf, @Cached InlinedConditionProfile doneProf, @Cached InlinedConditionProfile iterKindProf) {
            Object result2;
            Object set2 = iterator.getIteratedObject();
            if (detachedProf.profile(this, set2 == Undefined.instance)) {
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            assert (set2 instanceof JSSetObject);
            JSHashMap.Cursor mapCursor = iterator.getNextIndex();
            int itemKind = iterator.getIterationKind();
            if (doneProf.profile(this, !mapCursor.advance())) {
                iterator.setIteratedObject(Undefined.instance);
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            Object elementValue = mapCursor.getKey();
            if (iterKindProf.profile(this, itemKind == 2)) {
                result2 = elementValue;
            } else {
                assert (itemKind == 3);
                result2 = JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{elementValue, elementValue});
            }
            return this.createIterResultObjectNode.execute(frame, result2, false);
        }

        @Fallback
        protected static JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not a Set Iterator");
        }
    }
}

