/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOrBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.intl.SetNumberFormatDigitOptionsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.MissingResourceException;

public abstract class InitializeNumberFormatNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    @Node.Child
    SetNumberFormatDigitOptionsNode setNumberFormatDigitOptions;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getCurrencyOption;
    @Node.Child
    GetStringOptionNode getCurrencyDisplayOption;
    @Node.Child
    GetStringOptionNode getCurrencySignOption;
    @Node.Child
    GetStringOptionNode getUnitOption;
    @Node.Child
    GetStringOptionNode getUnitDisplayOption;
    @Node.Child
    GetStringOptionNode getNotationOption;
    @Node.Child
    GetStringOptionNode getCompactDisplayOption;
    @Node.Child
    GetStringOrBooleanOptionNode getUseGroupingOption;
    @Node.Child
    GetStringOptionNode getSignDisplayOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeNumberFormatNode(JSContext context2) {
        this.context = context2;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context2);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context2);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context2, IntlUtil.KEY_LOCALE_MATCHER, new String[]{"lookup", "best fit"}, "best fit");
        this.getNumberingSystemOption = GetStringOptionNode.create(context2, IntlUtil.KEY_NUMBERING_SYSTEM, null, null);
        this.getStyleOption = GetStringOptionNode.create(context2, IntlUtil.KEY_STYLE, new String[]{"decimal", "percent", "currency", "unit"}, "decimal");
        this.getCurrencyOption = GetStringOptionNode.create(context2, IntlUtil.KEY_CURRENCY, null, null);
        this.getCurrencyDisplayOption = GetStringOptionNode.create(context2, IntlUtil.KEY_CURRENCY_DISPLAY, new String[]{"code", "symbol", "narrowSymbol", "name"}, "symbol");
        this.getCurrencySignOption = GetStringOptionNode.create(context2, IntlUtil.KEY_CURRENCY_SIGN, new String[]{"standard", "accounting"}, "standard");
        this.getUnitOption = GetStringOptionNode.create(context2, IntlUtil.KEY_UNIT, null, null);
        this.getUnitDisplayOption = GetStringOptionNode.create(context2, IntlUtil.KEY_UNIT_DISPLAY, new String[]{"short", "narrow", "long"}, "short");
        this.getNotationOption = GetStringOptionNode.create(context2, IntlUtil.KEY_NOTATION, new String[]{"standard", "scientific", "engineering", "compact"}, "standard");
        this.getCompactDisplayOption = GetStringOptionNode.create(context2, IntlUtil.KEY_COMPACT_DISPLAY, new String[]{"short", "long"}, "short");
        this.getUseGroupingOption = GetStringOrBooleanOptionNode.create(context2, IntlUtil.KEY_USE_GROUPING, new String[]{"min2", "auto", "always"}, "always", false, null);
        this.getSignDisplayOption = GetStringOptionNode.create(context2, IntlUtil.KEY_SIGN_DISPLAY, new String[]{"auto", "never", "always", "exceptZero", "negative"}, "auto");
        this.setNumberFormatDigitOptions = SetNumberFormatDigitOptionsNode.create(context2);
    }

    public abstract JSNumberFormatObject executeInit(JSNumberFormatObject var1, Object var2, Object var3);

    public static InitializeNumberFormatNode createInitalizeNumberFormatNode(JSContext context2) {
        return InitializeNumberFormatNodeGen.create(context2);
    }

    @Specialization
    public JSNumberFormatObject initializeNumberFormat(JSNumberFormatObject numberFormatObj, Object localesArg, Object optionsArg) {
        try {
            Object useGrouping;
            int mxfdDefault;
            int mnfdDefault;
            JSNumberFormat.InternalState state = numberFormatObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String numberingSystem = this.getNumberingSystemOption.executeValue(options);
            if (numberingSystem != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(numberingSystem, this.errorBranch);
                numberingSystem = IntlUtil.normalizeUnicodeLocaleIdentifierType(numberingSystem);
            }
            state.resolveLocaleAndNumberingSystem(this.context, locales, numberingSystem);
            this.setNumberFormatUnitOptions(state, options);
            String style = state.getStyle();
            if ("currency".equals(style)) {
                int cDigits;
                mnfdDefault = cDigits = JSNumberFormat.currencyDigits(this.context, state.getCurrency());
                mxfdDefault = cDigits;
            } else {
                mnfdDefault = 0;
                mxfdDefault = "percent".equals(style) ? 0 : 3;
            }
            String notation = this.getNotationOption.executeValue(options);
            state.setNotation(notation);
            boolean compactNotation = "compact".equals(notation);
            this.setNumberFormatDigitOptions.execute(state, options, mnfdDefault, mxfdDefault, compactNotation);
            String compactDisplay = this.getCompactDisplayOption.executeValue(options);
            String defaultUseGrouping = "auto";
            if (compactNotation) {
                state.setCompactDisplay(compactDisplay);
                defaultUseGrouping = "min2";
            }
            if ((useGrouping = this.getUseGroupingOption.executeValue(options)) == null) {
                useGrouping = defaultUseGrouping;
            }
            state.setGroupingUsed(useGrouping);
            String signDisplay = this.getSignDisplayOption.executeValue(options);
            state.setSignDisplay(signDisplay);
            state.initializeNumberFormatter();
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return numberFormatObj;
    }

    private void setNumberFormatUnitOptions(JSNumberFormat.InternalState state, Object options) {
        String style = this.getStyleOption.executeValue(options);
        state.setStyle(style);
        boolean styleIsCurrency = "currency".equals(style);
        boolean styleIsUnit = "unit".equals(style);
        String currency = this.getCurrencyOption.executeValue(options);
        if (currency == null) {
            if (styleIsCurrency) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Currency can not be undefined when style is \"currency\".");
            }
        } else {
            IntlUtil.ensureIsWellFormedCurrencyCode(currency);
        }
        String currencyDisplay = this.getCurrencyDisplayOption.executeValue(options);
        String currencySign = this.getCurrencySignOption.executeValue(options);
        String unit = this.getUnitOption.executeValue(options);
        if (unit == null) {
            if (styleIsUnit) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Unit can not be undefined when style is \"unit\".");
            }
        } else {
            IntlUtil.ensureIsWellFormedUnitIdentifier(unit);
        }
        String unitDisplay = this.getUnitDisplayOption.executeValue(options);
        if (styleIsCurrency) {
            currency = IntlUtil.toUpperCase(currency);
            state.setCurrency(currency);
            state.setCurrencyDisplay(currencyDisplay);
            state.setCurrencySign(currencySign);
        } else if (styleIsUnit) {
            state.setUnit(unit);
            state.setUnitDisplay(unitDisplay);
        }
    }
}

