/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSOrdinaryObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.CompilableBiFunction;

public final class JSOrdinary
extends JSNonProxy
implements PrototypeSupplier {
    public static final TruffleString TYPE_NAME = Strings.constant("object");
    public static final TruffleString CLASS_NAME = Strings.constant("Object");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Object.prototype");
    public static final JSOrdinary INSTANCE = new JSOrdinary();
    public static final CompilableBiFunction<JSContext, JSDynamicObject, Shape> SHAPE_SUPPLIER = (ctx, proto) -> JSObjectUtil.getProtoChildShape(proto, INSTANCE, ctx);
    public static final JSOrdinary BARE_INSTANCE = new JSOrdinary();
    public static final JSOrdinary INTERNAL_FIELD_INSTANCE = new JSOrdinary();
    public static final JSOrdinary OVERLOADED_OPERATORS_INSTANCE = new JSOrdinary();

    private JSOrdinary() {
    }

    public static JSObject create(JSContext context2, JSObjectFactory factory, JSRealm realm) {
        return JSOrdinary.createWithRealm(context2, factory, realm);
    }

    public static JSObject createWithRealm(JSContext context2, JSObjectFactory factory, JSRealm realm) {
        JSOrdinaryObject obj = JSOrdinaryObject.create(factory.getShape(realm), factory.getPrototype(realm));
        factory.initProto(obj, realm);
        return context2.trackAllocation(obj);
    }

    public static JSObject create(JSContext context2, JSRealm realm) {
        return JSOrdinary.createWithRealm(context2, context2.getOrdinaryObjectFactory(), realm);
    }

    public static JSObject create(JSContext context2, JSRealm realm, JSDynamicObject proto) {
        JSObjectFactory factory = context2.getOrdinaryObjectFactory();
        JSOrdinaryObject obj = JSOrdinaryObject.create(factory.getShape(realm, proto), proto);
        factory.initProto(obj, realm, proto);
        return context2.trackAllocation(obj);
    }

    public static JSObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        JSOrdinaryObject obj = JSOrdinaryObject.create(factory.getShape(realm), proto);
        factory.initProto(obj, realm);
        return factory.trackAllocation(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject createWithPrototype(JSDynamicObject prototype, JSContext context2) {
        return JSOrdinary.createWithPrototype(prototype, context2, INSTANCE);
    }

    public static JSObject createWithNullPrototype(JSContext context2) {
        return context2.trackAllocation(JSOrdinaryObject.create(context2.getEmptyShapeNullPrototype(), Null.instance));
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject createWithPrototype(JSDynamicObject prototype, JSContext context2, JSOrdinary instanceLayout) {
        JSOrdinaryObject obj;
        assert (JSObjectUtil.isValidPrototype(prototype));
        if (prototype == Null.instance) {
            obj = JSOrdinaryObject.create(context2.makeEmptyShapeWithNullPrototype(instanceLayout), prototype);
        } else if (!context2.isMultiContext()) {
            obj = JSOrdinaryObject.create(JSObjectUtil.getProtoChildShape(prototype, instanceLayout, context2), prototype);
        } else {
            obj = JSOrdinaryObject.create(context2.makeEmptyShapeWithPrototypeInObject(instanceLayout), prototype);
            JSOrdinary.setProtoSlow(obj, prototype);
        }
        return context2.trackAllocation(obj);
    }

    public static JSObject createInitWithInstancePrototype(JSDynamicObject prototype, JSContext context2) {
        assert (JSObjectUtil.isValidPrototype(prototype));
        Shape shape = context2.getEmptyShapePrototypeInObject();
        JSOrdinaryObject obj = JSOrdinaryObject.create(shape, prototype);
        JSOrdinary.setProtoSlow(obj, prototype);
        return obj;
    }

    private static void setProtoSlow(JSObject obj, JSDynamicObject prototype) {
        JSObjectUtil.putHiddenProperty(obj, JSObject.HIDDEN_PROTO, prototype);
    }

    public static JSObject createWithoutPrototype(JSContext context2, JSDynamicObject proto) {
        Shape shape = context2.getEmptyShapePrototypeInObject();
        JSObject obj = JSOrdinary.create(context2, shape, proto);
        return obj;
    }

    public static JSObject create(JSContext context2, Shape shape, JSDynamicObject proto) {
        assert (JSShape.getJSClass(shape) instanceof JSOrdinary);
        return context2.trackAllocation(JSOrdinaryObject.create(shape, proto));
    }

    public static JSObject createInit(JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        return JSOrdinary.createInit(realm, realm.getObjectPrototype());
    }

    public static JSObject createInit(JSRealm realm, JSDynamicObject prototype) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSObjectUtil.isValidPrototype(prototype));
        JSContext context2 = realm.getContext();
        if (context2.isMultiContext()) {
            return JSOrdinary.createInitWithInstancePrototype(prototype, context2);
        }
        return JSOrdinaryObject.create(prototype == Null.instance ? context2.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2), prototype);
    }

    public static JSObject createWithNullPrototypeInit(JSContext context2) {
        CompilerAsserts.neverPartOfCompilation();
        return JSOrdinaryObject.create(context2.getEmptyShapeNullPrototype(), Null.instance);
    }

    public static boolean isJSOrdinaryObject(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSOrdinary.isJSOrdinaryObject((JSDynamicObject)obj);
    }

    public static boolean isJSOrdinaryObject(JSDynamicObject obj) {
        return JSOrdinary.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString getClassName(JSDynamicObject object) {
        Object toStringTag;
        JSContext context2 = JSObject.getJSContext(object);
        if (context2.getEcmaScriptVersion() <= 5 && Strings.isTString(toStringTag = this.get(object, Symbol.SYMBOL_TO_STRING_TAG))) {
            return JSRuntime.toStringIsString(toStringTag);
        }
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToDisplayString(obj, allowSideEffects, format, depth, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object get(JSDynamicObject thisObj, long index) {
        return this.get(thisObj, Strings.fromLong(index));
    }

    @Override
    public boolean hasOnlyShapeProperties(JSDynamicObject obj) {
        return true;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getObjectPrototype();
    }
}

