/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.charset.CharMatchers;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.QuantifierGuard;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackerSubExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexLiteralLookAroundExecutorNode;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import java.util.List;
import java.util.function.BiPredicate;
import org.graalvm.collections.Pair;

public final class TRegexBacktrackingNFAExecutorNode
extends TRegexBacktrackerSubExecutorNode {
    private static final int FLAG_WRITES_CAPTURE_GROUPS = 1;
    private static final int FLAG_FORWARD = 2;
    private static final int FLAG_BACKREF_WITH_NULL_TARGET_FAILS = 4;
    private static final int FLAG_MONITOR_CAPTURE_GROUPS_IN_EMPTY_CHECK = 8;
    private static final int FLAG_TRANSITION_MATCHES_STEP_BY_STEP = 16;
    private static final int FLAG_TRACK_LAST_GROUP = 32;
    private static final int FLAG_RETURNS_FIRST_GROUP = 64;
    private static final int FLAG_MUST_ADVANCE = 128;
    private static final int FLAG_LONE_SURROGATES = 256;
    private static final int FLAG_LOOPBACK_INITIAL_STATE = 512;
    private static final int FLAG_USE_MERGE_EXPLODE = 1024;
    private static final int FLAG_RECURSIVE_BACK_REFERENCES = 4096;
    private final PureNFA nfa;
    private final int numberOfStates;
    private final int nQuantifiers;
    private final int nZeroWidthQuantifiers;
    private final int maxNTransitions;
    private final int flags;
    private final InnerLiteral innerLiteral;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CharMatcher[] matchers;
    private final int[] zeroWidthTermEnclosedCGLow;
    private final int[] zeroWidthQuantifierCGOffsets;
    private final BiPredicate<Integer, Integer> equalsIgnoreCase;
    @Node.Child
    InputRegionMatchesNode regionMatchesNode;
    @Node.Child
    InputIndexOfStringNode indexOfNode;
    private final CharMatcher loopbackInitialStateMatcher;
    private static final int IP_BEGIN = -1;
    private static final int IP_BACKTRACK = -2;
    private static final int IP_END = -3;

    public TRegexBacktrackingNFAExecutorNode(RegexAST ast, PureNFA nfa, int numberOfStates, int numberOfTransitions, TRegexExecutorBaseNode[] subExecutors, boolean mustAdvance, CompilationBuffer compilationBuffer) {
        super(ast, numberOfTransitions, subExecutors);
        CodePointSet initialCharSet;
        this.numberOfStates = numberOfStates;
        RegexASTSubtreeRootNode subtree = nfa.getASTSubtree(ast);
        this.nfa = nfa;
        this.flags = TRegexBacktrackingNFAExecutorNode.createFlags(ast, nfa, mustAdvance, subtree, numberOfStates, numberOfTransitions);
        this.nQuantifiers = ast.getQuantifierCount().getCount();
        this.nZeroWidthQuantifiers = ast.getZeroWidthQuantifiables().size();
        List<QuantifiableTerm> zeroWidthQuantifiables = ast.getZeroWidthQuantifiables();
        this.zeroWidthTermEnclosedCGLow = new int[this.nZeroWidthQuantifiers];
        this.zeroWidthQuantifierCGOffsets = new int[this.zeroWidthTermEnclosedCGLow.length + 1];
        int offset = 0;
        for (int i = 0; i < this.nZeroWidthQuantifiers; ++i) {
            QuantifiableTerm quantifiable = zeroWidthQuantifiables.get(i);
            if (quantifiable.isGroup()) {
                Group group = quantifiable.asGroup();
                this.zeroWidthTermEnclosedCGLow[i] = group.getEnclosedCaptureGroupsLow();
                offset += 2 * (group.getEnclosedCaptureGroupsHigh() - group.getEnclosedCaptureGroupsLow());
            }
            this.zeroWidthQuantifierCGOffsets[i + 1] = offset;
        }
        this.innerLiteral = nfa.isRoot() && ast.getProperties().hasInnerLiteral() ? ast.extractInnerLiteral() : null;
        this.equalsIgnoreCase = ast.getOptions().getFlavor().getEqualsIgnoreCasePredicate(ast);
        this.loopbackInitialStateMatcher = this.isLoopbackInitialState() && this.innerLiteral == null ? ((initialCharSet = nfa.getMergedInitialStateCharSet(ast, compilationBuffer)) == null ? null : CharMatchers.createMatcher(initialCharSet, compilationBuffer)) : null;
        nfa.materializeGroupBoundaries();
        this.matchers = new CharMatcher[nfa.getNumberOfStates()];
        int maxTransitions = 0;
        for (int i = 0; i < this.matchers.length; ++i) {
            PureNFAState s = nfa.getState(i);
            if (s.isCharacterClass()) {
                this.matchers[i] = CharMatchers.createMatcher(s.getCharSet(), compilationBuffer);
            }
            maxTransitions = Math.max(maxTransitions, ((PureNFATransition[])s.getSuccessors()).length);
            s.initIsDeterministic(compilationBuffer);
        }
        for (TRegexExecutorBaseNode subExecutor : subExecutors) {
            if (!(subExecutor instanceof TRegexBacktrackingNFAExecutorNode)) continue;
            maxTransitions = Math.max(maxTransitions, ((TRegexBacktrackingNFAExecutorNode)subExecutor).maxNTransitions);
        }
        this.maxNTransitions = maxTransitions;
    }

    private TRegexBacktrackingNFAExecutorNode(TRegexBacktrackingNFAExecutorNode copy) {
        super(copy);
        this.nfa = copy.nfa;
        this.numberOfStates = copy.numberOfStates;
        this.nQuantifiers = copy.nQuantifiers;
        this.nZeroWidthQuantifiers = copy.nZeroWidthQuantifiers;
        this.maxNTransitions = copy.maxNTransitions;
        this.flags = copy.flags;
        this.innerLiteral = copy.innerLiteral;
        this.matchers = copy.matchers;
        this.zeroWidthTermEnclosedCGLow = copy.zeroWidthTermEnclosedCGLow;
        this.zeroWidthQuantifierCGOffsets = copy.zeroWidthQuantifierCGOffsets;
        this.equalsIgnoreCase = copy.equalsIgnoreCase;
        this.loopbackInitialStateMatcher = copy.loopbackInitialStateMatcher;
    }

    @Override
    public TRegexBacktrackerSubExecutorNode shallowCopy() {
        return new TRegexBacktrackingNFAExecutorNode(this);
    }

    @Override
    public int getNumberOfStates() {
        return this.numberOfStates;
    }

    private static int createFlags(RegexAST ast, PureNFA nfa, boolean mustAdvance, RegexASTSubtreeRootNode subtree, int nStates, int nTransitions) {
        int flags = 0;
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 1, subtree.hasCaptureGroups());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 2, !(subtree instanceof LookBehindAssertion));
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 4, ast.getOptions().getFlavor().backreferencesToUnmatchedGroupsFail());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 8, ast.getOptions().getFlavor().emptyChecksMonitorCaptureGroups());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 16, ast.getOptions().getFlavor().matchesTransitionsStepByStep());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 32, ast.getOptions().getFlavor().usesLastGroupResultField());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 64, !TRegexBacktrackingNFAExecutorNode.isFlagSet(flags, 2) && ast.getOptions().getFlavor().lookBehindsRunLeftToRight());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 128, mustAdvance);
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 256, ast.getProperties().hasLoneSurrogates());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 512, nfa.isRoot() && !ast.getFlags().isSticky() && !ast.getRoot().startsWithCaret());
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 1024, nStates <= 300 && nTransitions <= 300);
        flags = TRegexBacktrackingNFAExecutorNode.setFlag(flags, 4096, ast.getProperties().hasRecursiveBackReferences());
        return flags;
    }

    @Override
    public boolean writesCaptureGroups() {
        return this.isFlagSet(1);
    }

    @Override
    public String getName() {
        return "bt";
    }

    @Override
    public boolean isForward() {
        return this.isFlagSet(2);
    }

    public boolean isBackrefWithNullTargetFails() {
        return this.isFlagSet(4);
    }

    public boolean isMonitorCaptureGroupsInEmptyCheck() {
        return this.isFlagSet(8);
    }

    public boolean isTransitionMatchesStepByStep() {
        return this.isFlagSet(16);
    }

    public boolean isTrackLastGroup() {
        return this.isFlagSet(32);
    }

    public boolean isMustAdvance() {
        return this.isFlagSet(128);
    }

    public boolean isLoneSurrogates() {
        return this.isFlagSet(256);
    }

    public boolean isLoopbackInitialState() {
        return this.isFlagSet(512);
    }

    public boolean isUseMergeExplode() {
        return this.isFlagSet(1024);
    }

    public boolean isRecursiveBackreferences() {
        return this.isFlagSet(4096);
    }

    private boolean isFlagSet(int flag) {
        return TRegexBacktrackingNFAExecutorNode.isFlagSet(this.flags, flag);
    }

    @Override
    public TRegexExecutorLocals createLocals(TruffleString input, int fromIndex, int index, int maxIndex) {
        return TRegexBacktrackingNFAExecutorLocals.create(input, fromIndex, index, maxIndex, this.getNumberOfCaptureGroups(), this.nQuantifiers, this.nZeroWidthQuantifiers, this.zeroWidthTermEnclosedCGLow, this.zeroWidthQuantifierCGOffsets, this.isTransitionMatchesStepByStep(), this.maxNTransitions, this.isTrackLastGroup(), this.returnsFirstGroup(), this.isRecursiveBackreferences());
    }

    @Override
    public Object execute(VirtualFrame frame, TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        if (this.innerLiteral != null) {
            locals.setIndex(locals.getFromIndex());
            int innerLiteralIndex = this.findInnerLiteral(locals);
            if (CompilerDirectives.injectBranchProbability(0.010000000000000009, innerLiteralIndex < 0)) {
                return null;
            }
            locals.setLastInnerLiteralIndex(innerLiteralIndex);
            if (this.innerLiteral.getMaxPrefixSize() < 0) {
                locals.setIndex(locals.getFromIndex());
            } else {
                locals.setIndex(innerLiteralIndex);
                this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize(), codeRange);
            }
        }
        if (this.isLoopbackInitialState()) {
            locals.setLastInitialStateIndex(locals.getIndex());
        }
        if (this.isUseMergeExplode()) {
            this.runMergeExplode(frame, locals, codeRange);
        } else {
            this.runSlowPath(frame.materialize(), locals, codeRange);
        }
        return locals.popResult();
    }

    @CompilerDirectives.TruffleBoundary
    private void runSlowPath(MaterializedFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        this.runMergeExplode(frame, locals, codeRange);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    private void runMergeExplode(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        block18: {
            int nextIp;
            int ip = -1;
            block0: while (true) {
                locals.incLoopCount(this);
                if (CompilerDirectives.inInterpreter()) {
                    RegexRootNode.checkThreadInterrupted();
                }
                CompilerAsserts.partialEvaluationConstant(ip);
                if (ip == -1) {
                    if (this.nfa.getAnchoredInitialState() != this.nfa.getUnAnchoredInitialState() && this.inputAtBegin(locals)) {
                        ip = this.nfa.getAnchoredInitialState().getId();
                        continue;
                    }
                    ip = this.nfa.getUnAnchoredInitialState().getId();
                    continue;
                }
                if (ip == -2) {
                    if (CompilerDirectives.injectBranchProbability(0.010000000000000009, locals.canPopResult())) break block18;
                    if (!locals.canPop()) {
                        if (!this.isLoopbackInitialState()) break block18;
                        assert (this.isForward());
                        locals.setIndex(locals.getLastInitialStateIndex());
                        if (CompilerDirectives.injectBranchProbability(0.010000000000000009, !this.inputHasNext(locals))) break block18;
                        this.inputSkip(locals, codeRange);
                        if (this.innerLiteral != null) {
                            if (locals.getLastInitialStateIndex() == locals.getLastInnerLiteralIndex()) {
                                int innerLiteralIndex = this.findInnerLiteral(locals);
                                if (CompilerDirectives.injectBranchProbability(0.010000000000000009, innerLiteralIndex < 0)) break block18;
                                if (this.innerLiteral.getMaxPrefixSize() < 0) {
                                    locals.setIndex(locals.getLastInnerLiteralIndex());
                                    locals.setLastInnerLiteralIndex(innerLiteralIndex);
                                } else {
                                    locals.setLastInnerLiteralIndex(innerLiteralIndex);
                                    locals.setIndex(innerLiteralIndex);
                                    this.rewindUpTo(locals, locals.getFromIndex(), this.innerLiteral.getMaxPrefixSize(), codeRange);
                                }
                            }
                        } else if (this.loopbackInitialStateMatcher != null) {
                            assert (this.isForward());
                            while (CompilerDirectives.injectBranchProbability(0.99, this.inputHasNext(locals)) && !CompilerDirectives.injectBranchProbability(0.010000000000000009, this.loopbackInitialStateMatcher.match(this.inputReadAndDecode(locals, codeRange)))) {
                                this.inputAdvance(locals);
                            }
                        }
                        locals.setLastInitialStateIndex(locals.getIndex());
                        locals.resetToInitialState();
                        ip = this.nfa.getUnAnchoredInitialState().getId();
                        continue;
                    }
                    int nextIp2 = locals.pop();
                    for (int i = 0; i < this.nfa.getNumberOfStates(); ++i) {
                        int stateId = this.nfa.getState(i).getId();
                        CompilerAsserts.partialEvaluationConstant(stateId);
                        if (stateId != nextIp2) continue;
                        ip = stateId;
                        continue block0;
                    }
                    break block18;
                }
                if (ip == -3) break block18;
                PureNFAState curState = this.nfa.getState(ip);
                CompilerAsserts.partialEvaluationConstant(curState);
                PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors();
                CompilerAsserts.partialEvaluationConstant(successors);
                CompilerAsserts.partialEvaluationConstant(successors.length);
                nextIp = this.runState(frame, locals, codeRange, curState);
                for (int i = 0; i < successors.length; ++i) {
                    int targetIp = successors[i].getTarget().getId();
                    if (targetIp != nextIp) continue;
                    CompilerAsserts.partialEvaluationConstant(targetIp);
                    ip = targetIp;
                    continue block0;
                }
                if (nextIp != -2) break;
                ip = -2;
            }
            assert (nextIp == -3);
        }
    }

    @ExplodeLoop
    private int runState(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFAState curState) {
        long bs;
        int iBS;
        CompilerAsserts.partialEvaluationConstant(curState);
        if (CompilerDirectives.injectBranchProbability(0.010000000000000009, this.isAcceptableFinalState(curState, locals))) {
            locals.setResult();
            locals.pushResult();
            return -3;
        }
        if (curState.isSubMatcher() && !this.canInlineLookAroundIntoTransition(curState)) {
            TRegexBacktrackingNFAExecutorLocals subLocals = locals.createSubNFALocals(this.subExecutorReturnsFirstGroup(curState));
            int[] subMatchResult = this.runSubMatcher(frame, subLocals, codeRange, curState);
            if (CompilerDirectives.injectBranchProbability(0.010000000000000009, TRegexBacktrackingNFAExecutorNode.subMatchFailed(curState, subMatchResult))) {
                return -2;
            }
            if (!curState.isSubMatcherNegated() && this.getSubExecutor(curState).writesCaptureGroups()) {
                locals.overwriteCaptureGroups(subMatchResult);
            }
            if (!curState.isLookAround()) {
                locals.saveIndex(subLocals.getIndex());
                locals.restoreIndex();
            }
        }
        if (curState.isBackReference() && !this.canInlineBackReferenceIntoTransition(curState)) {
            int backrefResult = this.matchBackReferenceGeneric(locals, curState, codeRange);
            if (CompilerDirectives.injectBranchProbability(0.010000000000000009, backrefResult < 0)) {
                return -2;
            }
            locals.setIndex(backrefResult);
        }
        PureNFATransition[] successors = (PureNFATransition[])curState.getSuccessors();
        CompilerAsserts.partialEvaluationConstant(successors);
        CompilerAsserts.partialEvaluationConstant(successors.length);
        boolean atEnd = this.inputAtEnd(locals);
        int c = atEnd ? 0 : this.inputReadAndDecode(locals, codeRange);
        int index = locals.getIndex();
        if (curState.isDeterministic()) {
            if (this.isTransitionMatchesStepByStep()) {
                int[] currentFrame = locals.getStackFrameBuffer();
                locals.readFrame(currentFrame);
                for (int i = 0; i < successors.length; ++i) {
                    PureNFATransition transition = successors[i];
                    CompilerAsserts.partialEvaluationConstant(transition);
                    if (this.tryUpdateState(frame, locals, codeRange, transition, index, atEnd, c)) {
                        locals.restoreIndex();
                        return transition.getTarget().getId();
                    }
                    locals.writeFrame(currentFrame);
                }
                return -2;
            }
            for (int i = 0; i < successors.length; ++i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (!this.transitionMatches(frame, locals, codeRange, transition, index, atEnd, c)) continue;
                this.updateState(locals, transition, index);
                locals.restoreIndex();
                return transition.getTarget().getId();
            }
            return -2;
        }
        if (this.isTransitionMatchesStepByStep()) {
            boolean hasMatchingTransition = false;
            boolean transitionToFinalStateWins = false;
            int[] currentFrame = locals.getStackFrameBuffer();
            locals.readFrame(currentFrame);
            for (int i = successors.length - 1; i >= 0; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (this.tryUpdateState(frame, locals, codeRange, transition, index, atEnd, c)) {
                    hasMatchingTransition = true;
                    PureNFAState target = transition.getTarget();
                    CompilerAsserts.partialEvaluationConstant(target);
                    if (this.isAcceptableFinalState(target, locals)) {
                        locals.setResult();
                        locals.pushResult();
                        transitionToFinalStateWins = true;
                        locals.writeFrame(currentFrame);
                        continue;
                    }
                    locals.setPc(target.getId());
                    transitionToFinalStateWins = false;
                    locals.pushFrame(currentFrame);
                    continue;
                }
                locals.writeFrame(currentFrame);
            }
            if (transitionToFinalStateWins) {
                return -3;
            }
            if (hasMatchingTransition) {
                locals.pop();
                return locals.getPc();
            }
            return -2;
        }
        long[] transitionBitSet = locals.getTransitionBitSet();
        int bitSetWords = (successors.length - 1 >> 6) + 1;
        CompilerAsserts.partialEvaluationConstant(bitSetWords);
        int lastMatch = 0;
        int lastFinal = 0;
        int nMatched = -1;
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant(iBS);
            bs = 0L;
            long bit = 1L;
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant(iStart);
            CompilerAsserts.partialEvaluationConstant(iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                if (this.transitionMatches(frame, locals, codeRange, transition, index, atEnd, c)) {
                    bs |= bit;
                    lastMatch = i;
                    if (this.isAcceptableFinalState(transition.getTarget(), locals)) {
                        locals.setResult();
                        lastFinal = i;
                        --nMatched;
                    }
                }
                bit <<= 1;
            }
            transitionBitSet[iBS] = bs;
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            nMatched += Long.bitCount(transitionBitSet[iBS]);
        }
        if (CompilerDirectives.injectBranchProbability(0.75, nMatched > 0)) {
            locals.dupFrame(nMatched);
        }
        for (iBS = 0; iBS < bitSetWords; ++iBS) {
            CompilerAsserts.partialEvaluationConstant(iBS);
            bs = transitionBitSet[iBS];
            int iStart = successors.length - (iBS << 6) - 1;
            int iEnd = Math.max(-1, iStart - 64);
            CompilerAsserts.partialEvaluationConstant(iStart);
            CompilerAsserts.partialEvaluationConstant(iEnd);
            for (int i = iStart; i > iEnd; --i) {
                PureNFATransition transition = successors[i];
                CompilerAsserts.partialEvaluationConstant(transition);
                PureNFAState target = transition.getTarget();
                CompilerAsserts.partialEvaluationConstant(target);
                if ((bs & 1L) != 0L) {
                    if (this.isAcceptableFinalState(target, locals)) {
                        if (i == lastFinal) {
                            locals.pushResult(transition, index);
                        }
                        if (i == lastMatch) {
                            return -3;
                        }
                    } else {
                        this.updateState(locals, transition, index);
                        if (i == lastMatch) {
                            locals.restoreIndex();
                            return target.getId();
                        }
                        locals.setPc(target.getId());
                        locals.push();
                    }
                }
                bs >>>= 1;
            }
        }
        return -2;
    }

    private boolean isAcceptableFinalState(PureNFAState state, TRegexBacktrackingNFAExecutorLocals locals) {
        return state.isFinalState() && (!this.isMustAdvance() || locals.getIndex() != locals.getFromIndex());
    }

    public boolean returnsFirstGroup() {
        return this.isFlagSet(64);
    }

    private TRegexExecutorBaseNode getSubExecutor(PureNFAState subMatcherState) {
        return this.subExecutors[subMatcherState.getSubtreeId()];
    }

    protected boolean lookAroundExecutorIsLiteral(PureNFAState s) {
        return this.getSubExecutor(s).unwrap() instanceof TRegexLiteralLookAroundExecutorNode;
    }

    private boolean subExecutorReturnsFirstGroup(PureNFAState s) {
        TRegexExecutorNode executor = this.getSubExecutor(s).unwrap();
        if (executor instanceof TRegexBacktrackingNFAExecutorNode) {
            return ((TRegexBacktrackingNFAExecutorNode)executor).returnsFirstGroup();
        }
        return false;
    }

    private boolean canInlineLookAroundIntoTransition(PureNFAState s) {
        return s.isLookAround() && this.lookAroundExecutorIsLiteral(s) && (s.isSubMatcherNegated() || !this.getSubExecutor(s).writesCaptureGroups());
    }

    private boolean checkSubMatcherInline(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, PureNFAState target) {
        if (this.lookAroundExecutorIsLiteral(target)) {
            int saveIndex = locals.getIndex();
            int saveNextIndex = locals.getNextIndex();
            boolean result2 = (Boolean)this.getSubExecutor(target).execute(frame, locals, codeRange);
            locals.setIndex(saveIndex);
            locals.setNextIndex(saveNextIndex);
            return result2;
        }
        return !TRegexBacktrackingNFAExecutorNode.subMatchFailed(target, this.runSubMatcher(frame, locals.createSubNFALocals(transition, this.subExecutorReturnsFirstGroup(target)), codeRange, target));
    }

    protected int[] runSubMatcher(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals subLocals, TruffleString.CodeRange codeRange, PureNFAState subMatcherState) {
        return (int[])this.getSubExecutor(subMatcherState).execute(frame, subLocals, codeRange);
    }

    protected static boolean subMatchFailed(PureNFAState curState, Object subMatchResult) {
        return subMatchResult == null != curState.isSubMatcherNegated();
    }

    @ExplodeLoop
    protected boolean transitionMatches(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, int index, boolean atEnd, int c) {
        PureNFAState target = transition.getTarget();
        CompilerAsserts.partialEvaluationConstant(target);
        if (transition.hasCaretGuard() && index != 0) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getMaxIndex()) {
            return false;
        }
        block16: for (QuantifierGuard guard : transition.getQuantifierGuards()) {
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (guard.getKind()) {
                case loop: {
                    if (locals.getQuantifierCount(q) != q.getMax()) continue block16;
                    return false;
                }
                case exit: {
                    if (locals.getQuantifierCount(q) >= q.getMin()) continue block16;
                    return false;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) != index || this.isMonitorCaptureGroupsInEmptyCheck() && !locals.isResultUnmodifiedByZeroWidthQuantifier(q) || q.hasIndex() && locals.getQuantifierCount(q) <= q.getMin()) continue block16;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) == index && (!this.isMonitorCaptureGroupsInEmptyCheck() || locals.isResultUnmodifiedByZeroWidthQuantifier(q))) continue block16;
                    return false;
                }
                case enterEmptyMatch: {
                    if (locals.getQuantifierCount(q) < q.getMin()) continue block16;
                    return false;
                }
                case checkGroupMatched: {
                    if (TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(guard.getIndex()), index) != -1 && TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(guard.getIndex()), index) != -1) continue block16;
                    return false;
                }
                case checkGroupNotMatched: {
                    if (TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(guard.getIndex()), index) == -1 || TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(guard.getIndex()), index) == -1) continue block16;
                    return false;
                }
            }
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState());
                return target.isAnchoredFinalState() ? atEnd : true;
            }
            case 1: {
                return !atEnd && this.matchers[target.getId()].match(c);
            }
            case 2: {
                if (this.canInlineLookAroundIntoTransition(target)) {
                    return this.checkSubMatcherInline(frame, locals, codeRange, transition, target);
                }
                return true;
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition(target)) {
                    return this.matchBackReferenceSimple(locals, target, transition, index);
                }
                return true;
            }
            case 4: {
                return true;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected static int getBackRefBoundary(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int cgIndex, int index) {
        return transition.getGroupBoundaries().getUpdateIndices().get(cgIndex) ? index : (transition.getGroupBoundaries().getClearIndices().get(cgIndex) ? -1 : locals.getCaptureGroupBoundary(cgIndex));
    }

    @ExplodeLoop
    protected void updateState(TRegexBacktrackingNFAExecutorLocals locals, PureNFATransition transition, int index) {
        CompilerAsserts.partialEvaluationConstant(transition);
        if (this.isRecursiveBackreferences()) {
            assert (this.isForward());
            for (QuantifierGuard guard : transition.getQuantifierGuards()) {
                CompilerAsserts.partialEvaluationConstant(guard);
                if (guard.getKind() != QuantifierGuard.Kind.updateRecursiveBackrefPointer) continue;
                locals.saveRecursiveBackrefGroupStart(guard.getIndex());
            }
        }
        locals.apply(transition, index);
        block7: for (QuantifierGuard guard : transition.getQuantifierGuards()) {
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (guard.getKind()) {
                case loop: 
                case enter: 
                case loopInc: {
                    locals.incQuantifierCount(q);
                    continue block7;
                }
                case exit: 
                case exitReset: {
                    locals.resetQuantifierCount(q);
                    continue block7;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(q);
                    locals.setZeroWidthQuantifierResults(q);
                    continue block7;
                }
                case enterEmptyMatch: {
                    if (!transition.hasCaretGuard() && !transition.hasDollarGuard()) {
                        locals.setQuantifierCount(q, q.getMin());
                        continue block7;
                    }
                    locals.incQuantifierCount(q);
                    continue block7;
                }
            }
        }
        locals.saveIndex(this.getNewIndex(locals, transition.getTarget(), index));
    }

    @ExplodeLoop
    protected boolean tryUpdateState(VirtualFrame frame, TRegexBacktrackingNFAExecutorLocals locals, TruffleString.CodeRange codeRange, PureNFATransition transition, int index, boolean atEnd, int c) {
        CompilerAsserts.partialEvaluationConstant(transition);
        PureNFAState target = transition.getTarget();
        CompilerAsserts.partialEvaluationConstant(target);
        if (transition.hasCaretGuard() && index != 0) {
            return false;
        }
        if (transition.hasDollarGuard() && index < locals.getMaxIndex()) {
            return false;
        }
        switch (target.getKind()) {
            case 0: {
                assert (!target.isInitialState());
                if (!target.isAnchoredFinalState() || atEnd) break;
                return false;
            }
            case 1: {
                if (!atEnd && this.matchers[target.getId()].match(c)) break;
                return false;
            }
            case 2: {
                if (!this.canInlineLookAroundIntoTransition(target) || this.checkSubMatcherInline(frame, locals, codeRange, transition, target)) break;
                return false;
            }
            case 3: {
                if (!this.canInlineBackReferenceIntoTransition(target) || this.matchBackReferenceSimple(locals, target, transition, index)) break;
                return false;
            }
            case 4: {
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        block21: for (QuantifierGuard guard : transition.getQuantifierGuards()) {
            CompilerAsserts.partialEvaluationConstant(guard);
            Token.Quantifier q = guard.getQuantifier();
            CompilerAsserts.partialEvaluationConstant(q);
            switch (guard.getKind()) {
                case enter: 
                case loopInc: {
                    locals.incQuantifierCount(q);
                    continue block21;
                }
                case loop: {
                    if (locals.getQuantifierCount(q) == q.getMax()) {
                        return false;
                    }
                    locals.incQuantifierCount(q);
                    continue block21;
                }
                case exit: {
                    if (locals.getQuantifierCount(q) < q.getMin()) {
                        return false;
                    }
                    locals.resetQuantifierCount(q);
                    continue block21;
                }
                case exitReset: {
                    locals.resetQuantifierCount(q);
                    continue block21;
                }
                case updateCG: {
                    locals.setCaptureGroupBoundary(guard.getIndex(), index);
                    if (!this.isTrackLastGroup() || guard.getIndex() % 2 == 0 || guard.getIndex() <= 1) continue block21;
                    locals.setLastGroup(guard.getIndex() / 2);
                    continue block21;
                }
                case updateRecursiveBackrefPointer: {
                    locals.saveRecursiveBackrefGroupStart(guard.getIndex());
                    continue block21;
                }
                case enterZeroWidth: {
                    locals.setZeroWidthQuantifierGuardIndex(q);
                    locals.setZeroWidthQuantifierResults(q);
                    continue block21;
                }
                case exitZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) != index || this.isMonitorCaptureGroupsInEmptyCheck() && !locals.isResultUnmodifiedByZeroWidthQuantifier(q) || q.hasIndex() && locals.getQuantifierCount(q) <= q.getMin()) continue block21;
                    return false;
                }
                case escapeZeroWidth: {
                    if (locals.getZeroWidthQuantifierGuardIndex(q) == index && (!this.isMonitorCaptureGroupsInEmptyCheck() || locals.isResultUnmodifiedByZeroWidthQuantifier(q))) continue block21;
                    return false;
                }
                case enterEmptyMatch: {
                    if (locals.getQuantifierCount(q) >= q.getMin()) {
                        return false;
                    }
                    if (!transition.hasCaretGuard() && !transition.hasDollarGuard()) {
                        locals.setQuantifierCount(q, q.getMin());
                        continue block21;
                    }
                    locals.incQuantifierCount(q);
                    continue block21;
                }
                case checkGroupMatched: {
                    if (locals.getCaptureGroupStart(guard.getIndex()) != -1 && locals.getCaptureGroupEnd(guard.getIndex()) != -1) continue block21;
                    return false;
                }
                case checkGroupNotMatched: {
                    if (locals.getCaptureGroupStart(guard.getIndex()) == -1 || locals.getCaptureGroupEnd(guard.getIndex()) == -1) continue block21;
                    return false;
                }
            }
        }
        locals.saveIndex(this.getNewIndex(locals, target, index));
        return true;
    }

    private Pair<Integer, Integer> getBackRefBounds(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference) {
        for (int backRefNumber : backReference.getBackRefNumbers()) {
            int start2 = this.isRecursiveBackreferences() && backReference.isRecursiveReference() ? locals.getRecursiveCaptureGroupStart(backRefNumber) : locals.getCaptureGroupStart(backRefNumber);
            int end = locals.getCaptureGroupEnd(backRefNumber);
            if (start2 < 0 || end < 0) continue;
            return Pair.create(start2, end);
        }
        return Pair.create(-1, -1);
    }

    private Pair<Integer, Integer> getBackRefBounds(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, PureNFATransition transition, int index) {
        for (int backRefNumber : backReference.getBackRefNumbers()) {
            int start2 = this.isRecursiveBackreferences() && backReference.isRecursiveReference() ? locals.getRecursiveCaptureGroupStart(backRefNumber) : TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexStart(backRefNumber), index);
            int end = TRegexBacktrackingNFAExecutorNode.getBackRefBoundary(locals, transition, Group.groupNumberToBoundaryIndexEnd(backRefNumber), index);
            if (start2 < 0 || end < 0) continue;
            return Pair.create(start2, end);
        }
        return Pair.create(-1, -1);
    }

    private int getNewIndex(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState target, int index) {
        CompilerAsserts.partialEvaluationConstant(target.getKind());
        switch (target.getKind()) {
            case 0: 
            case 2: 
            case 4: {
                return index;
            }
            case 1: {
                return locals.getNextIndex();
            }
            case 3: {
                if (this.canInlineBackReferenceIntoTransition(target)) {
                    Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, target);
                    int start2 = backRefBounds.getLeft();
                    int end = backRefBounds.getRight();
                    if (start2 < 0 || end < 0) {
                        return index;
                    }
                    int length2 = end - start2;
                    return this.isForward() ? index + length2 : index - length2;
                }
                return index;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private boolean canInlineBackReferenceIntoTransition(PureNFAState backRef) {
        assert (backRef.isBackReference());
        return !backRef.isIgnoreCaseReference() && !this.isLoneSurrogates();
    }

    private boolean matchBackReferenceSimple(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, PureNFATransition transition, int index) {
        assert (backReference.isBackReference());
        assert (this.canInlineBackReferenceIntoTransition(backReference));
        Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, backReference, transition, index);
        int backrefStart = backRefBounds.getLeft();
        int backrefEnd = backRefBounds.getRight();
        if (backrefStart < 0 || backrefEnd < 0) {
            return !this.isBackrefWithNullTargetFails();
        }
        if (this.regionMatchesNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regionMatchesNode = this.insert(InputRegionMatchesNode.create());
        }
        int inputLength = locals.getMaxIndex();
        int backrefLength = backrefEnd - backrefStart;
        if (backrefLength == 0) {
            return true;
        }
        if (this.isForward() ? index + backrefLength > inputLength : index - backrefLength < 0) {
            return false;
        }
        return this.regionMatchesNode.execute(this, locals.getInput(), backrefStart, locals.getInput(), this.isForward() ? index : index - backrefLength, backrefLength, null, this.getEncoding());
    }

    private int matchBackReferenceGeneric(TRegexBacktrackingNFAExecutorLocals locals, PureNFAState backReference, TruffleString.CodeRange codeRange) {
        assert (backReference.isBackReference());
        assert (!this.canInlineBackReferenceIntoTransition(backReference));
        Pair<Integer, Integer> backRefBounds = this.getBackRefBounds(locals, backReference);
        int backrefStart = backRefBounds.getLeft();
        int backrefEnd = backRefBounds.getRight();
        if (backrefStart < 0 || backrefEnd < 0) {
            return this.isBackrefWithNullTargetFails() ? -1 : locals.getIndex();
        }
        int saveNextIndex = locals.getNextIndex();
        int inputLength = locals.getMaxIndex();
        int iBR = this.isForward() ? backrefStart : backrefEnd;
        int i = locals.getIndex();
        while (CompilerDirectives.injectBranchProbability(0.99, this.inputBoundsCheck(iBR, backrefStart, backrefEnd))) {
            if (CompilerDirectives.injectBranchProbability(0.010000000000000009, !this.inputBoundsCheck(i, 0, inputLength))) {
                locals.setNextIndex(saveNextIndex);
                return -1;
            }
            int codePointBR = this.inputReadAndDecode(locals, iBR, codeRange);
            iBR = locals.getNextIndex();
            int codePointI = this.inputReadAndDecode(locals, i, codeRange);
            i = locals.getNextIndex();
            if (!CompilerDirectives.injectBranchProbability(0.010000000000000009, !(!backReference.isIgnoreCaseReference() ? codePointBR == codePointI : this.equalsIgnoreCase(codePointBR, codePointI)))) continue;
            locals.setNextIndex(saveNextIndex);
            return -1;
        }
        locals.setNextIndex(saveNextIndex);
        return i;
    }

    private int findInnerLiteral(TRegexBacktrackingNFAExecutorLocals locals) {
        if (this.indexOfNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexOfNode = this.insert(InputIndexOfStringNode.create());
        }
        return this.indexOfNode.execute(this, locals.getInput(), locals.getIndex(), locals.getMaxIndex(), this.innerLiteral.getLiteralContent(), this.innerLiteral.getMaskContent(), this.getEncoding());
    }

    private boolean inputBoundsCheck(int i, int min, int max) {
        return this.isForward() ? i < max : i > min;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean equalsIgnoreCase(int a, int b) {
        return this.equalsIgnoreCase.test(a, b);
    }

    private static int setFlag(int flags, int flag, boolean value2) {
        if (value2) {
            return flags | flag;
        }
        return flags & ~flag;
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

