/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;

public class InboundHttpToHttp2Adapter
extends ChannelInboundHandlerAdapter {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    public InboundHttpToHttp2Adapter(Http2Connection connection, Http2FrameListener listener2) {
        this.connection = connection;
        this.listener = listener2;
    }

    private static int getStreamId(Http2Connection connection, HttpHeaders httpHeaders) {
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), connection.remote().incrementAndGetNextStreamId());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            InboundHttpToHttp2Adapter.handle(ctx, this.connection, this.listener, (FullHttpMessage)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handle(ChannelHandlerContext ctx, Http2Connection connection, Http2FrameListener listener2, FullHttpMessage message) throws Http2Exception {
        try {
            int streamId = InboundHttpToHttp2Adapter.getStreamId(connection, message.headers());
            Http2Stream stream2 = connection.stream(streamId);
            if (stream2 == null) {
                stream2 = connection.remote().createStream(streamId, false);
            }
            message.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)HttpScheme.HTTP.name());
            Http2Headers messageHeaders = HttpConversionUtil.toHttp2Headers((HttpMessage)message, true);
            boolean hasContent = message.content().isReadable();
            boolean hasTrailers = !message.trailingHeaders().isEmpty();
            listener2.onHeadersRead(ctx, streamId, messageHeaders, 0, !hasContent && !hasTrailers);
            if (hasContent) {
                listener2.onDataRead(ctx, streamId, message.content(), 0, !hasTrailers);
            }
            if (hasTrailers) {
                Http2Headers headers2 = HttpConversionUtil.toHttp2Headers(message.trailingHeaders(), true);
                listener2.onHeadersRead(ctx, streamId, headers2, 0, true);
            }
            stream2.closeRemoteSide();
        }
        finally {
            message.release();
        }
    }
}

