/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight.djangoForms;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormClassType;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormSetClassType;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormWrapper;
import com.intellij.util.ArrayUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.extensions.FQNamesProviderExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFormTypeProvider
extends PyTypeProviderBase {
    private static final String[] FORM_VIEW_METHODS = new String[]{"form_valid", "form_invalid"};

    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        if (param == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(0);
        }
        if (func == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(2);
        }
        if (!ArrayUtil.contains((String)func.getName(), (String[])FORM_VIEW_METHODS)) {
            return null;
        }
        if (!"form".equals(param.getName())) {
            return null;
        }
        PyClass aClass = func.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PyTargetExpression formClassAttribute = aClass.findClassAttribute("form_class", true, context);
        if (formClassAttribute == null) {
            return null;
        }
        PyExpression formClassValue = formClassAttribute.findAssignedValue();
        if (formClassValue == null) {
            return null;
        }
        PyClassType type = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)formClassValue), PyClassType.class);
        if (type == null) {
            return null;
        }
        return Ref.create((Object)type.toInstance());
    }

    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        String modelFormName;
        if (referenceTarget == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(4);
        }
        if (!(referenceTarget instanceof PyTargetExpression)) {
            return null;
        }
        if (context.maySwitchToAST(referenceTarget)) {
            return null;
        }
        QualifiedName calleeName = ((PyTargetExpression)referenceTarget).getCalleeName();
        if (calleeName == null) {
            return null;
        }
        String lastComponent = calleeName.getLastComponent();
        if (lastComponent == null) {
            return null;
        }
        PyPsiFacade psiFacade = PyPsiFacade.getInstance((Project)referenceTarget.getProject());
        PyClass modelFormClass = psiFacade.createClassByQName(modelFormName = FQNamesProviderExtKt.getFirstName((FQNamesProvider)DjangoFQNamesProvider.MODEL_FORM_CLASS), referenceTarget);
        if (modelFormClass == null) {
            return null;
        }
        PyClassType modelFormClassType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)modelFormClass), PyClassType.class);
        if (modelFormClassType == null) {
            return null;
        }
        modelFormClassType = (PyClassType)modelFormClassType.toInstance();
        if ("formset_factory".equals(lastComponent)) {
            String formSetName = FQNamesProviderExtKt.getFirstName((FQNamesProvider)DjangoFQNamesProvider.BASE_FORMSET_CLASS);
            PyClass formSet = psiFacade.createClassByQName(formSetName, referenceTarget);
            if (formSet == null) {
                return null;
            }
            return Ref.create((Object)((Object)new DjangoFormSetClassType(formSet, modelFormClassType)));
        }
        if ("modelform_factory".equals(lastComponent)) {
            return Ref.create((Object)((Object)new DjangoFormClassType(modelFormClass)));
        }
        if ("modelformset_factory".equals(lastComponent)) {
            PyClass modelFormSet = psiFacade.createClassByQName("django.forms.models.BaseModelFormSet", referenceTarget);
            if (modelFormSet == null) {
                return null;
            }
            return Ref.create((Object)((Object)new DjangoFormSetClassType(modelFormSet, modelFormClassType)));
        }
        return null;
    }

    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String functionName;
        if (function == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(5);
        }
        if (callSite == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(7);
        }
        if ("__getitem__".equals(functionName = function.getName()) && callSite instanceof PySubscriptionExpression) {
            PyType type = DjangoFormTypeProvider.getCallTypeForSubscription((PySubscriptionExpression)callSite, context);
            return type == null ? null : new Ref((Object)PyUnionType.union((PyType)type, null));
        }
        if (callSite instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)callSite;
            if ("formset_factory".equals(functionName)) {
                return DjangoFormTypeProvider.getCallTypeForFormSetFactory(callExpression, context);
            }
            if ("modelform_factory".equals(functionName)) {
                return DjangoFormTypeProvider.getCallTypeForModelFactory(callExpression, context);
            }
            if ("modelformset_factory".equals(functionName)) {
                return DjangoFormTypeProvider.getCallTypeForModelFormSetFactory(callExpression, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyClassType getArgumentAsClass(@NotNull PyCallExpression callExpression, @NotNull FunctionParameter argument, @Nullable String fallbackType, @NotNull TypeEvalContext context) {
        PyClassType possibleResult;
        PyTypedElement typedElement;
        if (callExpression == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(8);
        }
        if (argument == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(10);
        }
        if ((typedElement = (PyTypedElement)callExpression.getArgument(argument, PyTypedElement.class)) != null && (possibleResult = (PyClassType)PyUtil.as((Object)context.getType(typedElement), PyClassType.class)) != null) {
            return possibleResult;
        }
        if (fallbackType == null) {
            return null;
        }
        return (PyClassType)PyUtil.as((Object)PyTypeParser.getTypeByName((PsiElement)callExpression, (String)fallbackType, (TypeEvalContext)context), PyClassType.class);
    }

    @Nullable
    private static Ref<PyType> getCallTypeForModelFormSetFactory(@NotNull PyCallExpression callSite, @NotNull TypeEvalContext context) {
        PyClassType formsetType;
        if (callSite == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(12);
        }
        if ((formsetType = DjangoFormTypeProvider.getArgumentAsClass(callSite, (FunctionParameter)DjangoFunctionParams.MODEL_FORMSET_FORMSET, "django.forms.models.BaseModelFormSet", context)) == null) {
            return null;
        }
        PyClassType formType = DjangoFormTypeProvider.getArgumentAsClass(callSite, (FunctionParameter)DjangoFunctionParams.MODEL_FORM_FORMSET_FORM, FQNamesProviderExtKt.getFirstName((FQNamesProvider)DjangoFQNamesProvider.MODEL_FORM_CLASS), context);
        if (formType == null) {
            return null;
        }
        formType.putUserData(DjangoFormWrapper.DJANGO_MODEL_CLASS_CALL_SITE, (Object)callSite);
        PyCollectionTypeImpl type = new PyCollectionTypeImpl(formsetType.getPyClass(), true, Collections.singletonList(formType));
        type.putUserData(DjangoFormWrapper.DJANGO_MODEL_CLASS_CALL_SITE, (Object)callSite);
        return Ref.create((Object)type);
    }

    @Nullable
    private static Ref<PyType> getCallTypeForModelFactory(@NotNull PyCallExpression callSite, @NotNull TypeEvalContext context) {
        PyClassType formType;
        if (callSite == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(14);
        }
        if ((formType = DjangoFormTypeProvider.getArgumentAsClass(callSite, (FunctionParameter)DjangoFunctionParams.MODEL_FORM_FORMSET_FORM, FQNamesProviderExtKt.getFirstName((FQNamesProvider)DjangoFQNamesProvider.MODEL_FORM_CLASS), context)) == null) {
            return null;
        }
        PyClassTypeImpl type = new PyClassTypeImpl(formType.getPyClass(), true);
        type.putUserData(DjangoFormWrapper.DJANGO_MODEL_CLASS_CALL_SITE, (Object)callSite);
        return Ref.create((Object)type);
    }

    @Nullable
    private static Ref<PyType> getCallTypeForFormSetFactory(@NotNull PyCallExpression callSite, @NotNull TypeEvalContext context) {
        PyClassType formType;
        if (callSite == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(16);
        }
        if ((formType = DjangoFormTypeProvider.getArgumentAsClass(callSite, (FunctionParameter)DjangoFunctionParams.FORMSET_FACTORY_FORM, null, context)) == null) {
            return null;
        }
        PyClassType formSetType = DjangoFormTypeProvider.getArgumentAsClass(callSite, (FunctionParameter)DjangoFunctionParams.FORMSET_FACTORY_FORMSET, "django.forms.formsets.BaseFormSet", context);
        if (formSetType == null) {
            return null;
        }
        List<PyClassTypeImpl> elementTypes = Collections.singletonList(new PyClassTypeImpl(formType.getPyClass(), false));
        return Ref.create((Object)new PyCollectionTypeImpl(formSetType.getPyClass(), true, elementTypes));
    }

    @Nullable
    private static PyType getCallTypeForSubscription(@NotNull PySubscriptionExpression callSite, @NotNull TypeEvalContext context) {
        PyClassType dictType;
        if (callSite == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(18);
        }
        if ((dictType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)callSite.getOperand()), PyClassType.class)) == null) {
            return null;
        }
        StringLiteralExpression keyExpression = (StringLiteralExpression)PyUtil.as((Object)callSite.getIndexExpression(), StringLiteralExpression.class);
        if (keyExpression == null) {
            return null;
        }
        String keyValue = keyExpression.getStringValue();
        PyTypedElement qualifier = (PyTypedElement)new PsiQuery((PsiElement)callSite).map(o -> o.getQualifier()).map(new PsiQuery.PsiFilter(PyQualifiedExpression.class), o -> o.getQualifier()).getFirstElement();
        if (qualifier == null) {
            return null;
        }
        PyClassType formType = (PyClassType)PyUtil.as((Object)context.getType(qualifier), PyClassType.class);
        if (formType == null) {
            return null;
        }
        DjangoFormWrapper formWrapper = DjangoFormWrapper.getInstanceIfForm(formType, context);
        if (formWrapper == null) {
            return null;
        }
        return formWrapper.getAllowedFields(context).stream().filter(o -> keyValue.equals(o.getName())).findFirst().map(DjangoField::getFieldType).orElse(null);
    }

    @Nullable
    public @Nullable Ref<@Nullable PyCallableType> prepareCalleeTypeForCall(@Nullable PyType type, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyCollectionType collectionType;
        if (call == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            DjangoFormTypeProvider.$$$reportNull$$$0(20);
        }
        if (!DjangoFacet.isPresent((PsiElement)call)) {
            return super.prepareCalleeTypeForCall(type, call, context);
        }
        if (type instanceof PyClassType && ((PyClassType)type).getUserData(DjangoFormWrapper.DJANGO_MODEL_CLASS_CALL_SITE) != null) {
            return Ref.create((Object)((PyClassType)type));
        }
        if (type instanceof PyCollectionType && NameResolverTools.isSubclass((PyClass)(collectionType = (PyCollectionType)type).getPyClass(), (FQNamesProvider)DjangoFQNamesProvider.BASE_FORMSET_CLASS, (TypeEvalContext)context)) {
            return Ref.create((Object)collectionType);
        }
        return super.prepareCalleeTypeForCall(type, call, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/codeInsight/djangoForms/DjangoFormTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentAsClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallTypeForModelFormSetFactory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallTypeForModelFactory";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallTypeForFormSetFactory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallTypeForSubscription";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCalleeTypeForCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

