/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.DjangoRunnerUtilsKt;
import com.intellij.python.django.run.DjangoServerRunConfiguration;
import com.intellij.python.django.run.UrlFilterWithRedirection;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.python.remote.RemoteProcessControl;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.nio.file.Path;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoServerRunCommandLineState
extends PythonCommandLineState {
    private static final String COMMAND_RUNSERVER = "runserver";
    private static final String COMMAND_TESTSERVER = "testserver";
    private static final String COMMAND_RUNCONCURRENTSERVER = "runconcurrentserver";
    private static final String OPTION_NO_RELOAD = "--noreload";
    private static final String OPTION_ADDRPORT = "--addrport";
    private static final int DEFAULT_DJANGO_SERVER_PORT = 8000;
    private final DjangoServerRunConfiguration myConfig;

    public DjangoServerRunCommandLineState(DjangoServerRunConfiguration config, ExecutionEnvironment environment) {
        super((AbstractPythonRunConfiguration)config, environment);
        this.myConfig = config;
        Module module = this.myConfig.getModule();
        if (module != null && !this.myConfig.getEnvs().containsKey("DJANGO_SETTINGS_MODULE") && !System.getenv().containsKey("DJANGO_SETTINGS_MODULE")) {
            DjangoUtil.addDjangoSettingsToEnv(module, this.myConfig.getEnvs(), false);
        }
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.withEnvironment(DjangoRunnerUtilsKt.fixEnvsIfNeeded(SystemInfo.isWin10OrNewer, commandLine.getEnvironment(), System.getenv()));
        return PythonProcessRunner.createProcessHandlingCtrlC((GeneralCommandLine)commandLine);
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String additionalOptions;
        String host;
        Module module = this.myConfig.getModule();
        if (StringUtil.isEmpty((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(DjangoUtil.getProjectRoot((Module)module));
        } else {
            commandLine.setWorkDirectory(PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)this.myConfig));
        }
        ParametersList params = commandLine.getParametersList();
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exe_options = parametersList.getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParams = params.getParamsGroup("Script");
        assert (scriptParams != null);
        String manageScript = DjangoUtil.getManageScript((Module)module);
        if (manageScript.isEmpty()) {
            manageScript = DjangoUtil.getDjangoAdmin((String)this.myConfig.getInterpreterPath());
        }
        if (manageScript != null) {
            scriptParams.addParameter(manageScript);
        }
        if (this.myConfig.isUseCustomRunCommand()) {
            scriptParams.addParameter(this.myConfig.getCustomRunCommand());
            if (this.isRunServerCommand() && this.needNoReload() || this.myConfig.isRunNoReload()) {
                scriptParams.addParameter(OPTION_NO_RELOAD);
            }
        } else if (!this.myConfig.isRunTestServer()) {
            scriptParams.addParameter(COMMAND_RUNSERVER);
            if (this.needNoReload()) {
                scriptParams.addParameter(OPTION_NO_RELOAD);
            }
        } else {
            scriptParams.addParameter(COMMAND_TESTSERVER);
        }
        Object hostPort = null;
        Integer port = this.myConfig.getPort();
        if (port != null) {
            hostPort = Integer.toString(port);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(host = this.myConfig.getHost()))) {
            if (hostPort == null) {
                hostPort = "8000";
            }
            hostPort = host + ":" + (String)hostPort;
        }
        if (hostPort != null) {
            if (this.myConfig.isRunTestServer()) {
                scriptParams.addParameter(OPTION_ADDRPORT);
            }
            scriptParams.addParameter((String)hostPort);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            scriptParams.addParametersString(additionalOptions);
        }
    }

    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        String additionalOptions;
        String host;
        if (helpersAwareRequest == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(0);
        }
        PythonScriptExecution djangoExecution = new PythonScriptExecution();
        Module module = this.myConfig.getModule();
        String manageScript = DjangoUtil.getManageScript((Module)module);
        if (manageScript.isEmpty()) {
            manageScript = DjangoUtil.getDjangoAdmin((String)this.myConfig.getInterpreterPath());
        }
        if (manageScript != null) {
            djangoExecution.setPythonScriptPath(TargetEnvironmentFunctions.targetPath((Path)Path.of(manageScript, new String[0])));
        }
        if (this.myConfig.isUseCustomRunCommand()) {
            djangoExecution.addParameter(this.myConfig.getCustomRunCommand());
            if (this.isRunServerCommand() && this.needNoReload() || this.myConfig.isRunNoReload()) {
                djangoExecution.addParameter(OPTION_NO_RELOAD);
            }
        } else if (!this.myConfig.isRunTestServer()) {
            djangoExecution.addParameter(COMMAND_RUNSERVER);
            if (this.needNoReload()) {
                djangoExecution.addParameter(OPTION_NO_RELOAD);
            }
        } else {
            djangoExecution.addParameter(COMMAND_TESTSERVER);
        }
        Object hostPort = null;
        Integer port = this.myConfig.getPort();
        if (port != null) {
            hostPort = Integer.toString(port);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(host = this.myConfig.getHost()))) {
            if (hostPort == null) {
                hostPort = "8000";
            }
            hostPort = host + ":" + (String)hostPort;
        }
        if (hostPort != null) {
            if (this.myConfig.isRunTestServer()) {
                djangoExecution.addParameter(OPTION_ADDRPORT);
            }
            djangoExecution.addParameter((String)hostPort);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            PythonScripts.addParametersString((PythonExecution)djangoExecution, (String)additionalOptions);
        }
        PythonScriptExecution pythonScriptExecution = djangoExecution;
        if (pythonScriptExecution == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(1);
        }
        return pythonScriptExecution;
    }

    @Nullable
    protected Function<TargetEnvironment, String> getPythonExecutionWorkingDir(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (targetEnvironmentRequest == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(2);
        }
        Module module = this.myConfig.getModule();
        String workingDir = !StringUtil.isEmpty((String)this.myConfig.getWorkingDirectory()) ? PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)this.myConfig) : (module != null ? DjangoUtil.getProjectRoot((Module)module) : null);
        if (workingDir == null) {
            return null;
        }
        return TargetEnvironmentFunctions.targetPath((Path)Path.of(workingDir, new String[0]));
    }

    private boolean isRunServerCommand() {
        String command = this.myConfig.getCustomRunCommand();
        return COMMAND_RUNSERVER.equals(command) || COMMAND_RUNCONCURRENTSERVER.equals(command);
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler processHandler) {
        int port;
        HostAndPort localTunnel;
        if (processHandler instanceof RemoteProcessControl && this.myConfig.getHost() != null && (localTunnel = ((RemoteProcessControl)processHandler).getLocalTunnel(port = this.myConfig.getPort() != null ? this.myConfig.getPort() : 8000)) != null) {
            return new UrlFilterWithRedirection(Collections.singletonMap(HostAndPort.fromParts((String)this.myConfig.getHost(), (int)port), localTunnel));
        }
        UrlFilter urlFilter = super.createUrlFilter(processHandler);
        if (urlFilter == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(3);
        }
        return urlFilter;
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = super.createAndAttachConsole(project, processHandler, executor);
        if (DjangoUtil.getManageScript((Module)this.myConfig.getModule()).isEmpty()) {
            consoleView.print("No manage.py file specified in Settings->Django Support\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(4);
        }
        return consoleView2;
    }

    private boolean needNoReload() {
        return this.myConfig.isRunNoReload();
    }

    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = super.startProcess(processStarter, patchers);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler, this.myConfig.getBrowserUrl(), "development server", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(5);
        }
        return processHandler2;
    }

    @NotNull
    protected ProcessHandler startProcess(@NotNull PythonScriptTargetedCommandLineBuilder builder) throws ExecutionException {
        if (builder == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(6);
        }
        ProcessHandler processHandler = super.startProcess(builder);
        DjangoServerRunCommandLineState.addRunBrowserListener(processHandler, this.myConfig.getBrowserUrl(), "development server", (RunConfiguration)this.myConfig, this.myConfig.isLaunchJavascriptDebugger());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            DjangoServerRunCommandLineState.$$$reportNull$$$0(7);
        }
        return processHandler2;
    }

    public static void addRunBrowserListener(ProcessHandler processHandler, final String url, final String signature, RunConfiguration runConfiguration, boolean launchJavascriptDebugger) {
        if (launchJavascriptDebugger && JavaScriptDebuggerStarter.Util.start((RunConfiguration)runConfiguration, (String)url)) {
            return;
        }
        if (!StringUtil.isEmpty((String)url)) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    if (StringUtil.toLowerCase((String)event.getText()).contains(signature)) {
                        browserStarted.set((Object)true);
                        BrowserUtil.browse((String)url);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/python/django/run/DjangoServerRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareRequest";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/run/DjangoServerRunCommandLineState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/run/DjangoServerRunCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutionWorkingDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

