/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.testRunner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.python.extensions.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTestUtil {
    private DjangoTestUtil() {
    }

    public static List<PyClass> getTestCaseClassesFromFile(PyFile file) {
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)file.getProject(), null);
        return ContainerUtil.filter((Collection)file.getTopLevelClasses(), o -> PyClassExtKt.inherits((PyClass)o, (TypeEvalContext)context, (String[])new String[]{"django.test.testcases.TestCase"}));
    }

    public static boolean isDjangoTestCaseClass(@NotNull PyClass cls) {
        if (cls == null) {
            DjangoTestUtil.$$$reportNull$$$0(0);
        }
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)cls.getProject(), null);
        return PyClassExtKt.inherits((PyClass)cls, (TypeEvalContext)context, (String[])new String[]{"django.test.testcases.SimpleTestCase"});
    }

    @Nullable
    public static String getAppNameForLocation(Module module, PsiElement element) {
        String name;
        boolean needFullTestsPath;
        PsiFileSystemItem file;
        if (module == null || element == null) {
            return null;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance((Module)module);
        if (djangoFacet == null) {
            return null;
        }
        Object object = file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        String testRunner = DjangoSettingsPy.getTestRunner((Module)module);
        boolean isSuiteTestRunner = testRunner != null && (testRunner.contains("django_nose.NoseTestSuiteRunner") || testRunner.contains("django.test.simple.DjangoTestSuiteRunner"));
        boolean bl = needFullTestsPath = !isSuiteTestRunner || testRunner.contains("discover_runner.DiscoverRunner") || testRunner.contains("django_nose.NoseTestSuiteRunner");
        if (needFullTestsPath && (name = DjangoTestUtil.getDotPathByElement(element)) != null) {
            return name;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(vFile);
        ArrayList<String> files = new ArrayList<String>();
        VirtualFile projectRoot = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile();
        while (vFile != null && !Comparing.equal((Object)vFile, (Object)contentRoot) && !Comparing.equal((Object)vFile, (Object)projectRoot)) {
            if (needFullTestsPath) {
                files.add(0, vFile.getNameWithoutExtension());
            }
            if (DjangoTestUtil.isAppRoot(vFile) && !needFullTestsPath) {
                return vFile.getName();
            }
            vFile = vFile.getParent();
        }
        return needFullTestsPath ? StringUtil.join(files, (String)".") : null;
    }

    @Nullable
    private static String getDotPathByElement(@NotNull PsiElement element) {
        PsiDirectory root;
        if (element == null) {
            DjangoTestUtil.$$$reportNull$$$0(1);
        }
        if ((root = DjangoUtil.getProjectRoot((PsiElement)element)) == null) {
            return null;
        }
        VirtualFile mainFolder = root.getVirtualFile();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile elementFile = containingFile.getVirtualFile();
        if (!VfsUtilCore.isAncestor((VirtualFile)mainFolder, (VirtualFile)elementFile, (boolean)false)) {
            return null;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)elementFile, (VirtualFile)mainFolder, (char)'.');
        if (relativePath == null) {
            return null;
        }
        return relativePath.endsWith(".py") ? relativePath.substring(0, relativePath.length() - ".py".length()) : relativePath;
    }

    private static boolean isAppRoot(VirtualFile vFile) {
        VirtualFile[] children;
        if (!vFile.isDirectory()) {
            return false;
        }
        for (VirtualFile child : children = vFile.getChildren()) {
            if (!child.getName().startsWith("models") && !child.getName().startsWith("views")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String buildTargetFromLocation(@NotNull Module module, @Nullable String appName, @Nullable PsiElement element) {
        if (module == null) {
            DjangoTestUtil.$$$reportNull$$$0(2);
        }
        if (appName == null) {
            return null;
        }
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (containingClass != null) {
            return DjangoTestUtil.buildTargetFromLocation(module, appName, containingClass, element);
        }
        return appName;
    }

    @NotNull
    public static String buildTargetFromLocation(@NotNull Module module, @Nullable String appName, @NotNull PyClass containingClass, @Nullable PsiElement element) {
        if (module == null) {
            DjangoTestUtil.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            DjangoTestUtil.$$$reportNull$$$0(4);
        }
        PyFunction containingFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        String separator = DjangoTestUtil.getString(module);
        if (containingFunction != null) {
            String name = appName + separator;
            String string = name = name + containingClass.getName() + "." + containingFunction.getName();
            if (string == null) {
                DjangoTestUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String name = appName + separator;
        String string = name = name + containingClass.getName();
        if (string == null) {
            DjangoTestUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getString(@NotNull Module module) {
        String testRunner;
        if (module == null) {
            DjangoTestUtil.$$$reportNull$$$0(7);
        }
        return (testRunner = DjangoSettingsPy.getTestRunner((Module)module)) != null && testRunner.contains("django_nose.NoseTestSuiteRunner") ? ":" : ".";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/testRunner/DjangoTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/testRunner/DjangoTestUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTargetFromLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTestCaseClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDotPathByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildTargetFromLocation";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

