/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.kit;

import com.intellij.ml.inline.completion.impl.MLCompletionRequest;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionMultilineUtils;
import com.intellij.ml.inline.completion.impl.inline.MultiLineApplicabilityResult;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultiLinePolicy;
import com.intellij.ml.inline.completion.impl.kit.MultilinePolicyType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicies;", "", "<init>", "()V", "toPolicy", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "Lcom/intellij/ml/inline/completion/impl/kit/MultilinePolicyType;", "request", "Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "Disabled", "Enforced", "Suitable", "Relaxed", "intellij.fullLine.core.completion"})
public final class MLCompletionMultiLinePolicies {
    @NotNull
    public static final MLCompletionMultiLinePolicies INSTANCE = new MLCompletionMultiLinePolicies();

    private MLCompletionMultiLinePolicies() {
    }

    @NotNull
    public final MLCompletionMultiLinePolicy toPolicy(@NotNull MultilinePolicyType $this$toPolicy, @NotNull MLCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPolicy), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toPolicy.ordinal()]) {
            case 1 -> Disabled.INSTANCE;
            case 2 -> Enforced.INSTANCE;
            case 3 -> new Suitable(request);
            case 4 -> new Relaxed(request);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicies$Disabled;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "<init>", "()V", "check", "Lcom/intellij/ml/inline/completion/impl/inline/MultiLineApplicabilityResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.fullLine.core.completion"})
    public static final class Disabled
    implements MLCompletionMultiLinePolicy {
        @NotNull
        public static final Disabled INSTANCE = new Disabled();

        private Disabled() {
        }

        @Override
        @Nullable
        public Object check(@NotNull Continuation<? super MultiLineApplicabilityResult> $completion) {
            return MultiLineApplicabilityResult.DISABLED_BY_LANGUAGE_SUPPORTER;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicies$Enforced;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "<init>", "()V", "check", "Lcom/intellij/ml/inline/completion/impl/inline/MultiLineApplicabilityResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.fullLine.core.completion"})
    public static final class Enforced
    implements MLCompletionMultiLinePolicy {
        @NotNull
        public static final Enforced INSTANCE = new Enforced();

        private Enforced() {
        }

        @Override
        @Nullable
        public Object check(@NotNull Continuation<? super MultiLineApplicabilityResult> $completion) {
            return MultiLineApplicabilityResult.ENFORCED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\t*\u00020\u0003H\u0004J\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicies$Relaxed;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "request", "Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;)V", "getRequest", "()Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "isNextLineBlank", "", "check", "Lcom/intellij/ml/inline/completion/impl/inline/MultiLineApplicabilityResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.fullLine.core.completion"})
    public static class Relaxed
    implements MLCompletionMultiLinePolicy {
        @NotNull
        private final MLCompletionRequest request;

        public Relaxed(@NotNull MLCompletionRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
        }

        @NotNull
        public final MLCompletionRequest getRequest() {
            return this.request;
        }

        protected final boolean isNextLineBlank(@NotNull MLCompletionRequest $this$isNextLineBlank) {
            Intrinsics.checkNotNullParameter((Object)$this$isNextLineBlank, (String)"<this>");
            int currentLine = $this$isNextLineBlank.getParameters().getEditor().getDocument().getLineNumber($this$isNextLineBlank.getParameters().getOffset());
            int nextLineNumber = RangesKt.coerceAtMost((int)(currentLine + 1), (int)($this$isNextLineBlank.getParameters().getEditor().getDocument().getLineCount() - 1));
            Document document = $this$isNextLineBlank.getParameters().getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            String string = document2.getText(new TextRange(document2.getLineStartOffset(nextLineNumber), document2.getLineEndOffset(nextLineNumber)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String nextLineText = string;
            return StringsKt.isBlank((CharSequence)nextLineText);
        }

        @Override
        @Nullable
        public Object check(@NotNull Continuation<? super MultiLineApplicabilityResult> $completion) {
            return Relaxed.check$suspendImpl(this, $completion);
        }

        static /* synthetic */ Object check$suspendImpl(Relaxed $this, Continuation<? super MultiLineApplicabilityResult> $completion) {
            if (!$this.isNextLineBlank($this.request)) {
                return MLCompletionMultilineUtils.INSTANCE.isMultiLineSuitable($this.request, $completion);
            }
            return MultiLineApplicabilityResult.ENFORCED;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicies$Suitable;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "request", "Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;)V", "getRequest", "()Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "check", "Lcom/intellij/ml/inline/completion/impl/inline/MultiLineApplicabilityResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.fullLine.core.completion"})
    public static final class Suitable
    implements MLCompletionMultiLinePolicy {
        @NotNull
        private final MLCompletionRequest request;

        public Suitable(@NotNull MLCompletionRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
        }

        @NotNull
        public final MLCompletionRequest getRequest() {
            return this.request;
        }

        @Override
        @Nullable
        public Object check(@NotNull Continuation<? super MultiLineApplicabilityResult> $completion) {
            return MLCompletionMultilineUtils.INSTANCE.isMultiLineSuitable(this.request, $completion);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MultilinePolicyType.values().length];
            try {
                nArray[MultilinePolicyType.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultilinePolicyType.ENFORCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultilinePolicyType.SUITABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultilinePolicyType.RELAXED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

