/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.align;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.layout.LayoutTool;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.view.Graph2D;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class GraphAbstractAlignNodesAction
extends AbstractGraphAction {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        GraphBuilder<?, ?> builder2;
        if (e == null) {
            GraphAbstractAlignNodesAction.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            GraphAbstractAlignNodesAction.$$$reportNull$$$0(1);
        }
        if ((builder2 = this.getBuilder(e)) == null) {
            return;
        }
        NodeList selectedNodes = GraphManager.getGraphManager().createNodeList(graph.selectedNodes());
        GraphUndoService.getInstance().performPositionsOnlyChangingAction(builder2, this.getActionName(), () -> {
            LayoutTool.Statics.alignNodeLayouts(graph, selectedNodes, null, this.doAlignVertically(), this.getAlignmentMode());
            Layouter currentLayouter = builder2.getGraphPresentationModel().getSettings().getCurrentLayouter();
            Layouter edgeRouter = GraphLayoutService.getInstance().getEdgeRouterForLayouter(currentLayouter);
            if (edgeRouter != null) {
                GraphLayoutService.getInstance().queryLayout(builder2).withLayouter(edgeRouter).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER).run();
            }
        });
        graph.updateViews();
    }

    @Nls
    protected abstract String getActionName();

    protected abstract boolean doAlignVertically();

    protected abstract byte getAlignmentMode();

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            GraphAbstractAlignNodesAction.$$$reportNull$$$0(2);
        }
        if (graph == null) {
            GraphAbstractAlignNodesAction.$$$reportNull$$$0(3);
        }
        int minimumNodesRequiredToAlign = this.getAlignmentMode() == LayoutTool.ALIGN_NODES_DISTRIBUTED ? 3 : 2;
        e.getPresentation().setEnabledAndVisible(graph.selectedNodes().size() >= minimumNodesRequiredToAlign);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/align/GraphAbstractAlignNodesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

