/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.threadDumpParser;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.threadDumpParser.ThreadOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ThreadState {
    private final String myName;
    private final String myState;
    private String myStackTrace;
    private boolean myEmptyStackTrace;
    private String myJavaThreadState;
    private String myThreadStateDetail;
    private String myExtraState;
    private boolean isDaemon;
    private boolean isVirtual;
    private final Set<ThreadState> myThreadsWaitingForMyLock = new HashSet<ThreadState>();
    private final Set<ThreadState> myDeadlockedThreads = new HashSet<ThreadState>();
    private String ownableSynchronizers;
    @Nullable
    private ThreadOperation myOperation;
    private Boolean myKnownJDKThread;
    private int myStackDepth;

    public ThreadState(String name, String state) {
        String explicitlyUnnamedName = "{unnamed}";
        this.myName = name.isEmpty() ? explicitlyUnnamedName : (name.matches("@\\d+") ? explicitlyUnnamedName + name : name);
        this.myState = state.trim();
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getState() {
        return this.myState;
    }

    @NlsSafe
    public String getStackTrace() {
        return this.myStackTrace;
    }

    public void setStackTrace(@NotNull String stackTrace, boolean isEmpty) {
        if (stackTrace == null) {
            ThreadState.$$$reportNull$$$0(0);
        }
        this.myStackTrace = stackTrace;
        this.myEmptyStackTrace = isEmpty;
        this.myKnownJDKThread = null;
        this.myStackDepth = StringUtil.countNewLines((CharSequence)this.myStackTrace);
    }

    int getStackDepth() {
        return this.myStackDepth;
    }

    public boolean isKnownJDKThread() {
        String stackTrace = this.myStackTrace;
        if (stackTrace == null) {
            return false;
        }
        if (this.myKnownJDKThread == null) {
            this.myKnownJDKThread = ThreadDumpParser.isKnownJdkThread(stackTrace);
        }
        return this.myKnownJDKThread;
    }

    public Collection<ThreadState> getAwaitingThreads() {
        return Collections.unmodifiableSet(this.myThreadsWaitingForMyLock);
    }

    public Collection<ThreadState> getDeadlockedThreads() {
        return Collections.unmodifiableSet(this.myDeadlockedThreads);
    }

    public String toString() {
        return this.myName;
    }

    public void setJavaThreadState(String javaThreadState) {
        this.myJavaThreadState = javaThreadState;
    }

    public void setThreadStateDetail(@NonNls String threadStateDetail) {
        this.myThreadStateDetail = threadStateDetail;
    }

    public String getJavaThreadState() {
        return this.myJavaThreadState;
    }

    @NlsSafe
    public String getThreadStateDetail() {
        if (this.myOperation != null) {
            return this.myOperation.toString();
        }
        return this.myThreadStateDetail;
    }

    public boolean isEmptyStackTrace() {
        return this.myEmptyStackTrace;
    }

    @NlsSafe
    public String getExtraState() {
        return this.myExtraState;
    }

    public void setExtraState(String extraState) {
        this.myExtraState = extraState;
    }

    public boolean isSleeping() {
        return "sleeping".equals(this.getThreadStateDetail()) || ("parking".equals(this.getThreadStateDetail()) || "waiting on condition".equals(this.myState)) && this.isThreadPoolExecutor();
    }

    private boolean isThreadPoolExecutor() {
        return this.myStackTrace.contains("java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take") || this.myStackTrace.contains("java.util.concurrent.ThreadPoolExecutor.getTask");
    }

    public boolean isAwaitedBy(ThreadState thread) {
        return this.myThreadsWaitingForMyLock.contains(thread);
    }

    public void addWaitingThread(@NotNull ThreadState thread) {
        if (thread == null) {
            ThreadState.$$$reportNull$$$0(1);
        }
        this.myThreadsWaitingForMyLock.add(thread);
    }

    public boolean isDeadlocked() {
        return !this.myDeadlockedThreads.isEmpty();
    }

    public void addDeadlockedThread(ThreadState thread) {
        this.myDeadlockedThreads.add(thread);
    }

    @Nullable
    public ThreadOperation getOperation() {
        return this.myOperation;
    }

    public void setOperation(@Nullable ThreadOperation operation) {
        this.myOperation = operation;
    }

    public boolean isWaiting() {
        return "on object monitor".equals(this.myThreadStateDetail) || this.myState.startsWith("waiting") || "parking".equals(this.myThreadStateDetail) && !this.isSleeping();
    }

    public boolean isEDT() {
        String name = this.getName();
        return ThreadState.isEDT(name);
    }

    public boolean isIdle() {
        return "idle".equals(this.myThreadStateDetail);
    }

    public String getOwnableSynchronizers() {
        return this.ownableSynchronizers;
    }

    public void setOwnableSynchronizers(String ownableSynchronizers) {
        this.ownableSynchronizers = ownableSynchronizers;
    }

    public static boolean isEDT(String name) {
        return ThreadDumper.isEDT((String)name);
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean virtual) {
        this.isVirtual = virtual;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/threadDumpParser/ThreadState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setStackTrace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addWaitingThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

