/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Uri;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.OptionArgumentPresenceException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AllowAction;
import com.thaiopensource.validate.nrl.AttachAction;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import com.thaiopensource.validate.nrl.ElementsOrAttributes;
import com.thaiopensource.validate.nrl.Hashset;
import com.thaiopensource.validate.nrl.Mode;
import com.thaiopensource.validate.nrl.ModeUsage;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.nrl.Path;
import com.thaiopensource.validate.nrl.RejectAction;
import com.thaiopensource.validate.nrl.SchemaReceiverImpl;
import com.thaiopensource.validate.nrl.UnwrapAction;
import com.thaiopensource.validate.nrl.ValidateAction;
import com.thaiopensource.validate.nrl.ValidatorImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    private static final String IMPLICIT_MODE_NAME = "#implicit";
    private static final String WRAPPER_MODE_NAME = "#wrapper";
    static final String NRL_URI = "http://www.thaiopensource.com/validate/nrl";
    private final Hashtable modeMap = new Hashtable();
    private Mode startMode;
    private final Mode defaultBaseMode;
    private final boolean attributesSchema;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$SchemaImpl;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$AllowAction;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$AttachAction;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$UnwrapAction;
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$RejectAction;

    SchemaImpl(PropertyMap propertyMap) {
        super(propertyMap);
        this.attributesSchema = propertyMap.contains(NrlProperty.ATTRIBUTES_SCHEMA);
        this.makeBuiltinMode("#allow", class$com$thaiopensource$validate$nrl$AllowAction == null ? (class$com$thaiopensource$validate$nrl$AllowAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.AllowAction")) : class$com$thaiopensource$validate$nrl$AllowAction);
        this.makeBuiltinMode("#attach", class$com$thaiopensource$validate$nrl$AttachAction == null ? (class$com$thaiopensource$validate$nrl$AttachAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.AttachAction")) : class$com$thaiopensource$validate$nrl$AttachAction);
        this.makeBuiltinMode("#unwrap", class$com$thaiopensource$validate$nrl$UnwrapAction == null ? (class$com$thaiopensource$validate$nrl$UnwrapAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.UnwrapAction")) : class$com$thaiopensource$validate$nrl$UnwrapAction);
        this.defaultBaseMode = this.makeBuiltinMode("#reject", class$com$thaiopensource$validate$nrl$RejectAction == null ? (class$com$thaiopensource$validate$nrl$RejectAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.RejectAction")) : class$com$thaiopensource$validate$nrl$RejectAction);
    }

    private Mode makeBuiltinMode(String string, Class clazz) {
        Mode mode = this.lookupCreateMode(string);
        ActionSet actionSet = new ActionSet();
        ModeUsage modeUsage = new ModeUsage(Mode.CURRENT, mode);
        if (clazz == (class$com$thaiopensource$validate$nrl$AttachAction == null ? (class$com$thaiopensource$validate$nrl$AttachAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.AttachAction")) : class$com$thaiopensource$validate$nrl$AttachAction)) {
            actionSet.setResultAction(new AttachAction(modeUsage));
        } else if (clazz == (class$com$thaiopensource$validate$nrl$AllowAction == null ? (class$com$thaiopensource$validate$nrl$AllowAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.AllowAction")) : class$com$thaiopensource$validate$nrl$AllowAction)) {
            actionSet.addNoResultAction(new AllowAction(modeUsage));
        } else if (clazz == (class$com$thaiopensource$validate$nrl$UnwrapAction == null ? (class$com$thaiopensource$validate$nrl$UnwrapAction = SchemaImpl.class$("com.thaiopensource.validate.nrl.UnwrapAction")) : class$com$thaiopensource$validate$nrl$UnwrapAction)) {
            actionSet.setResultAction(new UnwrapAction(modeUsage));
        } else {
            actionSet.addNoResultAction(new RejectAction(modeUsage));
        }
        mode.bindElement("##any", actionSet);
        mode.noteDefined(null);
        AttributeActionSet attributeActionSet = new AttributeActionSet();
        if (this.attributesSchema) {
            attributeActionSet.setReject(true);
        } else {
            attributeActionSet.setAttach(true);
        }
        mode.bindAttribute("##any", attributeActionSet);
        return mode;
    }

    SchemaFuture installHandlers(XMLReader xMLReader, SchemaReceiverImpl schemaReceiverImpl) {
        Handler handler2 = new Handler(schemaReceiverImpl);
        xMLReader.setContentHandler(handler2);
        return handler2;
    }

    public Validator createValidator(PropertyMap propertyMap) {
        return new ValidatorImpl(this.startMode, propertyMap);
    }

    private Mode getModeAttribute(Attributes attributes, String string) {
        return this.lookupCreateMode(attributes.getValue("", string));
    }

    private Mode lookupCreateMode(String string) {
        if (string == null) {
            return null;
        }
        Mode mode = (Mode)this.modeMap.get(string = string.trim());
        if (mode == null) {
            mode = new Mode(string, this.defaultBaseMode);
            this.modeMap.put(string, mode);
        }
        return mode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$nrl$SchemaImpl == null ? (class$com$thaiopensource$validate$nrl$SchemaImpl = SchemaImpl.class$("com.thaiopensource.validate.nrl.SchemaImpl")) : class$com$thaiopensource$validate$nrl$SchemaImpl);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private Mode currentMode = null;
        private String defaultSchemaType;
        private Validator validator;
        private ElementsOrAttributes match;
        private ActionSet actions;
        private AttributeActionSet attributeActions;
        private String schemaUri;
        private String schemaType;
        private PropertyMapBuilder options;
        private final Vector mustSupportOptions = new Vector();
        private ModeUsage modeUsage;
        private boolean anyNamespace;

        Handler(SchemaReceiverImpl schemaReceiverImpl) {
            this.sr = schemaReceiverImpl;
            this.eh = ValidateProperty.ERROR_HANDLER.get(schemaReceiverImpl.getProperties());
            this.ceh = new CountingErrorHandler(this.eh);
        }

        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.sr.getProperties());
                ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.ceh);
                this.validator = this.sr.getNrlSchema().createValidator(propertyMapBuilder.toPropertyMap());
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new RuntimeException("internal error in RNG schema for NRL");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Hashset hashset = new Hashset();
            Hashset hashset2 = new Hashset();
            Enumeration enumeration = SchemaImpl.this.modeMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(string);
                if (!mode.isDefined()) {
                    this.error("undefined_mode", string, mode.getWhereUsed());
                }
                Mode mode2 = mode;
                while (mode2 != null) {
                    if (hashset2.contains(mode2)) break;
                    if (hashset.contains(mode2)) {
                        this.error("mode_cycle", mode2.getName(), mode2.getWhereDefined());
                        break;
                    }
                    hashset.add(mode2);
                    mode2 = mode2.getBaseMode();
                }
                hashset2.addAll(hashset);
                hashset.clear();
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (runtimeException instanceof WrappedIOException) {
                throw ((WrappedIOException)runtimeException).getException();
            }
            return runtimeException;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.xmlBaseHandler.startElement();
            String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (string4 != null) {
                this.xmlBaseHandler.xmlBaseAttribute(string4);
            }
            if (!SchemaImpl.NRL_URI.equals(string) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (string2.equals("rules")) {
                this.parseRules(attributes);
            } else if (string2.equals("mode")) {
                this.parseMode(attributes);
            } else if (string2.equals("namespace")) {
                this.parseNamespace(attributes);
            } else if (string2.equals("anyNamespace")) {
                this.parseAnyNamespace(attributes);
            } else if (string2.equals("validate")) {
                this.parseValidate(attributes);
            } else if (string2.equals("reject")) {
                this.parseReject(attributes);
            } else if (string2.equals("attach")) {
                this.parseAttach(attributes);
            } else if (string2.equals("unwrap")) {
                this.parseUnwrap(attributes);
            } else if (string2.equals("allow")) {
                this.parseAllow(attributes);
            } else if (string2.equals("context")) {
                this.parseContext(attributes);
            } else if (string2.equals("option")) {
                this.parseOption(attributes);
            } else {
                throw new RuntimeException("unexpected element \"" + string2 + "\"");
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (string2.equals("validate")) {
                this.finishValidate();
            }
        }

        private void parseRules(Attributes attributes) {
            SchemaImpl.this.startMode = SchemaImpl.this.getModeAttribute(attributes, "startMode");
            if (SchemaImpl.this.startMode == null) {
                SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(SchemaImpl.IMPLICIT_MODE_NAME);
                this.currentMode = SchemaImpl.this.startMode;
                SchemaImpl.this.startMode.noteDefined(null);
            }
            SchemaImpl.this.startMode.noteUsed(this.locator);
            if (SchemaImpl.this.attributesSchema) {
                Mode mode = SchemaImpl.this.lookupCreateMode(SchemaImpl.WRAPPER_MODE_NAME);
                ActionSet actionSet = new ActionSet();
                actionSet.addNoResultAction(new AllowAction(new ModeUsage(SchemaImpl.this.startMode, SchemaImpl.this.startMode)));
                mode.bindElement("##any", actionSet);
                mode.noteDefined(null);
                SchemaImpl.this.startMode = mode;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
        }

        private void parseMode(Attributes attributes) throws SAXException {
            this.currentMode = SchemaImpl.this.getModeAttribute(attributes, "name");
            if (this.currentMode.isDefined()) {
                this.error("duplicate_mode", this.currentMode.getName());
                this.error("first_mode", this.currentMode.getName(), this.currentMode.getWhereDefined());
            } else {
                Mode mode = SchemaImpl.this.getModeAttribute(attributes, "extends");
                if (mode != null) {
                    this.currentMode.setBaseMode(mode);
                }
                this.currentMode.noteDefined(this.locator);
            }
        }

        private void parseNamespace(Attributes attributes) throws SAXException {
            this.anyNamespace = false;
            this.parseRule(this.getNs(attributes), attributes);
        }

        private void parseAnyNamespace(Attributes attributes) throws SAXException {
            this.anyNamespace = true;
            this.parseRule("##any", attributes);
        }

        private void parseRule(String string, Attributes attributes) throws SAXException {
            this.match = this.toElementsOrAttributes(attributes.getValue("", "match"), ElementsOrAttributes.ELEMENTS);
            if (this.match.containsAttributes()) {
                this.attributeActions = new AttributeActionSet();
                if (!this.currentMode.bindAttribute(string, this.attributeActions)) {
                    if (string.equals("##any")) {
                        this.error("duplicate_attribute_action_any_namespace");
                    } else {
                        this.error("duplicate_attribute_action", string);
                    }
                }
            }
            if (this.match.containsElements()) {
                this.actions = new ActionSet();
                if (!this.currentMode.bindElement(string, this.actions)) {
                    if (string.equals("##any")) {
                        this.error("duplicate_element_action_any_namespace");
                    } else {
                        this.error("duplicate_element_action", string);
                    }
                }
            } else {
                this.actions = null;
            }
        }

        private void parseValidate(Attributes attributes) throws SAXException {
            this.schemaUri = this.getSchema(attributes);
            this.schemaType = this.getSchemaType(attributes);
            if (this.schemaType == null) {
                this.schemaType = this.defaultSchemaType;
            }
            this.modeUsage = this.actions != null ? this.getModeUsage(attributes) : null;
            this.options = new PropertyMapBuilder();
            this.mustSupportOptions.clear();
        }

        private void finishValidate() throws SAXException {
            try {
                Schema schema;
                if (this.attributeActions != null) {
                    schema = this.createSubSchema(true);
                    this.attributeActions.addSchema(schema);
                }
                if (this.actions != null) {
                    schema = this.createSubSchema(false);
                    this.actions.addNoResultAction(new ValidateAction(this.modeUsage, schema));
                }
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                this.hadError = true;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }

        private Schema createSubSchema(boolean bl) throws IOException, IncorrectSchemaException, SAXException {
            PropertyMap propertyMap = this.options.toPropertyMap();
            Schema schema = this.sr.createChildSchema(new InputSource(this.schemaUri), this.schemaType, propertyMap, bl);
            PropertyMap propertyMap2 = schema.getProperties();
            Enumeration enumeration = this.mustSupportOptions.elements();
            while (enumeration.hasMoreElements()) {
                MustSupportOption mustSupportOption = (MustSupportOption)enumeration.nextElement();
                Object object = propertyMap2.get(mustSupportOption.pid);
                if (object == null) {
                    this.error("unsupported_option", mustSupportOption.name, mustSupportOption.locator);
                    continue;
                }
                if (object.equals(propertyMap.get(mustSupportOption.pid))) continue;
                this.error("unsupported_option_arg", mustSupportOption.name, mustSupportOption.locator);
            }
            return schema;
        }

        private void parseOption(Attributes attributes) throws SAXException {
            block7: {
                Option option;
                String string;
                block8: {
                    String string2 = attributes.getValue("", "mustSupport");
                    boolean bl = string2 != null ? (string2 = string2.trim()).equals("1") || string2.equals("true") : false;
                    string = Uri.resolve(SchemaImpl.NRL_URI, attributes.getValue("", "name"));
                    option = this.sr.getOption(string);
                    if (option != null) break block8;
                    if (!bl) break block7;
                    this.error("unknown_option", string);
                    break block7;
                }
                String string3 = attributes.getValue("", "arg");
                try {
                    PropertyId propertyId = option.getPropertyId();
                    Object object = option.valueOf(string3);
                    Object object2 = this.options.get(propertyId);
                    if (object2 != null) {
                        if ((object = option.combine(new Object[]{object2, object})) == null) {
                            this.error("duplicate_option", string);
                        } else {
                            this.options.put(propertyId, object);
                        }
                        break block7;
                    }
                    this.options.put(propertyId, object);
                    this.mustSupportOptions.addElement(new MustSupportOption(string, propertyId, this.locator == null ? null : new LocatorImpl(this.locator)));
                }
                catch (OptionArgumentPresenceException optionArgumentPresenceException) {
                    this.error(string3 == null ? "option_requires_argument" : "option_unexpected_argument", string);
                }
                catch (OptionArgumentException optionArgumentException) {
                    if (string3 == null) {
                        this.error("option_requires_argument", string);
                        break block7;
                    }
                    this.error("option_bad_argument", string, string3);
                }
            }
        }

        private void parseAttach(Attributes attributes) {
            if (this.attributeActions != null) {
                this.attributeActions.setAttach(true);
            }
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.setResultAction(new AttachAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseUnwrap(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.setResultAction(new UnwrapAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseAllow(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.addNoResultAction(new AllowAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
        }

        private void parseReject(Attributes attributes) {
            if (this.actions != null) {
                this.modeUsage = this.getModeUsage(attributes);
                this.actions.addNoResultAction(new RejectAction(this.modeUsage));
            } else {
                this.modeUsage = null;
            }
            if (this.attributeActions != null) {
                this.attributeActions.setReject(true);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            block5: {
                if (this.anyNamespace) {
                    this.error("context_any_namespace");
                    return;
                }
                Mode mode = this.getUseMode(attributes);
                try {
                    Vector vector = Path.parse(attributes.getValue("", "path"));
                    if (this.modeUsage == null) break block5;
                    int n = 0;
                    int n2 = vector.size();
                    while (n < n2) {
                        Path path = (Path)vector.elementAt(n);
                        if (!this.modeUsage.addContext(path.isRoot(), path.getNames(), mode)) {
                            this.error("duplicate_path", path.toString());
                        }
                        ++n;
                    }
                }
                catch (Path.ParseException parseException) {
                    this.error(parseException.getMessageKey());
                }
            }
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "schema");
            if (Uri.hasFragmentId(string)) {
                this.error("schema_fragment_id");
            }
            return Uri.resolve(this.xmlBaseHandler.getBaseUri(), Uri.escapeDisallowedChars(string));
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes toElementsOrAttributes(String string, ElementsOrAttributes elementsOrAttributes) {
            if (string == null) {
                return elementsOrAttributes;
            }
            ElementsOrAttributes elementsOrAttributes2 = ElementsOrAttributes.NEITHER;
            if (string.indexOf("elements") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addElements();
            }
            if (string.indexOf("attributes") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addAttributes();
            }
            return elementsOrAttributes2;
        }

        private ModeUsage getModeUsage(Attributes attributes) {
            return new ModeUsage(this.getUseMode(attributes), this.currentMode);
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode = SchemaImpl.this.getModeAttribute(attributes, "useMode");
            if (mode == null) {
                return Mode.CURRENT;
            }
            mode.noteUsed(this.locator);
            return mode;
        }

        private String getNs(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "ns");
            if (string != null && !Uri.isAbsolute(string) && !string.equals("")) {
                this.error("ns_absolute");
            }
            return string;
        }

        void error(String string) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string), this.locator));
        }

        void error(String string, String string2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), this.locator));
        }

        void error(String string, String string2, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), locator));
        }

        void error(String string, String string2, String string3) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2, string3), this.locator));
        }
    }

    private static class MustSupportOption {
        private final String name;
        private final PropertyId pid;
        private final Locator locator;

        MustSupportOption(String string, PropertyId propertyId, Locator locator) {
            this.name = string;
            this.pid = propertyId;
            this.locator = locator;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException iOException) {
            this.exception = iOException;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

