/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.unix.UnixPtyProcess;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.runner.LocalOptionsConfigurer;
import org.jetbrains.plugins.terminal.runner.LocalShellIntegrationInjector;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    @ApiStatus.Internal
    public static final String LOGIN_CLI_OPTION = "--login";
    @ApiStatus.Internal
    public static final List<String> LOGIN_CLI_OPTIONS = List.of("--login", "-l");
    protected final Charset myDefaultCharset = StandardCharsets.UTF_8;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @Override
    @NotNull
    public ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions) {
        if (baseOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        ShellStartupOptions updatedOptions = LocalOptionsConfigurer.configureStartupOptions(baseOptions, this.myProject);
        if (this.enableShellIntegration()) {
            updatedOptions = LocalShellIntegrationInjector.injectShellIntegration(updatedOptions, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        }
        return this.applyTerminalCustomizers(updatedOptions);
    }

    @NotNull
    private ShellStartupOptions applyTerminalCustomizers(@NotNull ShellStartupOptions options) {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        String[] command2 = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command2 = customizer.customizeCommandAndEnvironment(this.myProject, options.getWorkingDirectory(), command2, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        ShellStartupOptions shellStartupOptions = options.builder().shellCommand(Arrays.asList(command2)).envVariables(envs).build();
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @Override
    @NotNull
    public PtyProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        PtyProcess ptyProcess;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        String[] command2 = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = options.getEnvVariables();
        TermSize initialTermSize = options.getInitialTermSize();
        String workingDir = options.getWorkingDirectory();
        if (workingDir == null) {
            throw new IllegalStateException("Working directory must not be null, startup options: " + String.valueOf(options));
        }
        ShellIntegration shellIntegration = options.getShellIntegration();
        boolean isBlockTerminal = this.isGenOneTerminalEnabled() && shellIntegration != null && shellIntegration.getCommandBlockIntegration() != null || this.isGenTwoTerminalEnabled() && !this.isGenOneTerminalEnabled();
        TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, command2, isBlockTerminal);
        if (isBlockTerminal) {
            TerminalUsageLocalStorage.getInstance().recordBlockTerminalUsed();
        }
        try {
            long startNano = System.nanoTime();
            PtyProcess process = (PtyProcess)ProcessService.getInstance().startPtyProcess(command2, workingDir, envs, LocalPtyOptions.defaults().builder().initialColumns(initialTermSize != null ? initialTermSize.getColumns() : -1).initialRows(initialTermSize != null ? initialTermSize.getRows() : -1).build(), null, false, false, false);
            LOG.info("Started " + process.getClass().getName() + " in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms from " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, !LOG.isDebugEnabled()));
            ptyProcess = process;
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to start " + LocalTerminalDirectRunner.stringifyProcessInfo(command2, workingDir, initialTermSize, envs, false), e);
        }
        if (ptyProcess == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        return ptyProcess;
    }

    protected boolean enableShellIntegration() {
        return TerminalOptionsProvider.getInstance().getShellIntegration();
    }

    @NotNull
    private static String stringifyProcessInfo(String @NotNull [] command2, @NotNull String workingDirectory, @Nullable TermSize initialTermSize, @NotNull Map<String, String> environment, boolean envDiff) {
        if (workingDirectory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        if (command2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        String info = Arrays.toString(command2) + " in " + workingDirectory + (LocalTerminalDirectRunner.isDirectory(workingDirectory) ? "" : " [no such directory]") + ", [" + String.valueOf(initialTermSize) + "]";
        if (envDiff) {
            String string = info + ", diff_envs=" + String.valueOf(LocalTerminalDirectRunner.getEnvironmentDiff(environment, System.getenv()));
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = info + ", envs=" + String.valueOf(environment);
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getEnvironmentDiff(@NotNull Map<String, String> environment, @NotNull Map<String, String> baseEnvironment) {
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(10);
        }
        if (baseEnvironment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        Map map2 = environment.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> Objects.equals(entry.getValue(), baseEnvironment.get(entry.getKey())) ? null : entry).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        if (map2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @ApiStatus.Internal
    public static boolean isDirectory(@NotNull String directory) {
        if (directory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(13);
        }
        try {
            boolean ok = Files.isDirectory(Path.of(directory, new String[0]), new LinkOption[0]);
            if (!ok) {
                LOG.info("Cannot start local terminal in " + directory + ": no such directory");
            }
            return ok;
        }
        catch (InvalidPathException e) {
            LOG.info("Cannot start local terminal in " + directory + ": invalid path", (Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public TtyConnector createTtyConnector(final @NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(14);
        }
        return new PtyProcessTtyConnector(process, this.myDefaultCharset){

            public void close() {
                if (process instanceof UnixPtyProcess) {
                    ((UnixPtyProcess)process).hangup();
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                        if (process.isAlive()) {
                            LOG.info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                            process.destroy();
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                } else {
                    process.destroy();
                }
            }

            public void resize(@NotNull TermSize termSize) {
                if (termSize == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resize to " + String.valueOf(termSize));
                }
                super.resize(termSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termSize", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$1", "resize"));
            }
        };
    }

    @Override
    @NotNull
    public String getDefaultTabTitle() {
        String string = TerminalOptionsProvider.getInstance().getTabName();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Deprecated(since="2024.3", forRemoval=true)
    @NotNull
    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(16);
        }
        List<String> list = LocalTerminalStartCommandBuilder.convertShellPathToCommand(this.getShellPath());
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(17);
        }
        return list;
    }

    @ApiStatus.Internal
    protected boolean isGenOneTerminalEnabled() {
        return false;
    }

    @NotNull
    private String getShellPath() {
        String string = TerminalProjectOptionsProvider.getInstance(this.myProject).getShellPath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public List<String> getCommand(@NotNull String shellPath2, @NotNull Map<String, String> envs, boolean shellIntegration) {
        if (shellPath2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(19);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(20);
        }
        List<String> command2 = LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2);
        if (shellIntegration) {
            ShellStartupOptions options = this.injectShellIntegration(command2, envs);
            List<String> list = Objects.requireNonNull(options.getShellCommand());
            if (list == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<String> list = command2;
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    ShellStartupOptions injectShellIntegration(@NotNull List<String> shellCommand, @NotNull Map<String, String> envs) {
        if (shellCommand == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(23);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(24);
        }
        ShellStartupOptions options = new ShellStartupOptions.Builder().shellCommand(shellCommand).envVariables(envs).build();
        ShellStartupOptions shellStartupOptions = LocalShellIntegrationInjector.injectShellIntegration(options, this.isGenOneTerminalEnabled(), this.isGenTwoTerminalEnabled());
        if (shellStartupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(25);
        }
        return shellStartupOptions;
    }

    @ApiStatus.Internal
    public static boolean isBlockTerminalSupported(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(26);
        }
        if (ShellNameUtil.isPowerShell(shellName)) {
            return SystemInfo.isWin11OrNewer && Registry.is((String)"terminal.new.ui.powershell.win11", (boolean)false) || SystemInfo.isWin10OrNewer && !SystemInfo.isWin11OrNewer && Registry.is((String)"terminal.new.ui.powershell.win10", (boolean)false) || SystemInfo.isUnix && Registry.is((String)"terminal.new.ui.powershell.unix", (boolean)false);
        }
        return shellName.equals("bash") || SystemInfo.isMac && shellName.equals("sh") || shellName.equals("zsh") || shellName.equals("fish") && Registry.is((String)"terminal.new.ui.fish", (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 9, 12, 15, 17, 18, 21, 22, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvironment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTerminalCustomizers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyProcessInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentDiff";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyTerminalCustomizers";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringifyProcessInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isBlockTerminalSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 9, 12, 15, 17, 18, 21, 22, 25 -> new IllegalStateException(string);
        };
    }
}

