/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;

public final class LocalTerminalStartCommandBuilder {
    private static final String INTERACTIVE_CLI_OPTION = "-i";

    @NotNull
    public static List<String> convertShellPathToCommand(@NotNull String shellPath2) {
        ArrayList<String> shellCommand;
        String shellExe;
        if (shellPath2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(0);
        }
        if ((shellExe = (String)ContainerUtil.getFirstItem(shellCommand = LocalTerminalStartCommandBuilder.isAbsoluteFilePathAndExists(shellPath2) ? List.of(shellPath2) : ParametersListUtil.parse((String)shellPath2, (boolean)false, (!SystemInfo.isWindows ? 1 : 0) != 0))) == null) {
            ArrayList<String> arrayList = shellCommand;
            if (arrayList == null) {
                LocalTerminalStartCommandBuilder.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        String shellName = PathUtil.getFileName((String)shellExe);
        if (!LocalTerminalStartCommandBuilder.containsLoginOrInteractiveOption((List<String>)shellCommand)) {
            shellCommand = new ArrayList<String>(shellCommand);
            if (LocalTerminalStartCommandBuilder.isLoginOptionAvailable(shellName) && SystemInfo.isMac) {
                shellCommand.add("--login");
            }
            if (LocalTerminalStartCommandBuilder.isInteractiveOptionAvailable(shellName)) {
                shellCommand.add(INTERACTIVE_CLI_OPTION);
            }
        }
        List<String> list = List.copyOf(shellCommand);
        if (list == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static boolean isAbsoluteFilePathAndExists(@NotNull String path) {
        File file;
        if (path == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(3);
        }
        return (file = new File(path)).isAbsolute() && file.isFile();
    }

    private static boolean containsLoginOrInteractiveOption(List<String> command2) {
        return LocalTerminalStartCommandBuilder.isLogin(command2) || command2.contains(INTERACTIVE_CLI_OPTION);
    }

    private static boolean isLogin(@NotNull List<String> command2) {
        if (command2 == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(command2, LocalTerminalDirectRunner.LOGIN_CLI_OPTIONS::contains);
    }

    private static boolean isLoginOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(5);
        }
        return ShellNameUtil.isBashZshFish(shellName);
    }

    private static boolean isInteractiveOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalStartCommandBuilder.$$$reportNull$$$0(6);
        }
        return ShellNameUtil.isBashZshFish(shellName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalTerminalStartCommandBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalTerminalStartCommandBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertShellPathToCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertShellPathToCommand";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteFilePathAndExists";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLogin";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLoginOptionAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveOptionAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

