from _typeshed import StrOrBytesPath
from typing_extensions import Self

from _cffi_backend import _CDataBase

def str_to_bytes(value: str, name: object) -> bytes: ...

class ConfigIterator:
    def __init__(self, config: _CDataBase, ptr: _CDataBase) -> None: ...
    def __del__(self) -> None: ...
    def __iter__(self) -> Self: ...
    def next(self) -> ConfigEntry: ...
    def __next__(self) -> ConfigEntry: ...

class ConfigMultivarIterator(ConfigIterator):
    def __next__(self) -> str: ...  # type: ignore[override]

class Config:
    def __init__(self, path: str | None = None) -> None: ...
    @classmethod
    def from_c(cls, repo: _CDataBase, ptr: _CDataBase) -> Config: ...
    def __del__(self) -> None: ...
    def __contains__(self, key: str) -> bool: ...
    def __getitem__(self, key: str) -> str: ...
    def __setitem__(self, key: str, value: bool | int | _CDataBase | StrOrBytesPath | None) -> None: ...
    def __delitem__(self, key: str) -> None: ...
    def __iter__(self) -> ConfigIterator: ...
    def get_multivar(self, name: str, regex: str | None = None) -> ConfigMultivarIterator: ...
    def set_multivar(self, name: str, regex: str, value: str) -> None: ...
    def delete_multivar(self, name: str, regex: str) -> None: ...
    def get_bool(self, key: str) -> bool: ...
    def get_int(self, key: str) -> int: ...
    def add_file(self, path: StrOrBytesPath, level: int = 0, force: int = 0) -> None: ...
    def snapshot(self) -> Config: ...
    @staticmethod
    def parse_bool(text: _CDataBase | bytes | str | None) -> bool: ...
    @staticmethod
    def parse_int(text: _CDataBase | bytes | str | None) -> int: ...
    @staticmethod
    def get_system_config() -> Config: ...
    @staticmethod
    def get_global_config() -> Config: ...
    @staticmethod
    def get_xdg_config() -> Config: ...

class ConfigEntry:
    def __del__(self) -> None: ...
    @property
    def c_value(self) -> _CDataBase: ...
    @property
    def raw_name(self) -> bytes: ...
    @property
    def raw_value(self) -> bytes: ...
    @property
    def level(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> str: ...
