/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.mwe.UriFilter;

public class NameBasedFilter
implements UriFilter {
    private String extension;
    private Pattern regularExpression;

    @Override
    public boolean matches(URI uri) {
        if (uri == null) {
            return false;
        }
        if (this.extension != null && !this.extension.equalsIgnoreCase(uri.fileExtension())) {
            return false;
        }
        return this.regularExpression == null || this.regularExpression.matcher(uri.toString()).find();
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression != null ? Pattern.compile(regularExpression) : null;
    }

    public Pattern getRegularExpression() {
        return this.regularExpression;
    }
}

