/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/binary_search.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/binary_search.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include <stdio.h>
#include "../binary_search.h"


START_TEST(binary_search_ge_basic)
{
#line 10
{
	const int arr[] = { 10, 20, 30, 40, 50 };
	ck_assert_uint_eq(binary_search_ge(arr, _i, &(int){5}, scalar_less), 0);
	for (int i = 1; i <= _i; i++) {
		ck_assert_uint_eq(binary_search_ge(arr, _i, &(int){i * 10},
						   scalar_less), i - 1);
		ck_assert_uint_eq(binary_search_ge(arr, _i, &(int){i * 10 + 5},
						   scalar_less), i);
	}
}

}
END_TEST

START_TEST(binary_search_ge_duplicates)
{
#line 22
{
	const int arr[] = { 10, 10, 10 };
	ck_assert_uint_eq(binary_search_ge(arr, 3, &(int){10}, scalar_less), 0);
}

}
END_TEST

START_TEST(binary_search_ge_custom_less)
{
#line 28
{
	const struct {
		int value;
		const char *str;
	} arr[] = {
		{ 10, "ten" },
		{ 20, "twenty" },
	};
	#define my_less(a, b) ((a)->value < *(b))
	ck_assert_uint_eq(binary_search_ge(arr, 2, &(int){20}, my_less), 1);
	#undef my_less
}

}
END_TEST

START_TEST(binary_search_gt_basic)
{
#line 42
{
	const int arr[] = { 10, 20, 30, 40, 50 };
	ck_assert_uint_eq(binary_search_gt(arr, _i, &(int){5}, scalar_less), 0);
	for (int i = 1; i <= _i; i++) {
		ck_assert_uint_eq(binary_search_gt(arr, _i, &(int){i * 10},
						   scalar_less), i);
		ck_assert_uint_eq(binary_search_gt(arr, _i, &(int){i * 10 + 5},
						   scalar_less), i);
	}
}

}
END_TEST

START_TEST(binary_search_gt_duplicates)
{
#line 54
{
	const int arr[] = { 10, 10, 10 };
	ck_assert_uint_eq(binary_search_gt(arr, 3, &(int){10}, scalar_less), 3);
}

}
END_TEST

START_TEST(binary_search_gt_custom_less)
{
#line 60
{
	const struct {
		int value;
		const char *str;
	} arr[] = {
		{ 10, "ten" },
		{ 20, "twenty" },
	};
	#define my_less(a, b) (*(a) < (b)->value)
	ck_assert_uint_eq(binary_search_gt(arr, 2, &(int){20}, my_less), 2);
	#undef my_less
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("binary_search");
    TCase *tc1_1 = tcase_create("binary_search");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_loop_test(tc1_1, binary_search_ge_basic, 0, 6);
    tcase_add_test(tc1_1, binary_search_ge_duplicates);
    tcase_add_test(tc1_1, binary_search_ge_custom_less);
    tcase_add_loop_test(tc1_1, binary_search_gt_basic, 0, 6);
    tcase_add_test(tc1_1, binary_search_gt_duplicates);
    tcase_add_test(tc1_1, binary_search_gt_custom_less);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
