// -*- C++ -*-
#ifndef RIVET_CentralEtHCM_HH
#define RIVET_CentralEtHCM_HH

#include "Rivet/Particle.hh"
#include "Rivet/Event.hh"
#include "Rivet/Projections/DISFinalState.hh"

namespace Rivet {


  /// @brief Summed \f$ E_\perp \f$ of central particles in HCM system.
  ///
  /// Sum up \f$ E_\perp \f$ of all particles in the hadronic final state in the
  /// central rapidity bin of the HCM system.
  class CentralEtHCM : public Projection {
  public:

    /// The default constructor. Must specify a FinalStateHCM projection
    /// object which is guaranteed to live throughout the run.
    CentralEtHCM(const DISFinalState& fs)
    {
      setName("CentralEtHCM");
      declare(fs, "FS");
    }

    /// Clone on the heap.
    RIVET_DEFAULT_PROJ_CLONE(CentralEtHCM);

    /// Import to avoid warnings about overload-hiding
    using Projection::operator =;


  protected:

    /// Apply the projection on to the Event.
    void project(const Event& e);

    /// Compare with other projections
    CmpState compare(const Projection& p) const {
      return mkNamedPCmp(p, "FS");
    }


  public:

    /// The sum of the Et in the central rapidity bin.
    double sumEt() const { return _sumet; }


  protected:

    /// The sum of the Et in the central rapidity bin.
    double _sumet;

  };

}


#endif
