// **********************************************************************
// * IBMASM HEADER FILE                                                 *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

#ifndef __Sysdrv_H_
#define __Sysdrv_H_



#ifdef SYS_NETWARE
   typedef void *SYS_HANDLE;
   typedef void *HANDLE;
#endif

#ifdef __OS2__
   #ifndef __DDR_H_
      typedef HFILE SYS_HANDLE;
   #endif
#endif

#ifdef __NT__
   typedef HANDLE SYS_HANDLE;
#endif

#ifdef SCO_UNIXWARE7
  typedef int SYS_HANDLE;
#endif

#ifdef __IBMLINUX__
  typedef int SYS_HANDLE;
#endif

// Compatible I2C ROM version number
#define I2C_MAJOR_ROM   0
#define I2C_MINOR_ROM   0

// Compatible I2C RAM version number
#define I2C_MAJOR_RAM   0
#define I2C_MINOR_RAM   0

// Current Device Driver version numbers (Wiseman uses these)
#define NT_DEVICE_DRIVER_MAJOR     5
#define NT_DEVICE_DRIVER_MINOR     04

#define OS2_DEVICE_DRIVER_MAJOR    NT_DEVICE_DRIVER_MAJOR
#define OS2_DEVICE_DRIVER_MINOR    NT_DEVICE_DRIVER_MINOR

#define NW_DEVICE_DRIVER_MAJOR     NT_DEVICE_DRIVER_MAJOR
#define NW_DEVICE_DRIVER_MINOR     NT_DEVICE_DRIVER_MINOR

#define UW7_DEVICE_DRIVER_MAJOR    NT_DEVICE_DRIVER_MAJOR
#define UW7_DEVICE_DRIVER_MINOR    NT_DEVICE_DRIVER_MINOR

// Use this command as a simple handshake command to the Service Processor.
// This requests the system state, and is a command that exists in the SP
// bios so that the SP can respond even if it has not been flashed.
#define RUThereSPCmdDef  0x04,0x03,0x06
#define RUThereSPCmdLen  3

// Block for 5000mS before checking if Service Processor is alive
#define RHBWaitLoop 5000

// Return Codes
#define RC_SUCCESS                                0
#define RC_INVALID_HANDLE                         1
#define RC_TIMEOUT                                2
#define RC_NOT_OPEN                               3
#define RC_OPEN_FAILED                            4
#define RC_CLOSE_FAILED                           5
#define RC_ALREADY_REGISTERED                     6
#define RC_EVENT_NOT_REGISTERED                   7
#define RC_SYSTEM_ERROR                           8
#define RC_INVALID_BUFFER                         9
#define RC_EVENT_CANCELLED                       10
#define RC_DRIVER_CLOSED                         11
#define RC_NO_EVENT_BFRS                         13
#define RC_ALREADY_OPEN                          14
#define RC_REVERSE_HB_ALREADY_REGISTERD          15
#define RC_REVERSE_HEARTBEAT_HAS_FAILED          17
#define RC_REVERSE_HB_ALREADY_STOPPED            18

// An endianess macro condersion
#define ARCH4(x) ( (((ULONG)(x)) >> 24) |              \
                   ((((ULONG)(x) << 8) >> 24) <<  8) | \
                   ((((ULONG)(x) >> 8) << 24) >>  8) | \
                   (((ULONG)(x)) << 24) )

// IOCTL_DEBUG subcommands
#define CLEAR_LOG            0x10   // delete all log/trace entries
#define GET_LOG_STATUS       0x20   // tell if the log/trace exists and if enabled
#define GET_TRACE_PARMS      0x30   // provide info on what is being traced
#define READ_LOG             0x40   // Obtain all log entries
#define SET_TRACE_PARMS      0x50   // set is going to be traced
#define START_LOGGING        0x60   // Start/enable logging
#define STOP_LOGGING         0x70   // Stop/disable logging

// IOCTL_DEBUG subcommands
#define START_ASR            0x10   // Start/enable ASR
#define STOP_ASR             0x20   // Stop/disable ASR

// IOCTL_DEBUG TRACE status, parm, and buffer size equates
#define TRACE_AVAILABLE   0x00000001   // Trace buffer created and initialized 
#define TRACE_ENABLED     0x00000002   // Trace buffer enabled for data
#define TRACE_STATUS      (TRACE_AVAILABLE | TRACE_ENABLED)

#define TRACE_REQUESTS    0x80000000
#define TRACE_RESPONSES   0x40000000
#define TRACE_EVENTWAITS  0x08000000
#define TRACE_EVENTRCVD   0x04000000
#define TRACE_HEARTBEAT   0x00800000
#define TRACE_TIMEOUTS    0x00080000
#define TRACE_ERRORS      0x00040000
#define TRACE_PROCS       0x00008000
#define TRACE_ALL         (TRACE_REQUESTS | TRACE_RESPONSES | \
                           TRACE_EVENTWAITS | TRACE_EVENTRCVD | \
                           TRACE_HEARTBEAT | TRACE_TIMEOUTS | \
                           TRACE_ERRORS | TRACE_PROCS)
#define TRACE_BUFFER_SIZE 4096

#define TRACE_CMD_SND     '?'
#define TRACE_CMD_RSP     '!'
#define TRACE_CMD_TO      '*'
#define TRACE_CMD_EVW     '#'
#define TRACE_CMD_EVR     '&'
#define TRACE_CMD_HB      '^'
#define TRACE_ERR         ':'
#define TRACE_PROC        '`'

/*--------------------------------------------------------------------*/
/* Macro used by all OSes to handle data wrapping in the trace buffer */
/*--------------------------------------------------------------------*/
#ifdef Ntsdebug_c
#define WRAP_MEMCPY(w_dest, w_source, w_amount)                        \
              RtlCopyMemory((w_dest), (w_source), (w_amount));
#elif defined(Uwsdebug_c)
#define WRAP_MEMCPY(w_dest, w_source, w_amount)                        \
              bcopy((w_source), (w_dest), (w_amount));
#else
#define WRAP_MEMCPY(w_dest, w_source, w_amount)                        \
              memcpy((w_dest), (w_source), (w_amount));
#endif

#define  TRACE_WRAP_HANDLER(tracePtr)                                  \
 /* Update starting pointer */                                         \
 int diff;                                                             \
 int count = 0;                                                        \
 USHORT entrySize;                                                     \
 int entrySizeOffset = ((LONG)&(((TRACE_ENTRY *)0)->entrySize));       \
 do                                                                    \
 {                                                                     \
   /* Calculate the location of entrySize */                           \
   diff = ((tracePtr).pFirstEntry + entrySizeOffset) -                 \
           (tracePtr).pEndOfBuffer;                                    \
                                                                       \
   /* Determine where the entrySize is located in the buffer */        \
   if (diff >= 0)                                                      \
   {                                                                   \
     /* entrySize has wrapped and is somewhere in the beginning */     \
     /*  of the buffer.  Offset to it and copy its contents     */     \
     WRAP_MEMCPY(&entrySize,                                           \
                 (tracePtr).pBuffer + diff,                            \
                 2);                                                   \
   }                                                                   \
   else  if ((int)(diff + sizeof(USHORT)) > 0)                         \
   {                                                                   \
     /* entrySize is split across the end and the beginning of  */     \
     /*  the buffer                                             */     \
     entrySize = *((tracePtr).pFirstEntry + entrySizeOffset);          \
     entrySize &= 0x00FF;                                              \
     entrySize |= (*((tracePtr).pBuffer)) << 8;                        \
   }                                                                   \
   else                                                                \
     entrySize = ((PTRACE_ENTRY)((tracePtr).pFirstEntry))->entrySize;  \
                                                                       \
   count += entrySize;                                                 \
   (tracePtr).pFirstEntry += entrySize;                                \
                                                                       \
   if ((tracePtr).pFirstEntry >=                                       \
       (tracePtr).pEndOfBuffer)                                        \
   {                                                                   \
     (tracePtr).pFirstEntry = (tracePtr).pBuffer +                     \
                               ((tracePtr).pFirstEntry -               \
                                (tracePtr).pEndOfBuffer);              \
   }                                                                   \
 } while(count < traceEntry.entrySize);


/*--------------------------------------------------------------------*/
/* Macro used by all OSes to handle the extra timeout value           */
/*--------------------------------------------------------------------*/
#define IS_EXTRA_TIMEOUT_NEEDED                                        \
           ((pCmdBuffer->cmdBlock.CommandLgth == 3) &&                 \
            ((pCmdBuffer->cmdString[0] == 0x06 ) &&                    \
             (pCmdBuffer->cmdString[1] == 0x03 ) &&                    \
             (pCmdBuffer->cmdString[2] == 0x01 )))  ||                 \
           ((pCmdBuffer->cmdBlock.CommandLgth == 2) &&                 \
            ((pCmdBuffer->cmdString[0] == 0x07 ) &&                    \
             (pCmdBuffer->cmdString[1] == 0x01 )))  ||                 \
           (pCmdBuffer->cmdString[0] == 0x08 )


//  I2C Command Equates
#define spWrite     0
#define spWriteNext 1
#define spRead      2
#define spReadNext  3
#define spCmdResp   4
#define spEvent     5
#define spHeartBeat 6

typedef struct
{
   unsigned char      CommandType;
   unsigned char      CommandLgth;
   unsigned short int DataLgth;
   unsigned char      Status;
   unsigned char      Reserved;
} spCmd;


typedef struct
{
  spCmd cmdBlock;
  unsigned char cmdString[3];
}*PCMD_BUFFER;

#endif
