/*
 * ocfsioctl.c
 *
 * ocfs' ioctl interface
 *
 * Copyright (C) 2002 Oracle Corporation.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 *
 * Authors: Neeraj Goyal, Suchit Kaura, Kurt Hackel, Sunil Mushran,
 *          Manish Singh, Wim Coekaerts
 */

#include <ocfs.h>

/* Tracing */
#define OCFS_DEBUG_CONTEXT      OCFS_DEBUG_CONTEXT_IOCTL

/*
 * ocfs_ioctl()
 *
 */
int ocfs_ioctl (struct inode *inode,
	    struct file *filp, unsigned int cmd, unsigned long arg)
{
	struct ocfs_ioc data;
	extern char *ocfs_version;
	int ret = 0;
	ocfs_super *osb;
	ocfs_cdsl cdsl;

	LOG_ENTRY_ARGS ("(0x%p, 0x%p, %u, %lu)\n", inode, filp, cmd, arg);

	if (_IOC_TYPE (cmd) != OCFS_IOC_MAGIC) {
		ret = -ENOTTY;
		goto exit_ioctl;
	}

	switch (cmd) {
	    case OCFS_IOC_GETTYPE:
		    strncpy (data.name, OCFS_NAME, sizeof (data.name) - 1);
		    strncpy (data.version, ocfs_version,
			     sizeof (data.version) - 1);
		    strncpy (data.nodename, OcfsGlobalCtxt.node_name,
			     sizeof (data.nodename) - 1);
		    // data.nodenum = OcfsGlobalCtxt.node_num;  TODO
		    data.nodenum = 999;	/* TODO */
		    ret = copy_to_user ((struct ocfs_ioc *) arg, &data,
					sizeof (struct ocfs_ioc));
		    break;
	    case OCFS_IOC_CDSL_MODIFY:
		    osb = ((ocfs_super *)(inode->i_sb->u.generic_sbp));
		    ret =
			copy_from_user (&cdsl, (void *) arg,
					sizeof (ocfs_cdsl));
		    if (!ret) {
			    ret = ocfs_create_delete_cdsl (inode, filp, osb, &cdsl);
			    if (ret < 0) {
				    if (ret != -EINTR)
					ret = -EINVAL;
			    }
		    }
		    break;
	    case OCFS_IOC_CDSL_GETINFO:	/* TODO: implement */
	    default:
		    ret = -ENOTTY;
		    break;
	}

      exit_ioctl:
	LOG_EXIT_LONG (ret);
	return ret;
}				/* ocfs_ioctl */
