/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractPlayer;
import com.sun.media.sound.EventDispatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.sound.sampled.LineUnavailableException;

class MixerSequencer
extends AbstractPlayer
implements Sequencer {
    private static final EventDispatcher eventDispatcher;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    static final MixerSequencerInfo info;
    private static Sequencer.SyncMode[] masterSyncModes;
    private static Sequencer.SyncMode[] slaveSyncModes;
    private static Sequencer.SyncMode masterSyncMode;
    private static Sequencer.SyncMode slaveSyncMode;
    private Sequence sequence = null;
    private byte[] midiData = null;
    private boolean runningInEngine = false;
    private boolean newSequenceStarted = false;
    private long tickCache = -1L;
    private long microsecondCache = -1L;
    private float tempoInBPMCache = -1.0f;
    private float tempoInMPQCache = -1.0f;
    private float tempoFactorCache = -1.0f;
    private boolean running = false;
    private boolean recording = false;
    private boolean sequenceChanged = false;
    private long loopStart = 0L;
    private long loopEnd = -1L;
    private int loopCount = 0;
    private long startTime = 0L;
    private long startMillisecondTime = 0L;
    private long lastTempoChangeTime = 0L;
    private long lastTempoChangeTick = 0L;
    private long recordTempoInMPQ = 500000L;
    private long startTick = 0L;
    private float divisionType = 0.0f;
    private int resolution = 0;
    private Vector metaEventListeners = new Vector();
    private Vector controllerEventListeners = new Vector();

    protected MixerSequencer() throws MidiUnavailableException {
        super(info);
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        int[] nArray = MidiSystem.getMidiFileTypes(sequence);
        if (nArray.length == 0) {
            throw new InvalidMidiDataException("Unsupported sequence: " + sequence);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MidiSystem.write(sequence, nArray[0], byteArrayOutputStream);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Unable to get file stream from sequence: " + sequence);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.setSequence(byteArrayInputStream);
            this.sequence = sequence;
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Failed to load sequence: " + sequence);
        }
    }

    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        int n;
        MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(inputStream);
        int n2 = midiFileFormat.getType();
        int n3 = midiFileFormat.getResolution();
        if (n2 == 2) {
            throw new InvalidMidiDataException("Unsupported file type: " + n2 + ". Only type 0 and type 1 MIDI files are supported.");
        }
        if (this.isOpen() && this.id != 0L) {
            this.stop();
            this.implClose();
            try {
                this.doImplOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        this.midiData = this.getBytesFromFileStream(inputStream, midiFileFormat);
        if (this.midiData == null || this.midiData.length == 0) {
            throw new IOException("Failed to read data from stream.");
        }
        this.sequence = null;
        if (!this.isOpen()) {
            return;
        }
        if (n2 == 0 || n2 == 1) {
            this.id = 0L;
            if (n3 == -1) {
                this.id = this.nOpenRmfSequencer(this.midiData, this.midiData.length);
            }
            if (this.id == 0L) {
                this.id = this.nOpenMidiSequencer(this.midiData, this.midiData.length);
            }
        }
        if (this.id == 0L) {
            throw new InvalidMidiDataException("Failed to load sequence");
        }
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n].setId(this.id);
        }
        this.connectToInternalSynth();
        this.propagateCaches();
        for (n = 0; n < this.controllerEventListeners.size(); ++n) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
            for (int i = 0; i < controllerVectorElement.controllers.length; ++i) {
                this.nAddControllerEventCallback(this.id, controllerVectorElement.controllers[i]);
            }
        }
    }

    public Sequence getSequence() {
        if (this.sequence == null && this.midiData != null && this.midiData.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.midiData);
            try {
                this.sequence = MidiSystem.getSequence(byteArrayInputStream);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sequence;
    }

    public synchronized void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        if (this.id == 0L) {
            return;
        }
        if (this.running) {
            return;
        }
        if (this.sequenceChanged) {
            try {
                this.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            this.sequenceChanged = false;
        }
        this.running = true;
        if (!this.newSequenceStarted) {
            this.nStartSequencer(this.id);
            this.newSequenceStarted = true;
            this.propagateCaches();
        } else {
            this.nResumeSequencer(this.id);
        }
        this.runningInEngine = true;
        this.callbackSongStart();
    }

    public synchronized void stop() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.stopRecording();
        if (this.id == 0L) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.implStop();
        this.callbackSongStop();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void recordEnable(Track track, int n) {
    }

    public void recordDisable(Track track) {
    }

    public float getTempoInBPM() {
        if (this.id == 0L || !this.newSequenceStarted) {
            if (this.tempoInBPMCache != -1.0f) {
                return this.tempoInBPMCache;
            }
            if (this.tempoInMPQCache != -1.0f) {
                return 6.0E7f / this.tempoInMPQCache;
            }
            if (this.id == 0L) {
                return 0.0f;
            }
        }
        return this.nGetTempoInBPM(this.id);
    }

    public void setTempoInBPM(float f) {
        if (f <= 0.0f) {
            f = 1.0f;
        }
        if (this.id == 0L || !this.newSequenceStarted) {
            this.tempoInBPMCache = f;
            this.tempoInMPQCache = -1.0f;
            return;
        }
        this.nSetTempoInBPM(this.id, (int)f);
        this.tempoInBPMCache = -1.0f;
        this.tempoInMPQCache = -1.0f;
    }

    public float getTempoInMPQ() {
        if (this.id == 0L || !this.newSequenceStarted) {
            if (this.tempoInMPQCache != -1.0f) {
                return this.tempoInMPQCache;
            }
            if (this.tempoInBPMCache != -1.0f) {
                return 6.0E7f / this.tempoInBPMCache;
            }
            if (this.id == 0L) {
                return 0.0f;
            }
        }
        return this.nGetTempoInMPQ(this.id);
    }

    public void setTempoInMPQ(float f) {
        if (f <= 0.0f) {
            f = 1.0f;
        }
        if (this.id == 0L || !this.newSequenceStarted) {
            this.tempoInMPQCache = f;
            this.tempoInBPMCache = -1.0f;
            return;
        }
        this.nSetTempoInMPQ(this.id, (int)f);
        this.tempoInBPMCache = -1.0f;
        this.tempoInMPQCache = -1.0f;
    }

    public void setTempoFactor(float f) {
        if (f <= 0.0f) {
            return;
        }
        if (this.id == 0L) {
            this.tempoFactorCache = f;
            return;
        }
        this.nSetMasterTempo(this.id, f);
        this.tempoFactorCache = -1.0f;
    }

    public float getTempoFactor() {
        if (this.id == 0L) {
            if (this.tempoFactorCache != -1.0f) {
                return this.tempoFactorCache;
            }
            return 1.0f;
        }
        return this.nGetMasterTempo(this.id);
    }

    public long getTickLength() {
        if (this.getSequence() != null) {
            return this.getSequence().getTickLength();
        }
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceTickLength(this.id) / 64L;
    }

    public synchronized long getTickPosition() {
        if (this.tickCache != -1L) {
            return this.tickCache;
        }
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerTickPosition(this.id) / 64L;
    }

    public synchronized void setTickPosition(long l) {
        if (l < 0L) {
            return;
        }
        if (this.id == 0L) {
            if (this.isOpen()) {
                this.tickCache = l;
                this.microsecondCache = -1L;
                return;
            }
            return;
        }
        if (!this.running) {
            this.tickCache = l;
        } else {
            this.nSetSequencerTickPosition(this.id, l * 64L);
            this.tickCache = -1L;
        }
        this.microsecondCache = -1L;
    }

    public long getMicrosecondLength() {
        if (this.getSequence() != null) {
            return this.getSequence().getMicrosecondLength();
        }
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceMicrosecondLength(this.id);
    }

    public long getMicrosecondPosition() {
        if (this.microsecondCache != -1L) {
            return this.microsecondCache;
        }
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerMicrosecondPosition(this.id);
    }

    public void setMicrosecondPosition(long l) {
        if (l < 0L) {
            return;
        }
        if (this.id == 0L) {
            if (this.isOpen()) {
                this.microsecondCache = l;
                this.tickCache = -1L;
                return;
            }
            return;
        }
        if (!this.running) {
            this.microsecondCache = l;
        } else {
            this.nSetSequencerMicrosecondPosition(this.id, l);
            this.microsecondCache = -1L;
        }
        this.tickCache = -1L;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    protected int getTrackCount() {
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    public void setTrackMute(int n, boolean bl) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.nSetTrackMute(this.id, n, bl);
    }

    public boolean getTrackMute(int n) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        return this.nGetTrackMute(this.id, n);
    }

    public void setTrackSolo(int n, boolean bl) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.nSetTrackSolo(this.id, n, bl);
    }

    public boolean getTrackSolo(int n) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        return this.nGetTrackSolo(this.id, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.addElement(metaEventListener);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            this.metaEventListeners.removeElement(metaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            int n;
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            for (n = 0; n < this.controllerEventListeners.size(); ++n) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
                if (!controllerVectorElement.listener.equals(controllerEventListener)) continue;
                controllerVectorElement.addControllers(nArray);
                bl = true;
                break;
            }
            if (!bl) {
                controllerVectorElement = new ControllerVectorElement(controllerEventListener, nArray);
                this.controllerEventListeners.addElement(controllerVectorElement);
            }
            if (this.id != 0L) {
                for (n = 0; n < nArray.length; ++n) {
                    this.nAddControllerEventCallback(this.id, nArray[n]);
                }
            }
            return controllerVectorElement.getControllers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
                if (!controllerVectorElement.listener.equals(controllerEventListener)) continue;
                controllerVectorElement.removeControllers(nArray);
                bl = true;
                break;
            }
            if (!bl) {
                return new int[0];
            }
            if (nArray == null) {
                this.controllerEventListeners.removeElement(controllerVectorElement);
                return new int[0];
            }
            return controllerVectorElement.getControllers();
        }
    }

    public void setLoopStartPoint(long l) {
        if (this.sequence != null && l > this.sequence.getTickLength() || this.loopEnd != -1L && this.loopStart > this.loopEnd || l < 0L) {
            throw new IllegalArgumentException("invalid loop start point: " + l);
        }
        this.loopStart = l;
    }

    public long getLoopStartPoint() {
        return this.loopStart;
    }

    public void setLoopEndPoint(long l) {
        if (this.sequence != null && l > this.sequence.getTickLength() || this.loopStart > l || l < -1L) {
            throw new IllegalArgumentException("invalid loop end point: " + l);
        }
        this.loopEnd = l;
    }

    public long getLoopEndPoint() {
        return this.loopEnd;
    }

    public void setLoopCount(int n) {
        if (n != -1 && n < 0) {
            throw new IllegalArgumentException("illegal value for loop count: " + n);
        }
        this.loopCount = n;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    protected long getTimeStamp() {
        return this.getMicrosecondPosition();
    }

    public synchronized void open() throws MidiUnavailableException {
        if (this.isOpen()) {
            return;
        }
        try {
            mixer.open(this);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new MidiUnavailableException(lineUnavailableException.getMessage());
        }
        this.implOpen();
        this.open = true;
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.open = false;
            this.implClose();
            mixer.close(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void implClose() {
        this.implStop();
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.newSequenceStarted = false;
        while (this.runningInEngine) {
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void propagateCaches() {
        if (this.tempoFactorCache != -1.0f) {
            this.setTempoFactor(this.tempoFactorCache);
        }
        if (this.tickCache != -1L) {
            this.setTickPosition(this.tickCache);
        }
        if (this.microsecondCache != -1L) {
            this.setMicrosecondPosition(this.microsecondCache);
        }
        if (this.tempoInMPQCache != -1.0f) {
            this.setTempoInMPQ(this.tempoInMPQCache);
        }
        if (this.tempoInBPMCache != -1.0f) {
            this.setTempoInBPM(this.tempoInBPMCache);
        }
    }

    protected void implOpen() throws MidiUnavailableException {
        this.doImplOpen();
        if (this.id == 0L) {
            try {
                Sequence sequence = this.sequence;
                if (this.midiData != null) {
                    this.setSequence(new ByteArrayInputStream(this.midiData));
                    this.sequence = sequence;
                } else if (this.sequence != null) {
                    this.setSequence(this.sequence);
                }
            }
            catch (IOException iOException) {
                throw new MidiUnavailableException(iOException.getMessage());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                throw new MidiUnavailableException(invalidMidiDataException.getMessage());
            }
        }
    }

    private void doImplOpen() throws MidiUnavailableException {
        this.openInternalSynth();
    }

    protected void implStop() {
        this.nPauseSequencer(this.id);
        this.running = false;
    }

    protected void sendMetaEvents(MetaMessage metaMessage) {
        eventDispatcher.sendAudioEvents(metaMessage, this.metaEventListeners);
    }

    protected void sendControllerEvents(ShortMessage shortMessage, int n) {
        Vector<ControllerEventListener> vector = new Vector<ControllerEventListener>();
        block0: for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
            for (int j = 0; j < controllerVectorElement.controllers.length; ++j) {
                if (controllerVectorElement.controllers[j] != n) continue;
                vector.addElement(controllerVectorElement.listener);
                continue block0;
            }
        }
        eventDispatcher.sendAudioEvents(shortMessage, vector);
    }

    protected byte[] getBytesFromFileStream(InputStream inputStream, MidiFileFormat midiFileFormat) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            throw new IOException("Stream is null");
        }
        long l = midiFileFormat.getByteLength();
        if (l != -1L) {
            byArray = new byte[(int)l];
            if ((long)inputStream.read(byArray) != l) {
                throw new IOException("Read failure: expected " + l + " bytes");
            }
        } else {
            int n = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n2 = n;
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n4 = inputStream.read(byArray2, 0, n2)) == -1) {
                    if (n3 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n4);
                n3 += n4;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void callbackSongEnd() {
        this.implStop();
        this.runningInEngine = false;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = new MetaMessage();
        try {
            ((MetaMessage)object).setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        this.sendMetaEvents((MetaMessage)object);
    }

    private void callbackSongStart() {
    }

    private void callbackSongStop() {
    }

    private void callbackMetaEvent(int n, int n2, int n3, byte[] byArray) {
        MetaMessage metaMessage = new MetaMessage();
        try {
            metaMessage.setMessage(n, byArray, n2);
            this.sendMetaEvents(metaMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private void callbackControllerEvent(int n, int n2, int n3, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176 + n, n3, n4);
            this.sendControllerEvents(shortMessage, n3);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    protected native long nOpenMidiSequencer(byte[] var1, int var2);

    protected native long nOpenRmfSequencer(byte[] var1, int var2);

    protected native void nStartSequencer(long var1);

    protected native void nPauseSequencer(long var1);

    protected native void nResumeSequencer(long var1);

    protected native void nAddControllerEventCallback(long var1, int var3);

    protected native long nGetSequencerTickPosition(long var1);

    protected native long nSetSequencerTickPosition(long var1, long var3);

    protected native long nGetSequencerMicrosecondPosition(long var1);

    protected native long nSetSequencerMicrosecondPosition(long var1, long var3);

    protected native int nGetTempoInBPM(long var1);

    protected native int nSetTempoInBPM(long var1, int var3);

    protected native int nGetTempoInMPQ(long var1);

    protected native int nSetTempoInMPQ(long var1, int var3);

    protected native float nGetMasterTempo(long var1);

    protected native float nSetMasterTempo(long var1, float var3);

    protected native void nSetTrackMute(long var1, int var3, boolean var4);

    protected native boolean nGetTrackMute(long var1, int var3);

    protected native void nSetTrackSolo(long var1, int var3, boolean var4);

    protected native boolean nGetTrackSolo(long var1, int var3);

    protected native long nGetSequenceTickLength(long var1);

    protected native long nGetSequenceMicrosecondLength(long var1);

    static {
        info = new MixerSequencerInfo();
        masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
        slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
        masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
        slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
        eventDispatcher = new EventDispatcher();
        eventDispatcher.start();
    }

    private class ControllerVectorElement {
        int[] controllers;
        ControllerEventListener listener;

        private ControllerVectorElement(ControllerEventListener controllerEventListener, int[] nArray) {
            this.listener = controllerEventListener;
            this.controllers = nArray;
        }

        private void addControllers(int[] nArray) {
            int n;
            int n2;
            if (nArray == null) {
                return;
            }
            int[] nArray2 = new int[this.controllers.length + nArray.length];
            for (n2 = 0; n2 < this.controllers.length; ++n2) {
                nArray2[n2] = this.controllers[n2];
            }
            int n3 = this.controllers.length;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = 0;
                for (int i = 0; i < this.controllers.length; ++i) {
                    if (nArray[n2] != this.controllers[i]) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                nArray2[n3++] = nArray[n2];
            }
            int[] nArray3 = new int[n3];
            for (n = 0; n < n3; ++n) {
                nArray3[n] = nArray2[n];
            }
            this.controllers = nArray3;
        }

        private void removeControllers(int[] nArray) {
            if (nArray == null) {
                this.controllers = new int[0];
            } else {
                int n;
                int[] nArray2 = new int[this.controllers.length];
                int n2 = 0;
                for (int i = 0; i < this.controllers.length; ++i) {
                    n = 0;
                    for (int j = 0; j < nArray.length; ++j) {
                        if (this.controllers[i] != nArray[j]) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) continue;
                    nArray2[n2++] = this.controllers[i];
                }
                int[] nArray3 = new int[n2];
                for (n = 0; n < n2; ++n) {
                    nArray3[n] = nArray2[n];
                }
                this.controllers = nArray3;
            }
        }

        private int[] getControllers() {
            int[] nArray = new int[this.controllers.length];
            for (int i = 0; i < this.controllers.length; ++i) {
                nArray[i] = this.controllers[i];
            }
            return nArray;
        }
    }

    private static class MixerSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer / synthesizer module";
        private static final String version = "Version 1.0";

        private MixerSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    static class RecordingTrack {
        Track track;
        int channel;

        RecordingTrack(Track track, int n) {
            this.track = track;
            this.channel = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RecordingTrack get(Vector vector, Track track) {
            Vector vector2 = vector;
            synchronized (vector2) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(i);
                    if (recordingTrack.track != track) continue;
                    return recordingTrack;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Vector get(Vector vector, int n) {
            Vector<Track> vector2 = new Vector<Track>();
            Vector vector3 = vector;
            synchronized (vector3) {
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(i);
                    if (recordingTrack.channel != n && recordingTrack.channel != -1) continue;
                    vector2.addElement(recordingTrack.track);
                }
            }
            return vector2;
        }
    }
}

