/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WSWebServiceContext;
import com.sun.xml.internal.ws.developer.EPRRecipe;
import com.sun.xml.internal.ws.developer.StatefulWebServiceManager;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.AbstractInstanceResolver;
import com.sun.xml.internal.ws.server.AbstractMultiInstanceResolver;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.spi.ProviderImpl;
import com.sun.xml.internal.ws.util.xml.ContentHandlerToXMLStreamWriter;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatefulInstanceResolver<T>
extends AbstractMultiInstanceResolver<T>
implements StatefulWebServiceManager<T> {
    @Nullable
    private volatile T fallback;
    private final Map<String, Instance> instances = Collections.synchronizedMap(new HashMap());
    private final Map<T, String> reverseInstances = Collections.synchronizedMap(new HashMap());
    private volatile long timeoutMilliseconds = 0L;
    private volatile StatefulWebServiceManager.Callback<T> timeoutCallback;
    private volatile Timer timer;
    private static final QName COOKIE_TAG = new QName("http://jax-ws.dev.java.net/xml/ns/", "objectId", "jaxws");
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server");

    public StatefulInstanceResolver(Class<T> clazz) {
        super(clazz);
    }

    @Override
    @NotNull
    public T resolve(Packet packet) {
        Object object;
        HeaderList headerList = packet.getMessage().getHeaders();
        Header header = headerList.get(COOKIE_TAG, true);
        String string = null;
        if (header != null) {
            string = header.getStringContent();
            object = this.instances.get(string);
            if (object != null) {
                ((Instance)object).restartTimer();
                return ((Instance)object).instance;
            }
            logger.log(Level.INFO, "Request had an unrecognized object ID " + string);
        }
        if ((object = this.fallback) != null) {
            return (T)object;
        }
        if (string == null) {
            throw new WebServiceException(ServerMessages.STATEFUL_COOKIE_HEADER_REQUIRED(COOKIE_TAG));
        }
        throw new WebServiceException(ServerMessages.STATEFUL_COOKIE_HEADER_INCORRECT(COOKIE_TAG, string));
    }

    @Override
    public void start(WSWebServiceContext wSWebServiceContext, WSEndpoint wSEndpoint) {
        super.start(wSWebServiceContext, wSEndpoint);
        if (wSEndpoint.getBinding().getAddressingVersion() == null) {
            throw new WebServiceException(ServerMessages.STATEFUL_REQURES_ADDRESSING(this.clazz));
        }
        for (Field accessibleObject : this.clazz.getDeclaredFields()) {
            if (accessibleObject.getType() != StatefulWebServiceManager.class) continue;
            if (!Modifier.isStatic(accessibleObject.getModifiers())) {
                throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(StatefulWebServiceManager.class, accessibleObject));
            }
            new AbstractInstanceResolver.FieldInjectionPlan<Object, StatefulInstanceResolver>(accessibleObject).inject(null, this);
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredMethods()) {
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length != 1 || classArray[0] != StatefulWebServiceManager.class) continue;
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(StatefulWebServiceManager.class, accessibleObject));
            }
            new AbstractInstanceResolver.MethodInjectionPlan<Object, StatefulInstanceResolver>((Method)accessibleObject).inject(null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.reverseInstances.clear();
        Map<String, Instance> map = this.instances;
        synchronized (map) {
            for (Instance instance : this.instances.values()) {
                instance.cancel();
                this.dispose(instance.instance);
            }
            this.instances.clear();
        }
        if (this.fallback != null) {
            this.dispose(this.fallback);
        }
        this.fallback = null;
    }

    @Override
    @NotNull
    public W3CEndpointReference export(T t) {
        return this.export(W3CEndpointReference.class, t);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, T t) {
        return this.export(clazz, t, null);
    }

    @Override
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, T t, EPRRecipe ePRRecipe) {
        return this.export(clazz, InvokerTube.getCurrentPacket(), t, ePRRecipe);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, WebServiceContext webServiceContext, T t) {
        if (webServiceContext instanceof WSWebServiceContext) {
            WSWebServiceContext wSWebServiceContext = (WSWebServiceContext)webServiceContext;
            return this.export(clazz, wSWebServiceContext.getRequestPacket(), t);
        }
        throw new WebServiceException(ServerMessages.STATEFUL_INVALID_WEBSERVICE_CONTEXT(webServiceContext));
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, @NotNull Packet packet, T t) {
        return this.export(clazz, packet, t, null);
    }

    @Override
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, @NotNull Packet packet, T t, EPRRecipe ePRRecipe) {
        return this.export(clazz, packet.webServiceContextDelegate.getEPRAddress(packet, this.owner), t, ePRRecipe);
    }

    @Override
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, String string, T t) {
        return this.export(clazz, string, t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <EPR extends EndpointReference> EPR export(Class<EPR> clazz, String string, T t, EPRRecipe ePRRecipe) {
        if (string == null) {
            throw new IllegalArgumentException("No address available");
        }
        String string2 = this.reverseInstances.get(t);
        if (string2 != null) {
            return this.createEPR(string2, clazz, string, ePRRecipe);
        }
        StatefulInstanceResolver statefulInstanceResolver = this;
        synchronized (statefulInstanceResolver) {
            string2 = this.reverseInstances.get(t);
            if (string2 != null) {
                return this.createEPR(string2, clazz, string, ePRRecipe);
            }
            if (t != null) {
                this.prepare(t);
            }
            string2 = UUID.randomUUID().toString();
            Instance instance = new Instance(t);
            this.instances.put(string2, instance);
            this.reverseInstances.put(t, string2);
            if (this.timeoutMilliseconds != 0L) {
                instance.restartTimer();
            }
        }
        return this.createEPR(string2, clazz, string, ePRRecipe);
    }

    private <EPR extends EndpointReference> EPR createEPR(String string, Class<EPR> clazz, String string2, EPRRecipe ePRRecipe) {
        AddressingVersion addressingVersion = AddressingVersion.fromSpecClass(clazz);
        try {
            Object object;
            Object object2;
            StreamWriterBufferCreator streamWriterBufferCreator = new StreamWriterBufferCreator();
            streamWriterBufferCreator.writeStartDocument();
            streamWriterBufferCreator.writeStartElement("wsa", "EndpointReference", addressingVersion.nsUri);
            streamWriterBufferCreator.writeNamespace("wsa", addressingVersion.nsUri);
            streamWriterBufferCreator.writeStartElement("wsa", "Address", addressingVersion.nsUri);
            streamWriterBufferCreator.writeCharacters(string2);
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeStartElement("wsa", "ReferenceParameters", addressingVersion.nsUri);
            streamWriterBufferCreator.writeStartElement(COOKIE_TAG.getPrefix(), COOKIE_TAG.getLocalPart(), COOKIE_TAG.getNamespaceURI());
            streamWriterBufferCreator.writeCharacters(string);
            streamWriterBufferCreator.writeEndElement();
            if (ePRRecipe != null) {
                object2 = ePRRecipe.getReferenceParameters().iterator();
                while (object2.hasNext()) {
                    object = (Header)object2.next();
                    object.writeTo(streamWriterBufferCreator);
                }
            }
            streamWriterBufferCreator.writeEndElement();
            if (ePRRecipe != null && !(object2 = ePRRecipe.getMetadata()).isEmpty()) {
                streamWriterBufferCreator.writeStartElement("wsa", "Metadata", addressingVersion.nsUri);
                object = XmlUtil.newTransformer();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Source source = (Source)iterator.next();
                    try {
                        ((Transformer)object).transform(source, new SAXResult(new FragmentContentHandler(new ContentHandlerToXMLStreamWriter(streamWriterBufferCreator))));
                    }
                    catch (TransformerException transformerException) {
                        throw new IllegalArgumentException("Unable to write EPR metadata " + source, transformerException);
                    }
                }
                streamWriterBufferCreator.writeEndElement();
            }
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeEndDocument();
            return (EPR)((EndpointReference)clazz.cast(ProviderImpl.INSTANCE.readEndpointReference(new XMLStreamBufferSource(streamWriterBufferCreator.getXMLStreamBuffer()))));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new Error(xMLStreamException);
        }
    }

    @Override
    public void unexport(@Nullable T t) {
        if (t == null) {
            return;
        }
        String string = this.reverseInstances.get(t);
        if (string == null) {
            return;
        }
        this.instances.remove(string);
        this.reverseInstances.remove(t);
    }

    @Override
    public T resolve(EndpointReference endpointReference) {
        class CookieSniffer
        extends DefaultHandler {
            StringBuilder buf = new StringBuilder();
            boolean inCookie = false;

            CookieSniffer() {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string2.equals(COOKIE_TAG.getLocalPart()) && string.equals(COOKIE_TAG.getNamespaceURI())) {
                    this.inCookie = true;
                }
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
                if (this.inCookie) {
                    this.buf.append(cArray, n, n2);
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                this.inCookie = false;
            }
        }
        CookieSniffer cookieSniffer = new CookieSniffer();
        endpointReference.writeTo(new SAXResult(cookieSniffer));
        Instance instance = this.instances.get(cookieSniffer.buf.toString());
        if (instance != null) {
            return instance.instance;
        }
        return null;
    }

    @Override
    public void setFallbackInstance(T t) {
        if (t != null) {
            this.prepare(t);
        }
        this.fallback = t;
    }

    @Override
    public void setTimeout(long l, StatefulWebServiceManager.Callback<T> callback) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeoutMilliseconds = l;
        this.timeoutCallback = callback;
        if (this.timeoutMilliseconds > 0L) {
            this.startTimer();
        }
    }

    @Override
    public void touch(T t) {
        String string = this.reverseInstances.get(t);
        if (string == null) {
            return;
        }
        Instance instance = this.instances.get(string);
        if (instance == null) {
            return;
        }
        instance.restartTimer();
    }

    private synchronized void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer("JAX-WS stateful web service timeout timer");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Instance {
        @NotNull
        final T instance;
        TimerTask task;

        public Instance(T t) {
            this.instance = t;
        }

        public synchronized void restartTimer() {
            this.cancel();
            if (StatefulInstanceResolver.this.timeoutMilliseconds == 0L) {
                return;
            }
            this.task = new TimerTask(){

                public void run() {
                    try {
                        StatefulWebServiceManager.Callback callback = StatefulInstanceResolver.this.timeoutCallback;
                        if (callback != null) {
                            callback.onTimeout(Instance.this.instance, StatefulInstanceResolver.this);
                            return;
                        }
                        StatefulInstanceResolver.this.unexport(Instance.this.instance);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "time out handler failed", throwable);
                    }
                }
            };
            StatefulInstanceResolver.this.timer.schedule(this.task, StatefulInstanceResolver.this.timeoutMilliseconds);
        }

        public synchronized void cancel() {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = null;
        }
    }
}

