/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Composite;
import sun.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public abstract class BufferedTextPipe
extends GlyphListPipe {
    private static final int BYTES_PER_GLYPH_IMAGE = 8;
    private static final int BYTES_PER_GLYPH_POSITION = 8;
    private static final int OFFSET_CONTRAST = 8;
    private static final int OFFSET_RGBORDER = 2;
    private static final int OFFSET_SUBPIXPOS = 1;
    private static final int OFFSET_POSITIONS = 0;
    protected final RenderQueue rq;

    private static int createPackedParams(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        return (glyphList.usePositions() ? 1 : 0) << 0 | (glyphList.isSubPixPos() ? 1 : 0) << 1 | (glyphList.isRGBOrder() ? 1 : 0) << 2 | (sunGraphics2D.lcdTextContrast & 0xFF) << 8;
    }

    protected BufferedTextPipe(RenderQueue renderQueue) {
        this.rq = renderQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGlyphList(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        Composite composite = sunGraphics2D.composite;
        if (composite == AlphaComposite.Src) {
            composite = AlphaComposite.SrcOver;
        }
        this.rq.lock();
        try {
            this.validateContext(sunGraphics2D, composite);
            this.enqueueGlyphList(sunGraphics2D, glyphList);
        }
        finally {
            this.rq.unlock();
        }
    }

    private void enqueueGlyphList(final SunGraphics2D sunGraphics2D, final GlyphList glyphList) {
        RenderBuffer renderBuffer = this.rq.getBuffer();
        final int n = glyphList.getNumGlyphs();
        int n2 = n * 8;
        int n3 = glyphList.usePositions() ? n * 8 : 0;
        int n4 = 24 + n2 + n3;
        final long[] lArray = glyphList.getImages();
        final float f = glyphList.getX() + 0.5f;
        final float f2 = glyphList.getY() + 0.5f;
        this.rq.addReference(glyphList.getStrike());
        if (n4 <= renderBuffer.capacity()) {
            if (n4 > renderBuffer.remaining()) {
                this.rq.flushNow();
            }
            this.rq.ensureAlignment(20);
            renderBuffer.putInt(40);
            renderBuffer.putInt(n);
            renderBuffer.putInt(BufferedTextPipe.createPackedParams(sunGraphics2D, glyphList));
            renderBuffer.putFloat(f);
            renderBuffer.putFloat(f2);
            renderBuffer.put(lArray, 0, n);
            if (glyphList.usePositions()) {
                float[] fArray = glyphList.getPositions();
                renderBuffer.put(fArray, 0, 2 * n);
            }
        } else {
            this.rq.flushAndInvokeNow(new Runnable(){

                public void run() {
                    BufferedTextPipe.this.drawGlyphList(n, glyphList.usePositions(), glyphList.isSubPixPos(), glyphList.isRGBOrder(), sunGraphics2D.lcdTextContrast, f, f2, lArray, glyphList.getPositions());
                }
            });
        }
    }

    protected abstract void drawGlyphList(int var1, boolean var2, boolean var3, boolean var4, int var5, float var6, float var7, long[] var8, float[] var9);

    protected abstract void validateContext(SunGraphics2D var1, Composite var2);
}

