/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.x11.X11SurfaceData;

public class X11Renderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    public static X11Renderer getInstance() {
        return GraphicsPrimitive.tracingEnabled() ? new X11TracingRenderer() : new X11Renderer();
    }

    private final long validate(SunGraphics2D sunGraphics2D) {
        X11SurfaceData x11SurfaceData = (X11SurfaceData)sunGraphics2D.surfaceData;
        return x11SurfaceData.getRenderGC(sunGraphics2D.getCompClip(), sunGraphics2D.compositeState, sunGraphics2D.composite, sunGraphics2D.pixel);
    }

    native void XDrawLine(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            int n5 = sunGraphics2D.transX;
            int n6 = sunGraphics2D.transY;
            this.XDrawLine(sunGraphics2D.surfaceData.getNativeOps(), l, n + n5, n2 + n6, n3 + n5, n4 + n6);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XDrawRect(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawRect(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XDrawRoundRect(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawRoundRect(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XDrawOval(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawOval(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XDrawArc(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawArc(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XDrawPoly(long var1, long var3, int var5, int var6, int[] var7, int[] var8, int var9, boolean var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), l, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, false);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), l, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, true);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillRect(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XFillRect(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillRoundRect(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XFillRoundRect(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillOval(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XFillOval(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillArc(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XFillArc(sunGraphics2D.surfaceData.getNativeOps(), l, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillPoly(long var1, long var3, int var5, int var6, int[] var7, int[] var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XFillPoly(sunGraphics2D.surfaceData.getNativeOps(), l, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    native void XFillSpans(long var1, long var3, SpanIterator var5, long var6, int var8, int var9);

    native void XDoPath(SunGraphics2D var1, long var2, long var4, int var6, int var7, Path2D.Float var8, boolean var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPath(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        int n;
        int n2;
        Path2D.Float float_;
        if (sunGraphics2D.transformState <= 1) {
            float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            float_ = new Path2D.Float(shape, sunGraphics2D.transform);
            n2 = 0;
            n = 0;
        }
        SunToolkit.awtLock();
        try {
            long l = this.validate(sunGraphics2D);
            this.XDoPath(sunGraphics2D, sunGraphics2D.surfaceData.getNativeOps(), l, n2, n, float_, bl);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        block11: {
            if (sunGraphics2D.strokeState == 0) {
                if (shape instanceof Polygon) {
                    if (sunGraphics2D.transformState < 3) {
                        Polygon polygon = (Polygon)shape;
                        this.drawPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                        return;
                    }
                }
                this.doPath(sunGraphics2D, shape, false);
            } else {
                if (sunGraphics2D.strokeState < 3) {
                    ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
                    try {
                        SunToolkit.awtLock();
                        try {
                            long l = this.validate(sunGraphics2D);
                            this.XFillSpans(sunGraphics2D.surfaceData.getNativeOps(), l, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), 0, 0);
                            break block11;
                        }
                        finally {
                            SunToolkit.awtUnlock();
                        }
                    }
                    finally {
                        shapeSpanIterator.dispose();
                    }
                }
                this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n;
        int n2;
        AffineTransform affineTransform;
        if (sunGraphics2D.strokeState == 0) {
            if (shape instanceof Polygon) {
                if (sunGraphics2D.transformState < 3) {
                    Polygon polygon = (Polygon)shape;
                    this.fillPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                    return;
                }
            }
            this.doPath(sunGraphics2D, shape, true);
            return;
        }
        if (sunGraphics2D.transformState < 3) {
            affineTransform = null;
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n = 0;
            n2 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n2, region.getLoY() - n, region.getHiX() - n2, region.getHiY() - n);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            SunToolkit.awtLock();
            try {
                long l = this.validate(sunGraphics2D);
                this.XFillSpans(sunGraphics2D.surfaceData.getNativeOps(), l, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), n2, n);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    native void devCopyArea(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    public static class X11TracingRenderer
    extends X11Renderer {
        void XDrawLine(long l, long l2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("X11DrawLine");
            super.XDrawLine(l, l2, n, n2, n3, n4);
        }

        void XDrawRect(long l, long l2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("X11DrawRect");
            super.XDrawRect(l, l2, n, n2, n3, n4);
        }

        void XDrawRoundRect(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("X11DrawRoundRect");
            super.XDrawRoundRect(l, l2, n, n2, n3, n4, n5, n6);
        }

        void XDrawOval(long l, long l2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("X11DrawOval");
            super.XDrawOval(l, l2, n, n2, n3, n4);
        }

        void XDrawArc(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("X11DrawArc");
            super.XDrawArc(l, l2, n, n2, n3, n4, n5, n6);
        }

        void XDrawPoly(long l, long l2, int n, int n2, int[] nArray, int[] nArray2, int n3, boolean bl) {
            GraphicsPrimitive.tracePrimitive("X11DrawPoly");
            super.XDrawPoly(l, l2, n, n2, nArray, nArray2, n3, bl);
        }

        void XDoPath(SunGraphics2D sunGraphics2D, long l, long l2, int n, int n2, Path2D.Float float_, boolean bl) {
            GraphicsPrimitive.tracePrimitive(bl ? "X11FillPath" : "X11DrawPath");
            super.XDoPath(sunGraphics2D, l, l2, n, n2, float_, bl);
        }

        void XFillRect(long l, long l2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("X11FillRect");
            super.XFillRect(l, l2, n, n2, n3, n4);
        }

        void XFillRoundRect(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("X11FillRoundRect");
            super.XFillRoundRect(l, l2, n, n2, n3, n4, n5, n6);
        }

        void XFillOval(long l, long l2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("X11FillOval");
            super.XFillOval(l, l2, n, n2, n3, n4);
        }

        void XFillArc(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("X11FillArc");
            super.XFillArc(l, l2, n, n2, n3, n4, n5, n6);
        }

        void XFillPoly(long l, long l2, int n, int n2, int[] nArray, int[] nArray2, int n3) {
            GraphicsPrimitive.tracePrimitive("X11FillPoly");
            super.XFillPoly(l, l2, n, n2, nArray, nArray2, n3);
        }

        void XFillSpans(long l, long l2, SpanIterator spanIterator, long l3, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("X11FillSpans");
            super.XFillSpans(l, l2, spanIterator, l3, n, n2);
        }

        void devCopyArea(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("X11CopyArea");
            super.devCopyArea(l, l2, n, n2, n3, n4, n5, n6);
        }
    }
}

