//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.



#ifndef ERASE_CD_H
#define ERASE_CD_H
#include <QFile>
#include <QProcess>
#include <QByteArray>
#include <QDialog>
#include "../build/ui_erasecd.h"

//
class erasecd : public QDialog, public Ui::erasecd
{
Q_OBJECT
public:
	erasecd( QWidget * parent = 0, Qt::WFlags f = 0 );
	QStringList device_path;
	QStringList id_device;
	QByteArray erase_output;
	bool is_erasing;
	bool loaded_success;
	QTimer *timer;

  QString Devices_Burn;
  QString Properties_Device;
  
  
private slots:
  void start_erase();
  void device_scan();
  void media_available();
  void combo_changed(int n);
  void updateEraseDisplay();
  void printOutErase(int, QProcess::ExitStatus);
  void disable_buttons();
  void enable_buttons();
  void play_success();
  void play_error();
      //burn
    void updateScanDevices();
    void scan_devices_burn();
    void updateScanDevicesProperties();
    void scan_device_properties_process_Finished(int, QProcess::ExitStatus);
  
private:
QProcess *erase;
    QProcess *scan_devices_process;
    QProcess *scan_device_properties_process;
  
  
};
#endif

