#!/usr/bin/env perl


print<<EOM;
/*
 * This file is automatically generated by $0
 * DO NOT EDIT MANUALLY, fix the $0 instead if necessary.
 */
#ifndef	ASN1_PARSER_EXPR_STR_H
#define	ASN1_PARSER_EXPR_STR_H

#include <assert.h>

#ifndef	__GNUC__
#define	__attribute__(x)	/* unused */
#endif

static char *asn1p_expr_type2str[] __attribute__ ((unused)) = {
EOM

while(<>) {
	chomp;
	next if(/TYPE_MAX/);
	next unless(/^[ \t]+(ASN_[A-Z]+_([A-Za-z0-9_]+))/);

	print "\t[ $1 ]\t = ";

	$_ = $2;
	if($_ eq "RELATIVE_OID") {
		print '"RELATIVE-OID"';
	} else {
		s/_/ /;
		print '"'.$_.'"';
	}

	print ",\n";
}

print<<EOM;
};

/*
 * Convert the ASN.1 expression type back into the string representation.
 */
#define ASN_EXPR_TYPE2STR(type) _asn1p_expr_type2string(type)

static inline char * __attribute__((unused))
_asn1p_expr_type2string(asn1p_expr_type_e type) {
    assert((signed int)type >= 0);
    if(type < sizeof(asn1p_expr_type2str)/sizeof(asn1p_expr_type2str[0]))
        return asn1p_expr_type2str[type];
    return NULL;
}

#endif	/* ASN1_PARSER_EXPR_STR_H */
EOM
