import time

from ...version import __version__
from . import uper


SOURCE_FMT = '''\
//! This file was generated by asn1tools version {version} {date}.

{helpers}
{types_code}\
'''


def generate(compiled, codec):
    """Generate Rust source code from given compiled specification.

    """

    date = time.ctime()

    if codec == 'uper':
        helpers, types_code = uper.generate(compiled)
    else:
        raise Exception()

    source = SOURCE_FMT.format(version=__version__,
                               date=date,
                               helpers=helpers,
                               types_code=types_code)

    return source
