# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "sig gallery-application create",
)
class Create(AAZCommand):
    """Create a gallery Application Definition.

    :example: Create a simple gallery Application.
        az sig gallery-application create --gallery-name MyGallery --name AppName -g MyResourceGroup --os-type windows
    """

    _aaz_info = {
        "version": "2021-07-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/galleries/{}/applications/{}", "2021-07-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.gallery_application_name = AAZStrArg(
            options=["-n", "--name", "--application-name", "--gallery-application-name"],
            help="The name of the gallery application.",
            required=True,
        )
        _args_schema.gallery_name = AAZStrArg(
            options=["-r", "--gallery-name"],
            help="Gallery name.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Resource location",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.description = AAZStrArg(
            options=["--description"],
            help="The description of this gallery Application Definition resource. This property is updatable.",
        )
        _args_schema.os_type = AAZStrArg(
            options=["--os-type"],
            help="This property allows you to specify the supported type of the OS that application is built for. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**",
            enum={"Linux": "Linux", "Windows": "Windows"},
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Resource tags",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.GalleryApplicationsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class GalleryApplicationsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "galleryApplicationName", self.ctx.args.gallery_application_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "galleryName", self.ctx.args.gallery_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2021-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("supportedOSType", AAZStrType, ".os_type", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _CreateHelper._build_schema_gallery_application_read(cls._schema_on_200_201)

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    _schema_gallery_application_read = None

    @classmethod
    def _build_schema_gallery_application_read(cls, _schema):
        if cls._schema_gallery_application_read is not None:
            _schema.id = cls._schema_gallery_application_read.id
            _schema.location = cls._schema_gallery_application_read.location
            _schema.name = cls._schema_gallery_application_read.name
            _schema.properties = cls._schema_gallery_application_read.properties
            _schema.tags = cls._schema_gallery_application_read.tags
            _schema.type = cls._schema_gallery_application_read.type
            return

        cls._schema_gallery_application_read = _schema_gallery_application_read = AAZObjectType()

        gallery_application_read = _schema_gallery_application_read
        gallery_application_read.id = AAZStrType(
            flags={"read_only": True},
        )
        gallery_application_read.location = AAZStrType(
            flags={"required": True},
        )
        gallery_application_read.name = AAZStrType(
            flags={"read_only": True},
        )
        gallery_application_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        gallery_application_read.tags = AAZDictType()
        gallery_application_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_gallery_application_read.properties
        properties.description = AAZStrType()
        properties.end_of_life_date = AAZStrType(
            serialized_name="endOfLifeDate",
        )
        properties.eula = AAZStrType()
        properties.privacy_statement_uri = AAZStrType(
            serialized_name="privacyStatementUri",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.release_note_uri = AAZStrType(
            serialized_name="releaseNoteUri",
        )
        properties.supported_os_type = AAZStrType(
            serialized_name="supportedOSType",
            flags={"required": True},
        )

        tags = _schema_gallery_application_read.tags
        tags.Element = AAZStrType()

        _schema.id = cls._schema_gallery_application_read.id
        _schema.location = cls._schema_gallery_application_read.location
        _schema.name = cls._schema_gallery_application_read.name
        _schema.properties = cls._schema_gallery_application_read.properties
        _schema.tags = cls._schema_gallery_application_read.tags
        _schema.type = cls._schema_gallery_application_read.type


__all__ = ["Create"]
