//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_3.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot3(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[3] = {6.663259077023708e-01,2.800775054150257e+00,7.032899038147373e+00};
  constexpr double aw[3] = {2.835931389201556e-01,1.526858844222733e-01,6.834439383950065e-03};
  constexpr double x[1152] = {  2.961907909809220e-01, -1.605735324243221e-02,  5.461601556202310e-04, -1.140146882676054e-05, -1.040579594989508e-08,
  1.248027584222446e-08, -5.648281579040981e-10,  1.024513777740748e-11,  3.199855763279449e-13, -2.662139053215769e-14,  6.791712157990545e-16,  2.656489444335588e-18,
  1.033212514316183e+00, -3.330848168086409e-02, -2.177347755717356e-05,  2.450383067515595e-05,  4.794432242539291e-09, -3.294334927233414e-08,  2.359572985965940e-13,
  5.240455914487461e-11,  2.524360743714605e-14, -8.204630353665457e-14, -3.781729656888576e-17,  1.274562553931474e-16,  1.774618490056192e+00, -1.404938734747934e-02,
 -5.682195677350740e-04, -1.559016009198644e-05, -1.635859527681777e-07,  1.085733465378623e-08,  7.704977230283884e-10,  2.359798677347824e-11,  5.614495586963010e-14,
 -2.999613214503894e-14, -1.489471691915305e-15, -3.169772607441557e-17,  2.398490670826105e-01, -1.222345314127062e-02,  4.144902466283799e-04, -1.019883116999430e-05,
  1.297684795274664e-07,  2.820856783732400e-09, -2.426966455188301e-10,  1.009622490601609e-11, -1.956854607765270e-13, -4.408442344030569e-15,  3.527548899798185e-16,
 -9.608962522422249e-18,  9.014312203808409e-01, -3.235288603686788e-02,  2.522856202934319e-04,  1.977742225050728e-05, -5.454919248420338e-07, -1.772752694292366e-08,
  1.090155890972624e-09,  1.523509216626156e-11, -1.847303054429019e-12, -2.830995355739420e-15,  2.718835626123694e-15, -3.380130529015931e-17,  1.708113049340503e+00,
 -1.936386399979748e-02, -7.599995533385510e-04, -1.525457051199157e-05,  2.871493016250112e-07,  3.602237551106031e-08,  1.201306875097670e-09, -4.982489663472342e-12,
 -2.236935183216379e-12, -9.180005161083786e-14, -4.032117984854281e-16,  1.350246024369357e-16,  1.968653969153101e-01, -9.359124990244489e-03,  3.056281843344041e-04,
 -7.905361136095522e-06,  1.468515642785981e-07, -3.869663436919955e-10, -5.638434875515690e-11,  3.298468873931931e-12, -1.856431932761115e-13,  3.124862507412205e-15,
  7.493921782541361e-17, -2.835801515035654e-18,  7.773262851766268e-01, -2.955112063554776e-02,  4.302697081560300e-04,  9.664856163111528e-06, -6.364042308602759e-07,
  7.415718351646230e-09,  7.953990725708970e-10, -2.958126332535110e-11, -6.484613122225725e-13,  4.828381905370826e-14, -2.524761671739539e-16, -5.021434966481688e-17,
  1.617532384026352e+00, -2.603400137652028e-02, -8.872008451725195e-04, -3.560256534417582e-06,  1.230684351026506e-06,  5.232096942627092e-08, -3.637982944164963e-10,
 -1.152917349948286e-10, -3.572900897626568e-12,  9.485502024287527e-14,  1.061808920051979e-14,  2.102078103777362e-16,  1.637732919665102e-01, -7.254567108151478e-03,
  2.244280067768930e-04, -5.670354135801938e-06,  1.300934079515021e-07, -1.182981313826481e-09, -2.715421575340612e-11, -4.267475207831512e-13, -3.790659658928794e-14,
  4.701978281672296e-15,  7.278458143066704e-18, -2.504793915747298e-18,  6.665177878713354e-01, -2.580164315178349e-02,  4.925786119404584e-04,  1.401571252117842e-06,
 -3.700850478899844e-07,  1.568496341334372e-08, -9.193615315529074e-11, -2.697607648211236e-11,  6.439996172875658e-13,  2.194773323688364e-14, -6.059207081168457e-16,
  8.586611163814126e-18,  1.499496640947965e+00, -3.289746804083784e-02, -7.821920831584680e-04,  2.276841242165568e-05,  1.886172923816850e-06, -1.840482811038978e-09,
 -4.074130254069762e-09, -9.269651918572861e-11,  6.878352676723008e-12,  3.739574258033801e-13, -6.452936722999099e-15, -1.004647043944968e-15,  1.379621916215773e-01,
 -5.697986147672594e-03,  1.679645235220274e-04, -3.818109429577622e-06,  9.888755672615360e-08, -1.964382307362824e-09, -3.209907447771412e-11,  7.864394446126844e-13,
  9.198164649014498e-14,  9.510919130480661e-16, -2.141762657540859e-16, -4.163032102817289e-18,  5.711860115329348e-01, -2.187241693071818e-02,  4.832493860925586e-04,
 -2.337240781288424e-06, -1.250923257940106e-07,  7.309359497517410e-09, -4.730992900681126e-10,  1.497099765677385e-12,  9.601849051099925e-13, -8.710392935140784e-15,
 -1.185734780863579e-15, -1.806395920501620e-17,  1.357796570389673e+00, -3.758850532102344e-02, -3.473754271397238e-04,  4.703035804536280e-05,  8.295267407279367e-07,
 -9.727082489925157e-08, -2.384337253249781e-09,  2.160707770240724e-10,  6.977695104920608e-12, -4.773671274894130e-13, -1.997840756666930e-14,  1.024715487833856e-15,
  1.176012704447694e-01, -4.513838602373029e-03,  1.302428442969353e-04, -2.578804765097650e-06,  5.530540948699602e-08, -2.168585821202866e-09,  2.395002718456670e-11,
  2.585414751647243e-12, -2.236801145887473e-14, -5.695760007255888e-15,  2.010925691882413e-17,  1.271915421687675e-17,  4.912126286215868e-01, -1.814523101551119e-02,
  4.461939542718574e-04, -3.716450074247422e-06, -7.356496415285522e-08, -6.939607276027527e-10, -1.138326192067229e-10,  1.829693374871621e-11, -1.158134900973997e-13,
 -3.999124295912022e-14,  4.332423614495261e-16,  7.850252430710613e-17,  1.205570706880955e+00, -3.804123051172844e-02,  2.285534213169426e-04,  4.390499032861518e-05,
 -1.146429567446924e-06, -7.532348936536608e-08,  3.755139560249991e-09,  1.229160909920614e-10, -1.067099508314165e-11, -1.534298753238427e-13,  2.777451723794923e-14,
  1.941439700411122e-17,  1.014510923481595e-01, -3.583620174656928e-03,  1.033353460426270e-04, -1.988676876748551e-06,  2.242324882926937e-08, -9.656180183246665e-10,
  6.211532738727063e-11, -3.488965717454150e-13, -1.106024775856151e-13,  2.132988459352893e-15,  2.085921120853531e-16, -7.283479892469993e-18,  4.254584599666106e-01,
 -1.477531596704936e-02,  3.940207221389119e-04, -5.000990227526548e-06, -8.016767225238586e-08,  1.235679381263381e-09,  1.863231478651604e-10,  1.505390255169714e-13,
 -6.642118346048447e-13,  1.517452831321420e-14,  1.230335707807936e-15, -5.515898039829171e-17,  1.059852029112894e+00, -3.449689149188574e-02,  6.130293514992574e-04,
  1.888720979538796e-05, -1.668525770602435e-06,  1.923952455897058e-08,  2.897548921995323e-09, -1.349097428417867e-10, -2.227399012274098e-12,  3.706972129800174e-13,
 -6.177588741018147e-15, -6.517930289824656e-16,  8.862612641597403e-02, -2.847277494269137e-03,  8.122537445517563e-05, -1.712594386370739e-06,  1.561135818241227e-08,
  1.178295915273946e-10,  2.141803155854728e-11, -1.814058813155334e-12,  2.226682436318423e-14,  2.874638917302567e-15, -1.252161399671684e-16, -2.205482757684867e-18,
  3.722549673852791e-01, -1.188168509112561e-02,  3.278341104616252e-04, -5.876004952013644e-06, -1.984709675108145e-08,  4.070761456233862e-09,  1.248956478715439e-11,
 -8.066247193813138e-12,  1.397895906375817e-13,  1.513402745633945e-14, -8.047618714192177e-16, -6.346540538756271e-18,  9.325292076051213e-01, -2.909260657788278e-02,
  7.008728823550158e-04, -2.248082927780594e-06, -8.927674277616376e-07,  4.515072130921247e-08, -4.001550292667599e-10, -6.913975479281393e-11,  3.803371212050780e-12,
 -2.713442102403403e-14, -6.367409692329653e-15,  3.220745665132244e-16,  7.841283091682416e-02, -2.275148857449302e-03,  6.229943741075572e-05, -1.430975932460540e-06,
  1.968705740826414e-08,  1.633291984957872e-10, -1.076520432167446e-11, -3.924156188059655e-13,  4.240746029669521e-14, -1.052200600261383e-15, -3.334343545509233e-17,
  3.136622747411145e-18,  3.295272639148178e-01, -9.540493962989416e-03,  2.579780167169904e-04, -5.589327962268057e-06,  5.023650000951996e-08,  2.456681290649858e-09,
 -1.103123258532241e-10, -4.727125352001171e-13,  2.026363661847863e-13, -6.544255073188975e-15, -1.230092237414640e-16,  1.722743055022504e-17,  8.269424015926236e-01,
 -2.377346711264025e-02,  6.150461973363725e-04, -1.026457861478640e-05, -1.797121731310987e-07,  2.403408109009667e-08, -9.861258111256774e-10,  1.176681669646415e-11,
  1.044066953559871e-12, -7.184998146047583e-14,  1.796306244630957e-15,  3.213225783311030e-17,  7.020803329526640e-02, -1.839937315573029e-03,  4.707536859888151e-05,
 -1.105358394818814e-06,  2.010861906887135e-08, -1.122278642894458e-10, -9.033152991069493e-12,  3.070346928871935e-13,  3.983745619954648e-15, -7.009183173436969e-16,
  2.597593211851045e-17, -1.104246330362881e-19,  2.950912088952438e-01, -7.728472496270009e-03,  1.968973722142825e-04, -4.530523190090477e-06,  7.465747027067530e-08,
  1.601642235515335e-10, -6.849006389846075e-11,  2.345807643186177e-12, -3.405212202572044e-15, -3.222614489351502e-15,  1.464060999542885e-16, -1.685423294531651e-18,
  7.408786951532157e-01, -1.936576055980265e-02,  4.867289490944352e-04, -1.042605495758295e-05,  1.022216930611855e-07,  6.216474172207984e-09, -4.767560877999693e-10,
  1.772815753926815e-11, -2.913857914147464e-13, -9.418601030990123e-15,  8.979445511877872e-16, -3.319729227179317e-17,  6.352490106556387e-02, -1.511154409865179e-03,
  3.563736156945925e-05, -8.104066635940734e-07,  1.639222470382410e-08, -2.282013463580703e-10, -1.163421979516555e-12,  2.039714213414680e-13, -6.193110455705106e-15,
  6.799523251706578e-18,  7.903073462770735e-18, -3.848588904426388e-19,  2.670117454393713e-01, -6.350682284561908e-03,  1.495728356534086e-04, -3.378592485847462e-06,
  6.635621123372218e-08, -7.795138592216501e-10, -1.491182252356525e-11,  1.299058667531515e-12, -4.084344125084958e-14,  3.508895903849182e-16,  3.299306354453653e-17,
 -1.971963854409034e-18,  6.704584796640507e-01, -1.593841231814531e-02,  3.739293323580577e-04, -8.269829689102273e-06,  1.462617698824621e-07, -4.502962854184383e-10,
 -1.267081723654120e-10,  7.525588440295249e-12, -2.635622023969933e-13,  5.280123587853735e-15,  3.067433424947399e-17, -7.688732409177701e-18,  5.799472506440735e-02,
 -1.260845010485068e-03,  2.733498259883240e-05, -5.846027995798067e-07,  1.190248724812932e-08, -2.082662647087637e-10,  2.087626810658283e-12,  4.456000672564774e-14,
 -3.291284826765171e-15,  9.698387847826963e-17, -9.681020844019801e-19, -5.868927821350715e-20,  2.437692309972713e-01, -5.299483021475466e-03,  1.148503030659638e-04,
 -2.451139641582631e-06,  4.944150273806263e-08, -8.312539411590926e-10,  6.100160656646433e-12,  3.201959615179442e-13, -1.925114642058052e-14,  5.844575294550674e-16,
 -8.297795361903195e-18, -2.004794939279170e-19,  6.121134624794297e-01, -1.330561036111712e-02,  2.880594624561554e-04, -6.110184896088512e-06,  1.197254751961914e-07,
 -1.743403049464682e-09, -6.433582455080984e-12,  1.945415782193472e-12, -9.837268592554970e-14,  3.282321338620783e-15, -7.299708895122211e-17,  5.057239710536251e-19,
  5.334845208936109e-02, -1.067286115804782e-03,  2.133447741960382e-05, -4.245152202137904e-07,  8.290202138966856e-09, -1.522108337564338e-10,  2.315544138514516e-12,
 -1.498677176698313e-14, -7.669707732941974e-16,  4.234338330980829e-17, -1.227254524776433e-18,  1.880272256514784e-20,  2.242400152775059e-01, -4.486088198489487e-03,
  8.966595944284146e-05, -1.783101157222597e-06,  3.472032887106743e-08, -6.299352868585611e-10,  9.103831935885323e-12, -2.949478556688732e-14, -4.728661765678279e-15,
  2.350717037381309e-16, -6.961458534848834e-18,  1.241623097270773e-19,  5.630780967222527e-01, -1.126449244459053e-02,  2.250909404882000e-04, -4.468578314886543e-06,
  8.628196841711240e-08, -1.509291790339434e-09,  1.808226065359143e-11,  1.903456849166736e-13, -2.434010835391814e-14,  1.094153576457986e-15, -3.487551067726090e-17,
  8.135994667152459e-19,  4.939129818442602e-02, -9.149446928066191e-04,  1.694499921487540e-05, -3.133837803005923e-07,  5.758269232429203e-09, -1.033356715379601e-10,
  1.723560497993137e-12, -2.295702311887012e-14,  7.621083242464554e-17,  9.693598137706888e-18, -4.555082345123802e-19,  1.295131660495474e-20,  2.076069666787093e-01,
 -3.845788170596901e-03,  7.122327104265838e-05, -1.316999225909201e-06,  2.417829873293297e-08, -4.322962858520225e-10,  7.108553818360548e-12, -8.891336237380190e-14,
 -4.064196645717003e-17,  5.556223884430734e-17, -2.439892901748161e-18,  7.037935443040773e-20,  5.213122755837869e-01, -9.656924984636170e-03,  1.788333064119203e-04,
 -3.305361438703246e-06,  6.053717569013537e-08, -1.071046832304074e-09,  1.686844819956796e-11, -1.670151189931252e-13, -2.873346082602919e-15,  2.581969509941038e-16,
 -1.056932206023101e-17,  3.219013427180800e-19,  4.598084343188185e-02, -7.930043933208188e-04,  1.367568814365885e-05, -2.357481598124433e-07,  4.055557038215300e-09,
 -6.918740747236587e-11,  1.147819782695612e-12, -1.752452465395213e-14,  2.064207489024652e-16, -1.392135543831576e-19, -1.000477773131171e-19,  4.214545268568086e-21,
  1.932717833386525e-01, -3.333242482749371e-03,  5.748282913094735e-05, -9.908752869902379e-07,  1.704182487817935e-08, -2.904083976119296e-10,  4.796904772853697e-12,
 -7.206532477722134e-14,  7.886474713705371e-16,  2.821240659844816e-18, -5.493435005086995e-19,  2.199271812828717e-20,  4.853159708284004e-01, -8.369943197676420e-03,
  1.443402962960027e-04, -2.487828501245374e-06,  4.275990087749300e-08, -7.264592228542058e-10,  1.185314632410184e-11, -1.696639279537422e-13,  1.406653625277101e-15,
  3.258249028466981e-17, -2.380067038628841e-18,  9.004192878810851e-20,  4.301114999460691e-02, -6.939079034645161e-04,  1.119480432143061e-05, -1.805861499394226e-07,
  2.911301650585742e-09, -4.680640537860990e-11,  7.450345034846803e-13, -1.149170655330445e-14,  1.618600596123419e-16, -1.708672249987636e-18, -2.282208963546615e-21,
  8.813383862197230e-22,  1.807892415224067e-01, -2.916710465719624e-03,  4.705518262433235e-05, -7.590509959590557e-07,  1.223618071898111e-08, -1.966640989820741e-10,
  3.126208941955518e-12, -4.798478147261736e-14,  6.641260589986311e-16, -6.458261874030364e-18, -3.814297184921977e-20,  4.704955962192387e-21,  4.539716489892432e-01,
 -7.324017315759948e-03,  1.181577360915240e-04, -1.905962034427112e-06,  3.071968350920711e-08, -4.933203869690956e-10,  7.813840302461321e-12, -1.183193731852200e-13,
  1.554752933561327e-15, -1.106277194233437e-17, -3.046481113060440e-19,  1.937479730922099e-20,  4.040194217900475e-02, -6.122910667371432e-04,  9.279235126799518e-06,
 -1.406224166939975e-07,  2.130704728800933e-09, -3.225753823128184e-11,  4.867303657612615e-13, -7.261118324804479e-15,  1.046928255332207e-16, -1.371060163604424e-18,
  1.318496907355540e-20,  3.417119062259654e-23,  1.698219300794601e-01, -2.573649757737277e-03,  3.900350056006056e-05, -5.910781841498152e-07,  8.955846212592620e-09,
 -1.355740935106119e-10,  2.044863814966179e-12, -3.045974488384021e-14,  4.368804514263232e-16, -5.617618204023718e-18,  4.951060168928477e-20,  3.584124816913990e-22,
  4.264321351718457e-01, -6.462574698504074e-03,  9.793984982386957e-05, -1.484219638269817e-06,  2.248754333960045e-08, -3.403411996516532e-10,  5.128130807214960e-12,
 -7.608195745539859e-14,  1.075653477936466e-15, -1.310998842155221e-17,  8.298267806936166e-20,  2.438992773135509e-21,  3.809131672353690e-02, -5.442727353636385e-04,
  7.776906071287824e-06, -1.111205140373607e-07,  1.587677243915677e-09, -2.267915379936424e-11,  3.236225048788142e-13, -4.600162792032729e-15,  6.458316032998071e-17,
 -8.748598705002363e-19,  1.073446370202152e-20, -9.580581986909471e-23,  1.601096526655073e-01, -2.287747596573853e-03,  3.268875334388840e-05, -4.670738082625054e-07,
  6.673471346472670e-09, -9.532495034168355e-11,  1.360100734647530e-12, -1.932460896919442e-14,  2.708640281211870e-16, -3.649336750476048e-18,  4.395680244616988e-20,
 -3.592709549917081e-22,  4.020440771147233e-01, -5.744659034222648e-03,  8.208323209171868e-05, -1.172846107566101e-06,  1.675726306124558e-08, -2.393497856703984e-10,
  3.414102602084519e-12, -4.845203577356257e-14,  6.762301125757376e-16, -8.977794508852346e-18,  1.025184451064135e-19, -6.032563236185025e-22,  3.603077854668313e-02,
 -4.869913554089295e-04,  6.582165355285465e-06, -8.896427624992034e-08,  1.202423968711994e-09, -1.625067882781833e-11,  2.195595048139580e-13, -2.962774741956939e-15,
  3.980990317978050e-17, -5.279648229340894e-19,  6.751020165743114e-21, -7.817204802436485e-23,  1.514485697856837e-01, -2.046976146408652e-03,  2.766688807585674e-05,
 -3.739444780857928e-07,  5.054156738794889e-09, -6.830620229695440e-11,  9.228438795892444e-13, -1.245142371671790e-14,  1.672237554660769e-16, -2.213998301417786e-18,
  2.815630572098537e-20, -3.201853870305275e-22,  3.802956253602924e-01, -5.140068826328768e-03,  6.947306412673547e-05, -9.389947032524434e-07,  1.269123123636963e-08,
 -1.715177686024802e-10,  2.317104205045672e-12, -3.125327827212444e-14,  4.192057100352111e-16, -5.525754229785836e-18,  6.925488152905919e-20, -7.480303028110952e-22,
  3.418179783424392e-02, -4.383002296737500e-04,  5.620157423152535e-06, -7.206511938174974e-08,  9.240608217992682e-10, -1.184864556184144e-11,  1.519146578923536e-13,
 -1.947017917344914e-15,  2.491950083995334e-17, -3.174921616374938e-19,  3.991248684852450e-21, -4.837737621329629e-23,  1.436767287195221e-01, -1.842312200588896e-03,
  2.362326977279000e-05, -3.029121048676674e-07,  3.884114173484055e-09, -4.980346412694855e-11,  6.385387989606353e-13, -8.183562017806221e-15,  1.047248376281543e-16,
 -1.333577295586611e-18,  1.673601380494410e-20, -2.017783157542391e-22,  3.607801082446750e-01, -4.626146494706203e-03,  5.931931951638772e-05, -7.606287803706181e-07,
  9.753217257561887e-09, -1.250587343029575e-10,  1.603370196587428e-12, -2.054712970056494e-14,  2.628467683394677e-16, -3.342712500287286e-18,  4.176547455789706e-20,
 -4.964972342720161e-22,  3.251337509626760e-02, -3.965635602741415e-04,  4.836860392873931e-06, -5.899487245724387e-08,  7.195561742982992e-10, -8.776337588441193e-12,
  1.070414573877248e-13, -1.305403484166453e-15,  1.591304460360864e-17, -1.936921175016804e-19,  2.346536989827653e-21, -2.804596060260652e-23,  1.366638289809127e-01,
 -1.666879996911085e-03,  2.033082875216312e-05, -2.479737982344914e-07,  3.024518271301492e-09, -3.688966341808813e-11,  4.499275531036706e-13, -5.486954605049201e-15,
  6.688405406139485e-17, -8.139818832406518e-19,  9.855987962941356e-21, -1.176017357872134e-22,  3.431703342128321e-01, -4.185626656775641e-03,  5.105182067743569e-05,
 -6.226757346113196e-07,  7.594729561958320e-09, -9.263187741508074e-11,  1.129786626975884e-12, -1.377766039278041e-14,  1.679283519007739e-16, -2.042915725851830e-18,
  2.470337390054536e-20, -2.934974700865103e-22,  3.100028680474814e-02, -3.605172026700784e-04,  4.192627444299053e-06, -4.875807442069033e-08,  5.670309393048522e-10,
 -6.594266999639773e-12,  7.668735402425679e-14, -8.918019545166109e-16,  1.036953604204572e-17, -1.205168032549422e-19,  1.398476915867615e-21, -1.614909458915004e-23,
  1.303038482379002e-01, -1.515365943532851e-03,  1.762291728505522e-05, -2.049453530132972e-07,  2.383407390643544e-09, -2.771775313505255e-11,  3.223406360860655e-13,
 -3.748510410315487e-15,  4.358579784565680e-17, -5.065407798583318e-19,  5.876966108996131e-21, -6.782933965051723e-23,  3.272000754151934e-01, -3.805166598726883e-03,
  4.425210722108636e-05, -5.146289667979795e-07,  5.984865904076469e-09, -6.960077763746830e-11,  8.094139278219515e-13, -9.412650043549785e-15,  1.094427351478163e-16,
 -1.271774485231624e-18,  1.474953696344044e-20, -1.700088971854485e-22,  2.962179971456907e-02, -3.291717514407301e-04,  3.657915554106868e-06, -4.064852496160640e-08,
  4.517060343402811e-10, -5.019574350026816e-12,  5.577983945478654e-14, -6.198467485764702e-16,  6.887734230166065e-18, -7.652586194528256e-20,  8.498156646606017e-22,
 -9.420961283526411e-24,  1.245096382124408e-01, -1.383611261858969e-03,  1.537535688698212e-05, -1.708583943081396e-07,  1.898660963666864e-09, -2.109883198574593e-11,
  2.344599880259543e-13, -2.605406911411424e-15,  2.895119008649400e-17, -3.216570874162746e-19,  3.571821653682784e-21, -3.959049353041028e-23,  3.126504977708685e-01,
 -3.474323401395713e-03,  3.860836038844200e-05, -4.290347540062929e-07,  4.767641291691064e-09, -5.298031657169039e-11,  5.887416621598880e-13, -6.542308317471275e-15,
  7.269742036157977e-17, -8.076687230635104e-19,  8.967709267306192e-21, -9.936017177385221e-23,  2.836071402726756e-02, -3.017438769340887e-04,  3.210404617274095e-06,
 -3.415710669631543e-08,  3.634146062395586e-10, -3.866550235426253e-12,  4.113815255644736e-14, -4.376884374889339e-16,  4.656732923030077e-18, -4.954278911948951e-20,
  5.270047809398839e-22, -5.602444760089155e-24,  1.192089028015702e-01, -1.268323373728027e-03,  1.349432921911820e-05, -1.435729441811612e-07,  1.527544631321120e-09,
 -1.625231328884603e-11,  1.729164468482850e-13, -1.839740353176002e-15,  1.957368040673657e-17, -2.082429278043983e-19,  2.215128137287554e-21, -2.354732695635523e-23,
  2.993400618194673e-01, -3.184829221443866e-03,  3.388499724185370e-05, -3.605194995728813e-07,  3.835747944629832e-09, -4.081044542557044e-11,  4.342026094923368e-13,
 -4.619686700309177e-15,  4.915048121928570e-17, -5.229044142693122e-19,  5.562085378579070e-21, -5.911957880726964e-23,  2.720264127112711e-02, -2.776068805040553e-04,
  2.833018284301761e-06, -2.891136049470159e-08,  2.950446063401184e-10, -3.010972752750400e-12,  3.072740862058646e-14, -3.135774615205449e-16,  3.200093724189458e-18,
 -3.265696817398959e-20,  3.332500351891455e-22, -3.399784278641517e-24,  1.143411627830660e-01, -1.166868069796716e-03,  1.190805707372236e-05, -1.215234411846342e-07,
  1.240164255470778e-09, -1.265605504840004e-11,  1.291568556036242e-13, -1.318063562341251e-15,  1.345098659777712e-17, -1.372672584817966e-19,  1.400747399704913e-21,
 -1.429010014464876e-23,  2.871169009328568e-01, -2.930069415448843e-03,  2.990178130006668e-05, -3.051519940303001e-07,  3.114120137837140e-09, -3.178004498573462e-11,
  3.243199099423879e-13, -3.309729266496246e-15,  3.377614544779264e-17, -3.446847672031194e-19,  3.517316479190417e-21, -3.588171863806664e-23,  2.613545235220620e-02,
 -2.562545577775556e-04,  2.512541106873221e-06, -2.463512402785576e-08,  2.415440424144671e-10, -2.368306496427569e-12,  2.322092278130291e-14, -2.276779607896260e-16,
  2.232349804340023e-18, -2.188780758874944e-20,  2.146036114127694e-22, -2.103827227020754e-24,  1.098554358022770e-01, -1.077117615628210e-03,  1.056099181093252e-05,
 -1.035490891700905e-07,  1.015284743758830e-09, -9.954728876733180e-12,  9.760476131603203e-14, -9.570012817571872e-16,  9.383260166264416e-18, -9.200124117038819e-20,
  9.020447168619000e-22, -8.842998635047588e-24,  2.758529956357022e-01, -2.704701126103630e-03,  2.651922689718042e-05, -2.600174150165233e-07,  2.549435409661386e-09,
 -2.499686756806938e-11,  2.450908826129185e-13, -2.403082409719033e-15,  2.356187584896155e-17, -2.310200065540563e-19,  2.265077527765384e-21, -2.220500544031753e-23,
  2.514885075156486e-02, -2.372744281964335e-04,  2.238637257506542e-06, -2.112109934796983e-08,  1.992733910525076e-10, -1.880104993855101e-12,  1.773841833421585e-14,
 -1.673584601424043e-16,  1.578993656919253e-18, -1.489747896409541e-20,  1.405541779517585e-22, -1.325960013949653e-24,  1.057084423873140e-01, -9.973382271325007e-04,
  9.409688732853771e-06, -8.877855038533207e-08,  8.376080475971083e-10, -7.902666105182331e-12,  7.456008986506731e-14, -7.034596644231275e-16,  6.637001422180253e-18,
 -6.261873438127050e-20,  5.907927643570428e-22, -5.573415559259544e-24,  2.654396688117295e-01, -2.504370726922171e-03,  2.362824202553777e-05, -2.229277858953816e-07,
  2.103279527399692e-09, -1.984402594686012e-11,  1.872244553193651e-13, -1.766425607647432e-15,  1.666587242726757e-17, -1.572390387897519e-19,  1.483511909802546e-21,
 -1.399511057034358e-23,  2.423403896473232e-02, -2.203276555361977e-04,  2.003144249488105e-06, -1.821190750878723e-08,  1.655764806700150e-10, -1.505365153799154e-12,
  1.368626893790309e-14, -1.244309102278102e-16,  1.131283547333324e-18, -1.028524365791870e-20,  9.350984258051974e-23, -8.500855309185838e-25,  1.018632038903777e-01,
 -9.261056702613296e-04,  8.419838368849368e-06, -7.655031216628621e-08,  6.959694516657173e-10, -6.327517992898398e-12,  5.752764552680888e-14, -5.230218203569311e-16,
  4.755136629457262e-18, -4.323207778614133e-20,  3.930509283112930e-22, -3.573172801437606e-24,  2.557840650578766e-01, -2.325501888469158e-03,  2.114267373164766e-05,
 -1.922220122627572e-07,  1.747617281844820e-09, -1.588874306043768e-11,  1.444550579825398e-13, -1.313336338325096e-15,  1.194040756407203e-17, -1.085581037092329e-19,
  9.869721798549820e-22, -8.972425481694121e-24,  2.338345524945335e-02, -2.051338140996146e-04,  1.799557902720064e-06, -1.578681047518092e-08,  1.384914509291344e-10,
 -1.214930780993569e-12,  1.065810772015317e-14, -9.349936786438282e-17,  8.202330046562062e-19, -7.195579685332089e-21,  6.312396016857631e-23, -5.537182743220015e-25,
  9.828793595665078e-02, -8.622412285813819e-04,  7.564101626810229e-06, -6.635687499522236e-08,  5.821226467283113e-10, -5.106731982935001e-12,  4.479934200616925e-14,
 -3.930069265581966e-16,  3.447694454407270e-18, -3.024525954585130e-20,  2.653296353308996e-22, -2.327449965520695e-24,  2.468063721242840e-01, -2.165134789441638e-03,
  1.899387206295384e-05, -1.666257351288587e-07,  1.461741740448474e-09, -1.282328275437198e-11,  1.124935930967595e-13, -9.868618442501771e-16,  8.657348953098249e-18,
 -7.594749708683520e-20,  6.662571723258288e-22, -5.844352873014148e-24,  2.259056397649931e-02, -1.914592087178910e-04,  1.622652211826775e-06, -1.375227766884732e-08,
  1.165530972703471e-10, -9.878090604598522e-13,  8.371864521318231e-15, -7.095310050113382e-17,  6.013406509968844e-19, -5.096473193800825e-21,  4.319355002567978e-23,
 -3.660469201888898e-25,  9.495516730354439e-02, -8.047626086061437e-04,  6.820511980566951e-06, -5.780510075838090e-08,  4.899089222635188e-10, -4.152068744165775e-12,
  3.518955069424785e-14, -2.982379517256110e-16,  2.527621805932608e-18, -2.142206210277543e-20,  1.815559256508429e-22, -1.538609037858280e-24,  2.384376081208817e-01,
 -2.020802837277584e-03,  1.712667787322721e-05, -1.451517632311136e-07,  1.230188044934617e-09, -1.042607125262662e-11,  8.836288257512402e-14, -7.488917757399432e-16,
  6.346996320466775e-18, -5.379196715497701e-20,  4.558968354346891e-22, -3.863531113816123e-24,  2.184968726617042e-02, -1.791078316541013e-04,  1.468195629943974e-06,
 -1.203519906348666e-08,  9.865580140928824e-11, -8.087084476424220e-13,  6.629203188665377e-15, -5.434138228920041e-17,  4.454510962820637e-19, -3.651483829316210e-21,
  2.993220587906706e-23, -2.453459307887042e-25,  9.184103203654691e-02, -7.528459288481091e-04,  6.171282922404777e-06, -5.058768527397907e-08,  4.146810207142003e-10,
 -3.399253158334479e-12,  2.786460304946269e-14, -2.284137329252666e-16,  1.872369517467178e-18, -1.534832234498749e-20,  1.258143717677219e-22, -1.031265258702588e-24,
  2.306178444838580e-01, -1.890437220591219e-03,  1.549642827073945e-05, -1.270284389952233e-07,  1.041286677913400e-09, -8.535710225011535e-12,  6.996953921534943e-14,
 -5.735593510792680e-16,  4.701622059301731e-18, -3.854047516608728e-20,  3.159267543335785e-22, -2.589563329330436e-24,  2.115586872542958e-02, -1.679142973217053e-04,
  1.332737105290841e-06, -1.057794494066236e-08,  8.395723261810466e-11, -6.663692190146596e-13,  5.288977759299125e-15, -4.197865828699597e-17,  3.331849426510930e-19,
 -2.644491522057401e-21,  2.098934995504062e-23, -1.665821393487607e-25,  8.892469689401200e-02, -7.057960222430176e-04,  5.601908608221643e-06, -4.446239290940997e-08,
  3.528983640199541e-10, -2.800957105067988e-12,  2.223121868588059e-14, -1.764493584562106e-16,  1.400479952833826e-18, -1.111562044943990e-20,  8.822476668869614e-23,
 -7.001965471992198e-25,  2.232947677560585e-01, -1.772292336939267e-03,  1.406669828916502e-05, -1.116474955255525e-07,  8.861470546168907e-10, -7.033356177938709e-12,
  5.582380358646146e-14, -4.430739703738887e-16,  3.516681605159077e-18, -2.791192968021100e-20,  2.215372047101777e-22, -1.758231745438604e-24  };
  constexpr double w[1152] = {  9.635330367414144e-02, -1.332486870619447e-02,  1.281086487731431e-03, -1.013035815763469e-04,  6.971267803053211e-06,
 -4.298124459409203e-07,  2.415656381799390e-08, -1.251888479818373e-09,  6.031044953007774e-11, -2.715334480561679e-12,  1.146501077150796e-13, -4.544520420286692e-15,
  1.936961199690184e-01, -4.863548349212126e-02,  7.398866872637872e-03, -8.360928406697557e-04,  7.636203905274582e-05, -5.897570271150017e-06,  3.961280281626444e-07,
 -2.358692555936739e-08,  1.262491758407869e-09, -6.139621658413616e-11,  2.735759301457305e-12, -1.123071727246165e-13,  1.235159348326596e-01, -4.468361826092352e-02,
  8.841514447963024e-03, -1.216638685837440e-03,  1.290346756337501e-04, -1.116631220938256e-05,  8.175346731491460e-07, -5.192641548102946e-08,  2.914406051322695e-09,
 -1.465937449950937e-10,  6.682467762170354e-12, -2.782148613419337e-13,  5.786858124018424e-02, -6.537700705758985e-03,  5.279105989746196e-04, -3.593595710959521e-05,
  2.167392093501490e-06, -1.188631895544573e-07,  6.020343949683899e-09, -2.840743863895548e-10,  1.258437970331878e-11, -5.264038227907921e-13,  2.085114800769086e-14,
 -7.829334734556685e-16,  7.467751610871433e-02, -1.526854807777769e-02,  2.016476277494254e-03, -2.040510799768944e-04,  1.704919616242237e-05, -1.224039745079699e-06,
  7.739408376448066e-08, -4.382420254854565e-09,  2.249122526973205e-10, -1.055780540383133e-11,  4.566528928003777e-13, -1.828533776021301e-14,  2.740005318743471e-02,
 -9.155731598587714e-03,  1.711385896802280e-03, -2.255038867947667e-04,  2.311831066687781e-05, -1.946796863129431e-06,  1.393848850318534e-07, -8.690030989166998e-09,
  4.801425444080680e-10, -2.382989550768508e-11,  1.073793968478896e-12, -4.425476823116377e-14,  3.807838146255339e-02, -3.590216790236514e-03,  2.459143739548514e-04,
 -1.448954385085303e-05,  7.682217571072909e-07, -3.739266807618144e-08,  1.703591851297575e-09, -7.304115129296587e-11,  2.954435221107107e-12, -1.138593822395155e-13,
  4.193752033801767e-15, -1.473079101685401e-16,  3.508239761193028e-02, -5.658910472743905e-03,  6.370620807614575e-04, -5.678817450312920e-05,  4.275135703264132e-06,
 -2.814273440874610e-07,  1.653508938397925e-08, -8.799882682392743e-10,  4.286423500609216e-11, -1.924870352376468e-12,  8.017003972091897e-14, -3.108896596074430e-15,
  7.101866414565621e-03, -2.090830111294170e-03,  3.602829186355986e-04, -4.467991358623088e-05,  4.372316393563992e-06, -3.549452057702764e-07,  2.467204553731046e-08,
 -1.501261334196842e-09,  8.128433160027278e-11, -3.965780901460759e-12,  1.761166446448723e-13, -7.168378994400313e-15,  2.678573821840961e-02, -2.154658693690962e-03,
  1.267818331022855e-04, -6.501686429171489e-06,  3.061035585199315e-07, -1.324610721609140e-08,  5.395683559253838e-10, -2.115564601622808e-11,  7.831806848077020e-13,
 -2.741877915255795e-14,  9.406440151841908e-16, -3.092308963001825e-17,  1.953804751126193e-02, -2.445663566634298e-03,  2.325087174528222e-04, -1.808715483049210e-05,
  1.211955736768787e-06, -7.237991166741244e-08,  3.911190393925013e-09, -1.933340950674075e-10,  8.842785341856264e-12, -3.765512707591390e-13,  1.496700289603883e-14,
 -5.575787543187813e-16,  2.271912231250450e-03, -5.485897197730111e-04,  8.458458782926586e-05, -9.656046889158218e-06,  8.868364105887260e-07, -6.854752296122715e-08,
  4.581487717256479e-09, -2.700082974406734e-10,  1.424095217872023e-11, -6.797178178435407e-13,  2.962716525358684e-14, -1.187007407404128e-15,  1.979722869657016e-02,
 -1.385614642955841e-03,  7.123540926225597e-05, -3.179831473129775e-06,  1.342317639481015e-07, -5.278946565789687e-09,  1.892168645690090e-10, -6.659083887133398e-12,
  2.371055231263278e-13, -7.545025901932384e-15,  2.178615665316140e-16, -7.345052258858316e-18,  1.245409680390952e-02, -1.208263255361639e-03,  9.663356447170246e-05,
 -6.569310296533795e-06,  3.886084663273178e-07, -2.083262720909316e-08,  1.031479540451897e-09, -4.704922611677066e-11,  1.991309113403405e-12, -7.968635929155106e-14,
  3.017364271792987e-15, -1.065930978309941e-16,  9.370899145574470e-04, -1.693664182371830e-04,  2.266487432856544e-05, -2.329599689601410e-06,  1.965103466876713e-07,
 -1.423263667619674e-08,  9.043960914636329e-10, -5.110575783430701e-11,  2.603546046790056e-12, -1.208949425688826e-13,  5.147255364576891e-15, -2.018822379129600e-16,
  1.519553429590217e-02, -9.385349265157081e-04,  4.313672613784147e-05, -1.680711273541946e-06,  6.250615679383152e-08, -2.321087463319769e-09,  7.732983000994595e-11,
 -2.198879590948723e-12,  6.939352879673417e-14, -2.686515057094692e-15,  7.299708221837483e-17, -7.725837226116206e-19,  8.784199247604950e-03, -6.695417032932354e-04,
  4.474326368700097e-05, -2.685371013746214e-06,  1.412031343959960e-07, -6.685095982628908e-09,  2.996132614947373e-10, -1.279139146122937e-11,  5.019640324714183e-13,
 -1.813938970104552e-14,  6.443246656670440e-16, -2.276557343096047e-17,  4.995068475656527e-04, -6.226052471727591e-05,  6.990109125550047e-06, -6.408079496512541e-07,
  4.865539364652528e-08, -3.223160280489185e-09,  1.921696578099436e-10, -1.034344343108658e-11,  5.027519932861632e-13, -2.240162323596084e-14,  9.303841922308566e-16,
 -3.582079974919274e-17,  1.202391543760122e-02, -6.600754926909302e-04,  2.771505602317896e-05, -9.685253718087838e-07,  3.064295173680979e-08, -1.023692595648229e-09,
  3.599770396367140e-11, -1.019791545005641e-12,  1.792626183426123e-14, -4.190021941391261e-16,  3.415339964141593e-17, -1.364057947221243e-18,  6.661253443980036e-03,
 -4.102035140702070e-04,  2.265964442658519e-05, -1.200460755597533e-06,  5.773688529978135e-08, -2.441838615111415e-09,  9.473860659141123e-11, -3.674221310577495e-12,
  1.429389255042801e-13, -4.985598849948539e-15,  1.452376407549226e-16, -4.187132569459744e-18,  3.274109493520857e-04, -2.751816967078491e-05,  2.448764179659541e-06,
 -2.007188391543025e-07,  1.382370109256684e-08, -8.173152230233112e-10,  4.404996158483408e-11, -2.240174155882577e-12,  1.055401947657027e-13, -4.464266492471573e-15,
  1.717301467170450e-16, -6.397915966452326e-18,  9.763492413213941e-03, -4.778042822891893e-04,  1.848692669770476e-05, -6.037388802379941e-07,  1.679663276215981e-08,
 -4.449302611246509e-10,  1.442905605747713e-11, -5.352051707284811e-13,  1.419485834941512e-14, -7.048491179923439e-17, -7.018895432170835e-18, -1.667280767567491e-19,
  5.309873036206537e-03, -2.738952374980476e-04,  1.250827958084792e-05, -5.712929345619581e-07,  2.539471826492723e-08, -1.018531555176361e-09,  3.532087243099178e-11,
 -1.113398552749617e-12,  3.763989234225206e-14, -1.453841614182272e-15,  5.119824102838678e-17, -1.223180277763626e-18,  2.453020949335442e-04, -1.475506413888630e-05,
  9.687301522259101e-07, -6.885361196358605e-08,  4.448303673200115e-09, -2.429596166770619e-10,  1.147811340297233e-11, -5.078018896163040e-13,  2.258502081603130e-14,
 -9.841976627312421e-16,  3.808751180374776e-17, -1.222439376822564e-18,  8.107867639462817e-03, -3.548954108992377e-04,  1.261002805591555e-05, -3.915870219421158e-07,
  1.039542066854352e-08, -2.313873539324753e-10,  5.050475957115191e-12, -1.709286689946691e-13,  7.551295566994906e-15, -2.330301277528064e-16,  1.433395240116266e-18,
  2.203634590359665e-19,  4.379039260901862e-03, -1.956370868017006e-04,  7.543446514069012e-06, -2.905348335174860e-07,  1.151776326172329e-08, -4.454592757296326e-10,
  1.540270983580866e-11, -4.452604507552959e-13,  1.089565243730396e-14, -2.925244921217163e-16,  1.196921772412525e-17, -5.250410562907071e-19,  1.978688415780071e-04,
 -9.391536906865933e-06,  4.472418723150473e-07, -2.528549973693818e-08,  1.506510433361430e-09, -8.082641277456763e-11,  3.653985349335053e-12, -1.402356311105967e-13,
  4.968448995768660e-15, -1.885497434247213e-16,  7.997733212511484e-18, -3.229428238167775e-19,  6.863860014916135e-03, -2.702991387068043e-04,  8.774094852495778e-06,
 -2.569249392346230e-07,  6.702931119214364e-09, -1.473152318288521e-10,  2.541514758033163e-12, -4.024761552515832e-14,  1.517076463362286e-15, -8.981958072797383e-17,
  3.577945127981906e-18, -6.429074171791171e-20,  3.698777260033242e-03, -1.466674816528790e-04,  4.923695346207492e-06, -1.610685760974220e-07,  5.466782760584294e-09,
 -1.933268283212946e-10,  6.688996075196663e-12, -2.062024503041246e-13,  5.144117617044500e-15, -9.409322332944134e-17,  1.385556666701916e-18, -5.434291704527555e-20,
  1.659856016794615e-04, -6.714975353089510e-06,  2.475199711738891e-07, -1.042374798413996e-08,  5.213479234718576e-10, -2.689890947127926e-11,  1.248119858832392e-12,
 -4.872956323006916e-14,  1.568414879848677e-15, -4.321422649212203e-17,  1.235367995690919e-18, -4.822248773985520e-20,  5.905826544028787e-03, -2.108195750448842e-04,
  6.247108778355140e-06, -1.702485494458674e-07,  4.294098287912360e-09, -9.650565464326980e-11,  1.770110728525525e-12, -2.185026750944100e-14,  1.199746862627863e-16,
 -6.836034051536469e-18,  7.878949229345199e-19, -4.122679564061814e-20,  3.180418032487228e-03, -1.137679495385615e-04,  3.411702970647245e-06, -9.747523103626406e-08,
  2.821938956015247e-09, -8.629366528487193e-11,  2.771001394971518e-12, -8.760603263134211e-14,  2.484078992552457e-15, -5.649319124404287e-17,  8.320308625836694e-19,
 -1.185058410738534e-21,  1.424510470496117e-04, -5.125605356109324e-06,  1.589466179688049e-07, -5.136021288347291e-09,  1.966006497142539e-10, -8.818299574130610e-12,
  4.033470389365894e-13, -1.669063258962149e-14,  5.853526154014483e-16, -1.667333290385375e-17,  3.713088308142549e-19, -6.700858761114194e-21,  5.151036293965849e-03,
 -1.679793389080536e-04,  4.559590099660223e-06, -1.148772244181208e-07,  2.741091858402828e-09, -6.101147926172720e-11,  1.202385340221841e-12, -1.851135212637622e-14,
  1.377734220869228e-16,  2.476534632655956e-18, -5.318247196727276e-20, -4.249931137499995e-21,  2.773461271035668e-03, -9.049682100542065e-05,  2.465719401035748e-06,
 -6.321206561060551e-08,  1.601682792484600e-09, -4.189800956687803e-11,  1.169533325403362e-12, -3.450287358999935e-14,  1.011371841175103e-15, -2.698647319084177e-17,
  5.881945308066699e-19, -8.298023648022392e-21,  1.241627577751393e-04, -4.057728797231932e-06,  1.117155380922882e-07, -3.002385174150097e-09,  8.810199732060321e-11,
 -3.093910369643046e-12,  1.255974846009011e-13, -5.177735419906804e-15,  1.951465961574691e-16, -6.327150481136073e-18,  1.679785246051327e-19, -3.372813693067614e-21,
  4.544283835163810e-03, -1.363545341575612e-04,  3.408561509465872e-06, -7.938007914137640e-08,  1.770304637662335e-09, -3.781318365676622e-11,  7.551894303503783e-13,
 -1.324890180566427e-14,  1.727362188546378e-16, -4.735006488911232e-19, -5.505499501642186e-20,  1.582430142527299e-21,  2.446663232439293e-03, -7.342476288224680e-05,
  1.837462347492192e-06, -4.303646438681240e-08,  9.817839273655013e-10, -2.251791956106662e-11,  5.387855345100207e-13, -1.384303632601998e-14,  3.780532320860573e-16,
 -1.036635295509528e-17,  2.636041293745017e-19, -5.654699723710343e-21,  1.095198347383169e-04, -3.287995195698355e-06,  8.252406501081558e-08, -1.962889235899862e-09,
  4.752542107735758e-11, -1.284292900911932e-12,  4.153764810458348e-14, -1.536602390502718e-15,  5.775262142690938e-17, -2.009176055058662e-18,  6.123459593925014e-20,
 -1.561539170254453e-21,  4.047981164944980e-03, -1.124664227352946e-04,  2.603864753265880e-06, -5.623576430589220e-08,  1.168354326810543e-09, -2.354336438478399e-11,
  4.567626454923279e-13, -8.291745712341590e-15,  1.313219176328405e-16, -1.472894343272646e-18, -2.004845832955715e-21,  6.880274412734558e-22,  2.179429741642782e-03,
 -6.055399959693370e-05,  1.402380794832835e-06, -3.033919206323692e-08,  6.351697586411636e-10, -1.315411922336832e-11,  2.764765283286726e-13, -6.099177595101458e-15,
  1.450413548117599e-16, -3.684706728892065e-18,  9.497757395511944e-20, -2.312550384990051e-21,  9.755510538501174e-05, -2.710754560091829e-06,  6.282715308853409e-08,
 -1.365388956954880e-09,  2.917138150552801e-11, -6.476739219236117e-13,  1.622017816864053e-14, -4.842250921397412e-16,  1.641149593676875e-17, -5.669254721284300e-19,
  1.835624709647901e-20, -5.299034033233650e-22,  3.635909294611858e-03, -9.404930461263920e-05,  2.027391861202860e-06, -4.078443226203643e-08,  7.905524822091403e-10,
 -1.494060055478923e-11,  2.756106317195237e-13, -4.909415340963142e-15,  8.188115103043757e-17, -1.186407155958243e-18,  1.172128280437379e-20,  5.126577302153634e-23,
  1.957566240808538e-03, -5.063637494535634e-05,  1.091633996007568e-06, -2.197058473068813e-08,  4.268808223408217e-10, -8.144135417799697e-12,  1.549907439092413e-13,
 -3.010178715105275e-15,  6.156779181879604e-17, -1.360408488078913e-18,  3.225095097455810e-20, -7.830498557236419e-22,  8.762360543234891e-05, -2.266607695116059e-06,
  4.887352053098485e-08, -9.848652363562117e-10,  1.925453486806322e-11, -3.764880197870435e-13,  7.738958014650454e-15, -1.801880944012554e-16,  4.973486710726825e-18,
 -1.551071272112263e-19,  4.953912968713757e-21, -1.499812580020055e-22,  3.289327042478658e-03, -7.959337899783157e-05,  1.605059176538542e-06, -3.020857649265944e-08,
  5.481270840948154e-10, -9.715629780537602e-12,  1.690580664063961e-13, -2.881932140323816e-15,  4.753817543994999e-17, -7.351287335137507e-19,  9.867488262990194e-21,
 -8.851103327078883e-23,  1.770966219778036e-03, -4.285297324873424e-05,  8.641773205342659e-07, -1.626660054901658e-08,  2.953551267766968e-10, -5.250921081102281e-12,
  9.237515467397896e-14, -1.629110502951402e-15,  2.941411653128078e-17, -5.601174957663584e-19,  1.153307999918943e-20, -2.555572463240936e-22,  7.927101402398876e-05,
 -1.918169922887447e-06,  3.868375090475917e-08, -7.283858100294625e-10,  1.324861896474707e-11, -2.373692856611118e-13,  4.294559909048295e-15, -8.220474096229031e-17,
  1.782796721793523e-18, -4.556556720078182e-20,  1.312290454692827e-21, -3.889724969563663e-23,  2.994531284047931e-03, -6.806728684913140e-05,  1.289410091991597e-06,
 -2.279722349109196e-08,  3.886461280296032e-10, -6.476589250571686e-12,  1.061807265186269e-13, -1.715719253084542e-15,  2.722573566461749e-17, -4.188104327683806e-19,
  6.052169471618356e-21, -7.611813273703109e-23,  1.612248696115050e-03, -3.664728368442579e-05,  6.942185560406019e-07, -1.227441540033399e-08,  2.092926168227703e-10,
 -3.490851560803985e-12,  5.743422171932868e-14, -9.393450998089691e-16,  1.544788544161110e-17, -2.605133683252620e-19,  4.634023456813737e-21, -8.907845610357791e-23,
  7.216657039370192e-05, -1.640386700361631e-06,  3.107456973647568e-08, -5.494699070624231e-10,  9.373467154476581e-12, -1.566959389723127e-13,  2.601546055071015e-15,
 -4.386656382934262e-17,  7.849383273981420e-19, -1.587802247858589e-20,  3.763193727738700e-22, -1.003076652751221e-23,  2.741297412342577e-03, -5.874958041770897e-05,
  1.049286672769377e-06, -1.749140573602891e-08,  2.811617337891505e-10, -4.418698102706483e-12,  6.836899724317593e-14, -1.045006575013723e-15,  1.578290745358463e-17,
 -2.345151368996847e-19,  3.384159320683114e-21, -4.600311892249945e-23,  1.475908138653470e-03, -3.163063976160918e-05,  5.649340681916715e-07, -9.417412900326191e-09,
  1.513854012607713e-10, -2.379742186746111e-12,  3.686051433609957e-14, -5.656557068921931e-16,  8.653809679046965e-18, -1.333633650263437e-19,  2.108694796797470e-21,
 -3.512441451257285e-23,  6.606376784603832e-05, -1.415833139167517e-06,  2.528732219986097e-08, -4.215458006042088e-10,  6.777177805554364e-12, -1.066017170392013e-13,
  1.655661446561698e-15, -2.566477396929670e-17,  4.054061959831741e-19, -6.800688917422498e-21,  1.284681265161705e-22, -2.825556701125574e-24,  2.521858115633583e-03,
 -5.112458126032953e-05,  8.637288684005729e-07, -1.361966966526002e-08,  2.070912133837761e-10, -3.078850231186710e-12,  4.507581887604247e-14, -6.524392992816588e-16,
  9.353387051702480e-18, -1.327328521020350e-19,  1.855881557795780e-21, -2.524540915578817e-23,  1.357762527594670e-03, -2.752535576201895e-05,  4.650297088242066e-07,
 -7.332812812780794e-09,  1.114989751589583e-10, -1.657778358801528e-12,  2.427812668295307e-14, -3.518408894618716e-16,  5.065733451509184e-18, -7.284678624127200e-20,
  1.056284393354453e-21, -1.570624279087452e-23,  6.077540007715506e-05, -1.232074490499490e-06,  2.081540824130163e-08, -3.282287929022625e-10,  4.991023228738039e-12,
 -7.421911871494939e-14,  1.087767490322665e-15, -1.581260292698576e-17,  2.301296367216463e-19, -3.418979296694296e-21,  5.389227519933949e-23, -9.514212925048529e-25,
  2.330218156780053e-03, -4.481649216472554e-05,  7.183163275699401e-07, -1.074570205852723e-08,  1.550104389431819e-10, -2.186380441406592e-12,  3.037028416655041e-14,
 -4.171821110509962e-16,  5.680635347897459e-18, -7.674949892925511e-20,  1.027813895584856e-21, -1.357751268630327e-23,  1.254584019828856e-03, -2.412909491468051e-05,
  3.867398526159304e-07, -5.785463451945735e-09,  8.345753291835039e-11, -1.177165844324494e-12,  1.635299292452132e-14, -2.247141487551463e-16,  3.063994608395856e-18,
 -4.158286376880931e-20,  5.643334177806746e-22, -7.724137627061338e-24,  5.615698184087540e-05, -1.080052937019524e-06,  1.731103287954402e-08, -2.589659208449627e-10,
  3.735708530767804e-12, -5.269420564319024e-14,  7.321695014813152e-16, -1.007001264476278e-17,  1.377658283573603e-19, -1.890596466032501e-21,  2.650282212154287e-23,
 -3.932283629944628e-25,  2.161684020240591e-03, -3.954667672722230e-05,  6.029241497501410e-07, -8.579385192357467e-09,  1.177218026429902e-10, -1.579421369780147e-12,
  2.086920579498828e-14, -2.727103968637621e-16,  3.533550023570210e-18, -4.546690146067266e-20,  5.812267200413736e-22, -7.371416615457045e-24,  1.163845633707611e-03,
 -2.129183850853865e-05,  3.246129587174616e-07, -4.619121410248247e-09,  6.338119163445264e-11, -8.503609452251303e-13,  1.123623366876617e-14, -1.468453317701432e-16,
  1.903462350249987e-18, -2.452724835355384e-20,  3.149741296628304e-22, -4.047173615846986e-24,  5.209540139544761e-05, -9.530532598596526e-07,  1.453014236643632e-08,
 -2.067585518664489e-10,  2.837038212110734e-12, -3.806382301235191e-14,  5.029825197991395e-16, -6.575037828857050e-18,  8.531192850107566e-20, -1.103167524403730e-21,
  1.432610540980389e-23, -1.899723095794847e-25,  2.012534314502729e-03, -3.510530962324887e-05,  5.103119742445323e-07, -6.923714558706761e-09,  9.058363203930167e-11,
 -1.158780178821974e-12,  1.459894395016137e-14, -1.819028591885563e-16,  2.247545068826536e-18, -2.758510586020754e-20,  3.366433884675016e-22, -4.084992071178017e-24,
  1.083543780049502e-03, -1.890061680906118e-05,  2.747507769744217e-07, -3.727711840952887e-09,  4.877002435364956e-11, -6.238852645312270e-13,  7.860089984109063e-15,
 -9.793936231841568e-17,  1.210251975714996e-18, -1.486037440348755e-20,  1.816194705422319e-22, -2.213799494542050e-24,  4.850097514066577e-05, -8.460187425107259e-07,
  1.229823926513501e-08, -1.668577413410688e-10,  2.183017167565350e-12, -2.792607639173948e-14,  3.518345229555828e-16, -4.384259145629767e-18,  5.419194111088833e-20,
 -6.661089148093068e-22,  8.170256663069812e-24, -1.006896308694794e-25,  1.879784473189537e-03, -3.133215908563811e-05,  4.352158956365236e-07, -5.642340653958540e-09,
  7.053764006843229e-11, -8.622304337994410e-13,  1.037995284999124e-14, -1.235855825288373e-16,  1.459156679941530e-18, -1.711481206948071e-20,  1.996615663399131e-22,
 -2.317922041897181e-24,  1.012071575163455e-03, -1.686916135974448e-05,  2.343192230143447e-07, -3.037823058007308e-09,  3.797730224455406e-11, -4.642229766763632e-13,
  5.588551429764523e-15, -6.653875804868031e-17,  7.856377843808147e-19, -9.216093230372373e-21,  1.075634463777700e-22, -1.250565160252946e-24,  4.530177664333838e-05,
 -7.550878800199928e-07,  1.048846482167687e-08, -1.359773225025634e-10,  1.699918713660917e-12, -2.077929975122507e-14,  2.501525382256399e-16, -2.978430693427622e-18,
  3.516960888871060e-20, -4.126886395763802e-22,  4.821843830607356e-24, -5.626038545413954e-26,  1.761015935915258e-03, -2.810330616452269e-05,  3.737511929883830e-07,
 -4.639248218023239e-09,  5.552896675474394e-11, -6.498787628289676e-13,  7.490569253004755e-15, -8.538830565838673e-17,  9.652653423137563e-19, -1.084033539531461e-20,
  1.210961101235576e-22, -1.346556428299750e-24,  9.481268717600574e-04, -1.513075447902975e-05,  2.012267704239392e-07, -2.497760420119088e-09,  2.989666639279622e-11,
 -3.498932304665517e-13,  4.032906540472476e-15, -4.597296154648323e-17,  5.197019749730735e-19, -5.836674340898441e-21,  6.520942205457968e-23, -7.254419795141588e-25,
  4.243951991933752e-05, -6.772742923331981e-07,  9.007199128555107e-09, -1.118033424259986e-10,  1.338217731643347e-12, -1.566172545209363e-14,  1.805188463646103e-16,
 -2.057825951538735e-18,  2.326317345827319e-20, -2.612858661338222e-22,  2.920102416151257e-24, -3.252119269030846e-26,  1.654250243551006e-03, -2.532180480758941e-05,
  3.230116359528281e-07, -3.845752061191408e-09,  4.415208925502800e-11, -4.956349952191087e-13,  5.479518535077919e-15, -5.991341813220172e-17,  6.496379034762270e-19,
 -6.997930464083897e-21,  7.498447056974772e-23, -7.998767515059464e-25,  8.906444720563795e-04, -1.363320063715102e-05,  1.739087112706209e-07, -2.070543938631645e-09,
  2.377138189417870e-11, -2.668487286251222e-13,  2.950160252282703e-15, -3.225726087985644e-17,  3.497644412586613e-19, -3.767714343993603e-21,  4.037345274958997e-23,
 -4.307314383491836e-25,  3.986652518634502e-05, -6.102416324636265e-07,  7.784403581595347e-09, -9.268051921942369e-11,  1.064041183927166e-12, -1.194453253787942e-14,
  1.320534347051624e-16, -1.443883006996734e-18,  1.565605372798584e-20, -1.686530269068185e-22,  1.807383990376519e-24, -1.928862751977259e-26,  1.557854949706525e-03,
 -2.291100806320912e-05,  2.807957753271356e-07, -3.212005843679902e-09,  3.542981304407345e-11, -3.821220322866133e-13,  4.058868805955045e-15, -4.263921870819041e-17,
  4.442006915497238e-19, -4.597281945352651e-21,  4.732928831884473e-23, -4.850925605421376e-25,  8.387454707235606e-04, -1.233523329392781e-05,  1.511797903899157e-07,
 -1.729336453254758e-09,  1.907532869774190e-11, -2.057336113245635e-13,  2.185285538827309e-15, -2.295685859953739e-17,  2.391567683638679e-19, -2.475173441714267e-21,
  2.548231583765984e-23, -2.611863185583202e-25,  3.754345138001955e-05, -5.521427508066383e-07,  6.767024452937692e-09, -7.740758230410037e-11,  8.538390978624687e-13,
 -9.208931853783263e-15,  9.781652229227393e-17, -1.027582228899924e-18,  1.070501609733742e-20, -1.107931056833618e-22,  1.140660386731922e-24, -1.169250793973751e-26,
  1.470472417681620e-03, -2.080972957505943e-05,  2.454168677798612e-07, -2.701354460557678e-09,  2.867249190837762e-11, -2.975705511300654e-13,  3.041474338135781e-15,
 -3.074536478286019e-17,  3.082059060080806e-19, -3.069406562544088e-21,  3.040715430964967e-23, -2.998954224899314e-25,  7.916989193292489e-04, -1.120390985781547e-05,
  1.321318690988474e-07, -1.454402939793901e-09,  1.543720275666494e-11, -1.602112906412847e-13,  1.637522695369043e-15, -1.655323312310826e-17,  1.659373660223207e-19,
 -1.652562593215217e-21,  1.637119748903272e-23, -1.614652924141756e-25,  3.543758019916360e-05, -5.015030896681529e-07,  5.914412150552995e-09, -6.510116353983980e-11,
  6.909913572768108e-13, -7.171287379235934e-15,  7.329786739639313e-17, -7.409465245028562e-19,  7.427597323009849e-21, -7.397120449424560e-23,  7.328041762952300e-25,
 -7.227657917933875e-27,  1.390965311011047e-03, -1.896868864501389e-05,  2.155688699229070e-07, -2.286513670843171e-09,  2.338665935861497e-11, -2.338854412473310e-13,
  2.303604219797023e-15, -2.243953321343632e-17,  2.167632179094533e-19, -2.080221457998906e-21,  1.985828391006884e-23, -1.887341766987864e-25,  7.488924785737465e-04,
 -1.021269771589967e-05,  1.160617766826815e-07, -1.231053626353811e-09,  1.259132284192657e-11, -1.259233759693208e-13,  1.240255139166446e-15, -1.208139240769746e-17,
  1.167048149875227e-19, -1.119986587934714e-21,  1.069166310227943e-23, -1.016144232736974e-25,  3.352150245764146e-05, -4.571350112030417e-07,  5.195091743633185e-09,
 -5.510372762724047e-11,  5.636056866358742e-13, -5.636511086610247e-15,  5.551560066491915e-17, -5.407804757718803e-19,  5.223875484566213e-21, -5.013222887724002e-23,
  4.785751556998229e-25, -4.548447091515496e-27,  1.318374418437190e-03, -1.734786616645260e-05,  1.902306396228331e-07, -1.946945249785142e-09,  1.921469866265593e-11,
 -1.854188988432933e-13,  1.762154880337735e-15, -1.656286349647745e-17,  1.543805493790696e-19, -1.429558602523454e-21,  1.316799254048923e-23, -1.207582539270890e-25,
  7.098097113536197e-04, -9.340050674532714e-06,  1.024197325986969e-07, -1.048230780607668e-09,  1.034514893552668e-11, -9.982910259031471e-14,  9.487400769615325e-16,
 -8.917407080105279e-18,  8.311812831538619e-20, -7.696710506120548e-22,  7.089618002873700e-24, -6.501602535103997e-26,  3.177210168930152e-05, -4.180740768516252e-07,
  4.584454265793812e-09, -4.692031458942263e-11,  4.630637179443213e-13, -4.468493947727915e-15,  4.246696788281828e-17, -3.991559440124543e-19,  3.720486816884181e-21,
 -3.445158463362681e-23,  3.173416371870746e-25, -2.910217121557613e-27,  1.251885700928588e-03, -1.591451567522209e-05,  1.685965666493145e-07, -1.667027455353440e-09,
  1.589436901031945e-11, -1.481782233191433e-13,  1.360489263397040e-15, -1.235398616747220e-17,  1.112461297021216e-19, -9.952104588984123e-22,  8.856317841065548e-24,
 -7.846456704822246e-26,  6.740123409533372e-04, -8.568338113805889e-06,  9.077199817819653e-08, -8.975236930838594e-10,  8.557491196425048e-12, -7.977880976197506e-14,
  7.324842456625974e-16, -6.651357334812388e-18,  5.989465682253481e-20, -5.358189949132497e-22,  4.768221115463523e-24, -4.224515017147350e-26,  3.016975999916261e-05,
 -3.835311147560992e-07,  4.063084951541304e-09, -4.017444899540679e-11,  3.830455911626182e-13, -3.571014056150667e-15,  3.278704639965474e-17, -2.977243032451170e-19,
  2.680970835635923e-21, -2.398402799591389e-23,  2.134324478749741e-25, -1.890954622479410e-27,  1.190804309536561e-03, -1.464165145225641e-05,  1.500257408802677e-07,
 -1.434762762857800e-09,  1.323125000770626e-11, -1.193059716496055e-13,  1.059480866491622e-15, -9.305191203111943e-18,  8.104445143278272e-20, -7.012509945165965e-22,
  6.035759646091844e-24, -5.172192768493040e-26,  6.411262623198889e-04, -7.883030985526940e-06,  8.077350890657405e-08, -7.724729244763807e-10,  7.123674137997438e-12,
 -6.423405681660200e-14,  5.704220269433350e-16, -5.009893236702367e-18,  4.363414360646033e-20, -3.775519004360259e-22,  3.249638953432409e-24, -2.784696687856792e-26,
  2.869773190798347e-05, -3.528557838613452e-07,  3.615538217823635e-09, -3.457699706854109e-11,  3.188658812265688e-13, -2.875208598098474e-15,  2.553290882936373e-17,
 -2.242500135522954e-19,  1.953126911133043e-21, -1.689976516937550e-23,  1.454585088469768e-25, -1.246470384428226e-27,  1.134533926117340e-03, -1.350688802636142e-05,
  1.340042910576610e-07, -1.240853751348137e-09,  1.107972311300716e-11, -9.673368257990657e-14,  8.317564012679866e-16, -7.073198102387253e-18,  5.964874193865729e-20,
 -4.997340814504508e-22,  4.164711210736109e-24, -3.455549421821926e-26,  6.108304191557733e-04, -7.272077004226259e-06,  7.214759769727460e-08, -6.680727650347985e-10,
  5.965297077020351e-12, -5.208118903855980e-14,  4.478157061037076e-16, -3.808193357860442e-18,  3.211474351262570e-20, -2.690556638029095e-22,  2.242270806786319e-24,
 -1.860459774382405e-26,  2.734164647497666e-05, -3.255086065673756e-07,  3.229430048660795e-09, -2.990389605414107e-11,  2.670152610008024e-13, -2.331228789583521e-15,
  2.004487389347175e-17, -1.704602017787610e-19,  1.437502024111518e-21, -1.204331778463877e-23,  1.003672609854751e-25, -8.327685310446617e-28  };
  int offset = -3;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 3;
    if (std::isnan(t)) {
      fill_n(rr+offset, 3, 0.5);
      fill_n(ww+offset, 3, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 3; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=3; ++j) {
        const int boxof = it*36+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
