;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; Similar to reorder-globals, but this runs the "real" version, without
;; "-always". That is, this tests the production code. The downside is we need
;; 128+ globals to see any changes here, so we keep most testing in the other
;; file.

;; RUN: foreach %s %t wasm-opt -all --reorder-globals -S -o - | filecheck %s

;; A situation where the simple greedy sort fails to be optimal. We have 129
;; globals, enough for the LEB size to grow by 1 for the last. One global,
;; |other|, is independent of the rest. The second is in a chain with all the
;; others:
;;
;;  global1 <- global2 <- .. <- global128
;;
;; other has a higher count than global1, so if we are greedy we pick it. But
;; global128 has the highest count by far, so it is actually worth emitting the
;; entire chain first, and only then other, which is the original order.
(module
  ;; CHECK:      (global $global1 i32 (i32.const 1))
  (global $global1 i32 (i32.const 1))
  ;; CHECK:      (global $global2 i32 (global.get $global1))
  (global $global2 i32 (global.get $global1))
  ;; CHECK:      (global $global3 i32 (global.get $global2))
  (global $global3 i32 (global.get $global2))
  ;; CHECK:      (global $global4 i32 (global.get $global3))
  (global $global4 i32 (global.get $global3))
  ;; CHECK:      (global $global5 i32 (global.get $global4))
  (global $global5 i32 (global.get $global4))
  ;; CHECK:      (global $global6 i32 (global.get $global5))
  (global $global6 i32 (global.get $global5))
  ;; CHECK:      (global $global7 i32 (global.get $global6))
  (global $global7 i32 (global.get $global6))
  ;; CHECK:      (global $global8 i32 (global.get $global7))
  (global $global8 i32 (global.get $global7))
  ;; CHECK:      (global $global9 i32 (global.get $global8))
  (global $global9 i32 (global.get $global8))
  ;; CHECK:      (global $global10 i32 (global.get $global9))
  (global $global10 i32 (global.get $global9))
  ;; CHECK:      (global $global11 i32 (global.get $global10))
  (global $global11 i32 (global.get $global10))
  ;; CHECK:      (global $global12 i32 (global.get $global11))
  (global $global12 i32 (global.get $global11))
  ;; CHECK:      (global $global13 i32 (global.get $global12))
  (global $global13 i32 (global.get $global12))
  ;; CHECK:      (global $global14 i32 (global.get $global13))
  (global $global14 i32 (global.get $global13))
  ;; CHECK:      (global $global15 i32 (global.get $global14))
  (global $global15 i32 (global.get $global14))
  ;; CHECK:      (global $global16 i32 (global.get $global15))
  (global $global16 i32 (global.get $global15))
  ;; CHECK:      (global $global17 i32 (global.get $global16))
  (global $global17 i32 (global.get $global16))
  ;; CHECK:      (global $global18 i32 (global.get $global17))
  (global $global18 i32 (global.get $global17))
  ;; CHECK:      (global $global19 i32 (global.get $global18))
  (global $global19 i32 (global.get $global18))
  ;; CHECK:      (global $global20 i32 (global.get $global19))
  (global $global20 i32 (global.get $global19))
  ;; CHECK:      (global $global21 i32 (global.get $global20))
  (global $global21 i32 (global.get $global20))
  ;; CHECK:      (global $global22 i32 (global.get $global21))
  (global $global22 i32 (global.get $global21))
  ;; CHECK:      (global $global23 i32 (global.get $global22))
  (global $global23 i32 (global.get $global22))
  ;; CHECK:      (global $global24 i32 (global.get $global23))
  (global $global24 i32 (global.get $global23))
  ;; CHECK:      (global $global25 i32 (global.get $global24))
  (global $global25 i32 (global.get $global24))
  ;; CHECK:      (global $global26 i32 (global.get $global25))
  (global $global26 i32 (global.get $global25))
  ;; CHECK:      (global $global27 i32 (global.get $global26))
  (global $global27 i32 (global.get $global26))
  ;; CHECK:      (global $global28 i32 (global.get $global27))
  (global $global28 i32 (global.get $global27))
  ;; CHECK:      (global $global29 i32 (global.get $global28))
  (global $global29 i32 (global.get $global28))
  ;; CHECK:      (global $global30 i32 (global.get $global29))
  (global $global30 i32 (global.get $global29))
  ;; CHECK:      (global $global31 i32 (global.get $global30))
  (global $global31 i32 (global.get $global30))
  ;; CHECK:      (global $global32 i32 (global.get $global31))
  (global $global32 i32 (global.get $global31))
  ;; CHECK:      (global $global33 i32 (global.get $global32))
  (global $global33 i32 (global.get $global32))
  ;; CHECK:      (global $global34 i32 (global.get $global33))
  (global $global34 i32 (global.get $global33))
  ;; CHECK:      (global $global35 i32 (global.get $global34))
  (global $global35 i32 (global.get $global34))
  ;; CHECK:      (global $global36 i32 (global.get $global35))
  (global $global36 i32 (global.get $global35))
  ;; CHECK:      (global $global37 i32 (global.get $global36))
  (global $global37 i32 (global.get $global36))
  ;; CHECK:      (global $global38 i32 (global.get $global37))
  (global $global38 i32 (global.get $global37))
  ;; CHECK:      (global $global39 i32 (global.get $global38))
  (global $global39 i32 (global.get $global38))
  ;; CHECK:      (global $global40 i32 (global.get $global39))
  (global $global40 i32 (global.get $global39))
  ;; CHECK:      (global $global41 i32 (global.get $global40))
  (global $global41 i32 (global.get $global40))
  ;; CHECK:      (global $global42 i32 (global.get $global41))
  (global $global42 i32 (global.get $global41))
  ;; CHECK:      (global $global43 i32 (global.get $global42))
  (global $global43 i32 (global.get $global42))
  ;; CHECK:      (global $global44 i32 (global.get $global43))
  (global $global44 i32 (global.get $global43))
  ;; CHECK:      (global $global45 i32 (global.get $global44))
  (global $global45 i32 (global.get $global44))
  ;; CHECK:      (global $global46 i32 (global.get $global45))
  (global $global46 i32 (global.get $global45))
  ;; CHECK:      (global $global47 i32 (global.get $global46))
  (global $global47 i32 (global.get $global46))
  ;; CHECK:      (global $global48 i32 (global.get $global47))
  (global $global48 i32 (global.get $global47))
  ;; CHECK:      (global $global49 i32 (global.get $global48))
  (global $global49 i32 (global.get $global48))
  ;; CHECK:      (global $global50 i32 (global.get $global49))
  (global $global50 i32 (global.get $global49))
  ;; CHECK:      (global $global51 i32 (global.get $global50))
  (global $global51 i32 (global.get $global50))
  ;; CHECK:      (global $global52 i32 (global.get $global51))
  (global $global52 i32 (global.get $global51))
  ;; CHECK:      (global $global53 i32 (global.get $global52))
  (global $global53 i32 (global.get $global52))
  ;; CHECK:      (global $global54 i32 (global.get $global53))
  (global $global54 i32 (global.get $global53))
  ;; CHECK:      (global $global55 i32 (global.get $global54))
  (global $global55 i32 (global.get $global54))
  ;; CHECK:      (global $global56 i32 (global.get $global55))
  (global $global56 i32 (global.get $global55))
  ;; CHECK:      (global $global57 i32 (global.get $global56))
  (global $global57 i32 (global.get $global56))
  ;; CHECK:      (global $global58 i32 (global.get $global57))
  (global $global58 i32 (global.get $global57))
  ;; CHECK:      (global $global59 i32 (global.get $global58))
  (global $global59 i32 (global.get $global58))
  ;; CHECK:      (global $global60 i32 (global.get $global59))
  (global $global60 i32 (global.get $global59))
  ;; CHECK:      (global $global61 i32 (global.get $global60))
  (global $global61 i32 (global.get $global60))
  ;; CHECK:      (global $global62 i32 (global.get $global61))
  (global $global62 i32 (global.get $global61))
  ;; CHECK:      (global $global63 i32 (global.get $global62))
  (global $global63 i32 (global.get $global62))
  ;; CHECK:      (global $global64 i32 (global.get $global63))
  (global $global64 i32 (global.get $global63))
  ;; CHECK:      (global $global65 i32 (global.get $global64))
  (global $global65 i32 (global.get $global64))
  ;; CHECK:      (global $global66 i32 (global.get $global65))
  (global $global66 i32 (global.get $global65))
  ;; CHECK:      (global $global67 i32 (global.get $global66))
  (global $global67 i32 (global.get $global66))
  ;; CHECK:      (global $global68 i32 (global.get $global67))
  (global $global68 i32 (global.get $global67))
  ;; CHECK:      (global $global69 i32 (global.get $global68))
  (global $global69 i32 (global.get $global68))
  ;; CHECK:      (global $global70 i32 (global.get $global69))
  (global $global70 i32 (global.get $global69))
  ;; CHECK:      (global $global71 i32 (global.get $global70))
  (global $global71 i32 (global.get $global70))
  ;; CHECK:      (global $global72 i32 (global.get $global71))
  (global $global72 i32 (global.get $global71))
  ;; CHECK:      (global $global73 i32 (global.get $global72))
  (global $global73 i32 (global.get $global72))
  ;; CHECK:      (global $global74 i32 (global.get $global73))
  (global $global74 i32 (global.get $global73))
  ;; CHECK:      (global $global75 i32 (global.get $global74))
  (global $global75 i32 (global.get $global74))
  ;; CHECK:      (global $global76 i32 (global.get $global75))
  (global $global76 i32 (global.get $global75))
  ;; CHECK:      (global $global77 i32 (global.get $global76))
  (global $global77 i32 (global.get $global76))
  ;; CHECK:      (global $global78 i32 (global.get $global77))
  (global $global78 i32 (global.get $global77))
  ;; CHECK:      (global $global79 i32 (global.get $global78))
  (global $global79 i32 (global.get $global78))
  ;; CHECK:      (global $global80 i32 (global.get $global79))
  (global $global80 i32 (global.get $global79))
  ;; CHECK:      (global $global81 i32 (global.get $global80))
  (global $global81 i32 (global.get $global80))
  ;; CHECK:      (global $global82 i32 (global.get $global81))
  (global $global82 i32 (global.get $global81))
  ;; CHECK:      (global $global83 i32 (global.get $global82))
  (global $global83 i32 (global.get $global82))
  ;; CHECK:      (global $global84 i32 (global.get $global83))
  (global $global84 i32 (global.get $global83))
  ;; CHECK:      (global $global85 i32 (global.get $global84))
  (global $global85 i32 (global.get $global84))
  ;; CHECK:      (global $global86 i32 (global.get $global85))
  (global $global86 i32 (global.get $global85))
  ;; CHECK:      (global $global87 i32 (global.get $global86))
  (global $global87 i32 (global.get $global86))
  ;; CHECK:      (global $global88 i32 (global.get $global87))
  (global $global88 i32 (global.get $global87))
  ;; CHECK:      (global $global89 i32 (global.get $global88))
  (global $global89 i32 (global.get $global88))
  ;; CHECK:      (global $global90 i32 (global.get $global89))
  (global $global90 i32 (global.get $global89))
  ;; CHECK:      (global $global91 i32 (global.get $global90))
  (global $global91 i32 (global.get $global90))
  ;; CHECK:      (global $global92 i32 (global.get $global91))
  (global $global92 i32 (global.get $global91))
  ;; CHECK:      (global $global93 i32 (global.get $global92))
  (global $global93 i32 (global.get $global92))
  ;; CHECK:      (global $global94 i32 (global.get $global93))
  (global $global94 i32 (global.get $global93))
  ;; CHECK:      (global $global95 i32 (global.get $global94))
  (global $global95 i32 (global.get $global94))
  ;; CHECK:      (global $global96 i32 (global.get $global95))
  (global $global96 i32 (global.get $global95))
  ;; CHECK:      (global $global97 i32 (global.get $global96))
  (global $global97 i32 (global.get $global96))
  ;; CHECK:      (global $global98 i32 (global.get $global97))
  (global $global98 i32 (global.get $global97))
  ;; CHECK:      (global $global99 i32 (global.get $global98))
  (global $global99 i32 (global.get $global98))
  ;; CHECK:      (global $global100 i32 (global.get $global99))
  (global $global100 i32 (global.get $global99))
  ;; CHECK:      (global $global101 i32 (global.get $global100))
  (global $global101 i32 (global.get $global100))
  ;; CHECK:      (global $global102 i32 (global.get $global101))
  (global $global102 i32 (global.get $global101))
  ;; CHECK:      (global $global103 i32 (global.get $global102))
  (global $global103 i32 (global.get $global102))
  ;; CHECK:      (global $global104 i32 (global.get $global103))
  (global $global104 i32 (global.get $global103))
  ;; CHECK:      (global $global105 i32 (global.get $global104))
  (global $global105 i32 (global.get $global104))
  ;; CHECK:      (global $global106 i32 (global.get $global105))
  (global $global106 i32 (global.get $global105))
  ;; CHECK:      (global $global107 i32 (global.get $global106))
  (global $global107 i32 (global.get $global106))
  ;; CHECK:      (global $global108 i32 (global.get $global107))
  (global $global108 i32 (global.get $global107))
  ;; CHECK:      (global $global109 i32 (global.get $global108))
  (global $global109 i32 (global.get $global108))
  ;; CHECK:      (global $global110 i32 (global.get $global109))
  (global $global110 i32 (global.get $global109))
  ;; CHECK:      (global $global111 i32 (global.get $global110))
  (global $global111 i32 (global.get $global110))
  ;; CHECK:      (global $global112 i32 (global.get $global111))
  (global $global112 i32 (global.get $global111))
  ;; CHECK:      (global $global113 i32 (global.get $global112))
  (global $global113 i32 (global.get $global112))
  ;; CHECK:      (global $global114 i32 (global.get $global113))
  (global $global114 i32 (global.get $global113))
  ;; CHECK:      (global $global115 i32 (global.get $global114))
  (global $global115 i32 (global.get $global114))
  ;; CHECK:      (global $global116 i32 (global.get $global115))
  (global $global116 i32 (global.get $global115))
  ;; CHECK:      (global $global117 i32 (global.get $global116))
  (global $global117 i32 (global.get $global116))
  ;; CHECK:      (global $global118 i32 (global.get $global117))
  (global $global118 i32 (global.get $global117))
  ;; CHECK:      (global $global119 i32 (global.get $global118))
  (global $global119 i32 (global.get $global118))
  ;; CHECK:      (global $global120 i32 (global.get $global119))
  (global $global120 i32 (global.get $global119))
  ;; CHECK:      (global $global121 i32 (global.get $global120))
  (global $global121 i32 (global.get $global120))
  ;; CHECK:      (global $global122 i32 (global.get $global121))
  (global $global122 i32 (global.get $global121))
  ;; CHECK:      (global $global123 i32 (global.get $global122))
  (global $global123 i32 (global.get $global122))
  ;; CHECK:      (global $global124 i32 (global.get $global123))
  (global $global124 i32 (global.get $global123))
  ;; CHECK:      (global $global125 i32 (global.get $global124))
  (global $global125 i32 (global.get $global124))
  ;; CHECK:      (global $global126 i32 (global.get $global125))
  (global $global126 i32 (global.get $global125))
  ;; CHECK:      (global $global127 i32 (global.get $global126))
  (global $global127 i32 (global.get $global126))
  ;; CHECK:      (global $global128 i32 (global.get $global127))
  (global $global128 i32 (global.get $global127))

  ;; CHECK:      (global $other i32 (i32.const 0))
  (global $other i32 (i32.const 0))

  ;; CHECK:      (func $uses (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $global128)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $uses
    ;; Aside from the uses in the globals themselves (which means one use for
    ;; each of global1..global127), we add two uses of other, to make it
    ;; have a higher count than global1, and 10 uses of global128, to make it
    ;; have the highest count by far.
    (drop (global.get $other))
    (drop (global.get $other))

    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
    (drop (global.get $global128))
  )
)

;; As above, but now the greedy sort is optimal. We remove all uses of
;; $global128, so $other has the highest count and there is no other factor that
;; matters here, so emitting $other first is best.
(module
  ;; CHECK:      (global $other i32 (i32.const 0))

  ;; CHECK:      (global $global1 i32 (i32.const 1))
  (global $global1 i32 (i32.const 1))
  ;; CHECK:      (global $global2 i32 (global.get $global1))
  (global $global2 i32 (global.get $global1))
  ;; CHECK:      (global $global3 i32 (global.get $global2))
  (global $global3 i32 (global.get $global2))
  ;; CHECK:      (global $global4 i32 (global.get $global3))
  (global $global4 i32 (global.get $global3))
  ;; CHECK:      (global $global5 i32 (global.get $global4))
  (global $global5 i32 (global.get $global4))
  ;; CHECK:      (global $global6 i32 (global.get $global5))
  (global $global6 i32 (global.get $global5))
  ;; CHECK:      (global $global7 i32 (global.get $global6))
  (global $global7 i32 (global.get $global6))
  ;; CHECK:      (global $global8 i32 (global.get $global7))
  (global $global8 i32 (global.get $global7))
  ;; CHECK:      (global $global9 i32 (global.get $global8))
  (global $global9 i32 (global.get $global8))
  ;; CHECK:      (global $global10 i32 (global.get $global9))
  (global $global10 i32 (global.get $global9))
  ;; CHECK:      (global $global11 i32 (global.get $global10))
  (global $global11 i32 (global.get $global10))
  ;; CHECK:      (global $global12 i32 (global.get $global11))
  (global $global12 i32 (global.get $global11))
  ;; CHECK:      (global $global13 i32 (global.get $global12))
  (global $global13 i32 (global.get $global12))
  ;; CHECK:      (global $global14 i32 (global.get $global13))
  (global $global14 i32 (global.get $global13))
  ;; CHECK:      (global $global15 i32 (global.get $global14))
  (global $global15 i32 (global.get $global14))
  ;; CHECK:      (global $global16 i32 (global.get $global15))
  (global $global16 i32 (global.get $global15))
  ;; CHECK:      (global $global17 i32 (global.get $global16))
  (global $global17 i32 (global.get $global16))
  ;; CHECK:      (global $global18 i32 (global.get $global17))
  (global $global18 i32 (global.get $global17))
  ;; CHECK:      (global $global19 i32 (global.get $global18))
  (global $global19 i32 (global.get $global18))
  ;; CHECK:      (global $global20 i32 (global.get $global19))
  (global $global20 i32 (global.get $global19))
  ;; CHECK:      (global $global21 i32 (global.get $global20))
  (global $global21 i32 (global.get $global20))
  ;; CHECK:      (global $global22 i32 (global.get $global21))
  (global $global22 i32 (global.get $global21))
  ;; CHECK:      (global $global23 i32 (global.get $global22))
  (global $global23 i32 (global.get $global22))
  ;; CHECK:      (global $global24 i32 (global.get $global23))
  (global $global24 i32 (global.get $global23))
  ;; CHECK:      (global $global25 i32 (global.get $global24))
  (global $global25 i32 (global.get $global24))
  ;; CHECK:      (global $global26 i32 (global.get $global25))
  (global $global26 i32 (global.get $global25))
  ;; CHECK:      (global $global27 i32 (global.get $global26))
  (global $global27 i32 (global.get $global26))
  ;; CHECK:      (global $global28 i32 (global.get $global27))
  (global $global28 i32 (global.get $global27))
  ;; CHECK:      (global $global29 i32 (global.get $global28))
  (global $global29 i32 (global.get $global28))
  ;; CHECK:      (global $global30 i32 (global.get $global29))
  (global $global30 i32 (global.get $global29))
  ;; CHECK:      (global $global31 i32 (global.get $global30))
  (global $global31 i32 (global.get $global30))
  ;; CHECK:      (global $global32 i32 (global.get $global31))
  (global $global32 i32 (global.get $global31))
  ;; CHECK:      (global $global33 i32 (global.get $global32))
  (global $global33 i32 (global.get $global32))
  ;; CHECK:      (global $global34 i32 (global.get $global33))
  (global $global34 i32 (global.get $global33))
  ;; CHECK:      (global $global35 i32 (global.get $global34))
  (global $global35 i32 (global.get $global34))
  ;; CHECK:      (global $global36 i32 (global.get $global35))
  (global $global36 i32 (global.get $global35))
  ;; CHECK:      (global $global37 i32 (global.get $global36))
  (global $global37 i32 (global.get $global36))
  ;; CHECK:      (global $global38 i32 (global.get $global37))
  (global $global38 i32 (global.get $global37))
  ;; CHECK:      (global $global39 i32 (global.get $global38))
  (global $global39 i32 (global.get $global38))
  ;; CHECK:      (global $global40 i32 (global.get $global39))
  (global $global40 i32 (global.get $global39))
  ;; CHECK:      (global $global41 i32 (global.get $global40))
  (global $global41 i32 (global.get $global40))
  ;; CHECK:      (global $global42 i32 (global.get $global41))
  (global $global42 i32 (global.get $global41))
  ;; CHECK:      (global $global43 i32 (global.get $global42))
  (global $global43 i32 (global.get $global42))
  ;; CHECK:      (global $global44 i32 (global.get $global43))
  (global $global44 i32 (global.get $global43))
  ;; CHECK:      (global $global45 i32 (global.get $global44))
  (global $global45 i32 (global.get $global44))
  ;; CHECK:      (global $global46 i32 (global.get $global45))
  (global $global46 i32 (global.get $global45))
  ;; CHECK:      (global $global47 i32 (global.get $global46))
  (global $global47 i32 (global.get $global46))
  ;; CHECK:      (global $global48 i32 (global.get $global47))
  (global $global48 i32 (global.get $global47))
  ;; CHECK:      (global $global49 i32 (global.get $global48))
  (global $global49 i32 (global.get $global48))
  ;; CHECK:      (global $global50 i32 (global.get $global49))
  (global $global50 i32 (global.get $global49))
  ;; CHECK:      (global $global51 i32 (global.get $global50))
  (global $global51 i32 (global.get $global50))
  ;; CHECK:      (global $global52 i32 (global.get $global51))
  (global $global52 i32 (global.get $global51))
  ;; CHECK:      (global $global53 i32 (global.get $global52))
  (global $global53 i32 (global.get $global52))
  ;; CHECK:      (global $global54 i32 (global.get $global53))
  (global $global54 i32 (global.get $global53))
  ;; CHECK:      (global $global55 i32 (global.get $global54))
  (global $global55 i32 (global.get $global54))
  ;; CHECK:      (global $global56 i32 (global.get $global55))
  (global $global56 i32 (global.get $global55))
  ;; CHECK:      (global $global57 i32 (global.get $global56))
  (global $global57 i32 (global.get $global56))
  ;; CHECK:      (global $global58 i32 (global.get $global57))
  (global $global58 i32 (global.get $global57))
  ;; CHECK:      (global $global59 i32 (global.get $global58))
  (global $global59 i32 (global.get $global58))
  ;; CHECK:      (global $global60 i32 (global.get $global59))
  (global $global60 i32 (global.get $global59))
  ;; CHECK:      (global $global61 i32 (global.get $global60))
  (global $global61 i32 (global.get $global60))
  ;; CHECK:      (global $global62 i32 (global.get $global61))
  (global $global62 i32 (global.get $global61))
  ;; CHECK:      (global $global63 i32 (global.get $global62))
  (global $global63 i32 (global.get $global62))
  ;; CHECK:      (global $global64 i32 (global.get $global63))
  (global $global64 i32 (global.get $global63))
  ;; CHECK:      (global $global65 i32 (global.get $global64))
  (global $global65 i32 (global.get $global64))
  ;; CHECK:      (global $global66 i32 (global.get $global65))
  (global $global66 i32 (global.get $global65))
  ;; CHECK:      (global $global67 i32 (global.get $global66))
  (global $global67 i32 (global.get $global66))
  ;; CHECK:      (global $global68 i32 (global.get $global67))
  (global $global68 i32 (global.get $global67))
  ;; CHECK:      (global $global69 i32 (global.get $global68))
  (global $global69 i32 (global.get $global68))
  ;; CHECK:      (global $global70 i32 (global.get $global69))
  (global $global70 i32 (global.get $global69))
  ;; CHECK:      (global $global71 i32 (global.get $global70))
  (global $global71 i32 (global.get $global70))
  ;; CHECK:      (global $global72 i32 (global.get $global71))
  (global $global72 i32 (global.get $global71))
  ;; CHECK:      (global $global73 i32 (global.get $global72))
  (global $global73 i32 (global.get $global72))
  ;; CHECK:      (global $global74 i32 (global.get $global73))
  (global $global74 i32 (global.get $global73))
  ;; CHECK:      (global $global75 i32 (global.get $global74))
  (global $global75 i32 (global.get $global74))
  ;; CHECK:      (global $global76 i32 (global.get $global75))
  (global $global76 i32 (global.get $global75))
  ;; CHECK:      (global $global77 i32 (global.get $global76))
  (global $global77 i32 (global.get $global76))
  ;; CHECK:      (global $global78 i32 (global.get $global77))
  (global $global78 i32 (global.get $global77))
  ;; CHECK:      (global $global79 i32 (global.get $global78))
  (global $global79 i32 (global.get $global78))
  ;; CHECK:      (global $global80 i32 (global.get $global79))
  (global $global80 i32 (global.get $global79))
  ;; CHECK:      (global $global81 i32 (global.get $global80))
  (global $global81 i32 (global.get $global80))
  ;; CHECK:      (global $global82 i32 (global.get $global81))
  (global $global82 i32 (global.get $global81))
  ;; CHECK:      (global $global83 i32 (global.get $global82))
  (global $global83 i32 (global.get $global82))
  ;; CHECK:      (global $global84 i32 (global.get $global83))
  (global $global84 i32 (global.get $global83))
  ;; CHECK:      (global $global85 i32 (global.get $global84))
  (global $global85 i32 (global.get $global84))
  ;; CHECK:      (global $global86 i32 (global.get $global85))
  (global $global86 i32 (global.get $global85))
  ;; CHECK:      (global $global87 i32 (global.get $global86))
  (global $global87 i32 (global.get $global86))
  ;; CHECK:      (global $global88 i32 (global.get $global87))
  (global $global88 i32 (global.get $global87))
  ;; CHECK:      (global $global89 i32 (global.get $global88))
  (global $global89 i32 (global.get $global88))
  ;; CHECK:      (global $global90 i32 (global.get $global89))
  (global $global90 i32 (global.get $global89))
  ;; CHECK:      (global $global91 i32 (global.get $global90))
  (global $global91 i32 (global.get $global90))
  ;; CHECK:      (global $global92 i32 (global.get $global91))
  (global $global92 i32 (global.get $global91))
  ;; CHECK:      (global $global93 i32 (global.get $global92))
  (global $global93 i32 (global.get $global92))
  ;; CHECK:      (global $global94 i32 (global.get $global93))
  (global $global94 i32 (global.get $global93))
  ;; CHECK:      (global $global95 i32 (global.get $global94))
  (global $global95 i32 (global.get $global94))
  ;; CHECK:      (global $global96 i32 (global.get $global95))
  (global $global96 i32 (global.get $global95))
  ;; CHECK:      (global $global97 i32 (global.get $global96))
  (global $global97 i32 (global.get $global96))
  ;; CHECK:      (global $global98 i32 (global.get $global97))
  (global $global98 i32 (global.get $global97))
  ;; CHECK:      (global $global99 i32 (global.get $global98))
  (global $global99 i32 (global.get $global98))
  ;; CHECK:      (global $global100 i32 (global.get $global99))
  (global $global100 i32 (global.get $global99))
  ;; CHECK:      (global $global101 i32 (global.get $global100))
  (global $global101 i32 (global.get $global100))
  ;; CHECK:      (global $global102 i32 (global.get $global101))
  (global $global102 i32 (global.get $global101))
  ;; CHECK:      (global $global103 i32 (global.get $global102))
  (global $global103 i32 (global.get $global102))
  ;; CHECK:      (global $global104 i32 (global.get $global103))
  (global $global104 i32 (global.get $global103))
  ;; CHECK:      (global $global105 i32 (global.get $global104))
  (global $global105 i32 (global.get $global104))
  ;; CHECK:      (global $global106 i32 (global.get $global105))
  (global $global106 i32 (global.get $global105))
  ;; CHECK:      (global $global107 i32 (global.get $global106))
  (global $global107 i32 (global.get $global106))
  ;; CHECK:      (global $global108 i32 (global.get $global107))
  (global $global108 i32 (global.get $global107))
  ;; CHECK:      (global $global109 i32 (global.get $global108))
  (global $global109 i32 (global.get $global108))
  ;; CHECK:      (global $global110 i32 (global.get $global109))
  (global $global110 i32 (global.get $global109))
  ;; CHECK:      (global $global111 i32 (global.get $global110))
  (global $global111 i32 (global.get $global110))
  ;; CHECK:      (global $global112 i32 (global.get $global111))
  (global $global112 i32 (global.get $global111))
  ;; CHECK:      (global $global113 i32 (global.get $global112))
  (global $global113 i32 (global.get $global112))
  ;; CHECK:      (global $global114 i32 (global.get $global113))
  (global $global114 i32 (global.get $global113))
  ;; CHECK:      (global $global115 i32 (global.get $global114))
  (global $global115 i32 (global.get $global114))
  ;; CHECK:      (global $global116 i32 (global.get $global115))
  (global $global116 i32 (global.get $global115))
  ;; CHECK:      (global $global117 i32 (global.get $global116))
  (global $global117 i32 (global.get $global116))
  ;; CHECK:      (global $global118 i32 (global.get $global117))
  (global $global118 i32 (global.get $global117))
  ;; CHECK:      (global $global119 i32 (global.get $global118))
  (global $global119 i32 (global.get $global118))
  ;; CHECK:      (global $global120 i32 (global.get $global119))
  (global $global120 i32 (global.get $global119))
  ;; CHECK:      (global $global121 i32 (global.get $global120))
  (global $global121 i32 (global.get $global120))
  ;; CHECK:      (global $global122 i32 (global.get $global121))
  (global $global122 i32 (global.get $global121))
  ;; CHECK:      (global $global123 i32 (global.get $global122))
  (global $global123 i32 (global.get $global122))
  ;; CHECK:      (global $global124 i32 (global.get $global123))
  (global $global124 i32 (global.get $global123))
  ;; CHECK:      (global $global125 i32 (global.get $global124))
  (global $global125 i32 (global.get $global124))
  ;; CHECK:      (global $global126 i32 (global.get $global125))
  (global $global126 i32 (global.get $global125))
  ;; CHECK:      (global $global127 i32 (global.get $global126))
  (global $global127 i32 (global.get $global126))
  ;; CHECK:      (global $global128 i32 (global.get $global127))
  (global $global128 i32 (global.get $global127))

  (global $other i32 (i32.const 0))

  ;; CHECK:      (func $uses (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $uses
    (drop (global.get $other))
    (drop (global.get $other))
  )
)

;; As the last testcase, but one global fewer. As a result we only need a single
;; LEB byte for them all, and we do not bother changing the sort here.
(module
  ;; CHECK:      (global $global1 i32 (i32.const 1))
  (global $global1 i32 (i32.const 1))
  ;; CHECK:      (global $global2 i32 (global.get $global1))
  (global $global2 i32 (global.get $global1))
  ;; CHECK:      (global $global3 i32 (global.get $global2))
  (global $global3 i32 (global.get $global2))
  ;; CHECK:      (global $global4 i32 (global.get $global3))
  (global $global4 i32 (global.get $global3))
  ;; CHECK:      (global $global5 i32 (global.get $global4))
  (global $global5 i32 (global.get $global4))
  ;; CHECK:      (global $global6 i32 (global.get $global5))
  (global $global6 i32 (global.get $global5))
  ;; CHECK:      (global $global7 i32 (global.get $global6))
  (global $global7 i32 (global.get $global6))
  ;; CHECK:      (global $global8 i32 (global.get $global7))
  (global $global8 i32 (global.get $global7))
  ;; CHECK:      (global $global9 i32 (global.get $global8))
  (global $global9 i32 (global.get $global8))
  ;; CHECK:      (global $global10 i32 (global.get $global9))
  (global $global10 i32 (global.get $global9))
  ;; CHECK:      (global $global11 i32 (global.get $global10))
  (global $global11 i32 (global.get $global10))
  ;; CHECK:      (global $global12 i32 (global.get $global11))
  (global $global12 i32 (global.get $global11))
  ;; CHECK:      (global $global13 i32 (global.get $global12))
  (global $global13 i32 (global.get $global12))
  ;; CHECK:      (global $global14 i32 (global.get $global13))
  (global $global14 i32 (global.get $global13))
  ;; CHECK:      (global $global15 i32 (global.get $global14))
  (global $global15 i32 (global.get $global14))
  ;; CHECK:      (global $global16 i32 (global.get $global15))
  (global $global16 i32 (global.get $global15))
  ;; CHECK:      (global $global17 i32 (global.get $global16))
  (global $global17 i32 (global.get $global16))
  ;; CHECK:      (global $global18 i32 (global.get $global17))
  (global $global18 i32 (global.get $global17))
  ;; CHECK:      (global $global19 i32 (global.get $global18))
  (global $global19 i32 (global.get $global18))
  ;; CHECK:      (global $global20 i32 (global.get $global19))
  (global $global20 i32 (global.get $global19))
  ;; CHECK:      (global $global21 i32 (global.get $global20))
  (global $global21 i32 (global.get $global20))
  ;; CHECK:      (global $global22 i32 (global.get $global21))
  (global $global22 i32 (global.get $global21))
  ;; CHECK:      (global $global23 i32 (global.get $global22))
  (global $global23 i32 (global.get $global22))
  ;; CHECK:      (global $global24 i32 (global.get $global23))
  (global $global24 i32 (global.get $global23))
  ;; CHECK:      (global $global25 i32 (global.get $global24))
  (global $global25 i32 (global.get $global24))
  ;; CHECK:      (global $global26 i32 (global.get $global25))
  (global $global26 i32 (global.get $global25))
  ;; CHECK:      (global $global27 i32 (global.get $global26))
  (global $global27 i32 (global.get $global26))
  ;; CHECK:      (global $global28 i32 (global.get $global27))
  (global $global28 i32 (global.get $global27))
  ;; CHECK:      (global $global29 i32 (global.get $global28))
  (global $global29 i32 (global.get $global28))
  ;; CHECK:      (global $global30 i32 (global.get $global29))
  (global $global30 i32 (global.get $global29))
  ;; CHECK:      (global $global31 i32 (global.get $global30))
  (global $global31 i32 (global.get $global30))
  ;; CHECK:      (global $global32 i32 (global.get $global31))
  (global $global32 i32 (global.get $global31))
  ;; CHECK:      (global $global33 i32 (global.get $global32))
  (global $global33 i32 (global.get $global32))
  ;; CHECK:      (global $global34 i32 (global.get $global33))
  (global $global34 i32 (global.get $global33))
  ;; CHECK:      (global $global35 i32 (global.get $global34))
  (global $global35 i32 (global.get $global34))
  ;; CHECK:      (global $global36 i32 (global.get $global35))
  (global $global36 i32 (global.get $global35))
  ;; CHECK:      (global $global37 i32 (global.get $global36))
  (global $global37 i32 (global.get $global36))
  ;; CHECK:      (global $global38 i32 (global.get $global37))
  (global $global38 i32 (global.get $global37))
  ;; CHECK:      (global $global39 i32 (global.get $global38))
  (global $global39 i32 (global.get $global38))
  ;; CHECK:      (global $global40 i32 (global.get $global39))
  (global $global40 i32 (global.get $global39))
  ;; CHECK:      (global $global41 i32 (global.get $global40))
  (global $global41 i32 (global.get $global40))
  ;; CHECK:      (global $global42 i32 (global.get $global41))
  (global $global42 i32 (global.get $global41))
  ;; CHECK:      (global $global43 i32 (global.get $global42))
  (global $global43 i32 (global.get $global42))
  ;; CHECK:      (global $global44 i32 (global.get $global43))
  (global $global44 i32 (global.get $global43))
  ;; CHECK:      (global $global45 i32 (global.get $global44))
  (global $global45 i32 (global.get $global44))
  ;; CHECK:      (global $global46 i32 (global.get $global45))
  (global $global46 i32 (global.get $global45))
  ;; CHECK:      (global $global47 i32 (global.get $global46))
  (global $global47 i32 (global.get $global46))
  ;; CHECK:      (global $global48 i32 (global.get $global47))
  (global $global48 i32 (global.get $global47))
  ;; CHECK:      (global $global49 i32 (global.get $global48))
  (global $global49 i32 (global.get $global48))
  ;; CHECK:      (global $global50 i32 (global.get $global49))
  (global $global50 i32 (global.get $global49))
  ;; CHECK:      (global $global51 i32 (global.get $global50))
  (global $global51 i32 (global.get $global50))
  ;; CHECK:      (global $global52 i32 (global.get $global51))
  (global $global52 i32 (global.get $global51))
  ;; CHECK:      (global $global53 i32 (global.get $global52))
  (global $global53 i32 (global.get $global52))
  ;; CHECK:      (global $global54 i32 (global.get $global53))
  (global $global54 i32 (global.get $global53))
  ;; CHECK:      (global $global55 i32 (global.get $global54))
  (global $global55 i32 (global.get $global54))
  ;; CHECK:      (global $global56 i32 (global.get $global55))
  (global $global56 i32 (global.get $global55))
  ;; CHECK:      (global $global57 i32 (global.get $global56))
  (global $global57 i32 (global.get $global56))
  ;; CHECK:      (global $global58 i32 (global.get $global57))
  (global $global58 i32 (global.get $global57))
  ;; CHECK:      (global $global59 i32 (global.get $global58))
  (global $global59 i32 (global.get $global58))
  ;; CHECK:      (global $global60 i32 (global.get $global59))
  (global $global60 i32 (global.get $global59))
  ;; CHECK:      (global $global61 i32 (global.get $global60))
  (global $global61 i32 (global.get $global60))
  ;; CHECK:      (global $global62 i32 (global.get $global61))
  (global $global62 i32 (global.get $global61))
  ;; CHECK:      (global $global63 i32 (global.get $global62))
  (global $global63 i32 (global.get $global62))
  ;; CHECK:      (global $global64 i32 (global.get $global63))
  (global $global64 i32 (global.get $global63))
  ;; CHECK:      (global $global65 i32 (global.get $global64))
  (global $global65 i32 (global.get $global64))
  ;; CHECK:      (global $global66 i32 (global.get $global65))
  (global $global66 i32 (global.get $global65))
  ;; CHECK:      (global $global67 i32 (global.get $global66))
  (global $global67 i32 (global.get $global66))
  ;; CHECK:      (global $global68 i32 (global.get $global67))
  (global $global68 i32 (global.get $global67))
  ;; CHECK:      (global $global69 i32 (global.get $global68))
  (global $global69 i32 (global.get $global68))
  ;; CHECK:      (global $global70 i32 (global.get $global69))
  (global $global70 i32 (global.get $global69))
  ;; CHECK:      (global $global71 i32 (global.get $global70))
  (global $global71 i32 (global.get $global70))
  ;; CHECK:      (global $global72 i32 (global.get $global71))
  (global $global72 i32 (global.get $global71))
  ;; CHECK:      (global $global73 i32 (global.get $global72))
  (global $global73 i32 (global.get $global72))
  ;; CHECK:      (global $global74 i32 (global.get $global73))
  (global $global74 i32 (global.get $global73))
  ;; CHECK:      (global $global75 i32 (global.get $global74))
  (global $global75 i32 (global.get $global74))
  ;; CHECK:      (global $global76 i32 (global.get $global75))
  (global $global76 i32 (global.get $global75))
  ;; CHECK:      (global $global77 i32 (global.get $global76))
  (global $global77 i32 (global.get $global76))
  ;; CHECK:      (global $global78 i32 (global.get $global77))
  (global $global78 i32 (global.get $global77))
  ;; CHECK:      (global $global79 i32 (global.get $global78))
  (global $global79 i32 (global.get $global78))
  ;; CHECK:      (global $global80 i32 (global.get $global79))
  (global $global80 i32 (global.get $global79))
  ;; CHECK:      (global $global81 i32 (global.get $global80))
  (global $global81 i32 (global.get $global80))
  ;; CHECK:      (global $global82 i32 (global.get $global81))
  (global $global82 i32 (global.get $global81))
  ;; CHECK:      (global $global83 i32 (global.get $global82))
  (global $global83 i32 (global.get $global82))
  ;; CHECK:      (global $global84 i32 (global.get $global83))
  (global $global84 i32 (global.get $global83))
  ;; CHECK:      (global $global85 i32 (global.get $global84))
  (global $global85 i32 (global.get $global84))
  ;; CHECK:      (global $global86 i32 (global.get $global85))
  (global $global86 i32 (global.get $global85))
  ;; CHECK:      (global $global87 i32 (global.get $global86))
  (global $global87 i32 (global.get $global86))
  ;; CHECK:      (global $global88 i32 (global.get $global87))
  (global $global88 i32 (global.get $global87))
  ;; CHECK:      (global $global89 i32 (global.get $global88))
  (global $global89 i32 (global.get $global88))
  ;; CHECK:      (global $global90 i32 (global.get $global89))
  (global $global90 i32 (global.get $global89))
  ;; CHECK:      (global $global91 i32 (global.get $global90))
  (global $global91 i32 (global.get $global90))
  ;; CHECK:      (global $global92 i32 (global.get $global91))
  (global $global92 i32 (global.get $global91))
  ;; CHECK:      (global $global93 i32 (global.get $global92))
  (global $global93 i32 (global.get $global92))
  ;; CHECK:      (global $global94 i32 (global.get $global93))
  (global $global94 i32 (global.get $global93))
  ;; CHECK:      (global $global95 i32 (global.get $global94))
  (global $global95 i32 (global.get $global94))
  ;; CHECK:      (global $global96 i32 (global.get $global95))
  (global $global96 i32 (global.get $global95))
  ;; CHECK:      (global $global97 i32 (global.get $global96))
  (global $global97 i32 (global.get $global96))
  ;; CHECK:      (global $global98 i32 (global.get $global97))
  (global $global98 i32 (global.get $global97))
  ;; CHECK:      (global $global99 i32 (global.get $global98))
  (global $global99 i32 (global.get $global98))
  ;; CHECK:      (global $global100 i32 (global.get $global99))
  (global $global100 i32 (global.get $global99))
  ;; CHECK:      (global $global101 i32 (global.get $global100))
  (global $global101 i32 (global.get $global100))
  ;; CHECK:      (global $global102 i32 (global.get $global101))
  (global $global102 i32 (global.get $global101))
  ;; CHECK:      (global $global103 i32 (global.get $global102))
  (global $global103 i32 (global.get $global102))
  ;; CHECK:      (global $global104 i32 (global.get $global103))
  (global $global104 i32 (global.get $global103))
  ;; CHECK:      (global $global105 i32 (global.get $global104))
  (global $global105 i32 (global.get $global104))
  ;; CHECK:      (global $global106 i32 (global.get $global105))
  (global $global106 i32 (global.get $global105))
  ;; CHECK:      (global $global107 i32 (global.get $global106))
  (global $global107 i32 (global.get $global106))
  ;; CHECK:      (global $global108 i32 (global.get $global107))
  (global $global108 i32 (global.get $global107))
  ;; CHECK:      (global $global109 i32 (global.get $global108))
  (global $global109 i32 (global.get $global108))
  ;; CHECK:      (global $global110 i32 (global.get $global109))
  (global $global110 i32 (global.get $global109))
  ;; CHECK:      (global $global111 i32 (global.get $global110))
  (global $global111 i32 (global.get $global110))
  ;; CHECK:      (global $global112 i32 (global.get $global111))
  (global $global112 i32 (global.get $global111))
  ;; CHECK:      (global $global113 i32 (global.get $global112))
  (global $global113 i32 (global.get $global112))
  ;; CHECK:      (global $global114 i32 (global.get $global113))
  (global $global114 i32 (global.get $global113))
  ;; CHECK:      (global $global115 i32 (global.get $global114))
  (global $global115 i32 (global.get $global114))
  ;; CHECK:      (global $global116 i32 (global.get $global115))
  (global $global116 i32 (global.get $global115))
  ;; CHECK:      (global $global117 i32 (global.get $global116))
  (global $global117 i32 (global.get $global116))
  ;; CHECK:      (global $global118 i32 (global.get $global117))
  (global $global118 i32 (global.get $global117))
  ;; CHECK:      (global $global119 i32 (global.get $global118))
  (global $global119 i32 (global.get $global118))
  ;; CHECK:      (global $global120 i32 (global.get $global119))
  (global $global120 i32 (global.get $global119))
  ;; CHECK:      (global $global121 i32 (global.get $global120))
  (global $global121 i32 (global.get $global120))
  ;; CHECK:      (global $global122 i32 (global.get $global121))
  (global $global122 i32 (global.get $global121))
  ;; CHECK:      (global $global123 i32 (global.get $global122))
  (global $global123 i32 (global.get $global122))
  ;; CHECK:      (global $global124 i32 (global.get $global123))
  (global $global124 i32 (global.get $global123))
  ;; CHECK:      (global $global125 i32 (global.get $global124))
  (global $global125 i32 (global.get $global124))
  ;; CHECK:      (global $global126 i32 (global.get $global125))
  (global $global126 i32 (global.get $global125))
  ;; CHECK:      (global $global127 i32 (global.get $global126))
  (global $global127 i32 (global.get $global126))

  ;; $global128 was removed

  ;; CHECK:      (global $other i32 (i32.const 0))
  (global $other i32 (i32.const 0))

  ;; CHECK:      (func $uses (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (global.get $other)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $uses
    (drop (global.get $other))
    (drop (global.get $other))
  )
)
