export interface CheckboxClasses {
    /** Styles applied to the root element. */
    root: string;
    /** State class applied to the root element if `checked={true}`. */
    checked: string;
    /** State class applied to the root element if `disabled={true}`. */
    disabled: string;
    /** State class applied to the root element if `indeterminate={true}`. */
    indeterminate: string;
    /** Styles applied to the root element if `color="primary"`. */
    colorPrimary: string;
    /** Styles applied to the root element if `color="secondary"`. */
    colorSecondary: string;
}
export type CheckboxClassKey = keyof CheckboxClasses;
export declare function getCheckboxUtilityClass(slot: string): string;
declare const checkboxClasses: CheckboxClasses;
export default checkboxClasses;
