// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

export type FlatNode = GraphNode & { id: string };

export type GraphNode = {
    label: string;
    kind: string;
    objectId: string;
    lastSeen: string;
    isTierZero: boolean;
    isOwnedObject: boolean;
    descendent_count?: number | null;
    properties?: Record<string, any>;
};

export type GraphEdge = {
    id1: string;
    id2: string;
    end1?: {
        arrow: boolean;
    };
    end2?: {
        arrow: boolean;
    };
    color?: string;
    data?: Record<string, string>;
    label: {
        text: string;
    };
};

export type GraphRecords = Record<string, GraphNode | GraphEdge>;
