/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "cht-1.7.pp" */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef P2C_H
#define P2C_H


/* Header file for code generated by "p2c", the Pascal-to-C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991, 1992, 1993 Free Software Foundation.
 * By Dave Gillespie, daveg@synaptics.com.  Version 1.21alpha-07.Dec.93.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */


#include <stdio.h>
#include <unistd.h>
#define DOUBLE double



/* If the following heuristic fails, compile -DBSD=0 for non-BSD systems,
   or -DBSD=1 for BSD systems. */

#ifdef M_XENIX
# define BSD 0
#endif

#ifdef vms
# define BSD 0
# ifndef __STDC__
#  define __STDC__ 1
# endif
#endif

#ifdef __TURBOC__
# define MSDOS 1
#endif

#ifdef MSDOS
# define BSD 0
#endif

#ifdef FILE       /* a #define in BSD, a typedef in SYSV (hp-ux, at least) */
# ifndef BSD	  /*  (a convenient, but horrible kludge!) */
#  define BSD 1
# endif
#endif

#ifdef BSD
# if !BSD
#  undef BSD
# endif
#endif


#if (defined(__STDC__) && !defined(M_XENIX)) || defined(__TURBOC__)
# include <stdlib.h>
# include <stddef.h>
# define HAS_STDLIB
# if defined(vms) || defined(__TURBOC__)
#  define NON_ANSI_CAT
# endif
#else
# ifndef BSD
#  ifndef __TURBOC__
#   include <memory.h>
#  endif
# endif
# ifdef hpux
#  ifdef _INCLUDE__STDC__
#   include <stddef.h>
#   include <stdlib.h>
#   define HAS_STDLIB
#  endif
# endif
# include <sys/types.h>
# if !defined(MSDOS) || defined(__TURBOC__)
#  define NON_ANSI_CAT
# endif
#endif

#if defined(NON_ANSI_CAT) && !defined(ANSI_CAT)
# ifdef NON_ANSI_CAT_ALTERNATE
#  define __CAT__(a,b)a/**/b
# else
#  define __ID__(a)a
#  define __CAT__(a,b)__ID__(a)b
# endif
#else
# define __CAT__(a,b)a##b
#endif


#ifdef BSD
# include <strings.h>
# define memcpy(a,b,n) (bcopy(b,a,n),a)
# define memcmp(a,b,n) bcmp(a,b,n)
# define strchr(s,c) index(s,c)
# define strrchr(s,c) rindex(s,c)
#else
# include <string.h>
#endif

#include <ctype.h>
#include <math.h>
#include <setjmp.h>
#include <assert.h>


#ifndef NO_LACK
#ifdef vms

#define LACK_LABS
#define LACK_MEMMOVE
#define LACK_MEMCPY

#else

#define LACK_LABS       /* Undefine these if your library has these */
#define LACK_MEMMOVE

#endif
#endif


typedef struct __p2c_jmp_buf {
    struct __p2c_jmp_buf *next;
    jmp_buf jbuf;
} __p2c_jmp_buf;


/* Warning: The following will not work if setjmp is used simultaneously.
   This also violates the ANSI restriction about using vars after longjmp,
   but a typical implementation of longjmp will get it right anyway. */

#ifndef FAKE_TRY
# define TRY(x)         do { __p2c_jmp_buf __try_jb;  \
			     __try_jb.next = __top_jb;  \
			     if (!setjmp((__top_jb = &__try_jb)->jbuf)) {
# define RECOVER(x)	__top_jb = __try_jb.next; } else {
# define RECOVER2(x,L)  __top_jb = __try_jb.next; } else {  \
			     if (0) { L: __top_jb = __try_jb.next; }
# define ENDTRY(x)      } } while (0) 
#else
# define TRY(x)         if (1) {
# define RECOVER(x)     } else do {
# define RECOVER2(x,L)  } else do { L: ;
# define ENDTRY(x)      } while (0)
#endif



#ifdef M_XENIX  /* avoid compiler bug */
# define SHORT_MAX  (32767)
# define SHORT_MIN  (-32768)
#endif


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  ((short)(((unsigned short) -1) >> 1))
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef INT_MAX
# define INT_MAX    ((int)(((unsigned int) -1) >> 1))
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   ((long)(((unsigned long) -1) >> 1))
# define LONG_MIN   (~LONG_MAX)
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#ifndef EXIT_SUCCESS
# ifdef vms
#  define EXIT_SUCCESS  1
#  define EXIT_FAILURE  (02000000000L)
# else
#  define EXIT_SUCCESS  0
#  define EXIT_FAILURE  1
# endif
#endif


#define SETBITS  32


#if defined(__STDC__) || defined(__TURBOC__)
# if !defined(vms) && !defined(M_LINT)
#  define Signed    signed
# else
#  define Signed
# endif
# define Void       void      /* Void f() = procedure */
# ifndef Const
#  define Const     const
# endif
# ifndef Volatile
# define Volatile   volatile
# endif
# ifdef M_LINT
#  define PP(x)     ()
#  define PV()	    ()
typedef char *Anyptr;
# else
#  define PP(x)     x         /* function prototype */
#  define PV()      (void)    /* null function prototype */
typedef void *Anyptr;
# endif
#else
# define Signed
# define Void       void
# ifndef Const
#  define Const
# endif
# ifndef Volatile
#  define Volatile
# endif
# define PP(x)      ()
# define PV()       ()
typedef char *Anyptr;
#endif

#ifdef __GNUC__
# define Inline     inline
#else
# define Inline
#endif

#define Register    register  /* Register variables */
#define Char        char      /* Characters (not bytes) */

#ifndef Static
# define Static     static    /* Private global funcs and vars */
#endif

#ifndef Local
# define Local      static    /* Nested functions */
#endif

typedef Signed   char schar;
typedef unsigned char uchar;
typedef unsigned char boolean;

#ifndef NO_DECLARE_ALFA
typedef Char alfa[10];
#endif

#ifndef true
# define true    1
# define false   0
#endif

#ifndef TRUE
# define TRUE    1
# define FALSE   0
#endif


typedef struct {
    Anyptr proc, link;
} _PROCEDURE;

#ifndef _FNSIZE
# define _FNSIZE  120
#endif


extern Void    PASCAL_MAIN  PP( (int, Char **) );
extern Char    **P_argv;
extern int     P_argc;
extern short   P_escapecode;
extern int     P_ioresult;
extern __p2c_jmp_buf *__top_jb;


#ifdef P2C_H_PROTO   /* if you have Ansi C but non-prototyped header files */
extern Char    *strcat      PP( (Char *, Const Char *) );
extern Char    *strchr      PP( (Const Char *, int) );
extern int      strcmp      PP( (Const Char *, Const Char *) );
extern Char    *strcpy      PP( (Char *, Const Char *) );
extern size_t   strlen      PP( (Const Char *) );
extern Char    *strncat     PP( (Char *, Const Char *, size_t) );
extern int      strncmp     PP( (Const Char *, Const Char *, size_t) );
extern Char    *strncpy     PP( (Char *, Const Char *, size_t) );
extern Char    *strrchr     PP( (Const Char *, int) );

extern Anyptr   memchr      PP( (Const Anyptr, int, size_t) );
extern Anyptr   memmove     PP( (Anyptr, Const Anyptr, size_t) );
extern Anyptr   memset      PP( (Anyptr, int, size_t) );
#ifndef memcpy
extern Anyptr   memcpy      PP( (Anyptr, Const Anyptr, size_t) );
extern int      memcmp      PP( (Const Anyptr, Const Anyptr, size_t) );
#endif

extern int      atoi        PP( (Const Char *) );
extern double   atof        PP( (Const Char *) );
extern long     atol        PP( (Const Char *) );
extern double   strtod      PP( (Const Char *, Char **) );
extern long     strtol      PP( (Const Char *, Char **, int) );
#endif /*P2C_H_PROTO*/

#ifndef HAS_STDLIB
#ifndef NO_DECLARE_MALLOC
extern Anyptr   malloc      PP( (size_t) );
extern Void     free        PP( (Anyptr) );
#endif
#endif

extern int      _OutMem     PV();
extern int      _CaseCheck  PV();
extern int      _NilCheck   PV();
extern int	_Escape     PP( (int) );
extern int	_EscIO      PP( (int) );
extern int	_EscIO2     PP( (int, Char *) );

extern long     ipow        PP( (long, long) );
extern long     P_imax      PP( (long, long) );
extern long     P_imin      PP( (long, long) );
extern double   P_rmax      PP( (double, double) );
extern double   P_rmin      PP( (double, double) );
extern Char    *strsub      PP( (Char *, Char *, int, int) );
extern Char    *strltrim    PP( (Char *) );
extern Char    *strrtrim    PP( (Char *) );
extern Char    *strrpt      PP( (Char *, Char *, int) );
extern Char    *strpad      PP( (Char *, Char *, int, int) );
extern int      strpos2     PP( (Char *, Char *, int) );
extern long     memavail    PV();
extern int      P_peek      PP( (FILE *) );
extern int      P_eof       PP( (FILE *) );
extern int      P_eoln      PP( (FILE *) );
extern Void     P_readpaoc  PP( (FILE *, Char *, int) );
extern Void     P_readlnpaoc PP( (FILE *, Char *, int) );
extern long     P_maxpos    PP( (FILE *) );
extern Char    *P_trimname  PP( (Char *, int) );
extern long    *P_setunion  PP( (long *, long *, long *) );
extern long    *P_setint    PP( (long *, long *, long *) );
extern long    *P_setdiff   PP( (long *, long *, long *) );
extern long    *P_setxor    PP( (long *, long *, long *) );
extern int      P_inset     PP( (unsigned, long *) );
extern int      P_setequal  PP( (long *, long *) );
extern int      P_subset    PP( (long *, long *) );
extern long    *P_addset    PP( (long *, unsigned) );
extern long    *P_addsetr   PP( (long *, unsigned, unsigned) );
extern long    *P_remset    PP( (long *, unsigned) );
extern long    *P_setcpy    PP( (long *, long *) );
extern long    *P_expset    PP( (long *, long) );
extern long     P_packset   PP( (long *) );
extern FILE    *_skipspaces PP( (FILE *) );
extern FILE    *_skipnlspaces PP( (FILE *) );


/* I/O error handling */
#define _CHKIO(cond,ior,val,def)  ((cond) ? P_ioresult=0,(val)  \
					  : P_ioresult=(ior),(def))
#define _SETIO(cond,ior)          (P_ioresult = (cond) ? 0 : (ior))

/* Following defines are suitable for the HP Pascal operating system */
#define FileNotFound     10
#define FileNotOpen      13
#define FileWriteError   38
#define BadInputFormat   14
#define EndOfFile        30

#define FILENOTFOUND     10
#define FILENOTOPEN      13
#define FILEWRITEERROR   38
#define BADINPUTFORMAT   14
#define ENDOFFILE        30

/* Creating temporary files */
#if (defined(BSD) || defined(NO_TMPFILE)) && !defined(HAVE_TMPFILE)
# define tmpfile()  (fopen(tmpnam(NULL), "w+"))
#endif

/* File buffers */
#define FILEBUF(f,sc,type) sc int __CAT__(f,_BFLAGS);   \
			   sc type __CAT__(f,_BUFFER)
#define FILEBUFNC(f,type)  int __CAT__(f,_BFLAGS);   \
			   type __CAT__(f,_BUFFER)

#define RESETBUF(f,type)   (__CAT__(f,_BFLAGS) = 1)
#define SETUPBUF(f,type)   (__CAT__(f,_BFLAGS) = 0)

#define GETFBUF(f,type)    (*((__CAT__(f,_BFLAGS) == 1 &&   \
			       ((__CAT__(f,_BFLAGS) = 2),   \
				fread(&__CAT__(f,_BUFFER),  \
				      sizeof(type),1,(f)))),\
			      &__CAT__(f,_BUFFER)))
#define AGETFBUF(f,type)   ((__CAT__(f,_BFLAGS) == 1 &&   \
			     ((__CAT__(f,_BFLAGS) = 2),   \
			      fread(__CAT__(f,_BUFFER),  \
				    sizeof(type),1,(f)))),\
			    __CAT__(f,_BUFFER))

#define PUTFBUF(f,type,v)  (GETFBUF(f,type) = (v))
#define CPUTFBUF(f,v)      (PUTFBUF(f,char,v))
#define APUTFBUF(f,type,v) (memcpy(AGETFBUF(f,type), (v),  \
				   sizeof(__CAT__(f,_BUFFER))))

#define GET(f,type)        (__CAT__(f,_BFLAGS) == 1 ?   \
			    fread(&__CAT__(f,_BUFFER),sizeof(type),1,(f)) :  \
			    (__CAT__(f,_BFLAGS) = 1))

#define PUT(f,type)        (fwrite(&__CAT__(f,_BUFFER),sizeof(type),1,(f)),  \
			    (__CAT__(f,_BFLAGS) = 0))
#define CPUT(f)            (PUT(f,char))

#define BUFEOF(f)	   (__CAT__(f,_BFLAGS) != 2 && P_eof(f))
#define BUFFPOS(f)	   (ftell(f) - (__CAT__(f,_BFLAGS) == 2))

typedef struct {
    FILE *f;
    int f_BFLAGS;    /* FILEBUFNC(f,Char); */
    Char f_BUFFER;
    Char name[_FNSIZE];
} _TEXT;

/* Memory allocation */
#ifdef __GCC__
# define Malloc(n)  (malloc(n) ?: (Anyptr)_OutMem())
#else
extern Anyptr __MallocTemp__;
# define Malloc(n)  ((__MallocTemp__ = malloc(n)) ? __MallocTemp__ : (Anyptr)_OutMem())
#endif
#define FreeR(p)    (free((Anyptr)(p)))    /* used if arg is an rvalue */
#define Free(p)     (free((Anyptr)(p)), (p)=NULL)

/* sign extension */
#define SEXT(x,n)   ((x) | -(((x) & (1L<<((n)-1))) << 1))

/* packed arrays */   /* BEWARE: these are untested! */
#define P_getbits_UB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] >>   \
				       (((~(i))&((1<<(L)-(n))-1)) << (n)) &  \
				       (1<<(1<<(n)))-1))

#define P_getbits_SB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] <<   \
				       (16 - ((((~(i))&((1<<(L)-(n))-1))+1) <<\
					      (n)) >> (16-(1<<(n))))))

#define P_putbits_UB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 (x) << (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_putbits_SB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 ((x) & (1<<(1<<(n)))-1) <<   \
				 (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_clrbits_B(a,i,n,L)    ((a)[(i)>>(L)-(n)] &=   \
				 ~( ((1<<(1<<(n)))-1) <<   \
				   (((~(i))&((1<<(L)-(n))-1)) << (n))) )

/* small packed arrays */
#define P_getbits_US(v,i,n)     ((int)((v) >> ((i)<<(n)) & (1<<(1<<(n)))-1))
#define P_getbits_SS(v,i,n)     ((int)((long)(v) << (SETBITS - (((i)+1) << (n))) >> (SETBITS-(1<<(n)))))
#define P_putbits_US(v,i,x,n)   ((v) |= (x) << ((i) << (n)))
#define P_putbits_SS(v,i,x,n)   ((v) |= ((x) & (1<<(1<<(n)))-1) << ((i)<<(n)))
#define P_clrbits_S(v,i,n)      ((v) &= ~( ((1<<(1<<(n)))-1) << ((i)<<(n)) ))

#define P_max(a,b)   ((a) > (b) ? (a) : (b))
#define P_min(a,b)   ((a) < (b) ? (a) : (b))


/* Fix ANSI-isms */

#ifdef LACK_LABS
# ifndef labs
#  define labs  my_labs
   extern long my_labs PP( (long) );
# endif
#endif

#ifdef LACK_MEMMOVE
# ifndef memmove
#  define memmove  my_memmove
   extern Anyptr my_memmove PP( (Anyptr, Const Anyptr, size_t) );
# endif
#endif

#ifdef LACK_MEMCPY
# ifndef memcpy
#  define memcpy  my_memcpy
   extern Anyptr my_memcpy PP( (Anyptr, Const Anyptr, size_t) );
# endif
# ifndef memcmp
#  define memcmp  my_memcmp
   extern int my_memcmp PP( (Const Anyptr, Const Anyptr, size_t) );
# endif
# ifndef memset
#  define memset  my_memset
   extern Anyptr my_memset PP( (Anyptr, int, size_t) );
# endif
#endif

/* Fix toupper/tolower on Suns and other stupid BSD systems */
#ifdef toupper
# undef toupper
# undef tolower
# define toupper(c)   my_toupper(c)
# define tolower(c)   my_tolower(c)
#endif

#ifndef _toupper
# if 'A' == 65 && 'a' == 97
#  define _toupper(c)  ((c)-'a'+'A')
#  define _tolower(c)  ((c)-'A'+'a')
# else
#  ifdef toupper
#   undef toupper   /* hope these are shadowing real functions, */
#   undef tolower   /* because my_toupper calls _toupper! */
#  endif
#  define _toupper(c)  toupper(c)
#  define _tolower(c)  tolower(c)
# endif
#endif


#endif    /* P2C_H */



/* End. */




/* Run-time library for use with "p2c", the Pascal to C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991, 1992, 1993 Free Software Foundation.
 * By Dave Gillespie, daveg@synaptics.com.  Version --VERSION--.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */





#ifndef NO_TIME
# include <time.h>
#endif


#define Isspace(c)  isspace(c)      /* or "((c) == ' ')" if preferred */




int P_argc;
char **P_argv;

short P_escapecode;
int P_ioresult;

long EXCP_LINE;    /* Used by Pascal workstation system */

Anyptr __MallocTemp__;

__p2c_jmp_buf *__top_jb;




void PASCAL_MAIN(argc, argv)
int argc;
char **argv;
{
    P_argc = argc;
    P_argv = argv;
    __top_jb = NULL;

#ifdef LOCAL_INIT
    LOCAL_INIT();
#endif
}





/* In case your system lacks these... */

long my_labs(x)
long x;
{
    return((x > 0) ? x : -x);
}




#ifdef __STDC__
Anyptr my_memcpy(Anyptr d, Const Anyptr s, size_t n)
#else
Anyptr my_memcpy(d, s, n)
Anyptr d, s;
register int n;
#endif
{
    register char *ss = (char *)s, *dd = (char *)d;
    while (n-- > 0)
	*dd++ = *ss++;
    return d;
}

#ifdef __STDC__
Anyptr my_memmove(Anyptr d, Const Anyptr s, size_t n)
#else
Anyptr my_memmove(d, s, n)
Anyptr d, s;
register int n;
#endif
{
    register char *dd = (char *)d, *ss = (char *)s;
    if (dd < ss || dd - ss >= (int)n) {
#if defined(bcopy) && defined(memcpy)
        my_memcpy(dd, ss, n);
#else
	memcpy(dd, ss, (size_t)n);
#endif
    } else if (n > 0) {
	dd += n;
	ss += n;
	while (n-- > 0)
	    *--dd = *--ss;
    }
    return d;
}

#ifdef __STDC__
int my_memcmp(Const Anyptr s1, Const Anyptr s2, size_t n)
#else
int my_memcmp(s1, s2, n)
Anyptr s1, s2;
register int n;
#endif
{
    register char *a = (char *)s1, *b = (char *)s2;
    register int i;
    while (n-- > 0)
	if ((i = (*a++) - (*b++)) != 0)
	    return i;
    return 0;
}

#ifdef __STDC__
Anyptr my_memset(Anyptr d, int c, size_t n)
#else
Anyptr my_memset(d, c, n)
Anyptr d;
register int c;
register int n;
#endif
{
    register char *dd = (char *)d;
    while (n-- > 0)
	*dd++ = c;
    return d;
}


int my_toupper(c)
int c;
{
    if (islower(c))
	return _toupper(c);
    else
	return c;
}


int my_tolower(c)
int c;
{
    if (isupper(c))
	return _tolower(c);
    else
	return c;
}




long ipow(a, b)
long a, b;
{
    long v;

    if (a == 0 || a == 1)
	return a;
    if (a == -1)
	return (b & 1) ? -1 : 1;
    if (b < 0)
	return 0;
    if (a == 2)
	return 1L << b;
    v = (b & 1) ? a : 1;
    while ((b >>= 1) > 0) {
	a *= a;
	if (b & 1)
	    v *= a;
    }
    return v;
}


long P_imax(a, b)
long a, b;
{
    if (a > b)
	return a;
    else
	return b;
}

long P_imin(a, b)
long a, b;
{
    if (a < b)
	return a;
    else
	return b;
}


double P_rmax(a, b)
double a, b;
{
    if (a > b)
	return a;
    else
	return b;
}

double P_rmin(a, b)
double a, b;
{
    if (a < b)
	return a;
    else
	return b;
}




/* Common string functions: */

/* Store in "ret" the substring of length "len" starting from "pos" (1-based).
   Store a shorter or null string if out-of-range.  Return "ret". */

char *strsub(ret, s, pos, len)
register char *ret, *s;
register int pos, len;
{
    register char *s2;

    if (--pos < 0 || len <= 0) {
        *ret = 0;
        return ret;
    }
    while (pos > 0) {
        if (!*s++) {
            *ret = 0;
            return ret;
        }
        pos--;
    }
    s2 = ret;
    while (--len >= 0) {
        if (!(*s2++ = *s++))
            return ret;
    }
    *s2 = 0;
    return ret;
}


/* Return the index of the first occurrence of "pat" as a substring of "s",
   starting at index "pos" (1-based).  Result is 1-based, 0 if not found. */

int strpos2(s, pat, pos)
char *s;
register char *pat;
register int pos;
{
    register char *cp, ch;
    register int slen;

    if (--pos < 0)
        return 0;
    slen = (int)strlen(s) - pos;
    cp = s + pos;
    if (!(ch = *pat++))
        return 0;
    pos = (int)strlen(pat);
    slen -= pos;
    while (--slen >= 0) {
        if (*cp++ == ch && !strncmp(cp, pat, (size_t)pos))
            return cp - s;
    }
    return 0;
}


/* Case-insensitive version of strcmp. */

int strcicmp(s1, s2)
register char *s1, *s2;
{
    register unsigned char c1, c2;

    while (*s1) {
	if (*s1++ != *s2++) {
	    if (!s2[-1])
		return 1;
	    c1 = (unsigned char)toupper(s1[-1]);
	    c2 = (unsigned char)toupper(s2[-1]);
	    if (c1 != c2)
		return c1 - c2;
	}
    }
    if (*s2)
	return -1;
    return 0;
}




/* HP and Turbo Pascal string functions: */

/* Trim blanks at left end of string. */

char *strltrim(s)
register char *s;
{
    while (Isspace(*s++)) ;
    return s - 1;
}


/* Trim blanks at right end of string. */

char *strrtrim(s)
register char *s;
{
    register char *s2 = s;

    if (!*s)
	return s;
    while (*++s2) ;
    while (s2 > s && Isspace(*--s2))
        *s2 = 0;
    return s;
}


/* Store in "ret" "num" copies of string "s".  Return "ret". */

char *strrpt(ret, s, num)
char *ret;
register char *s;
register int num;
{
    register char *s2 = ret;
    register char *s1;

    while (--num >= 0) {
        s1 = s;
        while ((*s2++ = *s1++)) ;
        s2--;
    }
    return ret;
}


/* Store in "ret" string "s" with enough pad chars added to reach "size". */

char *strpad(ret, s, padchar, num)
char *ret;
register char *s;
register int padchar, num;
{
    register char *d = ret;

    if (s == d) {
	while (*d++) ;
    } else {
	while ((*d++ = *s++)) ;
    }
    num -= (--d - ret);
    while (--num >= 0)
	*d++ = padchar;
    *d = 0;
    return ret;
}


/* Copy the substring of length "len" from index "spos" of "s" (1-based)
   to index "dpos" of "d", lengthening "d" if necessary.  Length and
   indices must be in-range. */

void strmove(len, s, spos, d, dpos)
register char *s, *d;
register int len, spos, dpos;
{
    s += spos - 1;
    d += dpos - 1;
    while (*d && --len >= 0)
	*d++ = *s++;
    if (len > 0) {
	while (--len >= 0)
	    *d++ = *s++;
	*d = 0;
    }
}


/* Delete the substring of length "len" at index "pos" from "s".
   Delete less if out-of-range. */

void strdelete(s, pos, len)
register char *s;
register int pos, len;
{
    register int slen;

    if (--pos < 0)
        return;
    slen = (int)strlen(s) - pos;
    if (slen <= 0)
        return;
    s += pos;
    if (slen <= len) {
        *s = 0;
        return;
    }
    while ((*s = s[len])) s++;
}


/* Insert string "src" at index "pos" of "dst". */

void strinsert(src, dst, pos)
register char *src, *dst;
register int pos;
{
    register int slen, dlen;

    if (--pos < 0)
        return;
    dlen = (int)strlen(dst);
    dst += dlen;
    dlen -= pos;
    if (dlen <= 0) {
        strcpy(dst, src);
        return;
    }
    slen = (int)strlen(src);
    do {
        dst[slen] = *dst;
        --dst;
    } while (--dlen >= 0);
    dst++;
    while (--slen >= 0)
        *dst++ = *src++;
}




/* File functions */

/* Peek at next character of input stream; return EOF at end-of-file. */

int P_peek(f)
FILE *f;
{
    int ch;

    ch = getc(f);
    if (ch == EOF)
	return EOF;
    ungetc(ch, f);
    return (ch == '\n') ? ' ' : ch;
}


/* Check if at end of file, using Pascal "eof" semantics.  End-of-file for
   stdin is broken; remove the special case for it to be broken in a
   different way. */

int P_eof(f)
FILE *f;
{
    register int ch;

    if (feof(f))
	return 1;
#ifdef HAVE_ISATTY
    if (isatty(fileno(f)))
#else
    if (f == stdin)
#endif
	return 0;    /* not safe to look-ahead on the keyboard! */
    ch = getc(f);
    if (ch == EOF)
	return 1;
    ungetc(ch, f);
    return 0;
}


/* Check if at end of line (or end of entire file). */

int P_eoln(f)
FILE *f;
{
    register int ch;

    ch = getc(f);
    if (ch == EOF)
        return 1;
    ungetc(ch, f);
    return (ch == '\n');
}


/* Skip whitespace (including newlines) in a file. */

FILE *_skipnlspaces(f)
FILE *f;
{
  register int ch;

  do {
    ch = getc(f);
  } while (ch == ' ' || ch == '\t' || ch == '\n');
  if (ch != EOF)
    ungetc(ch, f);
  return f;
}


/* Skip whitespace (not including newlines) in a file. */

FILE *_skipspaces(f)
FILE *f;
{
  register int ch;

  do {
    ch = getc(f);
  } while (ch == ' ' || ch == '\t');
  if (ch != EOF)
    ungetc(ch, f);
  return f;
}


/* Read a packed array of characters from a file. */

Void P_readpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	if (len <= 0)
	    return;
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	*s++ = ch;
	--len;
    }
    while (--len >= 0)
	*s++ = ' ';
    if (ch != EOF)
	ungetc(ch, f);
}

Void P_readlnpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	if (len > 0) {
	    *s++ = ch;
	    --len;
	}
    }
    while (--len >= 0)
	*s++ = ' ';
}


/* Compute maximum legal "seek" index in file (0-based). */

long P_maxpos(f)
FILE *f;
{
    long savepos = ftell(f);
    long val;

    if (fseek(f, 0L, SEEK_END))
        return -1;
    val = ftell(f);
    if (fseek(f, savepos, SEEK_SET))
        return -1;
    return val;
}


/* Use packed array of char for a file name. */

Char *P_trimname(fn, len)
register Char *fn;
register int len;
{
    static Char fnbuf[256];
    register Char *cp = fnbuf;
    
    while (--len >= 0 && *fn && !isspace(*fn))
	*cp++ = *fn++;
    *cp = 0;
    return fnbuf;
}




/* Pascal's "memavail" doesn't make much sense in Unix with virtual memory.
   We fix memory size as 10Meg as a reasonable compromise. */

long memavail()
{
    return 10000000;            /* worry about this later! */
}

long maxavail()
{
    return memavail();
}




/* Sets are stored as an array of longs.  S[0] is the size of the set;
   S[N] is the N'th 32-bit chunk of the set.  S[0] equals the maximum
   I such that S[I] is nonzero.  S[0] is zero for an empty set.  Within
   each long, bits are packed from lsb to msb.  The first bit of the
   set is the element with ordinal value 0.  (Thus, for a "set of 5..99",
   the lowest five bits of the first long are unused and always zero.) */

/* (Sets with 32 or fewer elements are normally stored as plain longs.) */

long *P_setunion(d, s1, s2)         /* d := s1 + s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ | *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    *dbase = d - dbase - 1;
    return dbase;
}


long *P_setint(d, s1, s2)           /* d := s1 * s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setdiff(d, s1, s2)          /* d := s1 - s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & ~*s2++;
    if (sz1 >= 0) {
        while (sz1-- >= 0)
            *d++ = *s1++;
    }
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setxor(d, s1, s2)         /* d := s1 / s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ ^ *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


int P_inset(val, s)                 /* val IN s */
register unsigned val;
register long *s;
{
    register int bit;
    bit = (int) (val % SETBITS);
    val /= SETBITS;
    if ((long)val < *s++ && ((1L<<bit) & s[val]))
	return 1;
    return 0;
}


long *P_addset(s, val)              /* s := s + [val] */
register long *s;
register unsigned val;
{
    register long *sbase = s;
    register int bit, size;
    bit = (int) (val % SETBITS);
    val /= SETBITS;
    size = (int)*s;
    if (++val >(unsigned) size) {
        s += size;
        while (val > (unsigned)size)
            *++s = 0, size++;
        *sbase = size;
    } else
        s += val;
    *s |= 1L<<bit;
    return sbase;
}


long *P_addsetr(s, v1, v2)              /* s := s + [v1..v2] */
register long *s;
register unsigned v1, v2;
{
    register long *sbase = s;
    register int b1, b2, size;
    if ((int)v1 > (int)v2)
	return sbase;
    b1 = (int) (v1 % SETBITS);
    v1 /= SETBITS;
    b2 = (int) (v2 % SETBITS);
    v2 /= SETBITS;
    size = *s;
    v1++;
    if (++v2 > (unsigned)size) {
        while (v2 > (unsigned)size)
            s[++size] = 0;
        s[v2] = 0;
        *s = (long)v2;
    }
    s += v1;
    if (v1 == v2) {
        *s |= (~((-2L)<<(b2-b1))) << b1;
    } else {
        *s++ |= (-1L) << b1;
        while (++v1 < v2)
            *s++ = -1;
        *s |= ~((-2L) << b2);
    }
    return sbase;
}


long *P_remset(s, val)              /* s := s - [val] */
register long *s;
register unsigned val;
{
    register int bit;
    bit = (int) (val % SETBITS);
    val /= SETBITS;
    if ((long)++val <= *s) {
	if (!(s[val] &= ~(1L<<bit)))
	    while (*s && !s[*s])
		(*s)--;
    }
    return s;
}


int P_setequal(s1, s2)              /* s1 = s2 */
register long *s1, *s2;
{
    register int size = *s1++;
    if (*s2++ != size)
        return 0;
    while (--size >= 0) {
        if (*s1++ != *s2++)
            return 0;
    }
    return 1;
}


int P_subset(s1, s2)                /* s1 <= s2 */
register long *s1, *s2;
{
    register int sz1 = *s1++, sz2 = *s2++;
    if (sz1 > sz2)
        return 0;
    while (--sz1 >= 0) {
        if (*s1++ & ~*s2++)
            return 0;
    }
    return 1;
}


long *P_setcpy(d, s)                /* d := s */
register long *d, *s;
{
    register long *save_d = d;

#ifdef SETCPY_MEMCPY
    memcpy(d, s, (*s + 1) * sizeof(long));
#else
    register int i = *s + 1;
    while (--i >= 0)
        *d++ = *s++;
#endif
    return save_d;
}


/* s is a "smallset", i.e., a 32-bit or less set stored
   directly in a long. */

long *P_expset(d, s)                /* d := s */
register long *d;
register long s;
{
    if (s) {
	d[1] = s;
	*d = 1;
    } else
        *d = 0;
    return d;
}


long P_packset(s)                   /* convert s to a small-set */
register long *s;
{
    if (*s++)
        return *s;
    else
        return 0;
}







int _OutMem()
{
    return _Escape(-2);
}

int _CaseCheck()
{
    return _Escape(-9);
}

int _NilCheck()
{
    return _Escape(-3);
}





/* The following is suitable for the HP Pascal operating system.
   It might want to be revised when emulating another system. */

char *_ShowEscape(buf, code, ior, prefix)
char *buf, *prefix;
int code, ior;
{
    char *bufp;

    if (prefix && *prefix) {
        strcpy(buf, prefix);
	strcat(buf, ": ");
        bufp = buf + strlen(buf);
    } else {
        bufp = buf;
    }
    if (code == -10) {
        snprintf(bufp,80, "Pascal system I/O error %d", ior);
        switch (ior) {
            case 3:
                strcat(buf, " (illegal I/O request)");
                break;
            case 7:
                strcat(buf, " (bad file name)");
                break;
            case FileNotFound:   /*10*/
                strcat(buf, " (file not found)");
                break;
            case FileNotOpen:    /*13*/
                strcat(buf, " (file not open)");
                break;
            case BadInputFormat: /*14*/
                strcat(buf, " (bad input format)");
                break;
            case 24:
                strcat(buf, " (not open for reading)");
                break;
            case 25:
                strcat(buf, " (not open for writing)");
                break;
            case 26:
                strcat(buf, " (not open for direct access)");
                break;
            case 28:
                strcat(buf, " (string subscript out of range)");
                break;
            case EndOfFile:      /*30*/
                strcat(buf, " (end-of-file)");
                break;
            case FileWriteError: /*38*/
		strcat(buf, " (file write error)");
		break;
        }
    } else {
        snprintf(bufp,80, "Pascal system error %d", code);
        switch (code) {
            case -2:
                strcat(buf, " (out of memory)");
                break;
            case -3:
                strcat(buf, " (reference to NIL pointer)");
                break;
            case -4:
                strcat(buf, " (integer overflow)");
                break;
            case -5:
                strcat(buf, " (divide by zero)");
                break;
            case -6:
                strcat(buf, " (real math overflow)");
                break;
            case -8:
                strcat(buf, " (value range error)");
                break;
            case -9:
                strcat(buf, " (CASE value range error)");
                break;
            case -12:
                strcat(buf, " (bus error)");
                break;
            case -20:
                strcat(buf, " (stopped by user)");
                break;
        }
    }
    return buf;
}


int _Escape(code)
int code;
{
    char buf[100];

    P_escapecode = code;
    if (__top_jb) {
	__p2c_jmp_buf *jb = __top_jb;
	__top_jb = jb->next;
	longjmp(jb->jbuf, 1);
    }
    if (code == 0)
        exit(EXIT_SUCCESS);
    if (code == -1)
        exit(EXIT_FAILURE);
    fprintf(stderr, "%s\n", _ShowEscape(buf, P_escapecode, P_ioresult, ""));
    exit(EXIT_FAILURE);
}

int _EscIO(code)
int code;
{
    P_ioresult = code;
    return _Escape(-10);
}

int _EscIO2(code, name)
int code;
char *name;
{
    P_ioresult = code;
    if (!__top_jb && name && *name) {
	char buf[100];
	fprintf(stderr, "%s: %s\n",
		name, _ShowEscape(buf, P_escapecode, P_ioresult, ""));
	exit(EXIT_FAILURE);
    }
    return _Escape(-10);
}

/* End. */


typedef struct TPoint {
  long X, Y, C, H, N, O, P, S, Si, B, Br, Cl, F, I, Al, Ag, As,Au, Ba, Be, Bi, Ca, Cd, 
       Co, Cr, Cs, Cu, Fe, Ga, Ge, Hf, Hg, In, Ir, Li, Lu, Mg, Mn, Mo, Na, Nb, Ni, Os, K, Pb, Pd, Pt, Rb, 
       Re, Rh, Ru, Sb, Sc, Se, Sn, Sr, Ta, Te, Ti, Tl, V, W, Ytt, Zn, Zr, RecCount;
  struct TPoint *Last;
} TPoint;

typedef struct TBond {
  long X1, Y1, X2, Y2, RecCount;
  struct TBond *Last;
} TBond;


Static long C, H, N, O, P, S, Si, B, Br, Cl, F, I, Al, Ag, As, Au, Ba, Be, Bi, Ca, Cd, 
            Co, Cr, Cs, Cu, Fe, Ga, Ge, Hf, Hg, In, Ir, Li, Lu, Mg, Mn, Mo, Na, Nb, Ni, Os, K, Pb,
            Pd, Pt, Rb, Re, Rh, Ru, Sb, Sc, Se, Sn, Sr, Ta, Te, Ti, Tl, V, W, Ytt, Zn, Zr, X1, X2, Y1, Y2, T, D;
Static FILE *IFile;
Static TPoint *Point, *Last, *Current;
Static TBond *Bond, *LastB, *CurrentB;
Static Char sss[256], A[256], subs[256], Alert[256];
Static Char sssb[7];
Static double M, Me;
Static Char separator;
Static long Count, code, atoms, rep, range, bonds;
Static boolean Abandon, debug, verbose, fa, nobonds;
Static long Sensi = 5;   /*bonds and labels joint precision sensitivity*/
Static Char IFile_NAME[_FNSIZE];


Static Void doBonds()
{
  do {
    if (!fgets(sss,256,IFile)) return;
    sscanf(sss, "%ld%ld%ld%ld%ld%ld%*[^\n]", &X1, &Y1, &X2, &Y2, &T, &D);
    /*getc(IFile);*/
    bonds--;
    if (debug)
      printf("%ld; %ld; %ld; %ld; %ld; %ld\n", X1, Y1, X2, Y2, T, D);
    if (D == 1 || T == 8){
	if (debug) printf("skipped\n");
	 continue;
	}
	if (debug) printf("parsed\n");
    if (T == 11)
      range = ((X1 - X2) * (X1 - X2) + (Y1 - Y2) * (Y1 - Y2)) * 4;

    LastB = Bond;
    Bond = (TBond *)malloc(sizeof(TBond));
    if (Bond == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
    Bond->X1 = X1;
    Bond->X2 = X2;
    Bond->Y1 = Y1;
    Bond->Y2 = Y2;
    Bond->Last = LastB;
    CurrentB = Bond;
    Bond = Bond->Last;
    while (Bond->Last != NULL) {
      if ((labs(Bond->X1 - X1) < Sensi && labs(Bond->Y1 - Y1) < Sensi &&
	   labs(Bond->X2 - X2) < Sensi && labs(Bond->Y2 - Y2) < Sensi) ||
	  (labs(Bond->X2 - X1) < Sensi && labs(Bond->Y2 - Y1) < Sensi &&
	   labs(Bond->X1 - X2) < Sensi && labs(Bond->Y1 - Y2) < Sensi)) {
	if (debug)
	  printf("  ! Bond overlap\n");
	strcat(Alert, "!");
      }
      Bond = Bond->Last;
    }
    Bond = CurrentB;

    Abandon = false;
    Current = Point;
    while (Point->Last != NULL) {
      if (T == 11) {
	Abandon = true;
	if ((Point->X - X1) * (Point->X - X1) +
	    (Point->Y - Y1) * (Point->Y - Y1) < range) {
	  if (Point->H > 0)
	    Point->H--;
	  if (debug)
	    printf("Ring --> stripped one H from %ld %ld\n",
		   Point->X, Point->Y);
	}
      } else {
	if (labs(Point->X - X1) < Sensi && labs(Point->Y - Y1) < Sensi) {
	  if (debug)
	    printf("  %ld --> Joined at %ld %ld\n", Point->RecCount, X1, Y1);
	  if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	      T == 13)
	    Point->H--;
	  if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15 )
	    Point->H -= 2;
	  if (T == 3)
	    Point->H -= 3;
	  if (Point->H < 0) {
	  	if (debug) printf("Point^.X=%ld, Point^.Y=%ld has H count <0 !\n",Point->X,Point->Y);
	  	Point->H = 0;
	  	}
	  Abandon = true;
	}
      }
      Point = Point->Last;
    }
    Point = Current;

    if (!Abandon) {
      Count++;
      Last = Point;
      Point = (TPoint *)malloc(sizeof(TPoint));
      if (Point == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
      Point->X = X1;
      if (debug)
	printf("  Point^.X=%ld", Point->X);
      Point->Y = Y1;
      if (debug)
	printf("  Point^.Y=%ld", Point->Y);
      if (T != 11 && T != 9)
	Point->C = 1;
      else
	Point->C = 0;
      if (debug)
	printf("  Point^.C=%ld", Point->C);
      if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	  T == 13)
	Point->H = 3;
      if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15)
	Point->H = 2;
      if (T == 3)
	Point->H = 1;
      if (debug)
	printf("  Point^.H=%ld", Point->H);
      Point->N = 0;
      Point->O = 0;
      Point->P = 0;
      Point->S = 0;
      Point->Si = 0;
      Point->B = 0;
      Point->Br = 0;
      Point->Cl = 0;
      Point->F = 0;
      Point->I = 0;
      Point->Al = 0;
      Point->Ag = 0;
      Point->As = 0;
      Point->Au = 0;
      Point->Ba = 0;
      Point->Be = 0;
      Point->Bi = 0;
      Point->Ca = 0;
      Point->Cd = 0;
      Point->Co = 0;
      Point->Cr = 0;
      Point->Cs = 0;
      Point->Cu = 0;
      Point->Fe = 0;
      Point->Ga = 0;
      Point->Ge = 0;
      Point->Hf = 0;
      Point->Hg = 0;
      Point->In = 0;
      Point->Ir = 0;
      Point->Li = 0;
      Point->Lu = 0;
      Point->Na = 0;
      Point->Nb = 0;
      Point->Ni = 0;
      Point->Os = 0;
      Point->Mg = 0;
      Point->Mn = 0;
      Point->Mo = 0;
      Point->K = 0;
      Point->Pb = 0;
      Point->Pd = 0;
      Point->Pt = 0;
      Point->Rb = 0;
      Point->Re = 0;
      Point->Rh = 0;
      Point->Ru = 0;
      Point->Sb = 0;
      Point->Sc = 0;
      Point->Se = 0;
      Point->Sn = 0;
      Point->Sr = 0;
      Point->Ta = 0;
      Point->Te = 0;
      Point->Ti = 0;
      Point->Tl = 0;
      Point->V = 0;
      Point->W = 0;
      Point->Ytt = 0;
      Point->Zn = 0;
      Point->Zr = 0;
      Point->RecCount = Count;
      if (debug)
	printf("  Point^.RecCount=%ld\n", Point->RecCount);
      Point->Last = Last;
    }

    if (T != 11) {
      Abandon = false;
      Current = Point;
      while (Point->Last != NULL) {
	if (labs(Point->X - X2) < Sensi && labs(Point->Y - Y2) < Sensi) {
	  if (debug)
	    printf("  %ld --> Joined at %ld %ld\n", Point->RecCount, X2, Y2);
	  if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	      T == 13)
	    Point->H--;
	  if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15)
	    Point->H -= 2;
	  if (T == 3)
	    Point->H -= 3;
	  if (Point->H < 0) {
	  	  	  if (debug) printf("Point^.X=%ld, Point^.Y=%ld has H count <0 !\n",Point->X,Point->Y);
			  Point->H = 0;
			  }
	  Abandon = true;
	}
	Point = Point->Last;
      }
      Point = Current;

      if (!Abandon) {
	Count++;
	Last = Point;
	Point = (TPoint *)malloc(sizeof(TPoint));
        if (Point == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
	Point->X = X2;
	if (debug)
	  printf("  Point^.X=%ld", Point->X);
	Point->Y = Y2;
	if (debug)
	  printf("  Point^.Y=%ld", Point->Y);
	if (T != 11 && T != 9)
	  Point->C = 1;
	else
	  Point->C = 0;
	if (debug)
	  printf("  Point^.C=%ld", Point->C);
	if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	    T == 13)
	  Point->H = 3;
	if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15 )
	  Point->H = 2;
	if (T == 3)
	  Point->H = 1;
	if (debug)
	  printf("  Point^.H=%ld", Point->H);
	Point->N = 0;
	Point->O = 0;
	Point->P = 0;
	Point->S = 0;
	Point->Si = 0;
	Point->B = 0;
	Point->Br = 0;
	Point->Cl = 0;
	Point->F = 0;
	Point->I = 0;
	Point->Al = 0;
	Point->Ag = 0;
	Point->As = 0;
        Point->Au = 0;
	Point->Ba = 0;
	Point->Be = 0;
        Point->Bi = 0;
	Point->Ca = 0;
	Point->Cd = 0;
	Point->Co = 0;
	Point->Cr = 0;
	Point->Cs = 0;
	Point->Cu = 0;
	Point->Fe = 0;
        Point->Ga = 0;
        Point->Ge = 0;
        Point->Hf = 0;
        Point->Hg = 0;
        Point->In = 0;
        Point->Ir = 0;
	Point->Li = 0;
        Point->Lu = 0;
	Point->Mg = 0;
	Point->Mn = 0;
        Point->Mo = 0;
	Point->Na = 0;
        Point->Nb = 0;
	Point->Ni = 0;
      Point->Os = 0;
	Point->K = 0;
      Point->Pb = 0;
      Point->Pd = 0;
      Point->Pt = 0;
      Point->Rb = 0;
      Point->Re = 0;
      Point->Rh = 0;
      Point->Ru = 0;
      Point->Sb = 0;
      Point->Sc = 0;
      Point->Se = 0;
      Point->Sn = 0;
      Point->Sr = 0;
      Point->Ta = 0;
      Point->Te = 0;
      Point->Ti = 0;
      Point->Tl = 0;
      Point->V = 0;
      Point->W = 0;
      Point->Ytt = 0;
      Point->Zn = 0;
      Point->Zr = 0;
	Point->RecCount = Count;
	if (debug)
	  printf("  Point^.RecCount=%ld\n", Point->RecCount);
	Point->Last = Last;
      }
    }
  } while (bonds != 0);
}


Static Void doLabels()
{
  long mul, gmul, gmpos, ggmul, ggmpos;
  boolean stripped;
  Char STR2[256];
  long FORLIM;
  Char *TEMP;

  if (debug)
    printf("---- and now parse the labels ---------\n");
  if (verbose)
    printf("HeteroAtoms: %ld\n", atoms);
  FORLIM = atoms;
  for (rep = 1; rep <= FORLIM; rep++) {
    if (fscanf(IFile, "%ld%ld%c", &X1, &Y1, &separator)<2) return;
    if (!fgets(sss, 256, IFile))return;
    TEMP = strchr(sss, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    snprintf(A,256, "%.*s", strpos2(sss, "\t", 1) - 1, sss);

    if (debug)
      printf("Atom %s X=%ld Y=%ld sss: %s\n", A, X1, Y1, sss);
    if (nobonds)
    {   /*initialize the Point structure if no bonds, only labels, defined*/
      Count++;
      Last = Point;
      Point = (TPoint *)malloc(sizeof(TPoint));
        if (Point == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
      Point->X = X1;
      Point->Y = Y1;
      Point->C = 0;
      Point->H = 0;
      Point->N = 0;
      Point->O = 0;
      Point->P = 0;
      Point->S = 0;
      Point->Si = 0;
      Point->B = 0;
      Point->Br = 0;
      Point->Cl = 0;
      Point->F = 0;
      Point->I = 0;
      Point->Al = 0;
      Point->Ag = 0;
      Point->As = 0;
      Point->Au = 0;
      Point->Ba = 0;
      Point->Be = 0;
      Point->Bi = 0;
      Point->Ca = 0;
      Point->Cd = 0;
      Point->Co = 0;
      Point->Cr = 0;
      Point->Cs = 0;
      Point->Cu = 0;
      Point->Fe = 0;
      Point->Ga = 0;
      Point->Ge = 0;
      Point->Hf = 0;
      Point->Hg = 0;
      Point->In = 0;
      Point->Ir = 0;
      Point->Li = 0;
      Point->Lu = 0;
      Point->Mg = 0;
      Point->Mn = 0;
      Point->Mo = 0;
      Point->Na = 0;
      Point->Nb = 0;
      Point->Ni = 0;
      Point->Os = 0;
      Point->K = 0;
      Point->Pb = 0;
      Point->Pd = 0;
      Point->Pt = 0;
      Point->Rb = 0;
      Point->Re = 0;
      Point->Rh = 0;
      Point->Ru = 0;
      Point->Sb = 0;
      Point->Sc = 0;
      Point->Se = 0;
      Point->Sn = 0;
      Point->Sr = 0;
      Point->Ta = 0;
      Point->Te = 0;
      Point->Ti = 0;
      Point->Tl = 0;
      Point->V = 0;
      Point->W = 0;
      Point->Ytt = 0;
      Point->Zn = 0;
      Point->Zr = 0;
      Point->RecCount = Count;
      Point->Last = Last;
    }
    Current = Point;
    while (Point->Last != NULL) {
      if (labs(Point->X - X1) < Sensi && labs(Point->Y - Y1) < Sensi) {
	if (debug)
	  printf("  [%ld]\n", Point->RecCount);
	Point->C = 0;   /*we substitute -CH_x(-) by -R(-)*/
	Point->H = 0;
	Point->N = 0;
	Point->O = 0;
	Point->P = 0;
	Point->S = 0;
	Point->Si = 0;
	Point->B = 0;
	Point->Br = 0;
	Point->Cl = 0;
	Point->F = 0;
	Point->I = 0;
	Point->Al = 0;
        Point->Ag = 0;
	Point->As = 0;
        Point->Au = 0;
	Point->Ba = 0;
        Point->Be = 0;
        Point->Bi = 0;
	Point->Ca = 0;
	Point->Cd = 0;
	Point->Co = 0;
	Point->Cr = 0;
	Point->Cs = 0;
	Point->Cu = 0;
	Point->Fe = 0;
        Point->Ga = 0;
        Point->Ge = 0;
        Point->Hf = 0;
        Point->Hg = 0;
        Point->In = 0;
        Point->Ir = 0;
	Point->Li = 0;
        Point->Lu = 0;
	Point->Mg = 0;
	Point->Mn = 0;
        Point->Mo = 0;
	Point->Na = 0;
        Point->Nb = 0;
	Point->Ni = 0;
      Point->Os = 0;
	Point->K = 0;
      Point->Pb = 0;
      Point->Pd = 0;
      Point->Pt = 0;
      Point->Rb = 0;
      Point->Re = 0;
      Point->Rh = 0;
      Point->Ru = 0;
      Point->Sb = 0;
      Point->Sc = 0;
      Point->Se = 0;
      Point->Sn = 0;
      Point->Sr = 0;
      Point->Ta = 0;
      Point->Te = 0;
      Point->Ti = 0;
      Point->Tl = 0;
      Point->V = 0;
      Point->W = 0;
      Point->Ytt = 0;
      Point->Zn = 0;
      Point->Zr = 0;
	mul = 1;
	gmul = 1;
	ggmul = 1;
	while (*A != '\0') {
	  stripped = false;
	  if ((int)strlen(A) >= 5) {
	    snprintf(subs,256, "%.5s", A);
	    if ((int)strlen(A) > 6) {
	      if (A[5] == '_') {
	       if (A[6]!= '{') {
		snprintf(STR2,256, "%c", A[6]);
	        if (A[7]=='_') snprintf(STR2,256, "%c%c", A[6],A[8]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=7;
		while(A[mul]!='}'){STR2[mul-7]=A[mul]; mul++ ; }
		STR2[mul-6]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "TBDMS")) {  /*Tert-butyldimethylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 6;
	      Point->H += mul * 15;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 6, (int)(strlen(A) - 5)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TBDPS")) {  /*Tert-butyldiphenylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 16;
	      Point->H += mul * 19;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 6, (int)(strlen(A) - 5)));
	      stripped = true;
	    }
	    if (A[0] == '[') {
	      ggmpos = strpos2(A, "]", 1);
	      if (ggmpos != 0) {
		if (A[ggmpos] == '_') {
	       if (A[ggmpos+1]!= '{') {
		snprintf(STR2,256, "%c", A[ggmpos+1]);
	        if (A[ggmpos+2]=='_') snprintf(STR2,256, "%c%c", A[ggmpos+1],A[ggmpos+3]);
		code = (sscanf(STR2, "%ld", &ggmul) == 0);
		}else{
		ggmul=ggmpos+2;
		while(A[ggmul]!='}'){STR2[ggmul-ggmpos-2]=A[ggmul]; ggmul++ ; }
		STR2[ggmul-ggmpos-1]='\0'; 
		code = (sscanf(STR2, "%ld", &ggmul) == 0);
		}  
		} else
		  ggmul = 1;
	      }
	    }
	    if (A[0] == '(') {
	      gmpos = strpos2(A, ")", 1);
	      if (gmpos != 0) {
		if (A[gmpos] == '_') {
	       if (A[gmpos+1]!= '{') {
		snprintf(STR2,256, "%c", A[gmpos+1]);
	        if (A[gmpos+2]=='_') snprintf(STR2,256, "%c%c", A[gmpos+1],A[gmpos+3]);
		code = (sscanf(STR2, "%ld", &gmul) == 0);
		}else{
		gmul=gmpos+2;
		while(A[gmul]!='}'){STR2[gmul-gmpos-2]=A[gmul]; gmul++ ; }
		STR2[gmul-gmpos-1]='\0'; 
		code = (sscanf(STR2, "%ld", &gmul) == 0);
		}  
		} else
		  gmul = 1;
	      }
	    }
	  }
	  if ((int)strlen(A) >= 4 && !stripped) {
	    snprintf(subs,256, "%.4s", A);
	    if ((int)strlen(A) > 5) {
	      if (A[4] == '_') {
	       if (A[5]!= '{') {
		snprintf(STR2,256, "%c", A[5]);
	        if (A[6]=='_') snprintf(STR2,256, "%c%c", A[5],A[7]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=6;
		while(A[mul]!='}'){STR2[mul-6]=A[mul]; mul++ ; }
		STR2[mul-5]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "DBAM"))
	    {  /*dibutylaminomethylene; =R, used as the N prot.*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 9;
	      Point->H += mul * 19;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "DMAM"))
	    {  /*dimethylaminomethylene; =R, used as the N prot.*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "DMTr")) {  /*dimethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 21;
	      Point->H += mul * 19;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MMTr")) {  /*monomethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 20;
	      Point->H += mul * 16;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TMTr")) {  /*trimethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 22;
	      Point->H += mul * 22;
	      Point->O += mul * 3;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	  }
	  if ((int)strlen(A) >= 3 && !stripped) {
	    snprintf(subs,256, "%.3s", A);
	    if ((int)strlen(A) > 4) {
	      if (A[3] == '_') {
	       if (A[4]!= '{') {
		snprintf(STR2,256, "%c", A[4]);
	        if (A[5]=='_') snprintf(STR2,256, "%c%c", A[4],A[6]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=5;
		while(A[mul]!='}'){STR2[mul-5]=A[mul]; mul++ ; }
		STR2[mul-4]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "Ade")) {  /*Adeninyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 4;
	      Point->N += mul * 5;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "BOC")) {  /*Butyloxycarbonyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 9;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cyt")) {  /*Cytosinyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 4;
	      Point->N += mul * 3;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Gua")) {  /*Guaninyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 4;
	      Point->N += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "iBu")) {  /*iso-Butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "iPr")) {  /*2-Propyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MOC")) {  /*Methoxycarbonyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 3;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MOM")) {  /*Methoxymethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "tBu")) {  /*t-Butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Thy")) {  /*Thyminyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 5;
	      Point->N += mul * 2;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TMS")) {  /*Trimethylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 9;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tol")) {  /*tolyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 8;
	      Point->H += mul * 7;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ura")) {  /*Uracilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 3;
	      Point->N += mul * 2;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	  }
	  if ((int)strlen(A) >= 2 && !stripped) {
	    snprintf(subs,256, "%.2s", A);
	    if ((int)strlen(A) > 3) {
	      if (A[2] == '_') {
	       if (A[3]!= '{') {
		snprintf(STR2,256, "%c", A[3]);
	        if (A[4]=='_') snprintf(STR2,256, "%c%c", A[3],A[5]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=4;
		while(A[mul]!='}'){STR2[mul-4]=A[mul]; mul++ ; }
		STR2[mul-3]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "Ac")) {  /*acetyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 3;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Al")) {  /*alumin(i)um*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Al += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ag")) {  /*silver*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ag += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "As")) {  /*arsenic*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->As += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Au")) {  /*gold*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Au += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ba")) {  /*barium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ba += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Be")) {  /*beryllium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Be += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bi")) {  /*bismuth*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Bi += mul ;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bn")) {  /*benzyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Br")) {  /*bromine*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Br += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bu")) {  /*butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bz")) {  /*benzoyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "CE")) {  /*cyanoethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 4;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cl")) {  /*chlorine*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cl += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ca")) {  /*calcium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ca += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cd")) {  /*cadmium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cd += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Co")) {  /*cobalt*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Co += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cr")) {  /*chromium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cr += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cs")) {  /*cesium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cs += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cu")) {  /*copper*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cu += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Et")) {  /*ethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 5;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Fe")) {  /*iron*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Fe += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ga")) {  /*gallium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ga += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ge")) {  /*germanium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ge += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Hf")) {  /*hafnium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Hf += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Hg")) {  /*mercury*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Hg += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "In")) {  /*indium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->In += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ir")) {  /*iridium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ir += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Li")) {  /*lithium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Li += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Lu")) {  /*lutetium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Lu += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Me")) {  /*methyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->H += mul * 3;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ms")) {  /*methanesulfonyl, mesyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->H += mul * 3;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Mg")) {  /*magnesium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Mg += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Mn")) {  /*manganese*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Mn += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Mo")) {  /*molybdenum*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Mo += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Na")) {  /*sodium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Na += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Nb")) {  /*niobium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Nb += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ni")) {  /*nickel*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ni += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Os")) {  /*osmium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Os += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Pb")) {  /*lead*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Pb += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Pd")) {  /*palladium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Pd += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ph")|| !strcmp(subs,"@F")) {  /*phenyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 6;
	      Point->H += mul * 5;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Pr")) {  /*propyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Pt")) {  /*platinum*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Pt += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Rb")) {  /*rubidium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Rb += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Re")) {  /*rhenium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Re += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Rh")) {  /*rhodium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Rh += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ru")) {  /*ruthenium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ru += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Sb")) {  /*antimony*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Sb += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Sc")) {  /*scandium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Sc += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Se")) {  /*selenium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Se += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Sn")) {  /*tin*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Sn += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Sr")) {  /*strontium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Sr += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ta")) {  /*tantal*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ta += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Te")) {  /*tellurium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Te += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ti")) {  /*titanium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Ti += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tf")) {  /*trifluoromethanesulfonyl, triflyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->F += mul * 3;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tl")) {  /*thallium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Tl += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tr")) {  /*trityl, triphenylmethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 19;
	      Point->H += mul * 15;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ts")) {  /*toluenesulfonyl, tosyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 7;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Si")) {  /*silicon*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Zn")) {  /*zinc*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Zn += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Zr")) {  /*zirconium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Zr += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	  }
	  if ((int)strlen(A) < 1 || stripped)
	    continue;
	  snprintf(subs,256, "%.1s", A);
	  if ((int)strlen(A) > 2) {
	    if (A[1] == '_') {
	       if (A[2]!= '{') {
		snprintf(STR2,256, "%c", A[2]);
	        if (A[3]=='_') snprintf(STR2,256, "%c%c", A[2],A[4]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=3;
		while(A[mul]!='}'){STR2[mul-3]=A[mul]; mul++ ; }
		STR2[mul-2]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	    } else
	      mul = 1;
	  }
	  mul *= gmul * ggmul;
	  if (!strcmp(subs, "B")) {  /*boron*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->B += mul;
	  }
	  if (!strcmp(subs, "C")) {  /*carbon*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->C += mul;
	  }
	  if (!strcmp(subs, "F")) {  /*fluorine*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->F += mul;
	  }
	  if (!strcmp(subs, "H")) {  /*hydrogen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->H += mul;
	  }
	  if (!strcmp(subs, "I")) {  /*iodine*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->I += mul;
	  }
	  if (!strcmp(subs, "K")) {  /*potassium*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->K += mul;
	  }
	  if (!strcmp(subs, "N")) {  /*nitrogen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->N += mul;
	  }
	  if (!strcmp(subs, "O")) {  /*oxygen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->O += mul;
	  }
	  if (!strcmp(subs, "P")) {  /*phosphorus*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->P += mul;
	  }
	  if (!strcmp(subs, "S")) {  /*sulfur*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->S += mul;
	  }
	  if (!strcmp(subs, "V")) {  /*vanadium*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->V += mul;
	  }
	  if (!strcmp(subs, "W")) {  /*tungsten*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->W += mul;
	  }
	  if (!strcmp(subs, "Y")) {  /*yttrium*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->Ytt += mul;
	  }
	  if (!strcmp(subs, "Z")) {  /*"Z", Benzyloxycarbonyl*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->C += mul * 8;
	    Point->H += mul * 7;
	    Point->O += mul * 2;
	  }
	  if (!strcmp(subs, ")"))  /*reset gmul*/
	    gmul = 1;
	  if (!strcmp(subs, "]")) {  /*reset gmul,ggmul*/
	    gmul = 1;
	    ggmul = 1;
	  }
	  if (true)
	    strcpy(A, strsub(STR2, A, 2, (int)(strlen(A) - 1)));
	}
      }
      Point = Point->Last;
    }
    Point = Current;
  }
}


int main(argc, argv)
int argc;
Char *argv[];
{
  Char STR1[256], STR2[256];
  Char *TEMP;
  boolean interactive=false;

  PASCAL_MAIN(argc, argv);
  IFile = NULL;
  if (P_argc == 1) {
    printf("enter \"cht -h\" for help\n");
    _Escape(0);
  }
  C = 0;
  H = 0;
  N = 0;
  O = 0;
  P = 0;
  S = 0;
  Si = 0;
  B = 0;
  Br = 0;
  I = 0;
  Cl = 0;
  F = 0;
  Al = 0;
  Ag = 0;
  As = 0;
  Au = 0;
  Ba = 0;
  Be = 0;
  Bi = 0;
  Ca = 0;
  Cd = 0;
  Co = 0;
  Cr = 0;
  Cs = 0;
  Cu = 0;
  Fe = 0;
  Ga = 0;
  Ge = 0;
  Hf = 0;
  Hg = 0;
  In = 0;
  Ir = 0;
  Li = 0;
  Lu = 0;
  Mg = 0;
  Mn = 0;
  Mo = 0;
  Na = 0;
  Nb = 0;
  Ni = 0;
  Os = 0;
  K = 0;
  Pb = 0;
  Pd = 0;
  Pt = 0;
  Rb = 0;
  Re = 0;
  Rh = 0;
  Ru = 0;
  Sb = 0;
  Sc = 0;
  Se = 0;
  Sn = 0;
  Sr = 0;
  Ta = 0;
  Te = 0;
  Ti = 0;
  Tl = 0;
  V = 0;
  W = 0;
  Ytt = 0;
  Zn = 0;
  Zr = 0;
  verbose = false;
  debug = false;
  fa = false;   /*no file assigned*/
  Count = 0;
  *Alert = '\0';
  for (rep = 1; rep < P_argc; rep++) {
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-v") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--verbose"))
      verbose = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-d") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--debug"))
      debug = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-i") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--interpret"))
      interactive = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-h") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--help")) {
      printf("The Chemtool drawings analyzer 1.7\n");
      printf("***   Gizmo Head Software   ***\n");
      printf("    Radek Liboska (c) 2001\n\n");
      printf("syntax: cht [-options] <filename.cht>\n\n");
      printf("Recognizes C,H,O,N,P,S,Si,B,Br,I,Cl,F,Al,Ag,As,Au,Ba,Be,Bi,Ca,Cd,Co,Cr,Cs,Cu,\nFe,Ga,Ge,Hf,Hg,In,Ir,Li,Lu,Mg,Mn,Mo,Na,Nb,Ni,Os,K,Pb,Pd,Pt,Rb,Re,Rh,Ru,Sb,Sc,Se,Sn,Sr,\nTa,Te,Ti,Tl,V,W,Y,Zn,Zr\n");
      printf(
	"        Ac,Ade,Bn,Bu,Bz,BOC,Cyt,CE,DBAM,DMAM,DMTr,Et,Gua,iBu,iPr,Me,Ms,MOC,\n");
      printf(
	"        MOM,MMTr,Ph,Pr,tBu,Tf,Thy,Tol,Tr,Ts,TBDMS,TBDPS,TMS,TMTr,Ura,Z\n");
      printf("Can handle two levels of parentheses; e.g. P[OCH(CH_3)_2]_3\n\n");
      printf("options:\n");
      printf("        -h or --help : this help\n");
      printf("        -v or --verbose : be verbose\n");
      printf("        -d or --debug : be more verbose\n\n");
      _Escape(0);
    }
    if (strcpy(STR2, P_argv[rep])[0] != '-') {
      strcpy(STR1, P_argv[rep]);
      strcpy(IFile_NAME, STR1);
      fa = true;
    }
  }
  if (!fa && !interactive) {
    printf("No file defined, enter \"cht -h\" for help\n");
    _Escape(1);
  }
  if (!interactive){
  if (IFile != NULL)
    IFile = freopen(IFile_NAME, "r", IFile);
  else
    IFile = fopen(IFile_NAME, "r");
  if (IFile == NULL)
    _EscIO2(FileNotFound, IFile_NAME);
  }else {
  if (IFile)fclose(IFile);
  IFile=tmpfile();
  fprintf(IFile,"Chemtool Version 1.0\ngeometry 100 100\n\bonds 0\natoms 1\n0	 0	%s 	0\n",IFile_NAME);
  rewind(IFile);
  }
  Point = (TPoint *)malloc(sizeof(TPoint));
        if (Point == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
  Point->X = 0;
  Point->Y = 0;
  Point->C = 0;
  Point->H = 0;
  Point->N = 0;
  Point->O = 0;
  Point->P = 0;
  Point->S = 0;
  Point->Si = 0;
  Point->B = 0;
  Point->Br = 0;
  Point->Cl = 0;
  Point->F = 0;
  Point->I = 0;
  Point->Al = 0;
  Point->As = 0;
  Point->Au = 0;
  Point->Ba = 0;
  Point->Be = 0;
  Point->Bi = 0;
  Point->Ca = 0;
  Point->Cd = 0;
  Point->Co = 0;
  Point->Cr = 0;
  Point->Cs = 0;
  Point->Cu = 0;
  Point->Fe = 0;
  Point->Ga = 0;
  Point->Ge = 0;
  Point->Hf = 0;
  Point->Hg = 0;
  Point->In = 0;
  Point->Ir = 0;
  Point->Li = 0;
  Point->Lu = 0;
  Point->Mg = 0;
  Point->Mn = 0;
  Point->Mo = 0;
  Point->Na = 0;
  Point->Nb = 0;
  Point->Ni = 0;
  Point->Os = 0;
  Point->K = 0;
  Point->Pb = 0;
  Point->Pd = 0;
  Point->Pt = 0;
  Point->Rb = 0;
  Point->Re = 0;
  Point->Rh = 0;
  Point->Ru = 0;
  Point->Sb = 0;
  Point->Sc = 0;
  Point->Se = 0;
  Point->Sn = 0;
  Point->Sr = 0;
  Point->Ta = 0;
  Point->Te = 0;
  Point->Ti = 0;
  Point->Tl = 0;
  Point->V = 0;
  Point->W = 0;
  Point->Ytt = 0;
  Point->Zn = 0;
  Point->Zr = 0;
  Point->RecCount = Count;
  Point->Last = NULL;
  Bond = (TBond *)malloc(sizeof(TBond));
        if (Bond == NULL) { 
    	fprintf(stderr,"Could not allocate memory\n");
	exit(1);
	}
  Bond->X1 = 0;
  Bond->Y1 = 0;
  Bond->X2 = 0;
  Bond->Y2 = 0;
  Bond->RecCount = Count;
  Bond->Last = NULL;
  if (!fgets(sss, 256, IFile))exit(2);
  TEMP = strchr(sss, '\n');
  if (TEMP != NULL)
    *TEMP = 0;
  snprintf(sss,256, "%.18s", strcpy(STR1, sss));
  if (strcmp(sss, "Chemtool Version 1")) {
    printf("Not a chemtool 1.x file, enter \"cht -h\" for help\n");
    printf("file starts: %s\n",sss);
    _Escape(2);
  }
  if (fscanf(IFile, "%*[^\n]") == EOF) exit(2);
  getc(IFile);
  if (!fgets(sssb, 7, IFile))exit(2);
  TEMP = strchr(sssb, '\n');
  if (TEMP != NULL) {
    *TEMP = 0;
    ungetc('\n', IFile);
  }
  if (fscanf(IFile, "%ld%*[^\n]", &bonds) == EOF) bonds = 0;
  getc(IFile);
  if (bonds == 0)
    nobonds = true;
  if (!strcmp(sssb, "bonds ")) {
    if (bonds > 0)
      doBonds();
  }
  if (!fgets(sssb, 7, IFile))exit(2);
  TEMP = strchr(sssb, '\n');
  if (TEMP != NULL) {
    *TEMP = 0;
    ungetc('\n', IFile);
  }
  if (fscanf(IFile, "%ld%*[^\n]", &atoms) == EOF) atoms = 0;
  getc(IFile);
  if (!strcmp(sssb, "atoms ")) {
    if (atoms > 0)
      doLabels();
  }
  if (IFile != NULL)
    fclose(IFile);
  IFile = NULL;
  if (verbose)
    printf("---------------------- Summary -------------------------\n");
  while (Point->Last != NULL) {
    if (verbose)
      printf(
	"RecCount: %ld X=%ld Y=%ld C%ld H%ld N%ld O%ld P%ld S%ld Si%ld B%ld\nBr%ld Cl%ld F%ld I%ld Al%ld Ag%ld As%ld Au%ld Ba%ld Be%ld Bi%ld Ca%ld Cd%ld Co%ld\nCr%ld Cs%ld Cu%ld Fe%ld Ga%ld Ge%ld Hf%ld Hg%ld In%ld Ir%ld Li%ld Lu%ld Mg%ld Mn%ld\n Mo%ld Na%ld Nb%ld Ni%ld Os%ld K%ld Pb%ld Pd%ld Pt%ld Rb%ld Re%ld Rh%ld Ru%ld Sb%ld\n Sc%ld Se%ld Sn%ld Sr%ld Ta%ld Te%ld Ti%ld Tl%ld V%ld W%ld Y%ld Zn%ld Zr%ld\n",
	Point->RecCount, Point->X, Point->Y, Point->C, Point->H, Point->N,
	Point->O, Point->P, Point->S, Point->Si, Point->B, Point->Br,
	Point->Cl, Point->F, Point->I, Point->Al, Point->Ag, Point->As, Point->Au, Point->Ba, 
	Point->Be,Point->Bi, Point->Ca, Point->Cd, Point->Co,
	Point->Cr, Point->Cs,Point->Cu,Point->Fe,Point->Ga,Point->Ge,Point->Hf,Point->Hg,
	Point->In, Point->Ir, Point->Li,Point->Lu,Point->Mg, Point->Mn, Point->Mo, Point->Na, Point->Nb,Point->Ni, 
	Point->Os,Point->K,Point->Pb,Point->Pd, Point->Pt, Point->Rb, Point->Re, Point->Rh, Point->Ru, 
	Point->Sb,Point->Sc,Point->Se,Point->Sn,Point->Sr,Point->Ta,
	Point->Te,Point->Ti,Point->Tl,Point->V,Point->W,Point->Ytt,Point->Zn,Point->Zr);
    C += Point->C;
    H += Point->H;
    N += Point->N;
    O += Point->O;
    P += Point->P;
    S += Point->S;
    Si += Point->Si;
    B += Point->B;
    Br += Point->Br;
    Cl += Point->Cl;
    F += Point->F;
    I += Point->I;
    Al += Point->Al;
    Ag += Point->Ag;
    As += Point->As;
    Au += Point->Au;
    Ba += Point->Ba;
    Be += Point->Be;
    Bi += Point->Bi;
    Ca += Point->Ca;
    Cd += Point->Cd;
    Co += Point->Co;
    Cr += Point->Cr;
    Cs += Point->Cs;
    Cu += Point->Cu;
    Fe += Point->Fe;
    Ga += Point->Ga;
    Ge += Point->Ge;
    Hf += Point->Hf;
    Hg += Point->Hg;
    In += Point->In;
    Ir += Point->Ir;
    Li += Point->Li;
    Lu += Point->Lu;
    Mg += Point->Mg;
    Mn += Point->Mn;
    Mo += Point->Mo;
    Na += Point->Na;
    Nb += Point->Nb;
    Ni += Point->Ni;
    Os += Point->Os;
    K += Point->K;
    Pb +=  Point->Pb;
    Pd +=  Point->Pd;
    Pt +=  Point->Pt;
    Rb +=  Point->Rb;
    Re +=  Point->Re;
    Rh +=  Point->Rh;
    Ru +=  Point->Ru;
    Sb +=  Point->Sb;
    Sc +=  Point->Sc;
    Se +=  Point->Se;
    Sn +=  Point->Sn;
    Sr +=  Point->Sr;
    Ta +=  Point->Ta;
    Te +=  Point->Te;
    Ti +=  Point->Ti;
    Tl +=  Point->Tl;
    V += Point->V;
    W += Point->W;
    Ytt += Point->Ytt;
    Zn += Point->Zn;
    Zr += Point->Zr;
    Point = Point->Last;
  }

  if (H < 0)   /*overlapped bonds*/
    H = 0;

  M = (double)C * 12.011 + (double)H * 1.0079 + (double)N * 14.0067 + (double)O * 15.9994 + (double)P * 30.97376 +
      (double)S * 32.064 + (double)Si * 28.086 + (double)B * 10.81 + (double)Br * 79.904 + (double)Cl * 35.453 +
      (double)F * 18.9984 + (double)I * 126.9045 + (double)Mg * 24.305 + (double)Na * 22.98977 + (double)K * 39.098 + 
      (double)Ca * 40.08 + (double)Cd * 112.41 + (double)Co * 58.933 + (double)Cr * 51.996 + (double)Cu * 63.546 + 
      (double)Fe * 55.847 + (double)Li * 6.941 + (double)Mn * 54.938 + (double)Ni * 58.69 + (double)Al * 26.981539 +
      (double)Ba * 137.327 + (double)Cs * 132.90543 + (double)As * 74.92159 + (double)Be *9.012182 +
      (double)Ga * 69.723 + (double)Ge * 72.61 + (double)Sb * 121.75 + (double)Sc * 44.95591 + (double)Se * 78.96 +
      (double)Sn * 118.710 + (double)Sr * 87.62 + (double)Rb * 85.4678 + (double)Te * 127.60 + (double)Ti * 47.88 +
      (double)V * 50.9415 + (double)Zn * 65.39 + (double)In * 114.82 + (double)Bi * 208.98037 + (double)Pb *207.2 +
      (double)Tl * 204.3833 + (double)Zr *91.224 + (double)Nb * 92.906 + (double)Mo*95.94 +
      (double)Ru * 101.07 + (double)Rh *102.9055 + (double)Re * 186.207 + (double)Pd *106.42 +
      (double)Ag *107.868 + (double)Pt *195.078 + (double)Ir * 192.217 + (double)Hg * 200.59 +
      (double)Os *190.2 + (double)W * 183.84 + (double)Au * 196.966 + (double)Ta *180.948 +
      (double)Hf * 178.49 + (double)Ytt * 88.906 + (double)Lu *174.967;
      
  Me = (double)C * 12. + (double)H * 1.007825037 + (double)N * 14.003074008 + (double)O * 15.99491464 +
       (double)P * 30.9737634 + (double)S * 31.9720718 + (double)Si * 27.9769284 + (double)B * 11.0093053 +
       (double)Br * 78.9183361 + (double)Cl * 34.968852729 + (double)F * 18.99840325 +
       (double)I * 126.904477 + (double)Mg * 23.9850450 + (double)Na * 22.9897697 + (double)K * 38.9637079 +
      (double)Ca * 39.9626 + (double)Cd * 113.9034 + (double)Co * 58.9332 + (double)Cr * 51.9405 + (double)Cu * 62.9296 +
      (double)Fe * 55.9349 +(double)Li * 7.0160 + (double)Mn * 54.93805 + (double)Ni * 57.9353 + (double)Al * 26.981539 +
      (double)Ba * 137.9052 + (double)Cs * 132.90543 + (double)As * 74.92159 + (double)Be * 9.012182 +
      (double)Ga * 68.9256 + (double)Ge * 73.9212 + (double)Sb * 120.9038 + (double)Sc * 44.95591 + 
      (double)Se *79.9165 + (double)Sn * 119.9022 + (double)Sr * 87.9056 + (double)Rb * 84.9118 + 
      (double)Te * 129.9062 + (double)Ti * 47.9479 + (double)V * 50.9440 + (double)Zn * 63.9291 + 
      (double)In * 114.9039 + (double)Bi * 208.98037 + (double)Pb * 207.9766 + (double)Tl * 204.9744 +
      (double)Zr * 89.9047 + (double)Nb *92.9064 + (double)Mo * 97.9054 + (double)Ru * 101.9043 +
      (double)Rh * 102.9055 + (double)Re * 186.9558 + (double)Pd * 105.9035 +(double)Ag * 106.9051 +
      (double)Pt * 194.9648 + (double)Ir * 192.9629 + (double)Hg * 201.9706 +(double)Os * 191.9615 +
      (double)W * 183.9510 + (double)Au * 196.9666 + (double)Ta * 180.9480 + (double)Hf * 179.9466 +
      (double)Ytt * 88.9059 + (double)Lu * 174.9408; 

  if (Me > 0 && *Alert == '\0') {
    if (C > 1)
      printf("C%ld", C);
    if (C == 1)
      putchar('C');
    if (H > 1)
      printf("H%ld", H);
    if (H == 1)
      putchar('H');
    if (N > 1)
      printf("N%ld", N);
    if (N == 1)
      putchar('N');
    if (O > 1)
      printf("O%ld", O);
    if (O == 1)
      putchar('O');
    if (P > 1)
      printf("P%ld", P);
    if (P == 1)
      putchar('P');
    if (S > 1)
      printf("S%ld", S);
    if (S == 1)
      putchar('S');
    if (Si > 1)
      printf("Si%ld", Si);
    if (Si == 1)
      printf("Si");
    if (B > 1)
      printf("B%ld", B);
    if (B == 1)
      putchar('B');
    if (Br > 1)
      printf("Br%ld", Br);
    if (Br == 1)
      printf("Br");
    if (Cl > 1)
      printf("Cl%ld", Cl);
    if (Cl == 1)
      printf("Cl");
    if (F > 1)
      printf("F%ld", F);
    if (F == 1)
      putchar('F');
    if (I > 1)
      printf("I%ld", I);
    if (I == 1)
      putchar('I');
    if (Ag > 1)
      printf("Ag%ld", Ag);
    if (Ag == 1)
      printf("Ag");   
    if (Al > 1)
      printf("Al%ld", Al);
    if (Al == 1)
      printf("Al");   
    if (As > 1)
      printf("As%ld", As);
    if (As == 1)
      printf("As");   
    if (Au > 1)
      printf("Au%ld", Au);
    if (Au == 1)
      printf("Au");   
    if (Ba > 1)
      printf("Ba%ld", Ba);
    if (Ba == 1)
      printf("Ba");   
    if (Be > 1)
      printf("Be%ld", Be);
    if (Be == 1)
      printf("Be");   
    if (Bi > 1)
      printf("Bi%ld", Bi);
    if (Bi == 1)
      printf("Bi");   
    if (Ca > 1)
      printf("Ca%ld", Ca);
    if (Ca == 1)
      printf("Ca");   
    if (Cd > 1)
      printf("Cd%ld", Cd);
    if (Cd == 1)
      printf("Cd");   
    if (Co > 1)
      printf("Co%ld", Co);
    if (Co == 1)
      printf("Co");   
    if (Cr > 1)
      printf("Cr%ld", Cr);
    if (Cr == 1)
      printf("Cr");   
    if (Cs > 1)
      printf("Cs%ld", Cs);
    if (Cs == 1)
      printf("Cs");   
    if (Cu > 1)
      printf("Cu%ld", Cu);
    if (Cu == 1)
      printf("Cu");   
    if (Fe > 1)
      printf("Fe%ld", Fe);
    if (Fe == 1)
      printf("Fe");   
    if (Ga > 1)
      printf("Ga%ld", Ga);
    if (Ga == 1)
      printf("Ga");   
    if (Ge > 1)
      printf("Ge%ld", Ge);
    if (Ge == 1)
      printf("Ge");   
    if (Hf > 1)
      printf("Hf%ld", Hf);
    if (Hf == 1)
      printf("Hf");   
    if (Hg > 1)
      printf("Hg%ld", Hg);
    if (Hg == 1)
      printf("Hg");   
    if (In > 1)
      printf("In%ld", In);
    if (In == 1)
      printf("In");
    if (Ir > 1)
      printf("Ir%ld", Ir);
    if (Ir == 1)
      printf("Ir");
    if (K > 1)
      printf("K%ld", K);
    if (K == 1)
      putchar('K');
    if (Li > 1)
      printf("Li%ld", Li);
    if (Li == 1)
      printf("Li");
    if (Lu > 1)
      printf("Lu%ld", Lu);
    if (Lu == 1)
      printf("Lu");
    if (Mg > 1)
      printf("Mg%ld", Mg);
    if (Mg == 1)
      printf("Mg");
    if (Mn > 1)
      printf("Mn%ld", Mn);
    if (Mn == 1)
      printf("Mn");   
    if (Mo > 1)
      printf("Mo%ld", Mo);
    if (Mo == 1)
      printf("Mo");   
    if (Na > 1)
      printf("Na%ld", Na);
    if (Na == 1)
      printf("Na");
    if (Nb > 1)
      printf("Nb%ld", Nb);
    if (Nb == 1)
      printf("Nb");
    if (Ni > 1)
      printf("Ni%ld", Ni);
    if (Ni == 1)
      printf("Ni");   
    if (Os > 1)
      printf("Os%ld", Os);
    if (Os == 1)
      printf("Os");   
    if (Pb > 1)
      printf("Pb%ld", Pb);
    if (Pb == 1)
      printf("Pb");   
    if (Pd > 1)
      printf("Pd%ld", Pd);
    if (Pd == 1)
      printf("Pd");   
    if (Pt > 1)
      printf("Pt%ld", Pt);
    if (Pt == 1)
      printf("Pt");   
    if (Rb > 1)
      printf("Rb%ld", Rb);
    if (Rb == 1)
      printf("Rb");   
    if (Re > 1)
      printf("Re%ld", Re);
    if (Re == 1)
      printf("Re");   
    if (Rh > 1)
      printf("Rh%ld", Rh);
    if (Rh == 1)
      printf("Rh");   
    if (Ru > 1)
      printf("Rb%ld", Ru);
    if (Ru == 1)
      printf("Ru");   
    if (Sb > 1)
      printf("Sb%ld", Sb);
    if (Sb == 1)
      printf("Sb");   
    if (Sc > 1)
      printf("Sc%ld", Sc);
    if (Sc == 1)
      printf("Sc");   
    if (Se > 1)
      printf("Se%ld", Se);
    if (Se == 1)
      printf("Se");   
    if (Sn > 1)
      printf("Sn%ld", Sn);
    if (Sn == 1)
      printf("Sn");   
    if (Sr > 1)
      printf("Sr%ld", Sr);
    if (Sr == 1)
      printf("Sr");   
    if (Ta > 1)
      printf("Ta%ld", Ta);
    if (Ta == 1)
      printf("Ta");   
    if (Te > 1)
      printf("Te%ld", Te);
    if (Te == 1)
      printf("Te");   
    if (Ti > 1)
      printf("Ti%ld", Ti);
    if (Ti == 1)
      printf("Ti");   
    if (Tl > 1)
      printf("Tl%ld", Tl);
    if (Tl == 1)
      printf("Tl");   
    if (V > 1)
      printf("V%ld", V);
    if (V == 1)
      printf("V");   
    if (W > 1)
      printf("W%ld", W);
    if (W == 1)
      printf("W");   
    if (Ytt > 1)
      printf("Y%ld", Ytt);
    if (Ytt == 1)
      printf("Y");   
    if (Zn > 1)
      printf("Zn%ld", Zn);
    if (Zn == 1)
      printf("Zn");   
    if (Zr > 1)
      printf("Zr%ld", Zr);
    if (Zr == 1)
      printf("Zr");   

    printf(" [%2.3f]", M);
    printf(" Me=%2.10f ", Me);

    if (C > 0)
      printf("%4.2f%%C;", (double)C * 12.011 * 100 / M);
    if (H > 0)
      printf("%4.2f%%H;", (double)H * 1.0079 * 100 / M);
    if (B > 0)
      printf("%4.2f%%B;", (double)B * 10.81 * 100 / M);
    if (N > 0)
      printf("%4.2f%%N;", (double)N * 14.0067 * 100 / M);
    if (O > 0)
      printf("%4.2f%%O;", (double)O * 15.9994 * 100 / M);
    if (P > 0)
      printf("%4.2f%%P;", (double)P * 30.97376 * 100 / M);
    if (S > 0)
      printf("%4.2f%%S;", (double)S * 32.0640 * 100 / M);
    if (K > 0)
      printf("%4.2f%%K;", (double)K * 39.098 * 100 / M);
    if (Mg > 0)
      printf("%4.2f%%Mg;", (double)Mg * 24.305 * 100 / M);
    if (Na > 0)
      printf("%4.2f%%Na;", (double)Na * 22.98977 * 100 / M);
    if (Si > 0)
      printf("%4.2f%%Si;", (double)Si * 28.086 * 100 / M);
    if (Br > 0)
      printf("%4.2f%%Br;", (double)Br * 79.904 * 100 / M);
    if (Cl > 0)
      printf("%4.2f%%Cl;", (double)Cl * 35.453 * 100 / M);
    if (F > 0)
      printf("%4.2f%%F;",  (double)F * 18.9984 * 100 / M);
    if (I > 0)
      printf("%4.2f%%I;",  (double)I * 126.9045 * 100 / M);
    if (Ag >0)
      printf("%4.2f%%Ag;", (double)Ag * 107.868 * 100 / M);
    if (Al >0)
      printf("%4.2f%%Al;", (double)Al * 26.981539 * 100 / M);
    if (As >0)
      printf("%4.2f%%As;", (double)As * 74.92159 * 100 / M);
    if (Au >0)
      printf("%4.2f%%Au;", (double)Au * 196.966 * 100 / M);
    if (Ba >0)
      printf("%4.2f%%Ba;", (double)Ba * 137.327 * 100 / M);
    if (Be >0)
      printf("%4.2f%%Be;", (double)Be * 9.012182 * 100 / M);
    if (Bi >0)
      printf("%4.2f%%Bi;", (double)Bi * 208.98037 * 100 / M);
    if (Ca >0)
      printf("%4.2f%%Ca;", (double)Ca * 40.08 * 100 / M);
    if (Cd >0)
      printf("%4.2f%%Cd;", (double)Cd * 112.41 * 100 / M); 
    if (Co >0)
      printf("%4.2f%%Co;", (double)Co * 58.993 * 100 / M);
    if (Cr >0)
      printf("%4.2f%%Cr;", (double)Cr * 51.996 * 100 / M);
    if (Cs >0)
      printf("%4.2f%%Cs;", (double)Cs * 132.90543 * 100 / M);
    if (Cu >0)
      printf("%4.2f%%Cu;", (double)Cu * 63.546 * 100 / M);
    if (Fe >0)
      printf("%4.2f%%Fe;", (double)Fe * 55.847 * 100 / M);     
    if (Ga >0)
      printf("%4.2f%%Ga;", (double)Ga * 69.723 * 100 / M);     
    if (Ge >0)
      printf("%4.2f%%Ge;", (double)Ge * 72.61 * 100 / M);     
    if (Hf >0)
      printf("%4.2f%%Hf;", (double)Hf * 178.49 * 100 / M);     
    if (Hg >0)
      printf("%4.2f%%Hg;", (double)Hg * 200.59 * 100 / M);     
    if (In >0)
      printf("%4.2f%%In;", (double)In * 114.82 * 100 / M);
    if (Ir >0)
      printf("%4.2f%%Ir;", (double)Ir * 192.217 * 100 / M);
    if (Li >0)
      printf("%4.2f%%Li;", (double)Li * 6.941 * 100 / M);
    if (Lu >0)
      printf("%4.2f%%Lu;", (double)Lu * 174.967 * 100 / M);
    if (Mn >0)
      printf("%4.2f%%Mn;", (double)Mn * 54.938 * 100 / M);
    if (Mo >0)
      printf("%4.2f%%Mo;", (double)Mo * 95.94 * 100 / M);
    if (Nb >0)
      printf("%4.2f%%Nb;", (double)Nb * 92.906  *100 / M);
    if (Ni >0)
      printf("%4.2f%%Ni;", (double)Ni * 58.69  *100 / M);
    if (Os >0)
      printf("%4.2f%%Os;", (double)Os * 190.2  *100 / M);
    if (Pb >0)
      printf("%4.2f%%Pb;", (double)Pb * 207.2  *100 / M);
    if (Pd >0)
      printf("%4.2f%%Pd;", (double)Pd * 106.42  *100 / M);
    if (Pt >0)
      printf("%4.2f%%Pt;", (double)Pt * 195.078  *100 / M);
    if (Rb >0)
      printf("%4.2f%%Rb;", (double)Rb * 85.4678  *100 / M);
    if (Re >0)
      printf("%4.2f%%Re;", (double)Re * 186.207  *100 / M);
    if (Rh >0)
      printf("%4.2f%%Rh;", (double)Rh * 102.9055  *100 / M);
    if (Ru >0)
      printf("%4.2f%%Ru;", (double)Ru * 101.07  *100 / M);
    if (Sb >0)
      printf("%4.2f%%Sb;", (double)Sb * 121.75  *100 / M);
    if (Sc >0)
      printf("%4.2f%%Sc;", (double)Sc * 44.95591  *100 / M);
    if (Se >0)
      printf("%4.2f%%Se;", (double)Se * 78.96  *100 / M);
    if (Sn >0)
      printf("%4.2f%%Sn;", (double)Sn * 118.71  *100 / M);
    if (Sr >0)
      printf("%4.2f%%Sr;", (double)Sr * 87.62  *100 / M);
    if (Ta >0)
      printf("%4.2f%%Ta;", (double)Ta * 180.948  *100 / M);
    if (Te >0)
      printf("%4.2f%%Te;", (double)Te * 127.60  *100 / M);
    if (Ti >0)
      printf("%4.2f%%Ti;", (double)Ti * 47.88  *100 / M);
    if (Tl >0)
      printf("%4.2f%%Tl;", (double)Tl * 204.3833 *100 / M);
    if (V >0)
      printf("%4.2f%%V;", (double)V * 50.9415  *100 / M);
    if (W >0)
      printf("%4.2f%%W;", (double)W * 183.84  *100 / M);
    if (Ytt >0)
      printf("%4.2f%%Y;", (double)Ytt * 88.906  *100 / M);
    if (Zn >0)
      printf("%4.2f%%Zn;", (double)Zn * 65.39  *100. / M);
    if (Zr >0)
      printf("%4.2f%%Zr;", (double)Zr * 91.224  *100. / M);
  } else {
    if (*Alert != '\0')
      printf("%s overlapped bonds !", Alert);
    else
      printf("C0H0 [0.00] Me=0.0000000000 0.00%%C;0.00%%H");
  }
  putchar('\n');
  exit(EXIT_SUCCESS);
}



/* End. */
