// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetIdentityIDReader is a Reader for the GetIdentityID structure.
type GetIdentityIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIdentityIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewGetIdentityIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetIdentityIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetIdentityIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 520:
		result := NewGetIdentityIDUnreachable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 521:
		result := NewGetIdentityIDInvalidStorageFormat()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /identity/{id}] GetIdentityID", response, response.Code())
	}
}

// NewGetIdentityIDOK creates a GetIdentityIDOK with default headers values
func NewGetIdentityIDOK() *GetIdentityIDOK {
	return &GetIdentityIDOK{}
}

/*
GetIdentityIDOK describes a response with status code 200, with default header values.

Success
*/
type GetIdentityIDOK struct {
	Payload *models.Identity
}

// IsSuccess returns true when this get identity Id o k response has a 2xx status code
func (o *GetIdentityIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get identity Id o k response has a 3xx status code
func (o *GetIdentityIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get identity Id o k response has a 4xx status code
func (o *GetIdentityIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get identity Id o k response has a 5xx status code
func (o *GetIdentityIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get identity Id o k response a status code equal to that given
func (o *GetIdentityIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get identity Id o k response
func (o *GetIdentityIDOK) Code() int {
	return 200
}

func (o *GetIdentityIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdOK %s", 200, payload)
}

func (o *GetIdentityIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdOK %s", 200, payload)
}

func (o *GetIdentityIDOK) GetPayload() *models.Identity {
	return o.Payload
}

func (o *GetIdentityIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Identity)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetIdentityIDBadRequest creates a GetIdentityIDBadRequest with default headers values
func NewGetIdentityIDBadRequest() *GetIdentityIDBadRequest {
	return &GetIdentityIDBadRequest{}
}

/*
GetIdentityIDBadRequest describes a response with status code 400, with default header values.

Invalid identity provided
*/
type GetIdentityIDBadRequest struct {
}

// IsSuccess returns true when this get identity Id bad request response has a 2xx status code
func (o *GetIdentityIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get identity Id bad request response has a 3xx status code
func (o *GetIdentityIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get identity Id bad request response has a 4xx status code
func (o *GetIdentityIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get identity Id bad request response has a 5xx status code
func (o *GetIdentityIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get identity Id bad request response a status code equal to that given
func (o *GetIdentityIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get identity Id bad request response
func (o *GetIdentityIDBadRequest) Code() int {
	return 400
}

func (o *GetIdentityIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdBadRequest", 400)
}

func (o *GetIdentityIDBadRequest) String() string {
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdBadRequest", 400)
}

func (o *GetIdentityIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetIdentityIDNotFound creates a GetIdentityIDNotFound with default headers values
func NewGetIdentityIDNotFound() *GetIdentityIDNotFound {
	return &GetIdentityIDNotFound{}
}

/*
GetIdentityIDNotFound describes a response with status code 404, with default header values.

Identity not found
*/
type GetIdentityIDNotFound struct {
}

// IsSuccess returns true when this get identity Id not found response has a 2xx status code
func (o *GetIdentityIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get identity Id not found response has a 3xx status code
func (o *GetIdentityIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get identity Id not found response has a 4xx status code
func (o *GetIdentityIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get identity Id not found response has a 5xx status code
func (o *GetIdentityIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get identity Id not found response a status code equal to that given
func (o *GetIdentityIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get identity Id not found response
func (o *GetIdentityIDNotFound) Code() int {
	return 404
}

func (o *GetIdentityIDNotFound) Error() string {
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdNotFound", 404)
}

func (o *GetIdentityIDNotFound) String() string {
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdNotFound", 404)
}

func (o *GetIdentityIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetIdentityIDUnreachable creates a GetIdentityIDUnreachable with default headers values
func NewGetIdentityIDUnreachable() *GetIdentityIDUnreachable {
	return &GetIdentityIDUnreachable{}
}

/*
GetIdentityIDUnreachable describes a response with status code 520, with default header values.

Identity storage unreachable. Likely a network problem.
*/
type GetIdentityIDUnreachable struct {
	Payload models.Error
}

// IsSuccess returns true when this get identity Id unreachable response has a 2xx status code
func (o *GetIdentityIDUnreachable) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get identity Id unreachable response has a 3xx status code
func (o *GetIdentityIDUnreachable) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get identity Id unreachable response has a 4xx status code
func (o *GetIdentityIDUnreachable) IsClientError() bool {
	return false
}

// IsServerError returns true when this get identity Id unreachable response has a 5xx status code
func (o *GetIdentityIDUnreachable) IsServerError() bool {
	return true
}

// IsCode returns true when this get identity Id unreachable response a status code equal to that given
func (o *GetIdentityIDUnreachable) IsCode(code int) bool {
	return code == 520
}

// Code gets the status code for the get identity Id unreachable response
func (o *GetIdentityIDUnreachable) Code() int {
	return 520
}

func (o *GetIdentityIDUnreachable) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdUnreachable %s", 520, payload)
}

func (o *GetIdentityIDUnreachable) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdUnreachable %s", 520, payload)
}

func (o *GetIdentityIDUnreachable) GetPayload() models.Error {
	return o.Payload
}

func (o *GetIdentityIDUnreachable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetIdentityIDInvalidStorageFormat creates a GetIdentityIDInvalidStorageFormat with default headers values
func NewGetIdentityIDInvalidStorageFormat() *GetIdentityIDInvalidStorageFormat {
	return &GetIdentityIDInvalidStorageFormat{}
}

/*
GetIdentityIDInvalidStorageFormat describes a response with status code 521, with default header values.

Invalid identity format in storage
*/
type GetIdentityIDInvalidStorageFormat struct {
	Payload models.Error
}

// IsSuccess returns true when this get identity Id invalid storage format response has a 2xx status code
func (o *GetIdentityIDInvalidStorageFormat) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get identity Id invalid storage format response has a 3xx status code
func (o *GetIdentityIDInvalidStorageFormat) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get identity Id invalid storage format response has a 4xx status code
func (o *GetIdentityIDInvalidStorageFormat) IsClientError() bool {
	return false
}

// IsServerError returns true when this get identity Id invalid storage format response has a 5xx status code
func (o *GetIdentityIDInvalidStorageFormat) IsServerError() bool {
	return true
}

// IsCode returns true when this get identity Id invalid storage format response a status code equal to that given
func (o *GetIdentityIDInvalidStorageFormat) IsCode(code int) bool {
	return code == 521
}

// Code gets the status code for the get identity Id invalid storage format response
func (o *GetIdentityIDInvalidStorageFormat) Code() int {
	return 521
}

func (o *GetIdentityIDInvalidStorageFormat) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdInvalidStorageFormat %s", 521, payload)
}

func (o *GetIdentityIDInvalidStorageFormat) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /identity/{id}][%d] getIdentityIdInvalidStorageFormat %s", 521, payload)
}

func (o *GetIdentityIDInvalidStorageFormat) GetPayload() models.Error {
	return o.Payload
}

func (o *GetIdentityIDInvalidStorageFormat) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}
