# This script was generated by crazy-complete.
# crazy-complete: A tool that creates robust and reliable autocompletion scripts for Bash, Fish and Zsh.
# For more information, visit: https://github.com/crazy-complete/crazy-complete

function _go-sendxmpp_jid_from_history
  builtin history | command grep go-sendxmpp | command grep -E -o '[^ ]+@[^ ]+(/[^ ]+)?' | command sort | command uniq
end

function _go-sendxmpp__--tls-version
  printf "%s\t%s\n" \
    10 TLSv1.0 \
    11 TLSv1.1 \
    12 TLSv1.2 \
    13 TLSv1.3
end

function _go-sendxmpp_fish_query
  # ===========================================================================
  #
  # This function implements the parsing of options and positionals in the Fish shell.
  #
  # Usage: __fish_query <OPTIONS> <COMMAND> [ARGS...]
  #
  # The first argument is a comma-separated list of options that the parser should know about.
  # Short options (-o), long options (--option), and old-style options (-option) are supported.
  #
  # If an option takes an argument, it is suffixed by '='.
  # If an option takes an optional argument, it is suffixed by '=?'.
  #
  # For example:
  #   __fish_query '-f,--flag,-old-style,--with-arg=,--with-optional=?' [...]
  #
  #   Here, -f, --flag and -old-style don't take options, --with-arg requires an
  #   argument and --with-optional takes an optional argument.
  #
  # COMMANDS
  #   positional_contains <NUM> <WORDS...>
  #     Checks if the positional argument number NUM is one of WORDS.
  #     NUM counts from one.
  #
  #   has_option <OPTIONS...>
  #     Checks if an option given in OPTIONS is passed on commandline.
  #
  #   option_is <OPTIONS...> -- <VALUES...>
  #     Checks if any option in OPTIONS has a value of VALUES.
  #
  #   num_of_positionals [<OPERATOR> <NUMBER>]
  #     Checks the number of positional arguments.
  #     If no arguments are provided, print the total count of positional arguments.
  #     If two arguments are provided, the first argument should be one of
  #     the comparison operators: '-lt', '-le', '-eq', '-ne', '-gt', '-ge'.
  #     Returns 0 if the count of positional arguments matches the
  #     specified NUMBER according to the comparison operator, otherwise returns 1.
  #
  # ===========================================================================

  set -l positionals
  set -l having_options
  set -l option_values

  set -l options $argv[1]
  set -e argv[1]

  set -l cmd $argv[1]
  set -e argv[1]

  set -l my_cache_key "$(commandline -b) $options"

  if test "$__QUERY_CACHE_KEY" = "$my_cache_key"
    set positionals    $__QUERY_CACHE_POSITIONALS
    set having_options $__QUERY_CACHE_HAVING_OPTIONS
    set option_values  $__QUERY_CACHE_OPTION_VALUES
  else
    # =========================================================================
    # Parsing of OPTIONS argument
    # =========================================================================

    set -l short_opts_with_arg
    set -l short_opts_without_arg
    set -l short_opts_with_optional_arg
    set -l long_opts_with_arg
    set -l long_opts_without_arg
    set -l long_opts_with_optional_arg

    set -l option

    if test -n "$options"
      for option in (string split -- ',' $options)
        # Using one big switch case is the fastest way
        switch $option
          case '--?*=';   set -a long_opts_with_arg           (string replace -- '='  '' $option)
          case '--?*=\?'; set -a long_opts_with_optional_arg  (string replace -- '=?' '' $option)
          case '--?*';    set -a long_opts_without_arg        $option
          case '-?=';     set -a short_opts_with_arg          (string replace -- '='  '' $option)
          case '-?=\?';   set -a short_opts_with_optional_arg (string replace -- '=?' '' $option)
          case '-?';      set -a short_opts_without_arg       $option
        end
      end
    end

    # =========================================================================
    # Parsing of options and positionals
    # =========================================================================

    set -l cmdline (commandline -poc)
    set -l cmdline_count (count $cmdline)

    set -l argi 2 # cmdline[1] is command name
    while test $argi -le $cmdline_count
      set -l arg "$cmdline[$argi]"
      set -l have_trailing_arg (test $argi -lt $cmdline_count && echo true || echo false)

      switch $arg
        case '-'
          set -a positionals -
        case '--'
          for argi in (seq (math $argi + 1) $cmdline_count)
            set -a positionals $cmdline[$argi]
          end
          break
        case '--*=*'
          set -l split (string split -m 1 -- '=' $arg)
          set -a having_options $split[1]
          set -a option_values "$split[2]"
        case '--*'
          if contains -- $arg $long_opts_with_arg
            if $have_trailing_arg
              set -a having_options $arg
              set -a option_values $cmdline[(math $argi + 1)]
              set argi (math $argi + 1)
            end
          else
            set -a having_options $arg
            set -a option_values ""
          end
        case '-*'
          set -l end_of_parsing false

          set -l arg_length (string length -- $arg)
          set -l i 2
          while not $end_of_parsing; and test $i -le $arg_length
            set -l option "-$(string sub -s $i -l 1 -- $arg)"
            set -l trailing_chars "$(string sub -s (math $i + 1) -- $arg)"

            if contains -- $option $short_opts_without_arg
              set -a having_options $option
              set -a option_values ""
            else if contains -- $option $short_opts_with_arg
              set end_of_parsing true

              if test -n "$trailing_chars"
                set -a having_options $option
                set -a option_values $trailing_chars
              else if $have_trailing_arg
                set -a having_options $option
                set -a option_values $cmdline[(math $argi + 1)]
                set argi (math $argi + 1)
              end
            else if contains -- $option $short_opts_with_optional_arg
              set -a having_options $option
              set end_of_parsing true
              set -a option_values "$trailing_chars" # may be empty
            end

            set i (math $i + 1)
          end
        case '*'
          set -a positionals $arg
      end

      set argi (math $argi + 1)
    end

    set -g __QUERY_CACHE_POSITIONALS    $positionals
    set -g __QUERY_CACHE_HAVING_OPTIONS $having_options
    set -g __QUERY_CACHE_OPTION_VALUES  $option_values
    set -g __QUERY_CACHE_KEY            $my_cache_key
  end

  # ===========================================================================
  # Commands
  # ===========================================================================

  switch $cmd
    case 'has_option'
      for option in $having_options
        contains -- $option $argv && return 0
      end

      return 1
    case 'num_of_positionals'
      switch (count $argv)
        case 0
          count $positionals
        case 1
          echo "_go-sendxmpp_fish_query: num_of_positionals: $argv[1]: missing operand" >&2
          return 1
        case 2
          if contains -- $argv[1] -lt -le -eq -ne -gt -ge;
            test (count $positionals) $argv[1] $argv[2] && return 0 || return 1
          else
            echo "_go-sendxmpp_fish_query: num_of_positionals: $argv[1]: unknown operator" >&2
            return 1
          end
        case '*'
          echo "_go-sendxmpp_fish_query: num_of_positionals: too many arguments" >&2
          return 1
      end
  end
end

set -l prog "go-sendxmpp"
set -l query "_go-sendxmpp_fish_query"

# Generally disable file completion
complete -c $prog -x

# command go-sendxmpp
set -l opts "--help,--version,-a=,--alias=,-c,--chatroom,-d,--debug,--fast-off,-f=,--file=,--headline,-h=,--http-upload=,-i,--interactive,-j=,--jserver=,-l,--listen,-m=,--message=,--muc-password=,-n,--no-tls-verify,--oob-file=,--ox,--ox-delete-nodes,--ox-genprivkey-rsa,--ox-genprivkey-x25519,--ox-import-privkey=,--ox-passphrase=,-p=,--password=,--raw,--scram-mech-pinning=,--ssdp-off,-s=,--subject=,--timeout=,-t,--tls,--tls-version=,-u=,--username="
set -l C000 "not $query '$opts' has_option --help --version"
set -l C001 "not $query '$opts' has_option --help --version -a --alias"
set -l C002 "not $query '$opts' has_option --ox --headline --help --version -c --chatroom"
set -l C003 "not $query '$opts' has_option --help --version -d --debug"
set -l C004 "not $query '$opts' has_option --help --version --fast-off"
set -l C005 "not $query '$opts' has_option --help --version -f --file"
set -l C006 "not $query '$opts' has_option --ox -c --chatroom --help --version --headline"
set -l C007 "not $query '$opts' has_option --ox -i --interactive -m --message --help --version -h --http-upload"
set -l C008 "not $query '$opts' has_option -h --http-upload --help --version -i --interactive"
set -l C009 "not $query '$opts' has_option --help --version -j --jserver"
set -l C010 "not $query '$opts' has_option --help --version -l --listen"
set -l C011 "not $query '$opts' has_option -h --http-upload --help --version -m --message"
set -l C012 "not $query '$opts' has_option --help --version --muc-password"
set -l C013 "not $query '$opts' has_option --help --version -n --no-tls-verify"
set -l C014 "not $query '$opts' has_option --ox --help --version --oob-file"
set -l C015 "not $query '$opts' has_option -h --http-upload -c --chatroom --oob-file --headline --help --version --ox"
set -l C016 "not $query '$opts' has_option --help --version --ox-delete-nodes"
set -l C017 "not $query '$opts' has_option --help --version --ox-genprivkey-rsa"
set -l C018 "not $query '$opts' has_option --help --version --ox-genprivkey-x25519"
set -l C019 "not $query '$opts' has_option --help --version --ox-import-privkey"
set -l C020 "not $query '$opts' has_option --help --version --ox-passphrase"
set -l C021 "not $query '$opts' has_option --help --version -p --password"
set -l C022 "not $query '$opts' has_option --help --version --raw"
set -l C023 "not $query '$opts' has_option --help --version --scram-mech-pinning"
set -l C024 "not $query '$opts' has_option --help --version --ssdp-off"
set -l C025 "not $query '$opts' has_option --help --version -s --subject"
set -l C026 "not $query '$opts' has_option --help --version --timeout"
set -l C027 "not $query '$opts' has_option --help --version -t --tls"
set -l C028 "not $query '$opts' has_option --help --version --tls-version"
set -l C029 "not $query '$opts' has_option --help --version -u --username"
set -l C030 "$query '$opts' num_of_positionals -ge 0"
complete -c $prog -n $C000 -l help -d 'Show help' -f
complete -c $prog -n $C000 -l version -d 'Show version information' -f
complete -c $prog -n $C001 -s a -l alias -d 'Set alias/nickname for chatrooms' -x
complete -c $prog -n $C002 -s c -l chatroom -d 'Send message to a chatroom' -f
complete -c $prog -n $C003 -s d -l debug -d 'Show debugging info' -f
complete -c $prog -n $C004 -l fast-off -d 'Disable XEP-0484: Fast Authentication Streamlining Tokens' -f
complete -c $prog -n $C005 -s f -l file -d 'Set configuration file (Default: ~/.config/go-sendxmpp/sendxmpprc)' -Fr
complete -c $prog -n $C006 -l headline -d 'Send message as type headline' -f
complete -c $prog -n $C007 -s h -l http-upload -d 'Send a file via http-upload' -Fr
complete -c $prog -n $C008 -s i -l interactive -d "Interactive mode (for use with e.g. 'tail -f')" -f
complete -c $prog -n $C009 -s j -l jserver -d 'XMPP server address' -x
complete -c $prog -n $C010 -s l -l listen -d 'Listen for messages and print them to stdout' -f
complete -c $prog -n $C011 -s m -l message -d 'Set file including the message' -Fr
complete -c $prog -n $C012 -l muc-password -d 'Password for password protected MUCs' -x
complete -c $prog -n $C013 -s n -l no-tls-verify -d 'Skip verification of TLS certificates (not recommended)' -f
complete -c $prog -n $C014 -l oob-file -d 'URL to send a file as out of band data' -x
complete -c $prog -n $C015 -l ox -d 'Use "OpenPGP for XMPP" encryption (experimental)' -f
complete -c $prog -n $C016 -l ox-delete-nodes -d 'Delete existing OpenPGP nodes on the server' -f
complete -c $prog -n $C017 -l ox-genprivkey-rsa -d 'Generate a private OpenPGP key (RSA 4096 bit) for the given JID and publish the corresponding public key' -f
complete -c $prog -n $C018 -l ox-genprivkey-x25519 -d 'Generate a private OpenPGP key (x25519) for the given JID and publish the corresponding public key' -f
complete -c $prog -n $C019 -l ox-import-privkey -d 'Import an existing private OpenPGP key' -Fr
complete -c $prog -n $C020 -l ox-passphrase -d 'Passphrase for locking and unlocking the private OpenPGP key' -x
complete -c $prog -n $C021 -s p -l password -d 'Password for XMPP account' -x
complete -c $prog -n $C022 -l raw -d 'Send raw XML' -f
complete -c $prog -n $C023 -l scram-mech-pinning -d 'Enforce the use of a certain SCRAM authentication mechanism' -x -a 'SCRAM-SHA-1 SCRAM-SHA-1-PLUS SCRAM-SHA-256 SCRAM-SHA-256-PLUS SCRAM-SHA-512 SCRAM-SHA-512-PLUS'
complete -c $prog -n $C024 -l ssdp-off -d 'Disable XEP-0474: SASL SCRAM Downgrade Protection' -f
complete -c $prog -n $C025 -s s -l subject -d 'Set message subject' -x
complete -c $prog -n $C026 -l timeout -d 'Connection timeout in seconds [default: 10]' -x
complete -c $prog -n $C027 -s t -l tls -d 'Use direct TLS' -f
complete -c $prog -n $C028 -l tls-version -d 'Minimal TLS version: 10 (TLSv1.0), 11 (TLSv1.1), 12 (TLSv1.2) or 13 (TLSv1.3) [default: 12]' -x -a '(_go-sendxmpp__--tls-version)'
complete -c $prog -n $C029 -s u -l username -d 'Username for XMPP account' -x
complete -c $prog -n $C030 -d 'Specify JID' -x -a '(_go-sendxmpp_jid_from_history)'

# vim: ft=fish ts=2 sts=2 sw=2 et