/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueRow;

public class ResultSetRow
implements DBDValueRow {
    public static final byte STATE_NORMAL = 1;
    public static final byte STATE_ADDED = 2;
    public static final byte STATE_REMOVED = 3;
    private int rowNumber;
    private int visualNumber;
    @NotNull
    public Object[] values;
    @Nullable
    public Map<DBDAttributeBinding, Object> changes;
    private byte state;
    @Nullable
    public ColorInfo colorInfo;

    ResultSetRow(int rowNumber, @NotNull Object[] values) {
        this.rowNumber = rowNumber;
        this.visualNumber = rowNumber;
        this.values = values;
        this.state = 1;
    }

    @NotNull
    public Object[] getValues() {
        return this.values;
    }

    public boolean isChanged() {
        return this.changes != null && !this.changes.isEmpty();
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getVisualNumber() {
        return this.visualNumber;
    }

    public void setVisualNumber(int visualNumber) {
        this.visualNumber = visualNumber;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public boolean isChanged(DBDAttributeBinding attr) {
        return this.changes != null && this.changes.containsKey(attr);
    }

    public void addChange(DBDAttributeBinding attr, @Nullable Object oldValue) {
        if (this.changes == null) {
            this.changes = new IdentityHashMap<DBDAttributeBinding, Object>();
        }
        this.changes.put(attr, oldValue);
    }

    public void resetChange(DBDAttributeBinding attr) {
        assert (this.changes != null);
        this.changes.remove(attr);
        if (this.changes.isEmpty()) {
            this.changes = null;
        }
    }

    void release() {
        Object[] objectArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            DBUtils.releaseValue((Object)value);
            ++n2;
        }
        if (this.changes != null) {
            for (Object oldValue : this.changes.values()) {
                DBUtils.releaseValue((Object)oldValue);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.rowNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResultSetRow) {
            ResultSetRow row = (ResultSetRow)obj;
            return this.rowNumber == row.rowNumber && this.visualNumber == row.visualNumber;
        }
        return super.equals(obj);
    }

    public static class ColorInfo {
        @Nullable
        public Color rowForeground;
        @Nullable
        public Color rowBackground;
        @Nullable
        public Color[] cellFgColors;
        @Nullable
        public Color[] cellBgColors;
    }
}

