/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceTransactionModeContributor
extends DataSourceMenuContributor {
    private static final Log log = Log.getLog(DataSourceTransactionModeContributor.class);

    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IEditorPart activePart = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        DBCExecutionContext executionContext = AbstractDataSourceHandler.getExecutionContextFromPart((IWorkbenchPart)activePart);
        DBPDataSource dataSource = null;
        if (executionContext != null) {
            dataSource = executionContext.getDataSource();
        }
        if (dataSource == null) {
            return;
        }
        DBPDataSourceInfo dsInfo = dataSource.getInfo();
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
        if (txnManager != null) {
            boolean autoCommit = false;
            try {
                autoCommit = txnManager.isAutoCommit();
            }
            catch (DBCException e) {
                log.warn((Object)"Can't determine current auto-commit mode", (Throwable)e);
            }
            DBPTransactionIsolation txnLevelCurrent = null;
            try {
                txnLevelCurrent = txnManager.getTransactionIsolation();
            }
            catch (DBCException ex) {
                log.warn((Object)"Can't determine current transaction isolation level", (Throwable)ex);
            }
            menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new TransactionAutoCommitAction(executionContext, true, autoCommit, txnLevelCurrent), (boolean)true));
            menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new TransactionAutoCommitAction(executionContext, false, !autoCommit, txnLevelCurrent), (boolean)true));
            ISmartTransactionManager smartTransactionManager = (ISmartTransactionManager)DBUtils.getAdapter(ISmartTransactionManager.class, (Object)activePart);
            menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new SmartAutoCommitAction(dataSource, smartTransactionManager), (boolean)true));
            menuItems.add((IContributionItem)new Separator());
            for (DBPTransactionIsolation txi : CommonUtils.safeCollection((Collection)dsInfo.getSupportedTransactionsIsolation())) {
                if (!txi.isEnabled()) continue;
                menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new TransactionIsolationAction(executionContext, txi, txi.equals(txnLevelCurrent)), (boolean)true));
            }
        }
    }

    private static class SmartAutoCommitAction
    extends Action {
        private final ISmartTransactionManager smartTransactionManager;

        SmartAutoCommitAction(DBPDataSource dataSource, ISmartTransactionManager smartTransactionManager) {
            this.smartTransactionManager = smartTransactionManager;
            this.setEnabled(smartTransactionManager != null);
            this.setChecked(smartTransactionManager != null ? smartTransactionManager.isSmartAutoCommit() : dataSource.getContainer().getPreferenceStore().getBoolean("transaction.smart.commit"));
        }

        public int getStyle() {
            return 2;
        }

        public String getText() {
            return CoreMessages.action_menu_transaction_smart_auto_commit;
        }

        public String getToolTipText() {
            return CoreMessages.action_menu_transaction_smart_auto_commit_tip;
        }

        public boolean isChecked() {
            if (this.smartTransactionManager != null) {
                return this.smartTransactionManager.isSmartAutoCommit();
            }
            return false;
        }

        public void run() {
            this.smartTransactionManager.setSmartAutoCommit(!this.smartTransactionManager.isSmartAutoCommit());
        }
    }

    private static class TransactionAutoCommitAction
    extends Action {
        private final DBCExecutionContext executionContext;
        private final boolean autoCommit;
        private final DBPTransactionIsolation isolation;

        TransactionAutoCommitAction(DBCExecutionContext executionContext, boolean autoCommit, boolean enabled, DBPTransactionIsolation isolation) {
            this.executionContext = executionContext;
            this.autoCommit = autoCommit;
            this.isolation = isolation;
            this.setChecked(enabled);
        }

        public int getStyle() {
            return 8;
        }

        public String getText() {
            String isolationName = this.isolation == null ? "?" : this.isolation.getTitle();
            return this.autoCommit ? CoreMessages.action_menu_transaction_autocommit_description : NLS.bind((String)CoreMessages.action_menu_transaction_manualcommit_description, (Object)isolationName);
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            final DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.executionContext);
            if (txnManager != null) {
                new AbstractJob("Set auto-commit"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        monitor.beginTask("Change connection auto-commit to " + autoCommit, 1);
                        try {
                            try {
                                monitor.subTask("Change context '" + executionContext.getContextName() + "' auto-commit state");
                                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> txnManager.setAutoCommit(monitor, autoCommit));
                            }
                            catch (Exception e) {
                                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        static /* synthetic */ boolean access$0(TransactionAutoCommitAction transactionAutoCommitAction) {
            return transactionAutoCommitAction.autoCommit;
        }
    }

    private static class TransactionIsolationAction
    extends Action {
        private final DBCExecutionContext executionContext;
        private final DBPTransactionIsolation level;

        TransactionIsolationAction(DBCExecutionContext executionContext, DBPTransactionIsolation level, boolean checked) {
            this.executionContext = executionContext;
            this.level = level;
            this.setChecked(checked);
        }

        public int getStyle() {
            return 8;
        }

        public String getText() {
            return this.level.getTitle();
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            final DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.executionContext);
            if (txnManager != null) {
                new AbstractJob("Set transaction isolation level"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        monitor.beginTask("Change transaction isolation level to " + level.getTitle(), 1);
                        try {
                            try {
                                monitor.subTask("Change context '" + executionContext.getContextName() + "' transaction isolation level");
                                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> txnManager.setTransactionIsolation(monitor, level));
                                executionContext.getDataSource().getContainer().setDefaultTransactionsIsolation(level);
                                executionContext.getDataSource().getContainer().persistConfiguration();
                            }
                            catch (Exception e) {
                                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        static /* synthetic */ DBPTransactionIsolation access$0(TransactionIsolationAction transactionIsolationAction) {
            return transactionIsolationAction.level;
        }
    }
}

