/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.fs.DBFRemoteFileStore;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.AlphanumericComparator;
import org.jkiss.utils.CommonUtils;

public class NavigatorResources {
    private static final Log log = Log.getLog(NavigatorResources.class);
    static final Comparator<DBNNode> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof DBNProjectDatabases) {
            return -1;
        }
        if (o2 instanceof DBNProjectDatabases) {
            return 1;
        }
        if (o1 instanceof DBNResource && o2 instanceof DBNResource) {
            boolean folder1 = DBNUtils.isFolderNode((DBNNode)o1);
            boolean folder2 = DBNUtils.isFolderNode((DBNNode)o2);
            if (folder1 && !folder2) {
                return -1;
            }
            if (folder2 && !folder1) {
                return 1;
            }
        }
        return AlphanumericComparator.getInstance().compare((CharSequence)o1.getNodeDisplayName(), (CharSequence)o2.getNodeDisplayName());
    };

    public static DBNProject getProjectNode(DBNRoot root, IProject project) {
        DBNProject[] dBNProjectArray = root.getProjects();
        int n = dBNProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RCPProject rcpProject;
            DBNProject node = dBNProjectArray[n2];
            DBPProject dBPProject = node.getProject();
            if (dBPProject instanceof RCPProject && (rcpProject = (RCPProject)dBPProject).getEclipseProject() == project) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public static DBNResource getNodeByResource(DBNModel model, IResource resource) {
        return NavigatorResources.getNodeByResource(model.getRoot(), resource);
    }

    public static DBNResource getNodeByResource(DBNRoot root, IResource resource) {
        DBNResource dbnResource;
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        DBNProject projectNode = NavigatorResources.getProjectNode(root, project);
        if (projectNode == null) {
            return null;
        }
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource parent = resource;
        while (parent != null && parent != project) {
            path.add(0, parent);
            parent = parent.getParent();
        }
        DBNProject curResNode = projectNode;
        for (IResource res : path) {
            if ((curResNode = NavigatorResources.getChild((DBNNode)curResNode, res)) != null) continue;
            return null;
        }
        return curResNode instanceof DBNResource ? (dbnResource = (DBNResource)curResNode) : null;
    }

    public static void refreshNavigatorResource(@NotNull DBPProject project, @NotNull IResource resource, Object source) {
        DBNModel navigatorModel = project.getNavigatorModel();
        if (navigatorModel == null) {
            return;
        }
        DBNProject projectNode = NavigatorResources.getProjectNode(navigatorModel.getRoot(), resource.getProject());
        DBNResource fileNode = NavigatorResources.findResource((DBNNode)projectNode, resource);
        if (fileNode != null) {
            fileNode.refreshResourceState(source);
        }
    }

    public static DBNResource findResource(@Nullable DBNNode node, @NotNull IResource resource) {
        try {
            return NavigatorResources.findResource((DBRProgressMonitor)new VoidProgressMonitor(), node, resource);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DBNResource findResource(@NotNull DBRProgressMonitor monitor, @Nullable DBNNode node, @NotNull IResource resource) throws DBException {
        void rcpProject;
        DBPProject dBPProject;
        if (node == null || !((dBPProject = node.getOwnerProject()) instanceof RCPProject)) {
            return null;
        }
        RCPProject rCPProject = (RCPProject)dBPProject;
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource parent = resource;
        while (!(parent instanceof IProject) && !CommonUtils.equalObjects((Object)parent, (Object)rcpProject.getRootResource())) {
            path.addFirst(parent);
            parent = parent.getParent();
        }
        DBNNode resNode = node;
        for (IResource res : path) {
            resNode.getChildren(monitor);
            resNode = NavigatorResources.getChild(resNode, res);
            if (resNode != null) continue;
            return null;
        }
        if (resNode instanceof DBNResource) {
            DBNResource dbnResource = (DBNResource)resNode;
            return dbnResource;
        }
        log.warn((Object)("Node '" + String.valueOf(resNode) + "' is not a local resource"));
        return null;
    }

    public static boolean isRootResource(DBPProject ownerProject, IResource resource) {
        if (ownerProject instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)ownerProject;
            if (CommonUtils.equalObjects((Object)resource.getParent(), (Object)rcpProject.getRootResource()) || CommonUtils.equalObjects((Object)resource.getParent(), (Object)rcpProject.getEclipseProject())) {
                return true;
            }
        }
        return false;
    }

    static void sortChildren(DBNNode[] list) {
        Arrays.sort(list, COMPARATOR);
    }

    public static DBNNode makeNode(DBNNode parentNode, IResource resource) {
        DBPResourceHandler resourceHandler;
        block6: {
            boolean isRootResource = NavigatorResources.isRootResource(parentNode.getOwnerProject(), resource);
            if (isRootResource && resource.getName().startsWith(".")) {
                return null;
            }
            try {
                if (parentNode instanceof DBNResource) {
                    DBNResource resourceNode = (DBNResource)parentNode;
                    if (resource instanceof IFolder && !isRootResource) {
                        return resourceNode.getHandler().makeNavigatorNode(parentNode, resource);
                    }
                }
                if ((resourceHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resource)) != null) break block6;
                log.debug((Object)("Skip resource '" + resource.getName() + "'"));
                return null;
            }
            catch (Exception e) {
                log.error((Object)("Error creating navigator node for resource '" + resource.getName() + "'"), (Throwable)e);
                return null;
            }
        }
        return resourceHandler.makeNavigatorNode(parentNode, resource);
    }

    public static DBNNode getChild(DBNNode parentNode, IResource resource) {
        DBNNodeWithCache nodeWithCache;
        if (parentNode instanceof DBNNodeWithCache && !(nodeWithCache = (DBNNodeWithCache)parentNode).needsInitialization()) {
            DBNNode[] dBNNodeArray = nodeWithCache.getCachedChildren();
            int n = dBNNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode child = dBNNodeArray[n2];
                if (Objects.equals(child.getAdapter(IResource.class), resource)) {
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void refreshThisResource(DBRProgressMonitor monitor, DBNNode resNode) throws DBException {
        IResource resource = (IResource)resNode.getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        try {
            NavigatorResources.refreshFileStore(monitor, resource);
            resource.refreshLocal(2, monitor.getNestedMonitor());
            IPath resourceLocation = resource.getLocation();
            if (resourceLocation != null && !resourceLocation.toFile().exists()) {
                log.debug((Object)("Resource '" + resource.getName() + "' doesn't exists on file system"));
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't refresh resource", (Throwable)e);
        }
    }

    public static void refreshFileStore(@NotNull DBRProgressMonitor monitor, IResource resource) throws DBException {
        DBFRemoteFileStore remoteFileStore;
        if (resource instanceof Resource && (remoteFileStore = (DBFRemoteFileStore)GeneralUtils.adapt((Object)((Resource)resource).getStore(), DBFRemoteFileStore.class)) != null) {
            remoteFileStore.refresh(monitor);
        }
    }
}

