/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.text.BaseTextDocumentProvider;
import org.jkiss.dbeaver.ui.editors.text.DatabaseMarkerAnnotationModel;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class SQLObjectDocumentProvider
extends BaseTextDocumentProvider {
    private String sourceText;
    private boolean sourceLoaded;
    private final SQLEditorBase editor;

    public SQLObjectDocumentProvider(SQLEditorBase editor) {
        this.editor = editor;
    }

    protected abstract String loadSourceText(DBRProgressMonitor var1) throws DBException;

    protected abstract void saveSourceText(DBRProgressMonitor var1, String var2) throws DBException;

    protected DBSObject getProviderObject() {
        return null;
    }

    public void setSourceText(String sourceText) {
        this.sourceText = sourceText;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    public boolean isModifiable(Object element) {
        return !this.editor.isReadOnly();
    }

    protected IDocument createDocument(Object element) {
        Document document = new Document();
        if (element instanceof StringEditorInput) {
            this.sourceText = ((StringEditorInput)element).getBuffer().toString();
        }
        if (this.sourceText == null) {
            final DBPDataSource dataSource = this.editor.getDataSource();
            if (dataSource != null) {
                this.sourceText = SQLUtils.generateCommentLine((DBPDataSource)this.editor.getDataSource(), (String)("Loading '" + this.editor.getEditorInput().getName() + "' source..."));
                document.set(this.sourceText);
            }
            AbstractJob job = new AbstractJob("Load SQL source"){
                {
                    super($anonymous0);
                    this.setUser(true);
                }

                protected IStatus run(DBRProgressMonitor monitor) {
                    monitor.beginTask(this.getName(), 1);
                    try {
                        if (dataSource != null) {
                            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> {
                                SQLObjectDocumentProvider.this.sourceText = SQLObjectDocumentProvider.this.loadSourceText(monitor);
                                if (SQLObjectDocumentProvider.this.sourceText == null) {
                                    SQLObjectDocumentProvider.this.sourceText = SQLUtils.generateCommentLine((DBPDataSource)dataSource, (String)"Empty source");
                                }
                            });
                        } else {
                            SQLObjectDocumentProvider.this.sourceText = SQLObjectDocumentProvider.this.loadSourceText(monitor);
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception e) {
                        SQLEditorBase.log.error((Object)e);
                        SQLObjectDocumentProvider.this.sourceText = "/* ERROR WHILE READING SOURCE:\n\n" + e.getMessage() + "\n*/";
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UIUtils.asyncExec(() -> {
                        SQLObjectDocumentProvider.this.editor.setInput(SQLObjectDocumentProvider.this.editor.getEditorInput());
                        SQLObjectDocumentProvider.this.editor.reloadSyntaxRules();
                    });
                    super.done(event);
                }
            });
            job.schedule();
        }
        document.set(this.sourceText);
        this.sourceLoaded = true;
        return document;
    }

    /*
     * WARNING - void declaration
     */
    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        DBSObject databaseObject = this.getProviderObject();
        if (databaseObject != null) {
            IProject resource;
            DBPProject dBPProject;
            DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(databaseObject);
            if (node == null || !((dBPProject = node.getOwnerProject()) instanceof RCPProject)) {
                v0 = null;
            } else {
                void rcpProject;
                RCPProject rCPProject = (RCPProject)dBPProject;
                v0 = resource = rcpProject.getEclipseProject();
            }
            if (resource != null) {
                return new DatabaseMarkerAnnotationModel(databaseObject, node, resource);
            }
        }
        return super.createAnnotationModel(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        DBRProgressMonitor pm = RuntimeUtils.makeMonitor((IProgressMonitor)monitor);
        pm.beginTask("Save nested editor", 1);
        try {
            try {
                this.saveSourceText(pm, document.get());
            }
            catch (DBException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }
        finally {
            pm.done();
        }
    }

    public boolean isSourceLoaded() {
        return this.sourceLoaded;
    }

    static /* synthetic */ void access$0(SQLObjectDocumentProvider sQLObjectDocumentProvider, String string) {
        sQLObjectDocumentProvider.sourceText = string;
    }

    static /* synthetic */ String access$1(SQLObjectDocumentProvider sQLObjectDocumentProvider) {
        return sQLObjectDocumentProvider.sourceText;
    }
}

