/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;

public class SQLContext
extends DocumentTemplateContext
implements DBPContextProvider {
    private SQLEditorBase editor;
    private Map<String, SQLVariable> variables = new HashMap<String, SQLVariable>();

    public SQLContext(TemplateContextType type, IDocument document, Position position, SQLEditorBase editor) {
        super(type, document, position);
        this.editor = editor;
    }

    public SQLEditorBase getEditor() {
        return this.editor;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.editor.getExecutionContext();
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                SQLVariable variable = new SQLVariable(SQLContext.this, type, name, offsets);
                SQLContext.this.variables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.formatTemplate(buffer);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private void formatTemplate(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        String indentation = this.getIndentation();
        String content = buffer.getString();
        if (!indentation.isEmpty() && content.indexOf(10) != -1) {
            StringBuilder result = new StringBuilder();
            int nCountPlace = 0;
            TemplateVariable[] templateVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateVariable variable = templateVariableArray[n2];
                nCountPlace += variable.getOffsets().length;
                ++n2;
            }
            int[][] aVarOffset = new int[nCountPlace][3];
            nCountPlace = 0;
            int i = 0;
            while (i < variables.length) {
                int[] aOffsets;
                int[] nArray = aOffsets = variables[i].getOffsets();
                int n3 = aOffsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    int aOffset;
                    aVarOffset[nCountPlace][0] = aOffset = nArray[n4];
                    aVarOffset[nCountPlace][1] = i;
                    aVarOffset[nCountPlace][2] = aOffset;
                    ++nCountPlace;
                    ++n4;
                }
                ++i;
            }
            i = 0;
            while (i < nCountPlace - 1) {
                int j = i + 1;
                while (j < nCountPlace) {
                    if (aVarOffset[i][0] > aVarOffset[j][0]) {
                        int[] tmp = aVarOffset[i];
                        aVarOffset[i] = aVarOffset[j];
                        aVarOffset[j] = tmp;
                    }
                    ++j;
                }
                ++i;
            }
            int iPlace = 0;
            int iSpaceLen = indentation.length();
            int i2 = 0;
            while (i2 < content.length()) {
                char c = content.charAt(i2);
                result.append(c);
                if (c == '\n') {
                    while (iPlace < nCountPlace && i2 > aVarOffset[iPlace][0]) {
                        ++iPlace;
                    }
                    int j = iPlace;
                    while (j < nCountPlace) {
                        aVarOffset[j][2] = aVarOffset[j][2] + iSpaceLen;
                        ++j;
                    }
                    result.append(indentation);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < variables.length) {
                int[] aOffsets = variables[i2].getOffsets();
                int iInd = 0;
                int j = 0;
                while (j < nCountPlace) {
                    if (aVarOffset[j][1] == i2) {
                        aOffsets[iInd] = aVarOffset[j][2];
                        ++iInd;
                    }
                    ++j;
                }
                ++i2;
            }
            buffer.setContent(result.toString(), variables);
        }
    }

    SQLVariable getTemplateVariable(String name) {
        SQLVariable variable = this.variables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve((TemplateVariable)variable, (TemplateContext)this);
        }
        return variable;
    }

    Collection<SQLVariable> getVariables() {
        return this.variables.values();
    }

    private String getIndentation() {
        int lineIndent;
        block4: {
            int start = this.getStart();
            IDocument document = this.getDocument();
            IRegion region = document.getLineInformationOfOffset(start);
            lineIndent = start - region.getOffset();
            if (lineIndent > 0) break block4;
            return "";
        }
        try {
            char[] buf = new char[lineIndent];
            int i = 0;
            while (i < lineIndent) {
                buf[i] = 32;
                ++i;
            }
            return String.valueOf(buf);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

