/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentStorageLocal;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TemporaryContentStorage
implements DBDContentStorageLocal {
    private final DBPPlatform platform;
    private Path file;
    private String charset;
    private boolean deleteFileOnRelease;

    public TemporaryContentStorage(DBPPlatform platform, Path file, String charset, boolean deleteFileOnRelease) {
        this.platform = platform;
        this.file = file;
        this.charset = CommonUtils.toString((Object)charset, (String)GeneralUtils.DEFAULT_ENCODING);
        this.deleteFileOnRelease = deleteFileOnRelease;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public Reader getContentReader() throws IOException {
        if (!CommonUtils.isEmpty((String)this.charset)) {
            return Files.newBufferedReader(this.file, Charset.forName(this.charset));
        }
        return Files.newBufferedReader(this.file);
    }

    @Override
    public long getContentLength() throws IOException {
        return Files.size(this.file);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        Path tempFile = ContentUtils.createTempContentFile(monitor, this.platform, "copy" + this.hashCode());
        try (InputStream is = Files.newInputStream(this.file, new OpenOption[0]);
             OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
            ContentUtils.copyStreams(is, Files.size(this.file), os, monitor);
        }
        catch (IOException e) {
            ContentUtils.deleteTempFile(tempFile);
            throw new IOException(e);
        }
        return new TemporaryContentStorage(this.platform, tempFile, this.charset, true);
    }

    @Override
    public void release() {
        if (this.deleteFileOnRelease) {
            ContentUtils.deleteTempFile(this.file);
        }
    }

    @Override
    public Path getDataFile() {
        return this.file;
    }
}

