/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectRename
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBPProject nodeProject;
        IStructuredSelection structSelection;
        Object element;
        DBNNode node;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (node = (DBNNode)RuntimeUtils.getObjectAdapter((Object)(element = (structSelection = (IStructuredSelection)selection).getFirstElement()), DBNNode.class)) != null && ((nodeProject = node.getOwnerProject()) == null || nodeProject.hasRealmPermission("project-resource-edit"))) {
            NavigatorHandlerObjectRename.renameNode(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), HandlerUtil.getActiveShell((ExecutionEvent)event), node, null, (Object)this);
        }
        return null;
    }

    public static boolean renameNode(IWorkbenchWindow workbenchWindow, Shell shell, DBNNode node, String newName, Object uiSource) {
        String oldName;
        String string = oldName = node instanceof DBNDatabaseNode ? ((DBNDatabaseNode)node).getPlainNodeName(true, false) : node.getNodeDisplayName();
        if (oldName == null) {
            oldName = "?";
        }
        if (newName == null) {
            newName = EnterNameDialog.chooseName((Shell)shell, (String)NLS.bind((String)UINavigatorMessages.actions_navigator_rename_object, (Object)node.getNodeTypeLabel()), (String)oldName);
        }
        if (CommonUtils.isEmpty((String)newName) || newName.equals(oldName)) {
            return false;
        }
        if (node.supportsRename()) {
            try {
                String finalNewName = newName;
                UIUtils.runInProgressService(monitor -> {
                    try {
                        node.rename(monitor, finalNewName);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return true;
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_rename_object_exception_title, NLS.bind((String)UINavigatorMessages.actions_navigator_rename_object_exception_message, (Object)oldName), (Throwable)e);
            }
        }
        if (node instanceof DBNDatabaseNode) {
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            return NavigatorHandlerObjectRename.renameDatabaseObject(workbenchWindow, dbNode, CommonUtils.toString((Object)UIUtils.normalizePropertyValue((Object)newName)), uiSource);
        }
        return false;
    }

    public static boolean renameDatabaseObject(IWorkbenchWindow workbenchWindow, DBNDatabaseNode node, String newName, Object uiSource) {
        try {
            DBEObjectRenamer objectRenamer;
            DBSObject object;
            if (node.getParentNode() instanceof DBNContainer && (object = node.getObject()) != null && (objectRenamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectRenamer.class)) != null) {
                NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectRename.getCommandTarget(workbenchWindow, node.getParentNode(), node, object.getClass(), false);
                LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
                options.put("uiSource", uiSource);
                objectRenamer.renameObject(commandTarget.getContext(), object, options, newName);
                if (object.isPersisted() && commandTarget.getEditor() == null) {
                    if (!NavigatorHandlerObjectRename.showScript(workbenchWindow, commandTarget.getContext(), DBPScriptObject.EMPTY_OPTIONS, UINavigatorMessages.actions_navigator_rename_script)) {
                        commandTarget.getContext().resetChanges(true);
                        return false;
                    }
                    NavigatorHandlerObjectBase.ObjectSaver renamer = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), DBPScriptObject.EMPTY_OPTIONS);
                    TasksJob.runTask((String)NLS.bind((String)UINavigatorMessages.actions_navigator_rename_database_object, (Object)object.getName()), (DBRRunnableWithProgress)renamer);
                } else {
                    for (DBECommand dBECommand : commandTarget.getContext().getFinalCommands()) {
                    }
                }
                return true;
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_rename_database_object_exception_title, NLS.bind((String)UINavigatorMessages.actions_navigator_rename_database_object_exception_message, (Object)node.getNodeDisplayName()), e);
            return false;
        }
        return false;
    }
}

