# Generated by Django 2.2.17 on 2021-02-27 17:14
from django.db import migrations
from django.utils import timezone
import logging
logger = logging.getLogger(__name__)


def populate_last_status_update(apps, schema_editor):
    # We can't import the models directly as it may be a newer
    # version than this migration expects. We use the historical version.
    logger.info('Setting last_status_update timestamp on findings to be initially equal to last_reviewed timestamp (may take a while)')

    now = timezone.now()
    Finding = apps.get_model('dojo', 'Finding')
    findings = Finding.objects.order_by('id').only('id', 'is_Mitigated', 'mitigated')

    page_size = 1000
    # use filter to make count fast on mysql
    total_count = Finding.objects.filter(id__gt=0).count()
    logger.debug('found %d findings to update:', total_count)

    # some dude in switzerland says he has 500k findings and the migration needed to be optimized to not take 1,5 hours to run
    # using paging (LIMIT/OFFSET) is very slow, the higher the page number, the longer the query takes
    # so we use a 'seek' method

    i = 0
    batch = []
    last_id = 0
    total_pages = (total_count // page_size) + 2
    for p in range(1, total_pages):
        page = findings.filter(id__gt=last_id)[:page_size]
        for find in page:
            i += 1
            last_id = find.id
            # logger.info('last_id: %s', last_id)

            # last_status_update is set to now by default by migration or when adding a finding
            # for existing findings this should not be 'now'.
            # only valid value would be from miti   gated, otherwise we set it to None
            # to avoid code relying on it while the value is not reliable
            if find.is_Mitigated:
                find.last_status_update = find.mitigated
            else:
                find.last_status_update = None

            batch.append(find)

            if (i > 0 and i % page_size == 0):
                Finding.objects.bulk_update(batch, ['last_status_update'])
                batch = []
                logger.info('%s out of %s findings processed ...', i, total_count)

    Finding.objects.bulk_update(batch, ['last_status_update'])
    batch = []
    logger.info('%s out of %s findings processed ...', i, total_count)


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0081_last_status_update'),
    ]

    operations = [
        migrations.RunPython(populate_last_status_update, migrations.RunPython.noop),
    ]
