/* Copyright (c) 2022-2024 hors<horsicq@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "xaboutwidget.h"

#include "ui_xaboutwidget.h"

XAboutWidget::XAboutWidget(QWidget *pParent) : XShortcutsWidget(pParent), ui(new Ui::XAboutWidget)
{
    ui->setupUi(this);

    g_data = {};

    ui->labelDate->setText(__DATE__);
    ui->tabWidgetAbout->setCurrentIndex(0);
}

XAboutWidget::~XAboutWidget()
{
    delete ui;
}

void XAboutWidget::adjustView()
{
}

void XAboutWidget::setData(const DATA &data)
{
    g_data = data;

    ui->labelInfo->setText(data.sInfo);
    ui->labelLibraries->setText(data.sLibraries);

    QPixmap pixMap = QPixmap(data.sLogoPath);

    pixMap = pixMap.scaledToHeight(height());

    ui->labelLogo->setPixmap(pixMap);
}

void XAboutWidget::on_pushButtonCheckUpdates_clicked()
{
    // TODO GitHub API for checking version
#ifdef QT_NETWORK_LIB
    if (g_data.sServerVersionLink != "") {
        QNetworkAccessManager manager(this);
        QNetworkRequest request(QUrl(g_data.sServerVersionLink));
        QNetworkReply *pReply = manager.get(request);
        QEventLoop loop;
        QObject::connect(pReply, SIGNAL(finished()), &loop, SLOT(quit()));
        loop.exec();

        if (pReply->error() == QNetworkReply::NoError) {
            if (pReply->bytesAvailable()) {
                QByteArray baData = pReply->readAll();
                QString sVersion = QString(baData.data());

                if (QCoreApplication::applicationVersion().toDouble() < sVersion.toDouble()) {
                    if (QMessageBox::information(this, tr("Update information"),
                                                 QString("%1\r\n\r\n%2\r\n\r\n%3").arg(tr("New version available"), sVersion, tr("Go to download page?")),
                                                 QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes) {
                        QDesktopServices::openUrl(QUrl(g_data.sUpdatesLink));
                    }
                } else {
                    QMessageBox::information(this, tr("Update information"), tr("No update available"));
                }
            }
        } else {
            QMessageBox::critical(this, tr("Network error"), pReply->errorString());
        }
    } else {
        QDesktopServices::openUrl(QUrl(g_data.sUpdatesLink));
    }
#else
    QDesktopServices::openUrl(QUrl(g_data.sUpdatesLink));
#endif
}

void XAboutWidget::on_labelInfo_linkActivated(const QString &sLink)
{
    if (sLink.startsWith("http", Qt::CaseInsensitive)) {
        QDesktopServices::openUrl(sLink);
    } else {
        QApplication::clipboard()->setText(sLink);

        QMessageBox::information(this, tr("Information"), tr("The value copied to clipboard"));
    }
}

void XAboutWidget::on_pushButtonFollowGithub_clicked()
{
    QDesktopServices::openUrl(QUrl(QString("https://github.com/horsicq")));
}

void XAboutWidget::on_pushButtonFollowTwitter_clicked()
{
    QDesktopServices::openUrl(QUrl(QString("https://twitter.com/horsicq")));
}

void XAboutWidget::on_pushButtonFollowYoutube_clicked()
{
    QDesktopServices::openUrl(QUrl(QString("https://www.youtube.com/@funreverseengineering")));
}

void XAboutWidget::on_pushButtonThanks_clicked()
{
    QDesktopServices::openUrl(QUrl(g_data.sThanksLink));
}

void XAboutWidget::registerShortcuts(bool bState)
{
    Q_UNUSED(bState)
}
