/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.tableModels;

import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.gui.tableModels.ErrorTableObject;
import com.sittinglittleduck.DirBuster.workGenerators.MultiThreadedGenerator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ScanInfoTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{new String("Task"), new String("Progress"), new String("Control")};
    private Vector<ErrorTableObject> data;
    private JTable table;
    Manager manager = Manager.getInstance();

    public ScanInfoTableModel(JTable table) {
        this.table = table;
        this.data = this.manager.errors;
    }

    public void setColumnName(int index, String name) {
        if (index < this.columnNames.length) {
            this.columnNames[index] = name;
        }
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    public Object getValueAt(int row, int col) {
        MultiThreadedGenerator gen = this.manager.genThreads.elementAt(row);
        if (col == 0) {
            if (gen.getType() == 0) {
                return "Testing for dirs in " + gen.getStartpoint();
            }
            if (gen.getType() == 1) {
                return "Testing for files in " + gen.getStartpoint() + " with extention " + gen.getFileExt();
            }
            return null;
        }
        if (col == 1) {
            return gen.getCurrentPoint();
        }
        if (col == 2) {
            return "";
        }
        return null;
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.manager.genThreads.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int c) {
        return this.columnNames[c].getClass();
    }

    public void clearAllResults() {
        this.data.removeAllElements();
        this.fireTableDataChanged();
    }

    public void refreshTable() {
        this.fireTableDataChanged();
    }
}

