// $Id: DRAWxtlViewUI.cxx 1083 2010-11-17 16:21:56Z larry $
//
// DRAWxtl V5.5 main window description
// initial version generated by Fast Light User Interface Designer (fluid) version 1.0104
//
// Coded using the FLTK 1.1.6 widget set
//
//     Larry W. Finger, Martin Kroeker and Brian Toby
//
// routines contained within this file:
//
//  DRAWxtlViewUI::DRAWxtlViewUI - the constructor
//  Draw_Fl_Input::handle - the keyboard handler for this derived class
//

#include "DRAWxtlViewUI.h"
extern DRAWxtlViewUI *drvui;

void Main_Frame_Combo_cb (Fl_Widget *, void *);

static const char *Origin_X_ttp = { "Fractional coordinate (x) of center of drawing." };
static const char *Origin_Y_ttp = { "Fractional coordinate (y) of center of drawing." };
static const char *Origin_Z_ttp = { "Fractional coordinate (z) of center of drawing." };

static const char *X_Min_ttp = { "Fractional coordinate of minimum value of x\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *Y_Min_ttp = { "Fractional coordinate of minimum value of y\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *Z_Min_ttp = { "Fractional coordinate of minimum value of z\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *X_Max_ttp = { "Fractional coordinate of maximum value of x\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *Y_Max_ttp = { "Fractional coordinate of maximum value of y\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *Z_Max_ttp = { "Fractional coordinate of maximum value of z\n"
	"(See 'pack' command in Help/Input File Commands)"
};

static const char *X_Min_Clip_ttp = { "Fractional coordinate of minimum clip value of x\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *Y_Min_Clip_ttp = { "Fractional coordinate of minimum clip value of y\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *Z_Min_Clip_ttp = { "Fractional coordinate of minimum clip value of z\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *X_Max_Clip_ttp = { "Fractional coordinate of maximum clip value of x\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *Y_Max_Clip_ttp = { "Fractional coordinate of maximum clip value of y\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *Z_Max_Clip_ttp = { "Fractional coordinate of maximum clip value of z\n"
	"(See 'clip' command in Help/Input File Commands)\n"
	"Inactive unless 'Use Bond Clipping' is checked."
};

static const char *Str_Name_ttp = { "File name of current structure file\n"
	"Use 'Select Data File' menu item under 'File' to change."
};
static const char *Orthographic_ttp = { "If set, an orthographic view is generated." };
static const char *Bond_Clipping_ttp =
    { "Set to generate 'half' bonds at edge of drawing." };
static const char *Generate_VRML1_ttp = { "Set for VRML1 output (not VRML97)." };

//
// Remember to update the menuitem number in all deactivate() calls for View->POV in 
// CrystalView.cxx and Edit1.cxx when you insert a menu item before the POV entry below !
//
Fl_Menu_Item
    DRAWxtlViewUI::drawxtl_menu[] = {
    {"File", 0, 0, 0, FL_SUBMENU, 0, 0, 14, 56},
    {" Select Data File", 0, (Fl_Callback *) SelectDataFile_cb, 0, 0, 0, 0, 14, 56},
    {" Import External Format ", 0, 0, 0, FL_SUBMENU, 0, 0, 14, 56},
    {" Import CIF File", 0, (Fl_Callback *) ImportDataFile_cb, 0, 0, 0, 0, 14, 56},
    {" Import FDAT File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 1, 0, 0, 0, 14,
     56},
    {" Import GSAS File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 2, 0, 0, 0, 14,
     56},
    {" Import Schakal File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 3, 0, 0, 0,
     14, 56},
    {" Import Shelx File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 4, 0, 0, 0, 14,
     56},
    {" Import WIEN2k File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 5, 0, 0, 0, 14,
     56},
    {" Import DISCUS File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 6, 0, 0, 0, 14,
     56},
    {" Import FULLPROF File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 7, 0, 0, 0,
     14, 56},
    {" Import Exciting File", 0, (Fl_Callback *) ImportDataFile_cb, (void *) 8, 0, 0, 0,
     14, 56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {" Save Current", 0, (Fl_Callback *) Save_Current_cb, 0, 0, 0, 0, 14, 56},
    {" Save Image as Postscript", 0, (Fl_Callback *) Dump_View_cb, 0, 0, 0, 0, 14, 56},
    {" Save Image as GIF", 0, (Fl_Callback *) dump_gif, 0, 0, 0, 0, 14, 56},
    {" Configure", 0, 0, 0, FL_SUBMENU | FL_MENU_DIVIDER, 0, 0, 14, 56},
    {" POV", 0, (Fl_Callback *) Configure_cb, 0, 0, 0, 0, 14, 56},
    {" MSMS", 0, (Fl_Callback *) Configure_MSMS_cb, 0, 0, 0, 0, 14, 56},
    {" Misc.", 0, (Fl_Callback *) Configure_Misc_cb, 0, 0, 0, 0, 14, 56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {" Exit", 0, (Fl_Callback *) Exit_cb, 0, 0, 0, 0, 14, 56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {"Edit", 0, 0, 0, FL_SUBMENU, 0, 0, 14, 56},
    {" Edit Parameters", 0, (Fl_Callback *) Edit_Parmeters_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Spheres", 0, (Fl_Callback *) Edit_Spheres_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Bonds", 0, (Fl_Callback *) Edit_Bond_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Ellipsoids", 0, (Fl_Callback *) Edit_Ellipsoid_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Polyhedra/Planes", 0, (Fl_Callback *) Edit_Polyhedra_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Arrows", 0, (Fl_Callback *) Edit_Arrow_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Lone-Pair Cones", 0, (Fl_Callback *) Edit_LonePair_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Slab Parameters", 0, (Fl_Callback *) Edit_Slab_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Map Parameters", 0, (Fl_Callback *) Edit_Maps_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Surface Parameters", 0, (Fl_Callback *) Edit_Surfaces_cb, 0, 0, 0, 0, 14, 56},
    {" Edit Modulation Parameters", 0, (Fl_Callback *) Edit_Modparms_cb, 0,
     FL_MENU_DIVIDER, 0, 0, 14, 56},
    {" Edit STR File (Original Version)", 0, (Fl_Callback *) Edit_STR_cb, (void *) 1, 0,
     0, 0, 14, 56},
    {" Edit STR File (Working Version)", 0, (Fl_Callback *) Edit_STR_cb, 0, 0, 0, 0, 14,
     56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {"View", 0, 0, 0, FL_SUBMENU, 0, 0, 14, 56},
    {" POV", 0, (Fl_Callback *) View_POV_cb, 0, 0, 0, 0, 14, 56},
    {" Listing", 0, (Fl_Callback *) View_Listing_cb, 0, 0, 0, 0, 14, 56},
    {" Console", 0, (Fl_Callback *) View_Console_cb, 0, 0, 0, 0, 14, 56},
    {" Geometry", 0, (Fl_Callback *) View_Cursor_cb, 0, 0, 0, 0, 14, 56},
    {" File", 0, (Fl_Callback *) View_File_cb, 0, 0, 0, 0, 14, 56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {"Help", 0, 0, 0, FL_SUBMENU, 0, 0, 14, 56},
    {" Input File Commands", 0, (Fl_Callback *) Input_Help_cb, 0, 0, 0, 0, 14, 56},
    {" Color Name/RGB Table", 0, (Fl_Callback *) Color_Help_cb, 0, 0, 0, 0, 14, 56},
    {" Graphics Help", 0, (Fl_Callback *) Graphics_Help_cb, 0, 0, 0, 0, 14, 56},
    {" Spacegroup Help", 0, (Fl_Callback *) Spacegroup_Help_cb, 0, FL_MENU_DIVIDER, 0, 0,
     14, 56},
    {" About DRAWxtl", 0, (Fl_Callback *) About_Help_cb, 0, 0, 0, 0, 14, 56},
    {0, 0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Group *Menu_Group;

CrystalView *crystal2;

Fl_Group *Cursor_Group;

Fl_Group *Left_Panel_Group;

volatile int w_width = 855;

volatile int w_height = 660;

int y_start = 30;

int w_st_x = 150;

int w_st_y = 20;

static int
scaled_x (int x)
{
    return min (x, (x * w_width) / 855);
}

static int
scaled_y (int y)
{
    return (y * w_height) / 660;
}

DRAWxtlViewUI::DRAWxtlViewUI ()
{
    int y;

    int y_step = 25;

    if (Fl::w () == 800) {	// adjust screen parameters for 800 x 600
	w_width = 790;
	w_height = 530;
	w_st_x = 0;
	y_step = 20;
    } else if (Fl::w () == 640) {	// adjust for 640 x 480
	w_width = 630;
	w_height = 420;
	w_st_x = 0;
	y_step = 18;
    }
    DRAWxtl_Window *o = mainWindow =
	new DRAWxtl_Window (w_st_x, w_st_y, w_width, w_height,
			    "   DRAWxtl V5.5");

    o->begin ();
    o->box (FL_UP_BOX);
    o->selection_color ((Fl_Color) 128);
    o->labelfont (1);
    o->labelsize (49);
    o->labelcolor (FL_RED);
    o->callback ((Fl_Callback *) Exit_cb);
    o->align (FL_ALIGN_BOTTOM);
    o->when (FL_WHEN_CHANGED);
    o->size_range (160, 100, Fl::w (), Fl::h ());
    Fl_Group *g = Menu_Group = new Fl_Group (0, 0, w_width, 25);

    g->begin ();
    Fl_Box *b = new Fl_Box (0, 0, w_width, 25);

    Fl_Menu_Bar *om = new Fl_Menu_Bar (0, 0, w_width - 50, 25);

    om->menu (drawxtl_menu);
    Fl_Button *on = new Fl_Button (w_width - 50, 0, 50, 25, "Exit");

    on->callback ((Fl_Callback *) Exit_cb);
    g->resizable (b);
    g->end ();
    Left_Panel_Group =
	new Fl_Group (0, scaled_y (25), scaled_x (275), w_height - scaled_y (25));
    Fl_Text_Display *op = mainLabel =
	new Fl_Text_Display (0, scaled_y (60), scaled_x (275), 0, "DRAWxtl V5.5");
    op->box (FL_NO_BOX);
    op->color ((Fl_Color) 1);
    op->selection_color ((Fl_Color) 1);
    op->labelfont (1);
    op->labelsize (scaled_y (20));
    op->labelcolor ((Fl_Color) 1);
    op->textcolor (1);
    y = y_start;
    {
	Fl_Check_Button *o = Show_Vector_Triple =
	    new Fl_Check_Button (scaled_x (20), scaled_y (y) + 25,
				 scaled_x (25), scaled_y (25), "Show Vector Triple");

	o->down_box (FL_DOWN_BOX);
	o->callback ((Fl_Callback *) Check_Box_cb);
    }
    y += y_step - 5;
    {
	Fl_Check_Button *o = Orthographic_View =
	    new Fl_Check_Button (scaled_x (20), scaled_y (y) + 25,
				 scaled_x (30), scaled_y (25), "Non-Perspective View");

	o->down_box (FL_DOWN_BOX);
	o->tooltip (Orthographic_ttp);
	o->callback ((Fl_Callback *) Check_Box_cb);
    }
    y += y_step - 5;
    {
	Fl_Check_Button *o = Generate_VRML1 =
	    new Fl_Check_Button (scaled_x (20), scaled_y (y) + 25,
				 scaled_x (25), scaled_y (25), "Generate VRML1");

	o->down_box (FL_DOWN_BOX);
	o->tooltip (Generate_VRML1_ttp);
	o->callback ((Fl_Callback *) Check_Box_cb);
    }
    y += y_step - 5;
    {
	Fl_Check_Button *o = Use_Clipping =
	    new Fl_Check_Button (scaled_x (20), scaled_y (y) + 25,
				 scaled_x (25), scaled_y (25), "Use Bond Clipping");

	o->down_box (FL_DOWN_BOX);
	o->tooltip (Bond_Clipping_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    Origin1_Msg =
	new Fl_Output (scaled_x (20), scaled_y (y) + 40, scaled_x (250), scaled_y (20));
    Origin1_Msg->value ("Special space group - see Help/Spacegroup");
    Origin1_Msg->textsize (scaled_y (12));
    Origin1_Msg->textcolor (FL_RED);
    Origin1_Msg->box (FL_NO_BOX);
    Origin1_Msg->hide ();
    {
	Flu_Combo_List *o = Frame_No =
	    new Flu_Combo_List (scaled_x (180), scaled_y (y + 5),
				scaled_x (70), scaled_y (20), "Frame No.");

	o->align (FL_ALIGN_TOP);
	o->hide ();
	o->callback (Main_Frame_Combo_cb);
    }
    y += y_step + 10;
    {
	Flu_Spinner *o = X_Min = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Xmin");

	o->type (1);
	o->minimum (-10);
	o->maximum (1);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (X_Min_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = X_Max = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Xmax");

	o->type (1);
	o->minimum (-1);
	o->maximum (10);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (X_Max_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    y += y_step + 20;
    {
	Flu_Spinner *o = X_Min_clip = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Xmin");
	o->type (1);
	o->minimum (-10);
	o->maximum (4);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (X_Min_Clip_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = X_Max_clip = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Xmax");
	o->type (1);
	o->minimum (-4);
	o->maximum (10);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->callback ((Fl_Callback *) Max_Min_cb);
	o->tooltip (X_Max_Clip_ttp);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
    }
    y += y_step + 20;
    {
	Flu_Spinner *o = Y_Min = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Ymin");

	o->type (1);
	o->minimum (-10);
	o->maximum (1);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Y_Min_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = Y_Max = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Ymax");

	o->type (1);
	o->minimum (-1);
	o->maximum (10);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Y_Max_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    y += y_step + 20;
    {
	Flu_Spinner *o = Y_Min_clip = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Ymin");
	o->type (1);
	o->minimum (-10);
	o->maximum (4);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->tooltip (Y_Min_Clip_ttp);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = Y_Max_clip = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Ymax");
	o->type (1);
	o->minimum (-10);
	o->maximum (4);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Y_Max_Clip_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    y += y_step + 20;
    {
	Flu_Spinner *o = Z_Min = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Zmin");

	o->type (1);
	o->minimum (-10);
	o->maximum (1);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Z_Min_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = Z_Max = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						  scaled_x (100), scaled_y (25), "Zmax");

	o->type (1);
	o->minimum (-1);
	o->maximum (10);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Z_Max_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    y += y_step + 20;
    {
	Flu_Spinner *o = Z_Min_clip = new Flu_Spinner (scaled_x (20), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Zmin");
	o->type (1);
	o->minimum (-10);
	o->maximum (4);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Z_Min_Clip_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    {
	Flu_Spinner *o = Z_Max_clip = new Flu_Spinner (scaled_x (150), scaled_y (y) + 25,
						       scaled_x (100), scaled_y (25),
						       "Clip Zmax");
	o->type (1);
	o->minimum (-4);
	o->maximum (10);
	o->step (0.05);
	o->align (FL_ALIGN_BOTTOM);
	o->deactivate ();
	o->valuecolor (FL_WHITE, FL_SELECTION_COLOR);
	o->tooltip (Z_Max_Clip_ttp);
	o->callback ((Fl_Callback *) Max_Min_cb);
    }
    y += y_step + 20;
    {
	Draw_Fl_Input *o = Origin_X = new Draw_Fl_Input (scaled_x (20), scaled_y (y) + 25,
							 scaled_x (60), scaled_y (25),
							 "Origin X");
	o->callback ((Fl_Callback *) Offset_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_CHANGED);
	o->tooltip (Origin_X_ttp);
    }
    {
	Draw_Fl_Input *o = Origin_Y =
	    new Draw_Fl_Input (scaled_x (100), scaled_y (y) + 25,
			       scaled_x (60), scaled_y (25), "Origin Y");

	o->callback ((Fl_Callback *) Offset_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_CHANGED);
	o->tooltip (Origin_Y_ttp);
    }
    {
	Draw_Fl_Input *o = Origin_Z =
	    new Draw_Fl_Input (scaled_x (185), scaled_y (y) + 25,
			       scaled_x (60), scaled_y (25), "Origin Z");

	o->callback ((Fl_Callback *) Offset_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_CHANGED);
	o->tooltip (Origin_Z_ttp);
    }
    y += y_step + 20;
    {
	Draw_Fl_Input *o = X_Rot = new Draw_Fl_Input (scaled_x (20), scaled_y (y) + 25,
						      scaled_x (60), scaled_y (25),
						      "X-Rot");
	o->callback ((Fl_Callback *) Rotation_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_ENTER_KEY);
    }
    {
	Draw_Fl_Input *o = Y_Rot = new Draw_Fl_Input (scaled_x (100), scaled_y (y) + 25,
						      scaled_x (60), scaled_y (25),
						      "Y-Rot");
	o->callback ((Fl_Callback *) Rotation_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_ENTER_KEY);
    }
    {
	Draw_Fl_Input *o = Z_Rot = new Draw_Fl_Input (scaled_x (185), scaled_y (y) + 25,
						      scaled_x (60), scaled_y (25),
						      "Z-Rot");
	o->callback ((Fl_Callback *) Rotation_cb);
	o->align (FL_ALIGN_BOTTOM);
	o->when (FL_WHEN_ENTER_KEY);
    }
    y += y_step + 20;
    {
	Fl_Output *o = CurFile = new Fl_Output (scaled_x (20), scaled_y (y) + 25,
						scaled_x (225), scaled_y (25),
						"Current Structure File");
	o->align (FL_ALIGN_BOTTOM);
	o->color (FL_BACKGROUND_COLOR);
	o->box (FL_THIN_DOWN_BOX);
	o->tooltip (Str_Name_ttp);
    }
    y += y_step + 20;
    {
	Fl_Output *o = CurDir = new Fl_Output (scaled_x (20), scaled_y (y) + 25,
					       scaled_x (225), scaled_y (40),
					       "Current Directory");
	o->color (FL_BACKGROUND_COLOR);
	o->box (FL_THIN_DOWN_BOX);
	o->align (FL_ALIGN_BOTTOM);
    }
    Left_Panel_Group->end ();
    {
	CrystalView *o = crystal = crystal2 =
	    new CrystalView (scaled_x (275), 25, w_width - 275,
			     w_height - 65, "label");

	o->box (FL_NO_BOX);
	o->color (FL_BACKGROUND_COLOR);
	o->selection_color (FL_BACKGROUND_COLOR);
	o->labeltype (FL_NORMAL_LABEL);
	o->labelfont (0);
	o->labelsize (14);
	o->labelcolor (FL_BLACK);
	o->end ();
    }
    o->resizable (crystal);
    Cursor_Group = new Fl_Group (scaled_x (275), w_height - 55, w_width - 275, 35);
    {
	Fl_Multiline_Output *p = Cursor_pos =
	    new Fl_Multiline_Output (scaled_x (275), w_height - 35,
				     w_width - 275, 45);

	p->textsize (13);
	p->color (FL_BACKGROUND_COLOR);
	p->box (FL_THIN_DOWN_BOX);
	p->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
	p->when (FL_WHEN_RELEASE);
    }
    Cursor_Group->box (FL_NO_BOX);
    Cursor_Group->resizable (crystal);
    Cursor_Group->end ();
    o->end ();
}

int
Draw_Fl_Input::handle (int e)
{
    if (e == FL_KEYDOWN) {
	if (Fl::event_key () == FL_Tab) {
	    next_focus ();
	    return 1;
	}
    }
    return Fl_Input::handle (e);
}

void
DRAWxtl_Window::resize (int X, int Y, int W, int H)
{
/* resize the various parts of the layout as the main window is resized by dragging
 * a corner, or by pressing the "maximize" button in the upper right-hand corner.
 * The left-most panel of widgets is never made wider than the 275 pixels that it
 * had before resizing was implemented. FLTK does not resize widget labels; therefore
 * each of them has to be resized individually. This works OK, but we get discrete
 * jumps in the size rather than a smooth transition.
 */
    int lp_w;

    int text_h;

    int ctext_h;

    int label_h;

    /* calculate width for the left panel group, which is in the
     * range from 0 to 275 */
    lp_w = (int) (275. * ((float) DRAWxtl_Window::w () / 855.));
    Fl_Double_Window::resize (X, Y, W, H);
    Menu_Group->resize (0, 0, DRAWxtl_Window::w (), 25);
    crystal2->resize (lp_w, 25, DRAWxtl_Window::w () - lp_w, DRAWxtl_Window::h () - 60);
    Cursor_Group->resize (lp_w, DRAWxtl_Window::h () - 55, DRAWxtl_Window::w () - lp_w,
			  35);
    drvui->Cursor_pos->resize (lp_w, DRAWxtl_Window::h () - 35,
			       DRAWxtl_Window::w () - lp_w, 35);
    Left_Panel_Group->resize (0, 25, lp_w, DRAWxtl_Window::h () - 25);
    text_h = min (14, (14 * DRAWxtl_Window::h ()) / 660);
    ctext_h = min (13, (13 * DRAWxtl_Window::h ()) / 660);
    label_h = min (20, (20 * DRAWxtl_Window::h ()) / 660);

    drvui->mainLabel->labelsize (label_h);
    drvui->X_Max->labelsize (text_h);
    drvui->Y_Max->labelsize (text_h);
    drvui->Z_Max->labelsize (text_h);
    drvui->X_Min->labelsize (text_h);
    drvui->Y_Min->labelsize (text_h);
    drvui->Z_Min->labelsize (text_h);
    drvui->X_Max_clip->labelsize (text_h);
    drvui->Y_Max_clip->labelsize (text_h);
    drvui->Z_Max_clip->labelsize (text_h);
    drvui->X_Min_clip->labelsize (text_h);
    drvui->Y_Min_clip->labelsize (text_h);
    drvui->Z_Min_clip->labelsize (text_h);
    drvui->X_Rot->labelsize (text_h);
    drvui->Y_Rot->labelsize (text_h);
    drvui->Z_Rot->labelsize (text_h);
    drvui->X_Max->valuesize (text_h);
    drvui->Y_Max->valuesize (text_h);
    drvui->Z_Max->valuesize (text_h);
    drvui->X_Min->valuesize (text_h);
    drvui->Y_Min->valuesize (text_h);
    drvui->Z_Min->valuesize (text_h);
    drvui->X_Max_clip->valuesize (text_h);
    drvui->Y_Max_clip->valuesize (text_h);
    drvui->Z_Max_clip->valuesize (text_h);
    drvui->X_Min_clip->valuesize (text_h);
    drvui->Y_Min_clip->valuesize (text_h);
    drvui->Z_Min_clip->valuesize (text_h);
    drvui->X_Rot->textsize (text_h);
    drvui->Y_Rot->textsize (text_h);
    drvui->Z_Rot->textsize (text_h);
    drvui->Origin_X->labelsize (text_h);
    drvui->Origin_Y->labelsize (text_h);
    drvui->Origin_Z->labelsize (text_h);
    drvui->Origin_X->textsize (text_h);
    drvui->Origin_Y->textsize (text_h);
    drvui->Origin_Z->textsize (text_h);
    drvui->Orthographic_View->labelsize (text_h);
    drvui->Show_Vector_Triple->labelsize (text_h);
    drvui->Use_Clipping->labelsize (text_h);
    drvui->Generate_VRML1->labelsize (text_h);
    drvui->Frame_No->labelsize (text_h);
    drvui->CurFile->labelsize (text_h);
    drvui->CurFile->textsize (text_h);
    drvui->CurDir->labelsize (text_h);
    drvui->CurDir->textsize (text_h);
    drvui->Cursor_pos->textsize (ctext_h);

    w_width = crystal2->w();
    w_height = crystal2->h();
}
